/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.setup;

import com.jgoodies.application.Application;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.framework.setup.BodyTextMode;
import java.util.prefs.Preferences;

public class BasicApplicationPreferences
extends Bean
implements Cloneable {
    public static final String PROPERTY_MENU_VISIBLE_ALWAYS = "menuVisibleAlways";
    public static final String PROPERTY_OPTIMIZED_FOR_SCREEN_READER = "optimizedForScreenReader";
    public static final String PROPERTY_BODY_TEXT_MODE = "bodyTextMode";
    private static final String KEY_MENU_VISIBLE_ALWAYS = "menu_visible_always";
    private static final String KEY_OPTIMIZED_FOR_SCREEN_READER = "optimized_for_screen_reader";
    private static final String KEY_BODY_TEXT_MODE = "body_text_mode";
    private boolean menuVisibleAlways;
    private boolean optimizedForScreenReader;
    private BodyTextMode bodyTextMode;

    public static BasicApplicationPreferences fromUserPreferences() {
        return BasicApplicationPreferences.from(Application.getInstance().getContext().getUserPreferences());
    }

    public static BasicApplicationPreferences from(Preferences pres) {
        BasicApplicationPreferences appPrefs = new BasicApplicationPreferences();
        appPrefs.readFrom(pres);
        return appPrefs;
    }

    public void readFrom(Preferences prefs) {
        this.setMenuVisibleAlways(prefs.getBoolean(KEY_MENU_VISIBLE_ALWAYS, SystemUtils.IS_OS_MAC));
        this.setOptimizedForScreenReader(prefs.getBoolean(KEY_OPTIMIZED_FOR_SCREEN_READER, false));
        this.setBodyTextMode(BodyTextMode.valueOf(prefs.get(KEY_BODY_TEXT_MODE, BodyTextMode.CLASSIC.name())));
    }

    public void storeIn(Preferences prefs) {
        prefs.putBoolean(KEY_MENU_VISIBLE_ALWAYS, this.isMenuVisibleAlways());
        prefs.putBoolean(KEY_OPTIMIZED_FOR_SCREEN_READER, this.isOptimizedForScreenReader());
        prefs.put(KEY_BODY_TEXT_MODE, this.getBodyTextMode().name());
    }

    public boolean isMenuVisibleAlways() {
        return this.menuVisibleAlways;
    }

    public void setMenuVisibleAlways(boolean menuVisibleAlways) {
        boolean oldValue = this.isMenuVisibleAlways();
        this.menuVisibleAlways = menuVisibleAlways;
        this.firePropertyChange(PROPERTY_MENU_VISIBLE_ALWAYS, oldValue, menuVisibleAlways);
    }

    public BodyTextMode getBodyTextMode() {
        return this.bodyTextMode;
    }

    public void setBodyTextMode(BodyTextMode mode) {
        BodyTextMode oldValue = this.getBodyTextMode();
        this.bodyTextMode = mode;
        this.firePropertyChange(PROPERTY_BODY_TEXT_MODE, oldValue, mode);
    }

    public boolean isOptimizedForScreenReader() {
        return this.optimizedForScreenReader;
    }

    public void setOptimizedForScreenReader(boolean optimized) {
        boolean oldValue = this.isOptimizedForScreenReader();
        this.optimizedForScreenReader = optimized;
        this.firePropertyChange(PROPERTY_OPTIMIZED_FOR_SCREEN_READER, oldValue, optimized);
    }

    public BasicApplicationPreferences clone() {
        try {
            return (BasicApplicationPreferences)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

