/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.navigation;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.factories.CC;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

final class SplitView
extends JLayeredPane {
    public static final String PROPERTY_DISPLAY_MODE = "displayMode";
    public static final String PROPERTY_PANE_OPEN = "paneOpen";
    private SplitViewDisplayMode displayMode;
    private boolean paneOpen;
    private JComponent compactPane;
    private JComponent pane;
    private JComponent content;

    SplitView(SplitViewDisplayMode mode) {
        this.setLayout(new FormLayout("left:pref, fill:pref:grow", "f:p:g"));
        this.displayMode = Preconditions.checkNotNull(mode, "The %s must not be null.", "mode");
        this.setOpaque(false);
    }

    public SplitViewDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(SplitViewDisplayMode newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", "display mode");
        this.displayMode = newValue;
        this.firePropertyChange(PROPERTY_DISPLAY_MODE, (Object)this.displayMode, (Object)this.displayMode);
        this.updateVisibilities();
    }

    public boolean isPaneOpen() {
        return this.paneOpen;
    }

    public void setPaneOpen(boolean newValue) {
        this.paneOpen = newValue;
        this.firePropertyChange(PROPERTY_PANE_OPEN, this.paneOpen, this.paneOpen);
        this.updateVisibilities();
    }

    public void setPaneAndContent(JComponent pane, JComponent compactPane, JComponent content) {
        this.removeAll();
        this.setPane(pane);
        this.setCompactPane(compactPane);
        this.setContent(content);
    }

    public JComponent getPane() {
        return this.pane;
    }

    private void setPane(JComponent newValue) {
        CellConstraints cc;
        this.pane = Preconditions.checkNotNull(newValue, "The %s must not be null.", "pane");
        int layer = -1;
        if (this.displayMode == SplitViewDisplayMode.COMPACT_OVERLAY || this.displayMode == SplitViewDisplayMode.OVERLAY) {
            cc = CC.xyw(1, 1, 2, "left, fill");
            layer = JLayeredPane.POPUP_LAYER;
        } else {
            cc = CC.xy(1, 1);
            layer = JLayeredPane.DEFAULT_LAYER;
        }
        this.add((Component)this.pane, cc);
        this.setLayer(this.pane, layer);
        this.pane.setVisible(this.isPaneOpen());
        this.revalidate();
        this.repaint();
    }

    public JComponent getCompactPane() {
        return this.compactPane;
    }

    private void setCompactPane(JComponent newValue) {
        this.compactPane = Preconditions.checkNotNull(newValue, "The %s must not be null.", "compact pane");
        CellConstraints cc = this.displayMode == SplitViewDisplayMode.OVERLAY ? CC.xy(2, 1, "left, top") : CC.xy(1, 1);
        this.add((Component)this.compactPane, cc);
        if (this.displayMode == SplitViewDisplayMode.INLINE) {
            this.compactPane.setVisible(false);
        } else if (this.displayMode != SplitViewDisplayMode.OVERLAY) {
            this.compactPane.setVisible(!this.isPaneOpen());
        }
        this.revalidate();
        this.repaint();
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContent(JComponent newValue) {
        this.content = Preconditions.checkNotNull(newValue, "The %s must not be null.", "content");
        this.add((Component)this.content, CC.xy(2, 1));
        this.revalidate();
        this.repaint();
    }

    void closeOverlayPane() {
        if (this.displayMode == SplitViewDisplayMode.COMPACT_OVERLAY || this.displayMode == SplitViewDisplayMode.OVERLAY) {
            this.setPaneOpen(false);
        }
    }

    private void updateVisibilities() {
        if (this.compactPane != null) {
            this.compactPane.setVisible(this.displayMode == SplitViewDisplayMode.COMPACT_INLINE || this.displayMode == SplitViewDisplayMode.COMPACT_OVERLAY || this.displayMode == SplitViewDisplayMode.OVERLAY);
        }
        if (this.pane != null) {
            this.pane.setVisible(this.isPaneOpen());
        }
        this.revalidate();
        this.repaint();
    }

    static enum SplitViewDisplayMode {
        INLINE,
        OVERLAY,
        COMPACT_INLINE,
        COMPACT_OVERLAY;

    }
}

