/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Strings;
import com.jgoodies.dialogs.core.internal.BasicPropertyPaneBuilder;
import com.jgoodies.dialogs.core.pane.property.TabbedPropertyPane;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public final class TabbedPropertyPaneBuilder
extends BasicPropertyPaneBuilder<TabbedPropertyPane, TabbedPropertyPaneBuilder> {
    public Adder beginTab() {
        return new Adder(this);
    }

    @Override
    protected TabbedPropertyPane createPane() {
        return new TabbedPropertyPane();
    }

    void addTab(String tabTitle, JComponent tabComponent) {
        ((TabbedPropertyPane)this.pane).addTab(tabTitle, tabComponent);
    }

    public static final class Adder {
        private final TabbedPropertyPaneBuilder builder;
        private String title;
        private EmptyBorder padding;
        private boolean paddingSet;
        private JComponent content;

        Adder(TabbedPropertyPaneBuilder builder) {
            this.builder = builder;
        }

        public Adder title(String plainTitle, Object ... args) {
            this.title = Strings.get(plainTitle, args);
            return this;
        }

        public Adder padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return this;
        }

        public Adder content(JComponent tabContent) {
            this.content = tabContent;
            return this;
        }

        public TabbedPropertyPaneBuilder endTab() {
            if (this.paddingSet) {
                this.content.setBorder(this.padding);
            }
            this.builder.addTab(this.title, this.content);
            return this.builder;
        }
    }

    public static final class TabAdder {
        private final TabbedPropertyPaneBuilder builder;
        private final String tabTitle;
        private EmptyBorder padding;
        private boolean paddingSet;

        TabAdder(TabbedPropertyPaneBuilder builder, String tabTitle) {
            this.builder = builder;
            this.tabTitle = tabTitle;
        }

        public TabAdder padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return this;
        }

        public TabbedPropertyPaneBuilder content(JComponent tabContent) {
            if (this.paddingSet) {
                tabContent.setBorder(this.padding);
            }
            this.builder.addTab(this.tabTitle, tabContent);
            return this.builder;
        }
    }
}

