/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.internal.PropertyPaneAction;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.property.PropertyPane;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneModel;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;

public final class TabbedPropertyPane
extends PropertyPane {
    private static final String UI_CLASS_ID = "JSDL.TabbedPropertyPaneUI";

    public TabbedPropertyPane() {
        this(CommandValue.OK, CommandValue.CANCEL);
    }

    public TabbedPropertyPane(Object okObject, Object cancelObject) {
        this(new Object[]{okObject, cancelObject});
    }

    public TabbedPropertyPane(Object okObject, Object cancelObject, Object applyObject) {
        this(new Object[]{okObject, cancelObject, applyObject});
    }

    public TabbedPropertyPane(PropertyPaneModel model) {
        this(PropertyPaneAction.createOKCancelApplyActionsFor(model));
    }

    private TabbedPropertyPane(Object[] commitObjects) {
        super((JComponent)JGComponentFactory.getCurrent().createTabbedPane(), commitObjects);
        this.setBackground(UIManager.getColor("TabbedPropertyPane.background"));
        ((AbstractStyledPaneVisualConfiguration)this.getVisualConfiguration()).setCommandArea(null);
    }

    public void addTab(String markedTitle, JComponent component) {
        Preconditions.checkNotNull(component, "The %s must not be null.", "tab component");
        String plainTitle = MnemonicUtils.plainText(markedTitle);
        Preconditions.checkNotBlank(plainTitle, "The %s must not be null.", "plain tab title");
        JSDLCoreStyleChecker.getInstance().checkTabTitle(plainTitle);
        this.getTabbedPane().addTab(plainTitle, component);
        MnemonicUtils.configure(this.getTabbedPane(), this.getTabbedPane().getTabCount() - 1, markedTitle);
    }

    public SingleSelectionModel getTabModel() {
        return this.getTabbedPane().getModel();
    }

    protected JTabbedPane getTabbedPane() {
        return (JTabbedPane)this.getContent();
    }

    @Override
    protected String layoutGroup() {
        return "TabbedPropertyPane";
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }
}

