/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice.list_builder;

import com.jgoodies.dialogs.basics.choice.list_builder.AbstractListBuilderView;
import com.jgoodies.dialogs.basics.choice.list_builder.AbstractTreeListBuilderModel;
import java.beans.PropertyChangeEvent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class DefaultTreeListBuilderView<E>
extends AbstractListBuilderView<E, AbstractTreeListBuilderModel<E>, JTree, JList<E>> {
    private final TreeModelListener optionsTreeDataListener = new OptionsTreeModelListener();

    public DefaultTreeListBuilderView(AbstractTreeListBuilderModel<E> model) {
        super(model);
        this.initEventHandling();
    }

    private void initEventHandling() {
        ((AbstractTreeListBuilderModel)this.model).getOptionsSelectionModel().addTreeSelectionListener(this::onOptionsTreeSelectionChanged);
        ((AbstractTreeListBuilderModel)this.model).addPropertyChangeListener("optionsDataModel", this::onOptionsDataModelChanged);
    }

    public final void setOptionsCellRenderer(TreeCellRenderer cellRenderer) {
        ((JTree)this.getOptionsView()).setCellRenderer(cellRenderer);
    }

    public final void setOptionsRootVisible(boolean newValue) {
        ((JTree)this.getOptionsView()).setRootVisible(newValue);
    }

    public final void setOptionsShowsRootHandles(boolean newValue) {
        ((JTree)this.getOptionsView()).setShowsRootHandles(newValue);
    }

    public final void setBuiltListCellRenderer(ListCellRenderer<? super E> cellRenderer) {
        ((JList)this.getBuiltListView()).setCellRenderer(cellRenderer);
    }

    @Override
    protected JTree createDefaultOptionsView() {
        JTree optionsTree = new JTree();
        this.updateTreeModels(optionsTree);
        return optionsTree;
    }

    @Override
    protected JList<E> createDefaultBuiltListView() {
        return this.createDefaultBuiltListList();
    }

    private void onOptionsTreeSelectionChanged(TreeSelectionEvent evt) {
        this.handleOptionsSelectionChanged();
    }

    private void onOptionsDataModelChanged(PropertyChangeEvent evt) {
        this.updateTreeModels((JTree)this.getOptionsView());
        TreeModel oldModel = (TreeModel)evt.getOldValue();
        if (oldModel != null) {
            oldModel.removeTreeModelListener(this.optionsTreeDataListener);
        }
        TreeModel newModel = ((AbstractTreeListBuilderModel)this.model).getOptionsDataModel();
        newModel.addTreeModelListener(this.optionsTreeDataListener);
        this.handleOptionsDataChanged();
    }

    protected void handleOptionsDataChanged() {
    }

    protected void handleOptionsSelectionChanged() {
    }

    public final void updateTreeModels(JTree tree) {
        tree.setModel(((AbstractTreeListBuilderModel)this.model).getOptionsDataModel());
        tree.setSelectionModel(((AbstractTreeListBuilderModel)this.model).getOptionsSelectionModel());
    }

    private final class OptionsTreeModelListener
    implements TreeModelListener {
        private OptionsTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent evt) {
            DefaultTreeListBuilderView.this.handleOptionsDataChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent evt) {
            DefaultTreeListBuilderView.this.handleOptionsDataChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent evt) {
            DefaultTreeListBuilderView.this.handleOptionsDataChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent evt) {
            DefaultTreeListBuilderView.this.handleOptionsDataChanged();
        }
    }
}

