/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.accessibility;

import com.jgoodies.common.base.Strings;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public final class AccessibilityUtils {
    private AccessibilityUtils() {
    }

    public static boolean hasAccessibleInfo(Component c) {
        return Strings.isNotBlank(AccessibilityUtils.getAccessibleInfo(c));
    }

    public static String getAccessibleInfo(Component c) {
        String accessibleName = c.getAccessibleContext().getAccessibleName();
        if (Strings.isNotBlank(accessibleName)) {
            String trimmedName = accessibleName.trim();
            return trimmedName.endsWith(":") ? trimmedName.substring(0, trimmedName.length() - 1) : trimmedName;
        }
        if (c instanceof JComponent) {
            return ((JComponent)c).getToolTipText();
        }
        return null;
    }

    public static List<Component> visitAndCollectComponents(Container root, Predicate<Component> filter) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component child : root.getComponents()) {
            if (!child.isShowing()) continue;
            if (filter.test(child)) {
                result.add(child);
                continue;
            }
            if (!(child instanceof Container)) continue;
            result.addAll(AccessibilityUtils.visitAndCollectComponents((Container)child, filter));
        }
        return result;
    }

    public static final class DefaultInputElementFilter
    implements Predicate<Component> {
        @Override
        public boolean test(Component c) {
            return c instanceof JTextComponent && ((JTextComponent)c).isRequestFocusEnabled() || c instanceof AbstractButton && !(c instanceof JMenu) || c instanceof JSlider || c instanceof JSpinner || c instanceof JComboBox || c instanceof JList || c instanceof JTable || c instanceof JTree;
        }
    }
}

