/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.internal;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.Locale;

public final class DateUtils {
    private DateUtils() {
    }

    public static boolean isYesterday(Date date) {
        return DateUtils.isYesterday(DateUtils.toLocalDate(date));
    }

    public static boolean isYesterday(LocalDate date) {
        return LocalDate.now().minusDays(1L).equals(date);
    }

    public static boolean isToday(Date date) {
        return DateUtils.isToday(DateUtils.toLocalDate(date));
    }

    public static boolean isToday(LocalDate date) {
        return LocalDate.now().equals(date);
    }

    public static boolean isTomorrow(Date date) {
        return DateUtils.isTomorrow(DateUtils.toLocalDate(date));
    }

    public static boolean isTomorrow(LocalDate date) {
        return LocalDate.now().plusDays(1L).equals(date);
    }

    public static boolean isThisWeek(LocalDate date) {
        int dateWeek;
        TemporalField woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
        int thisWeek = LocalDate.now().get(woy);
        return thisWeek == (dateWeek = date.get(woy));
    }

    public static boolean isThisMonth(LocalDate date) {
        return LocalDate.now().getMonthValue() == date.getMonthValue();
    }

    public static boolean isThisYear(LocalDate date) {
        return LocalDate.now().getYear() == date.getYear();
    }

    public static Date toDate(LocalDate localDate) {
        return localDate == null ? null : Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return localDateTime == null ? null : Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            return ((java.sql.Date)date).toLocalDate();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            ((Timestamp)date).toLocalDateTime();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

