/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.extras;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;

public final class NonNullValueModel
extends AbstractValueModel {
    private final ValueModel subject;
    private final Object defaultValue;

    public NonNullValueModel(ValueModel subject, Object defaultValue) {
        this.subject = subject;
        this.defaultValue = Preconditions.checkNotNull(defaultValue, "The %s must not be null.", "default value");
        subject.addValueChangeListener(this::onSubjectValueChanged);
    }

    @Override
    public Object getValue() {
        Object subjectValue = this.subject.getValue();
        return subjectValue != null ? subjectValue : this.defaultValue;
    }

    @Override
    public void setValue(Object newValue) {
        this.subject.setValue(newValue);
    }

    private void onSubjectValueChanged(PropertyChangeEvent evt) {
        this.fireValueChange(evt.getOldValue(), evt.getNewValue(), true);
    }
}

