---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, cellules, mise en forme,
              faire disparaître une cellule, lignes partielles
---

# Comment supprimer la cellule supérieure gauche ?

Avec les commandes `\multicolumn` et `\cline` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{tabular}{|c|*{9}{c}|}
  \cline{2-10}
  \multicolumn{1}{c|}{}
    & 1 &  2 &  3 &  4 &  5 &  6 &  7 &  8 &  9 \\
  \hline
  1 & 1 &  2 &  3 &  4 &  5 &  6 &  7 &  8 &  9 \\
  2 & 2 &  4 &  6 &  8 & 10 & 12 & 14 & 16 & 18 \\
  3 & 3 &  6 &  9 & 12 & 15 & 18 & 21 & 24 & 27 \\
  4 & 4 &  8 & 12 & 16 & 20 & 24 & 28 & 32 & 36 \\
  5 & 5 & 10 & 15 & 20 & 25 & 30 & 35 & 40 & 45 \\
  6 & 6 & 12 & 18 & 24 & 30 & 36 & 42 & 48 & 54 \\
  7 & 7 & 14 & 21 & 28 & 35 & 42 & 49 & 56 & 63 \\
  8 & 8 & 16 & 24 & 32 & 40 & 48 & 56 & 64 & 72 \\
  9 & 9 & 18 & 27 & 36 & 45 & 54 & 63 & 72 & 81 \\
  \hline
\end{tabular}
\end{document}
```

Dans le détail :
- `\hline` trace une ligne horizontale sur toute la largeur 
  du tableau ;
- `\cline{⟨col1⟩-⟨col2⟩}` trace une ligne horizontale 
  de la colonne numéro `⟨col1⟩` à la colonne numéro `⟨col2⟩`.

Bien sûr, pour supprimer une autre cellule, la même méthode
s'appliquera...


:::{sources}
- [Making stats table with `\multicolumn` and `\cline`](https://tex.stackexchange.com/q/314025), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [Faire des tableaux sous LaTeX](https://www.tuteurs.ens.fr/logiciels/latex/tableaux.html).
:::