---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie,
              style des entrées bibliographiques, unsrt,
              titre de sectionnement
---

# Comment gérer le style bibliographique `unsrt` avec des tables des matières ?

En utilisant le style bibliographique [unsrt](ctanpkg:bibtex), vous vous
attendez à ce que votre bibliographie ne soit *pas* triée : les entrées de la
bibliographie apparaissent alors dans l'ordre dans lequel elles sont apparues
pour la première fois dans votre document.

Cependant, si vous avez la malchance d'avoir besoin d'une citation
bibliographique dans un
[titre de sectionnement](/3_composition/texte/titres/start) et que vous avez
également une table des matières, les citations qui apparaissent maintenant
dans la table des matières perturberont l'ordre "naturel" produit par le style
[unsrt](ctanpkg:bibtex). La situation sera similaire avec des citations dans
des légendes de figure (ou de table) et que vous avez une liste de figures (ou
de tables).


## Avec des suppressions de fichier

Il existe une méthode manuelle assez simple pour résoudre le problème,
dès lors que le document est stable :

1. supprimez le fichier auxiliaire (d'extension `.aux`) et tous les fichiers
  `.toc`, `.lof` ou `.lot` ;
2. exécutez LaTeX ;
3. exécutez `BibTeX` ;
4. exécutez LaTeX aussi souvent que nécessaire pour que le document reste
  stable.


## Avec l'extension <ctanpkg:notoccite>

La méthode manuelle peut rapidement devenir fastidieuse.

L'extension <ctanpkg:notoccite> empêche les citations présentes dans les
entrées de la table des matières, de la liste des figures, ou de celle des
tableaux, d'intervenir dans l'ordre de numérotation.

```
% exemple de fichier .bib
\begin{filecontents}[overwrite,noheader]{\jobname.bib}
@Misc{doc3,
          author =       {Tutu3},
           title =       {Bien boire pour bien dormir, 4\up{e} édition}
}
@Misc{doc2,
          author =       {Titi2},
           title =       {Blabla, 2\up{de} édition}
}
@Misc{doc1,
          author =       {Toto1},
           title =       {Blabla}
}
\end{filecontents}
\documentclass[french]{article}
 \usepackage[T1]{fontenc}
 \usepackage{babel}
 \usepackage{times}
 \usepackage{ipsum}

 \usepackage{notoccite}
 \bibliographystyle{unsrt}

\pagestyle{headings}
\begin{document}\thispagestyle{empty}
\listoftables
\tableofcontents

\bigskip

Cf.~\cite{doc1}.

\section{Voir \cite{doc2}}

\ipsum<Lang=FR>[2]

\begin{table}[htbp]
  \centering
  \begin{tabular}{|l|l|}
    \hline
    Poids&Quantité\\
\hline
55kg&1L\\
\hline
85kg&2L (fraîche)\\
\hline
  \end{tabular}
  \caption{Table issue de \cite{doc3}}
\end{table}

\ipsum<Lang=FR>

\section{Revoir \cite{doc1}}

\ipsum<Lang=FR>[3]

%\clearpage
\bibliography{\jobname.bib}
\end{document}
```

Dans le passé, il fallait que les clés de citation apparaissant dans des
titres susceptibles de se retrouver dans des en-têtes de pages soient en
haut-de-casse, car elles le devenaient dans l'en-tête à cause d'un
`\MakeUppercase`.  On pouvait utiliser l'extension <ctanpkg:textcase>.  Ce
n'est plus nécessaire depuis LaTeX 2022-06-01, comme l'illustre l'exemple
ci-dessus.

:::{todo}
Confirmer que c'est bien depuis LaTeX 2022-06-01 que l'argument
de `\cite` est protégé contre le changement de casse dans les en-têtes.
:::


:::{sources}
[Table of contents rearranges unsrt ordering](faquk:FAQ-bibtocorder)
:::