/*
 * Copyright (C) 2020 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2020 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 08 апр. 2016 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_ROBINSON_DADSON_H_
#define GENERATED_ISO226_ROBINSON_DADSON_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const float robinson_dadson_curve_0_phons[1468] =
    {
        -41.22, -41.16, -41.17, -41.17, -41.16, -41.18, -41.28, -41.36, -41.44, -41.50,
        -41.62, -41.69, -41.75, -41.86, -41.85, -41.93, -42.02, -42.06, -42.12, -42.13,
        -42.23, -42.26, -42.42, -42.51, -42.55, -42.56, -42.56, -42.53, -42.53, -42.63,
        -42.68, -42.74, -42.90, -43.08, -43.24, -43.34, -43.39, -43.53, -43.59, -43.69,
        -43.73, -43.78, -43.82, -43.79, -43.87, -43.91, -43.91, -43.94, -43.95, -43.99,
        -44.05, -44.09, -44.18, -44.20, -44.20, -44.20, -44.24, -44.30, -44.31, -44.41,
        -44.54, -44.56, -44.63, -44.71, -44.77, -44.95, -45.06, -45.11, -45.06, -45.17,
        -45.22, -45.28, -45.28, -45.38, -45.42, -45.40, -45.43, -45.45, -45.48, -45.54,
        -45.52, -45.55, -45.69, -45.81, -45.78, -45.76, -45.87, -46.00, -46.02, -46.02,
        -46.16, -46.29, -46.38, -46.47, -46.48, -46.50, -46.56, -46.58, -46.60, -46.69,
        -46.74, -46.76, -46.80, -46.88, -46.98, -47.00, -47.02, -47.05, -47.07, -47.08,
        -47.14, -47.24, -47.33, -47.38, -47.42, -47.51, -47.59, -47.63, -47.70, -47.69,
        -47.74, -47.81, -47.91, -47.92, -48.01, -48.16, -48.31, -48.37, -48.40, -48.47,
        -48.54, -48.58, -48.65, -48.68, -48.71, -48.76, -48.85, -48.90, -49.01, -49.12,
        -49.13, -49.26, -49.32, -49.43, -49.50, -49.61, -49.65, -49.67, -49.70, -49.83,
        -49.83, -49.86, -49.89, -49.99, -50.00, -50.10, -50.12, -50.14, -50.24, -50.36,
        -50.41, -50.50, -50.65, -50.79, -50.93, -51.01, -51.09, -51.19, -51.23, -51.26,
        -51.37, -51.47, -51.50, -51.53, -51.60, -51.63, -51.66, -51.68, -51.74, -51.81,
        -51.86, -51.92, -52.01, -52.09, -52.16, -52.23, -52.32, -52.48, -52.62, -52.66,
        -52.61, -52.74, -52.93, -52.98, -53.05, -53.11, -53.29, -53.46, -53.55, -53.64,
        -53.71, -53.76, -53.78, -53.83, -53.80, -53.86, -53.92, -53.96, -54.04, -54.09,
        -54.14, -54.14, -54.22, -54.26, -54.31, -54.37, -54.44, -54.49, -54.56, -54.63,
        -54.66, -54.80, -54.91, -55.00, -55.06, -55.14, -55.37, -55.44, -55.52, -55.58,
        -55.62, -55.66, -55.75, -55.83, -55.81, -55.94, -55.96, -56.08, -56.11, -56.21,
        -56.28, -56.34, -56.34, -56.41, -56.50, -56.49, -56.54, -56.60, -56.57, -56.65,
        -56.73, -56.82, -56.86, -56.88, -56.98, -57.04, -57.09, -57.23, -57.28, -57.32,
        -57.32, -57.45, -57.45, -57.61, -57.62, -57.72, -57.74, -57.86, -57.88, -58.00,
        -58.10, -58.22, -58.24, -58.22, -58.30, -58.41, -58.47, -58.49, -58.54, -58.61,
        -58.65, -58.68, -58.71, -58.81, -58.85, -58.94, -58.97, -59.08, -59.10, -59.12,
        -59.20, -59.25, -59.31, -59.34, -59.36, -59.35, -59.38, -59.37, -59.45, -59.54,
        -59.51, -59.55, -59.61, -59.63, -59.77, -59.87, -59.87, -59.99, -60.04, -60.07,
        -60.12, -60.20, -60.25, -60.24, -60.29, -60.31, -60.31, -60.22, -60.23, -60.35,
        -60.46, -60.57, -60.59, -60.70, -60.71, -60.79, -60.89, -60.90, -60.96, -60.96,
        -60.97, -61.03, -61.06, -61.08, -61.10, -61.10, -61.27, -61.29, -61.38, -61.39,
        -61.48, -61.48, -61.58, -61.52, -61.60, -61.61, -61.60, -61.62, -61.65, -61.67,
        -61.69, -61.76, -61.78, -61.77, -61.80, -61.87, -61.91, -61.96, -62.05, -62.07,
        -62.25, -62.25, -62.22, -62.19, -62.21, -62.29, -62.32, -62.36, -62.42, -62.51,
        -62.59, -62.62, -62.69, -62.78, -62.79, -62.79, -62.84, -62.92, -63.00, -63.02,
        -63.04, -63.09, -63.07, -63.16, -63.18, -63.24, -63.29, -63.31, -63.36, -63.33,
        -63.39, -63.40, -63.47, -63.50, -63.55, -63.64, -63.66, -63.73, -63.77, -63.83,
        -63.83, -63.87, -63.92, -63.99, -63.96, -63.96, -63.95, -63.99, -64.01, -64.08,
        -64.22, -64.20, -64.27, -64.26, -64.30, -64.25, -64.29, -64.26, -64.32, -64.31,
        -64.37, -64.35, -64.40, -64.38, -64.43, -64.50, -64.58, -64.65, -64.67, -64.70,
        -64.71, -64.76, -64.74, -64.83, -64.88, -64.85, -64.87, -64.87, -64.95, -64.97,
        -65.01, -65.07, -65.16, -65.14, -65.17, -65.23, -65.31, -65.39, -65.35, -65.36,
        -65.33, -65.40, -65.40, -65.48, -65.51, -65.55, -65.60, -65.58, -65.63, -65.62,
        -65.68, -65.68, -65.77, -65.77, -65.82, -65.80, -65.78, -65.73, -65.81, -65.78,
        -65.76, -65.79, -65.84, -65.97, -66.00, -66.02, -66.08, -66.14, -66.22, -66.28,
        -66.30, -66.29, -66.28, -66.25, -66.26, -66.24, -66.23, -66.21, -66.28, -66.31,
        -66.40, -66.45, -66.48, -66.44, -66.46, -66.51, -66.49, -66.44, -66.47, -66.56,
        -66.52, -66.56, -66.56, -66.62, -66.71, -66.77, -66.85, -66.94, -66.97, -67.00,
        -67.06, -67.07, -67.15, -67.12, -67.20, -67.17, -67.25, -67.19, -67.26, -67.22,
        -67.26, -67.27, -67.30, -67.27, -67.35, -67.34, -67.29, -67.35, -67.33, -67.39,
        -67.36, -67.42, -67.49, -67.56, -67.56, -67.55, -67.60, -67.65, -67.73, -67.69,
        -67.75, -67.76, -67.75, -67.80, -67.81, -67.84, -67.91, -67.94, -67.84, -67.85,
        -67.85, -67.95, -67.95, -68.04, -68.08, -68.11, -68.03, -68.07, -68.11, -68.16,
        -68.17, -68.26, -68.25, -68.20, -68.21, -68.20, -68.29, -68.35, -68.39, -68.43,
        -68.40, -68.41, -68.47, -68.51, -68.58, -68.60, -68.64, -68.64, -68.73, -68.74,
        -68.83, -68.86, -68.91, -68.93, -68.93, -68.99, -69.04, -69.01, -68.99, -69.04,
        -69.05, -69.08, -69.12, -69.15, -69.19, -69.23, -69.25, -69.31, -69.28, -69.31,
        -69.34, -69.42, -69.41, -69.38, -69.46, -69.54, -69.62, -69.66, -69.69, -69.76,
        -69.78, -69.78, -69.71, -69.70, -69.75, -69.79, -69.85, -69.86, -69.93, -69.95,
        -70.02, -70.08, -70.12, -70.13, -70.21, -70.26, -70.33, -70.36, -70.38, -70.44,
        -70.42, -70.43, -70.45, -70.43, -70.49, -70.49, -70.56, -70.54, -70.60, -70.62,
        -70.63, -70.67, -70.74, -70.77, -70.80, -70.84, -70.92, -70.93, -70.94, -70.98,
        -71.01, -71.02, -71.06, -71.10, -71.11, -71.13, -71.15, -71.18, -71.19, -71.22,
        -71.28, -71.32, -71.36, -71.36, -71.37, -71.43, -71.46, -71.53, -71.55, -71.55,
        -71.55, -71.55, -71.55, -71.55, -71.59, -71.64, -71.77, -71.79, -71.88, -71.89,
        -71.89, -71.94, -71.98, -72.04, -72.11, -72.16, -72.21, -72.29, -72.35, -72.39,
        -72.43, -72.43, -72.43, -72.43, -72.43, -72.43, -72.48, -72.52, -72.56, -72.68,
        -72.71, -72.71, -72.76, -72.80, -72.85, -72.90, -72.93, -72.98, -73.01, -73.05,
        -73.10, -73.13, -73.15, -73.19, -73.22, -73.22, -73.24, -73.26, -73.28, -73.28,
        -73.33, -73.39, -73.39, -73.38, -73.44, -73.48, -73.48, -73.47, -73.47, -73.51,
        -73.56, -73.62, -73.64, -73.64, -73.64, -73.69, -73.79, -73.90, -73.97, -74.03,
        -74.12, -74.13, -74.23, -74.23, -74.22, -74.22, -74.26, -74.31, -74.36, -74.38,
        -74.38, -74.44, -74.54, -74.66, -74.76, -74.77, -74.76, -74.76, -74.75, -74.75,
        -74.80, -74.85, -74.81, -74.86, -74.90, -74.92, -74.99, -75.03, -75.07, -75.12,
        -75.18, -75.21, -75.29, -75.31, -75.38, -75.45, -75.50, -75.55, -75.57, -75.64,
        -75.72, -75.74, -75.81, -75.87, -75.89, -75.90, -75.89, -75.89, -75.89, -75.88,
        -75.95, -76.02, -76.07, -76.07, -76.13, -76.20, -76.25, -76.30, -76.39, -76.39,
        -76.44, -76.49, -76.53, -76.53, -76.57, -76.62, -76.71, -76.73, -76.77, -76.85,
        -76.89, -76.97, -76.98, -77.02, -77.02, -77.06, -77.06, -77.21, -77.20, -77.29,
        -77.33, -77.34, -77.34, -77.33, -77.37, -77.37, -77.45, -77.47, -77.52, -77.57,
        -77.59, -77.62, -77.66, -77.67, -77.71, -77.73, -77.74, -77.82, -77.84, -77.89,
        -77.93, -77.95, -77.94, -78.00, -78.08, -78.10, -78.17, -78.16, -78.22, -78.27,
        -78.31, -78.31, -78.30, -78.36, -78.40, -78.39, -78.49, -78.54, -78.63, -78.62,
        -78.67, -78.80, -78.85, -78.85, -78.85, -78.84, -78.88, -78.94, -78.93, -78.88,
        -78.90, -78.88, -78.89, -78.98, -79.04, -79.16, -79.17, -79.17, -79.22, -79.23,
        -79.22, -79.22, -79.22, -79.21, -79.21, -79.22, -79.25, -79.28, -79.34, -79.37,
        -79.36, -79.34, -79.33, -79.34, -79.34, -79.34, -79.34, -79.32, -79.30, -79.29,
        -79.29, -79.29, -79.30, -79.33, -79.37, -79.37, -79.38, -79.42, -79.44, -79.45,
        -79.45, -79.47, -79.39, -79.40, -79.29, -79.29, -79.29, -79.29, -79.34, -79.36,
        -79.40, -79.48, -79.48, -79.48, -79.43, -79.39, -79.35, -79.39, -79.44, -79.44,
        -79.44, -79.44, -79.49, -79.49, -79.49, -79.44, -79.44, -79.42, -79.37, -79.39,
        -79.41, -79.41, -79.46, -79.47, -79.48, -79.43, -79.39, -79.33, -79.32, -79.33,
        -79.43, -79.49, -79.45, -79.40, -79.36, -79.34, -79.36, -79.38, -79.40, -79.35,
        -79.33, -79.29, -79.25, -79.25, -79.19, -79.21, -79.26, -79.24, -79.26, -79.25,
        -79.22, -79.25, -79.23, -79.26, -79.19, -79.23, -79.16, -79.20, -79.23, -79.23,
        -79.17, -79.19, -79.09, -79.05, -78.96, -78.98, -79.00, -78.95, -78.94, -78.85,
        -78.80, -78.79, -78.82, -78.84, -78.82, -78.79, -78.78, -78.78, -78.72, -78.71,
        -78.68, -78.72, -78.62, -78.62, -78.56, -78.59, -78.53, -78.56, -78.63, -78.62,
        -78.59, -78.62, -78.60, -78.60, -78.60, -78.60, -78.59, -78.59, -78.59, -78.58,
        -78.56, -78.55, -78.56, -78.52, -78.58, -78.52, -78.50, -78.50, -78.51, -78.54,
        -78.47, -78.50, -78.45, -78.43, -78.42, -78.37, -78.41, -78.41, -78.37, -78.33,
        -78.21, -78.15, -78.13, -78.09, -78.02, -78.00, -78.01, -77.95, -78.02, -77.89,
        -77.83, -77.82, -77.82, -77.91, -77.87, -77.96, -77.92, -77.92, -77.90, -77.89,
        -77.85, -77.81, -77.74, -77.77, -77.74, -77.72, -77.75, -77.73, -77.68, -77.67,
        -77.72, -77.66, -77.65, -77.58, -77.53, -77.57, -77.55, -77.58, -77.57, -77.51,
        -77.52, -77.53, -77.47, -77.51, -77.49, -77.48, -77.47, -77.40, -77.34, -77.27,
        -77.22, -77.16, -77.13, -77.13, -77.11, -77.10, -77.10, -77.15, -77.18, -77.19,
        -77.21, -77.21, -77.19, -77.21, -77.19, -77.21, -77.26, -77.26, -77.20, -77.20,
        -77.24, -77.24, -77.20, -77.18, -77.22, -77.17, -77.19, -77.15, -77.16, -77.15,
        -77.16, -77.14, -77.16, -77.08, -77.08, -77.03, -77.06, -77.04, -77.06, -77.05,
        -77.08, -77.12, -77.14, -77.13, -77.17, -77.15, -77.18, -77.17, -77.13, -77.11,
        -77.10, -77.08, -76.99, -76.96, -76.90, -76.86, -76.88, -76.90, -76.93, -76.95,
        -76.97, -76.97, -76.98, -76.99, -76.99, -77.01, -77.02, -77.05, -77.07, -77.09,
        -77.08, -77.06, -77.06, -77.06, -77.06, -77.06, -77.05, -77.05, -77.05, -77.05,
        -77.10, -77.11, -77.21, -77.26, -77.26, -77.24, -77.20, -77.16, -77.10, -77.08,
        -77.13, -77.22, -77.26, -77.29, -77.26, -77.29, -77.24, -77.28, -77.27, -77.26,
        -77.25, -77.26, -77.28, -77.28, -77.29, -77.29, -77.25, -77.32, -77.32, -77.39,
        -77.33, -77.34, -77.33, -77.42, -77.37, -77.37, -77.40, -77.44, -77.48, -77.46,
        -77.43, -77.41, -77.40, -77.32, -77.32, -77.36, -77.37, -77.36, -77.39, -77.36,
        -77.29, -77.39, -77.44, -77.45, -77.48, -77.49, -77.56, -77.63, -77.58, -77.54,
        -77.73, -77.78, -77.70, -77.65, -77.70, -77.72, -77.67, -77.71, -77.64, -77.68,
        -77.67, -77.62, -77.63, -77.60, -77.55, -77.55, -77.44, -77.41, -77.38, -77.47,
        -77.61, -77.58, -77.54, -77.47, -77.52, -77.68, -77.46, -77.41, -77.36, -77.47,
        -77.42, -77.43, -77.40, -77.28, -77.09, -77.05, -76.91, -76.83, -76.89, -76.81,
        -76.81, -76.78, -76.75, -76.61, -76.55, -76.52, -76.48, -76.47, -76.36, -76.29,
        -76.26, -76.27, -76.32, -76.34, -76.29, -76.24, -76.33, -76.35, -76.31, -76.26,
        -76.29, -76.18, -75.93, -75.93, -75.97, -75.95, -75.66, -75.60, -75.56, -75.57,
        -75.53, -75.48, -75.43, -75.40, -75.35, -75.25, -75.18, -75.21, -75.13, -75.09,
        -75.03, -75.03, -75.02, -75.04, -74.97, -74.90, -74.82, -74.75, -74.67, -74.63,
        -74.59, -74.46, -74.35, -74.24, -74.21, -74.14, -74.03, -73.96, -73.89, -73.83,
        -73.73, -73.60, -73.46, -73.41, -73.39, -73.39, -73.43, -73.43, -73.36, -73.31,
        -73.25, -73.16, -73.11, -73.06, -73.01, -72.96, -72.87, -72.79, -72.75, -72.65,
        -72.52, -72.52, -72.47, -72.40, -72.29, -72.30, -72.29, -72.21, -72.22, -72.22,
        -72.22, -72.18, -72.12, -72.07, -72.01, -71.96, -71.89, -71.81, -71.74, -71.71,
        -71.64, -71.65, -71.64, -71.56, -71.55, -71.56, -71.51, -71.48, -71.43, -71.35,
        -71.35, -71.33, -71.34, -71.26, -71.17, -71.19, -71.15, -71.11, -71.07, -71.11,
        -71.07, -71.05, -71.02, -71.04, -71.05, -70.96, -70.96, -70.98, -71.02, -70.90,
        -70.84, -70.83, -70.81, -70.79, -70.78, -70.75, -70.70, -70.63, -70.66, -70.72,
        -70.63, -70.57, -70.52, -70.52, -70.48, -70.45, -70.40, -70.36, -70.31, -70.28,
        -70.25, -70.15, -70.02, -69.94, -69.86, -69.81, -69.57, -69.48, -69.40, -69.35,
        -69.17, -69.13, -68.94, -68.87, -68.73, -68.68, -68.52, -68.33, -68.17, -68.03,
        -67.92, -67.76, -67.60, -67.52, -67.31, -67.04, -66.84, -66.58, -66.36, -66.18,
        -65.78, -65.53, -65.32, -64.91, -64.78, -64.25, -64.14, -63.42, -63.13, -62.80,
        -62.54, -62.06, -61.62, -61.22, -60.96, -60.73, -60.36, -60.00
    };

    static const float robinson_dadson_curve_10_phons[1468] =
    {
        -37.61, -37.58, -37.58, -37.61, -37.63, -37.66, -37.76, -37.83, -37.90, -37.95,
        -38.05, -38.10, -38.15, -38.23, -38.23, -38.31, -38.41, -38.46, -38.50, -38.52,
        -38.62, -38.65, -38.75, -38.84, -38.88, -38.89, -38.90, -38.89, -38.86, -38.96,
        -39.00, -39.08, -39.22, -39.40, -39.53, -39.59, -39.64, -39.77, -39.86, -39.91,
        -39.93, -39.97, -40.04, -40.01, -40.05, -40.05, -40.08, -40.17, -40.17, -40.18,
        -40.24, -40.27, -40.36, -40.38, -40.40, -40.39, -40.44, -40.51, -40.53, -40.59,
        -40.66, -40.68, -40.75, -40.80, -40.83, -40.97, -41.04, -41.12, -41.09, -41.25,
        -41.27, -41.32, -41.34, -41.45, -41.49, -41.45, -41.46, -41.47, -41.49, -41.57,
        -41.52, -41.59, -41.71, -41.86, -41.82, -41.77, -41.89, -41.95, -41.95, -42.01,
        -42.08, -42.19, -42.27, -42.37, -42.38, -42.41, -42.48, -42.50, -42.52, -42.58,
        -42.62, -42.65, -42.67, -42.75, -42.83, -42.87, -42.90, -42.92, -42.94, -42.95,
        -43.01, -43.11, -43.19, -43.21, -43.25, -43.33, -43.40, -43.43, -43.48, -43.47,
        -43.52, -43.59, -43.68, -43.69, -43.76, -43.89, -44.04, -44.11, -44.13, -44.17,
        -44.24, -44.30, -44.36, -44.39, -44.42, -44.48, -44.56, -44.62, -44.70, -44.78,
        -44.81, -44.93, -44.98, -45.04, -45.11, -45.22, -45.24, -45.25, -45.27, -45.40,
        -45.39, -45.42, -45.47, -45.57, -45.60, -45.72, -45.75, -45.77, -45.84, -45.94,
        -45.99, -46.08, -46.20, -46.33, -46.41, -46.48, -46.58, -46.66, -46.70, -46.74,
        -46.80, -46.88, -46.93, -46.96, -47.01, -47.04, -47.08, -47.09, -47.17, -47.23,
        -47.29, -47.35, -47.42, -47.50, -47.55, -47.60, -47.67, -47.80, -47.92, -47.96,
        -47.91, -48.04, -48.16, -48.17, -48.21, -48.28, -48.44, -48.58, -48.67, -48.76,
        -48.82, -48.87, -48.88, -48.93, -48.93, -49.01, -49.08, -49.11, -49.20, -49.23,
        -49.25, -49.24, -49.32, -49.37, -49.42, -49.48, -49.57, -49.64, -49.69, -49.75,
        -49.80, -49.92, -50.03, -50.10, -50.15, -50.19, -50.35, -50.39, -50.50, -50.54,
        -50.58, -50.61, -50.69, -50.77, -50.77, -50.86, -50.87, -50.99, -51.03, -51.11,
        -51.15, -51.22, -51.24, -51.36, -51.44, -51.43, -51.47, -51.55, -51.50, -51.59,
        -51.64, -51.70, -51.77, -51.79, -51.86, -51.90, -51.95, -52.06, -52.08, -52.10,
        -52.09, -52.17, -52.17, -52.33, -52.35, -52.45, -52.48, -52.62, -52.64, -52.75,
        -52.81, -52.92, -52.94, -52.94, -53.02, -53.09, -53.15, -53.17, -53.25, -53.30,
        -53.32, -53.34, -53.37, -53.48, -53.49, -53.57, -53.59, -53.72, -53.75, -53.77,
        -53.85, -53.91, -53.94, -53.98, -54.01, -53.99, -54.01, -54.01, -54.06, -54.12,
        -54.13, -54.19, -54.24, -54.27, -54.38, -54.49, -54.49, -54.60, -54.61, -54.60,
        -54.65, -54.76, -54.83, -54.81, -54.84, -54.90, -54.92, -54.85, -54.84, -54.90,
        -54.98, -55.05, -55.07, -55.18, -55.18, -55.24, -55.34, -55.35, -55.40, -55.40,
        -55.40, -55.45, -55.49, -55.52, -55.54, -55.54, -55.68, -55.70, -55.80, -55.81,
        -55.89, -55.90, -56.00, -55.96, -56.05, -56.08, -56.09, -56.13, -56.16, -56.17,
        -56.19, -56.23, -56.23, -56.23, -56.27, -56.34, -56.37, -56.40, -56.49, -56.48,
        -56.59, -56.57, -56.57, -56.55, -56.58, -56.64, -56.68, -56.72, -56.76, -56.85,
        -56.91, -56.93, -56.98, -57.07, -57.09, -57.09, -57.09, -57.18, -57.26, -57.30,
        -57.32, -57.36, -57.36, -57.43, -57.46, -57.51, -57.56, -57.57, -57.62, -57.59,
        -57.65, -57.67, -57.71, -57.75, -57.81, -57.89, -57.90, -57.97, -57.98, -58.03,
        -58.00, -58.04, -58.08, -58.15, -58.12, -58.11, -58.10, -58.16, -58.15, -58.22,
        -58.35, -58.33, -58.40, -58.47, -58.48, -58.45, -58.47, -58.44, -58.51, -58.49,
        -58.54, -58.50, -58.57, -58.52, -58.59, -58.68, -58.75, -58.81, -58.82, -58.88,
        -58.90, -58.93, -58.91, -58.99, -59.01, -58.96, -58.98, -58.98, -59.01, -59.01,
        -59.05, -59.13, -59.20, -59.19, -59.25, -59.30, -59.38, -59.44, -59.41, -59.45,
        -59.42, -59.47, -59.46, -59.50, -59.53, -59.54, -59.60, -59.58, -59.64, -59.62,
        -59.68, -59.66, -59.75, -59.77, -59.84, -59.83, -59.85, -59.81, -59.89, -59.84,
        -59.84, -59.87, -59.93, -60.01, -60.03, -60.04, -60.09, -60.16, -60.22, -60.29,
        -60.31, -60.28, -60.29, -60.25, -60.27, -60.26, -60.26, -60.23, -60.27, -60.28,
        -60.35, -60.40, -60.44, -60.41, -60.46, -60.50, -60.48, -60.48, -60.50, -60.55,
        -60.53, -60.59, -60.60, -60.66, -60.74, -60.79, -60.88, -60.94, -60.98, -60.99,
        -61.04, -61.05, -61.10, -61.08, -61.13, -61.12, -61.18, -61.14, -61.21, -61.20,
        -61.24, -61.23, -61.28, -61.24, -61.32, -61.29, -61.27, -61.32, -61.31, -61.36,
        -61.29, -61.33, -61.38, -61.44, -61.44, -61.46, -61.51, -61.54, -61.63, -61.56,
        -61.60, -61.61, -61.59, -61.66, -61.67, -61.70, -61.77, -61.78, -61.72, -61.74,
        -61.73, -61.81, -61.85, -61.90, -61.95, -61.97, -61.92, -61.95, -62.02, -62.07,
        -62.09, -62.14, -62.16, -62.11, -62.09, -62.07, -62.13, -62.19, -62.21, -62.22,
        -62.20, -62.23, -62.25, -62.28, -62.33, -62.34, -62.39, -62.39, -62.48, -62.49,
        -62.55, -62.60, -62.65, -62.68, -62.70, -62.77, -62.80, -62.79, -62.77, -62.84,
        -62.84, -62.90, -62.93, -62.94, -62.99, -63.03, -63.04, -63.07, -63.04, -63.06,
        -63.11, -63.17, -63.14, -63.10, -63.16, -63.22, -63.30, -63.35, -63.38, -63.45,
        -63.47, -63.48, -63.39, -63.36, -63.41, -63.48, -63.51, -63.54, -63.60, -63.63,
        -63.67, -63.72, -63.77, -63.79, -63.83, -63.87, -63.93, -63.96, -63.97, -64.02,
        -64.01, -64.01, -64.00, -63.98, -64.02, -64.03, -64.06, -64.08, -64.11, -64.16,
        -64.19, -64.21, -64.25, -64.27, -64.28, -64.33, -64.41, -64.44, -64.47, -64.52,
        -64.53, -64.57, -64.59, -64.61, -64.61, -64.64, -64.67, -64.69, -64.72, -64.76,
        -64.79, -64.81, -64.83, -64.83, -64.83, -64.86, -64.88, -64.92, -64.92, -64.93,
        -64.94, -64.94, -64.98, -64.98, -65.04, -65.08, -65.20, -65.23, -65.34, -65.35,
        -65.35, -65.37, -65.39, -65.42, -65.46, -65.48, -65.51, -65.59, -65.65, -65.70,
        -65.74, -65.75, -65.75, -65.75, -65.77, -65.77, -65.80, -65.84, -65.88, -65.96,
        -65.98, -65.99, -66.01, -66.04, -66.06, -66.09, -66.10, -66.15, -66.17, -66.21,
        -66.28, -66.32, -66.35, -66.37, -66.38, -66.39, -66.43, -66.45, -66.48, -66.50,
        -66.55, -66.60, -66.60, -66.60, -66.65, -66.69, -66.69, -66.68, -66.69, -66.70,
        -66.73, -66.76, -66.76, -66.76, -66.76, -66.81, -66.91, -66.99, -67.03, -67.06,
        -67.18, -67.22, -67.33, -67.35, -67.34, -67.34, -67.36, -67.38, -67.40, -67.41,
        -67.41, -67.46, -67.54, -67.64, -67.71, -67.71, -67.71, -67.70, -67.69, -67.69,
        -67.74, -67.79, -67.75, -67.80, -67.84, -67.86, -67.91, -67.93, -67.96, -68.00,
        -68.04, -68.06, -68.13, -68.14, -68.19, -68.25, -68.28, -68.33, -68.34, -68.40,
        -68.46, -68.47, -68.53, -68.58, -68.59, -68.59, -68.59, -68.59, -68.58, -68.58,
        -68.64, -68.72, -68.76, -68.77, -68.83, -68.90, -68.94, -68.99, -69.08, -69.08,
        -69.13, -69.18, -69.23, -69.22, -69.27, -69.29, -69.36, -69.37, -69.38, -69.43,
        -69.45, -69.51, -69.49, -69.53, -69.51, -69.55, -69.53, -69.68, -69.65, -69.74,
        -69.78, -69.77, -69.76, -69.76, -69.80, -69.80, -69.87, -69.90, -69.94, -69.99,
        -70.02, -70.05, -70.08, -70.10, -70.14, -70.16, -70.18, -70.25, -70.26, -70.30,
        -70.30, -70.30, -70.26, -70.28, -70.35, -70.36, -70.41, -70.41, -70.46, -70.50,
        -70.54, -70.53, -70.51, -70.56, -70.60, -70.57, -70.67, -70.69, -70.74, -70.73,
        -70.78, -70.87, -70.91, -70.91, -70.91, -70.90, -70.95, -71.02, -71.02, -70.98,
        -71.01, -71.00, -70.98, -71.05, -71.08, -71.19, -71.18, -71.18, -71.25, -71.26,
        -71.26, -71.26, -71.26, -71.25, -71.25, -71.26, -71.27, -71.29, -71.32, -71.36,
        -71.36, -71.33, -71.32, -71.33, -71.33, -71.34, -71.34, -71.31, -71.30, -71.30,
        -71.30, -71.30, -71.30, -71.32, -71.34, -71.35, -71.35, -71.37, -71.38, -71.39,
        -71.38, -71.39, -71.30, -71.30, -71.20, -71.20, -71.20, -71.20, -71.23, -71.23,
        -71.26, -71.30, -71.32, -71.32, -71.29, -71.28, -71.23, -71.26, -71.28, -71.28,
        -71.28, -71.28, -71.30, -71.30, -71.30, -71.25, -71.25, -71.19, -71.14, -71.15,
        -71.16, -71.16, -71.19, -71.21, -71.23, -71.19, -71.14, -71.09, -71.10, -71.11,
        -71.19, -71.24, -71.21, -71.18, -71.13, -71.13, -71.14, -71.15, -71.15, -71.10,
        -71.08, -71.05, -71.00, -71.02, -70.98, -70.98, -71.01, -71.00, -71.03, -71.01,
        -70.94, -70.95, -70.92, -70.94, -70.86, -70.88, -70.80, -70.81, -70.83, -70.84,
        -70.80, -70.81, -70.74, -70.69, -70.62, -70.63, -70.63, -70.59, -70.59, -70.49,
        -70.45, -70.44, -70.47, -70.48, -70.46, -70.41, -70.40, -70.44, -70.41, -70.38,
        -70.35, -70.39, -70.29, -70.29, -70.22, -70.24, -70.18, -70.21, -70.25, -70.27,
        -70.25, -70.25, -70.24, -70.22, -70.22, -70.21, -70.20, -70.18, -70.20, -70.17,
        -70.16, -70.13, -70.15, -70.12, -70.15, -70.10, -70.10, -70.09, -70.09, -70.15,
        -70.07, -70.12, -70.04, -70.01, -70.02, -69.96, -70.00, -69.98, -69.96, -69.93,
        -69.84, -69.79, -69.77, -69.71, -69.67, -69.61, -69.59, -69.56, -69.63, -69.52,
        -69.50, -69.49, -69.50, -69.55, -69.51, -69.60, -69.58, -69.54, -69.52, -69.50,
        -69.45, -69.43, -69.40, -69.41, -69.40, -69.35, -69.38, -69.32, -69.30, -69.26,
        -69.33, -69.25, -69.26, -69.21, -69.14, -69.19, -69.14, -69.17, -69.15, -69.12,
        -69.12, -69.13, -69.10, -69.14, -69.10, -69.13, -69.12, -69.06, -68.99, -68.92,
        -68.90, -68.82, -68.81, -68.81, -68.79, -68.78, -68.79, -68.86, -68.89, -68.91,
        -68.94, -68.91, -68.92, -68.91, -68.88, -68.86, -68.90, -68.89, -68.84, -68.82,
        -68.84, -68.83, -68.83, -68.85, -68.92, -68.87, -68.90, -68.85, -68.87, -68.86,
        -68.85, -68.81, -68.83, -68.78, -68.79, -68.74, -68.77, -68.75, -68.77, -68.75,
        -68.76, -68.80, -68.80, -68.82, -68.84, -68.82, -68.84, -68.84, -68.83, -68.82,
        -68.81, -68.82, -68.74, -68.73, -68.69, -68.68, -68.71, -68.72, -68.73, -68.74,
        -68.75, -68.75, -68.76, -68.76, -68.77, -68.77, -68.78, -68.79, -68.80, -68.81,
        -68.81, -68.80, -68.80, -68.80, -68.80, -68.80, -68.80, -68.80, -68.80, -68.80,
        -68.85, -68.85, -68.95, -69.00, -69.00, -68.99, -68.97, -68.95, -68.92, -68.91,
        -68.96, -69.05, -69.07, -69.10, -69.05, -69.11, -69.06, -69.11, -69.09, -69.11,
        -69.11, -69.09, -69.10, -69.10, -69.11, -69.12, -69.08, -69.14, -69.11, -69.19,
        -69.12, -69.17, -69.15, -69.25, -69.22, -69.24, -69.25, -69.27, -69.32, -69.30,
        -69.27, -69.28, -69.30, -69.24, -69.26, -69.29, -69.29, -69.28, -69.32, -69.30,
        -69.25, -69.36, -69.41, -69.44, -69.41, -69.44, -69.52, -69.60, -69.56, -69.51,
        -69.68, -69.69, -69.63, -69.60, -69.63, -69.65, -69.56, -69.59, -69.52, -69.57,
        -69.59, -69.59, -69.63, -69.60, -69.56, -69.58, -69.48, -69.47, -69.40, -69.49,
        -69.62, -69.58, -69.53, -69.47, -69.48, -69.66, -69.51, -69.47, -69.45, -69.50,
        -69.48, -69.51, -69.48, -69.36, -69.20, -69.19, -69.09, -69.05, -69.12, -69.06,
        -69.08, -69.09, -69.12, -69.02, -68.99, -68.97, -68.90, -68.89, -68.81, -68.76,
        -68.74, -68.74, -68.78, -68.77, -68.70, -68.67, -68.72, -68.74, -68.70, -68.65,
        -68.69, -68.57, -68.45, -68.43, -68.46, -68.45, -68.24, -68.23, -68.21, -68.18,
        -68.11, -68.08, -68.05, -68.02, -67.96, -67.89, -67.83, -67.84, -67.83, -67.84,
        -67.83, -67.84, -67.83, -67.84, -67.81, -67.74, -67.68, -67.60, -67.53, -67.48,
        -67.46, -67.35, -67.25, -67.15, -67.13, -67.07, -66.97, -66.90, -66.88, -66.82,
        -66.72, -66.61, -66.50, -66.45, -66.44, -66.44, -66.46, -66.49, -66.43, -66.39,
        -66.32, -66.28, -66.23, -66.16, -66.11, -66.09, -66.02, -65.95, -65.93, -65.84,
        -65.73, -65.73, -65.68, -65.64, -65.58, -65.59, -65.59, -65.50, -65.50, -65.50,
        -65.51, -65.48, -65.44, -65.39, -65.34, -65.27, -65.23, -65.14, -65.11, -65.07,
        -65.03, -65.04, -65.05, -65.00, -65.00, -65.02, -65.00, -64.97, -64.93, -64.88,
        -64.88, -64.89, -64.94, -64.89, -64.81, -64.81, -64.78, -64.79, -64.77, -64.79,
        -64.74, -64.75, -64.74, -64.73, -64.75, -64.69, -64.69, -64.68, -64.71, -64.65,
        -64.59, -64.58, -64.56, -64.57, -64.57, -64.55, -64.47, -64.43, -64.46, -64.49,
        -64.45, -64.39, -64.37, -64.39, -64.37, -64.37, -64.33, -64.34, -64.34, -64.32,
        -64.31, -64.23, -64.13, -64.09, -64.01, -63.96, -63.74, -63.70, -63.62, -63.60,
        -63.44, -63.40, -63.26, -63.20, -63.06, -63.01, -62.85, -62.69, -62.55, -62.46,
        -62.38, -62.22, -62.11, -62.01, -61.81, -61.61, -61.41, -61.23, -61.08, -60.92,
        -60.57, -60.35, -60.18, -59.85, -59.70, -59.21, -59.04, -58.48, -58.09, -57.81,
        -57.53, -57.25, -56.89, -56.46, -56.20, -55.94, -55.65, -55.40
    };

    static const float robinson_dadson_curve_20_phons[1468] =
    {
        -34.00, -33.99, -34.00, -34.05, -34.10, -34.15, -34.24, -34.30, -34.36, -34.40,
        -34.48, -34.51, -34.55, -34.60, -34.61, -34.69, -34.80, -34.85, -34.89, -34.91,
        -35.01, -35.04, -35.09, -35.16, -35.21, -35.22, -35.25, -35.25, -35.19, -35.28,
        -35.33, -35.42, -35.54, -35.72, -35.83, -35.85, -35.88, -36.01, -36.12, -36.14,
        -36.13, -36.16, -36.26, -36.24, -36.22, -36.19, -36.26, -36.40, -36.39, -36.37,
        -36.43, -36.45, -36.53, -36.56, -36.59, -36.58, -36.64, -36.72, -36.76, -36.77,
        -36.78, -36.80, -36.86, -36.89, -36.89, -36.98, -37.02, -37.12, -37.12, -37.33,
        -37.32, -37.35, -37.40, -37.52, -37.55, -37.49, -37.49, -37.50, -37.49, -37.59,
        -37.53, -37.64, -37.73, -37.90, -37.86, -37.79, -37.90, -37.90, -37.89, -37.99,
        -38.01, -38.09, -38.16, -38.27, -38.28, -38.32, -38.41, -38.41, -38.44, -38.46,
        -38.51, -38.53, -38.55, -38.62, -38.68, -38.74, -38.78, -38.78, -38.80, -38.82,
        -38.89, -38.98, -39.04, -39.04, -39.07, -39.15, -39.22, -39.23, -39.27, -39.25,
        -39.29, -39.36, -39.46, -39.46, -39.51, -39.61, -39.76, -39.84, -39.85, -39.88,
        -39.94, -40.01, -40.07, -40.10, -40.13, -40.20, -40.28, -40.33, -40.39, -40.44,
        -40.50, -40.60, -40.64, -40.66, -40.73, -40.83, -40.84, -40.83, -40.83, -40.97,
        -40.96, -40.99, -41.05, -41.15, -41.21, -41.34, -41.38, -41.39, -41.45, -41.53,
        -41.58, -41.66, -41.75, -41.87, -41.90, -41.96, -42.06, -42.13, -42.18, -42.23,
        -42.24, -42.29, -42.37, -42.38, -42.42, -42.45, -42.49, -42.50, -42.59, -42.65,
        -42.72, -42.77, -42.83, -42.90, -42.94, -42.97, -43.02, -43.13, -43.22, -43.27,
        -43.21, -43.34, -43.39, -43.35, -43.38, -43.45, -43.59, -43.69, -43.79, -43.88,
        -43.94, -43.97, -43.98, -44.03, -44.06, -44.17, -44.23, -44.25, -44.36, -44.37,
        -44.36, -44.33, -44.42, -44.48, -44.52, -44.59, -44.70, -44.78, -44.82, -44.87,
        -44.93, -45.05, -45.15, -45.19, -45.25, -45.25, -45.34, -45.35, -45.48, -45.51,
        -45.54, -45.55, -45.63, -45.72, -45.73, -45.78, -45.78, -45.90, -45.94, -46.02,
        -46.03, -46.11, -46.15, -46.31, -46.38, -46.36, -46.41, -46.50, -46.43, -46.53,
        -46.54, -46.58, -46.67, -46.69, -46.74, -46.76, -46.82, -46.89, -46.88, -46.89,
        -46.86, -46.89, -46.89, -47.05, -47.08, -47.18, -47.21, -47.37, -47.41, -47.50,
        -47.51, -47.62, -47.64, -47.65, -47.74, -47.77, -47.83, -47.85, -47.95, -48.00,
        -47.98, -48.00, -48.04, -48.16, -48.13, -48.19, -48.22, -48.36, -48.39, -48.42,
        -48.49, -48.56, -48.57, -48.62, -48.65, -48.62, -48.65, -48.65, -48.67, -48.71,
        -48.76, -48.82, -48.87, -48.91, -49.00, -49.11, -49.11, -49.20, -49.19, -49.13,
        -49.18, -49.32, -49.41, -49.38, -49.40, -49.50, -49.54, -49.48, -49.44, -49.45,
        -49.50, -49.53, -49.55, -49.65, -49.65, -49.69, -49.79, -49.79, -49.83, -49.83,
        -49.83, -49.88, -49.92, -49.95, -49.98, -49.98, -50.09, -50.12, -50.22, -50.22,
        -50.31, -50.31, -50.43, -50.40, -50.50, -50.55, -50.58, -50.65, -50.67, -50.67,
        -50.69, -50.69, -50.68, -50.68, -50.74, -50.80, -50.83, -50.84, -50.92, -50.89,
        -50.92, -50.88, -50.92, -50.91, -50.95, -51.00, -51.04, -51.08, -51.10, -51.18,
        -51.23, -51.24, -51.26, -51.36, -51.38, -51.38, -51.34, -51.44, -51.53, -51.58,
        -51.60, -51.63, -51.64, -51.69, -51.75, -51.79, -51.83, -51.84, -51.88, -51.86,
        -51.91, -51.94, -51.95, -52.00, -52.07, -52.15, -52.13, -52.20, -52.20, -52.22,
        -52.17, -52.21, -52.24, -52.31, -52.28, -52.25, -52.25, -52.33, -52.29, -52.37,
        -52.48, -52.47, -52.54, -52.67, -52.66, -52.66, -52.64, -52.62, -52.71, -52.66,
        -52.71, -52.66, -52.75, -52.67, -52.75, -52.86, -52.91, -52.97, -52.97, -53.06,
        -53.09, -53.10, -53.08, -53.14, -53.14, -53.07, -53.09, -53.08, -53.08, -53.05,
        -53.10, -53.18, -53.24, -53.24, -53.33, -53.38, -53.44, -53.49, -53.47, -53.53,
        -53.52, -53.53, -53.52, -53.52, -53.54, -53.53, -53.60, -53.58, -53.64, -53.62,
        -53.68, -53.64, -53.72, -53.77, -53.86, -53.87, -53.91, -53.90, -53.96, -53.90,
        -53.91, -53.95, -54.01, -54.05, -54.06, -54.06, -54.11, -54.17, -54.22, -54.30,
        -54.31, -54.27, -54.30, -54.25, -54.29, -54.28, -54.29, -54.25, -54.26, -54.25,
        -54.31, -54.36, -54.39, -54.39, -54.46, -54.49, -54.47, -54.51, -54.52, -54.53,
        -54.54, -54.61, -54.64, -54.70, -54.76, -54.81, -54.91, -54.93, -54.98, -54.99,
        -55.02, -55.04, -55.06, -55.04, -55.07, -55.07, -55.11, -55.09, -55.16, -55.17,
        -55.22, -55.20, -55.25, -55.21, -55.29, -55.25, -55.24, -55.28, -55.28, -55.32,
        -55.23, -55.23, -55.28, -55.32, -55.33, -55.36, -55.43, -55.44, -55.52, -55.43,
        -55.44, -55.45, -55.44, -55.51, -55.53, -55.56, -55.63, -55.62, -55.61, -55.62,
        -55.61, -55.67, -55.76, -55.76, -55.82, -55.82, -55.81, -55.84, -55.93, -55.98,
        -56.02, -56.03, -56.07, -56.02, -55.98, -55.95, -55.97, -56.02, -56.03, -56.02,
        -56.00, -56.05, -56.03, -56.05, -56.09, -56.08, -56.14, -56.14, -56.23, -56.23,
        -56.28, -56.35, -56.40, -56.44, -56.47, -56.54, -56.55, -56.58, -56.55, -56.64,
        -56.64, -56.72, -56.73, -56.73, -56.79, -56.83, -56.83, -56.83, -56.80, -56.81,
        -56.87, -56.92, -56.87, -56.83, -56.86, -56.91, -56.99, -57.03, -57.08, -57.14,
        -57.15, -57.17, -57.08, -57.02, -57.07, -57.16, -57.18, -57.23, -57.27, -57.32,
        -57.32, -57.36, -57.42, -57.45, -57.45, -57.48, -57.53, -57.55, -57.55, -57.60,
        -57.60, -57.60, -57.55, -57.53, -57.54, -57.57, -57.56, -57.61, -57.63, -57.71,
        -57.76, -57.76, -57.76, -57.76, -57.76, -57.81, -57.90, -57.95, -58.01, -58.06,
        -58.06, -58.12, -58.12, -58.12, -58.12, -58.15, -58.19, -58.20, -58.25, -58.30,
        -58.30, -58.30, -58.30, -58.29, -58.30, -58.30, -58.30, -58.30, -58.30, -58.32,
        -58.33, -58.33, -58.42, -58.42, -58.49, -58.51, -58.62, -58.66, -58.80, -58.81,
        -58.81, -58.81, -58.81, -58.81, -58.81, -58.81, -58.81, -58.89, -58.94, -59.00,
        -59.05, -59.07, -59.08, -59.08, -59.10, -59.11, -59.13, -59.15, -59.19, -59.24,
        -59.26, -59.27, -59.27, -59.27, -59.27, -59.28, -59.28, -59.32, -59.33, -59.38,
        -59.46, -59.50, -59.56, -59.55, -59.55, -59.55, -59.62, -59.64, -59.68, -59.73,
        -59.77, -59.82, -59.81, -59.81, -59.86, -59.90, -59.90, -59.90, -59.90, -59.89,
        -59.89, -59.89, -59.89, -59.88, -59.88, -59.94, -60.03, -60.09, -60.09, -60.09,
        -60.23, -60.31, -60.43, -60.47, -60.46, -60.46, -60.46, -60.44, -60.43, -60.43,
        -60.43, -60.48, -60.54, -60.61, -60.66, -60.66, -60.65, -60.64, -60.64, -60.64,
        -60.69, -60.73, -60.69, -60.74, -60.78, -60.80, -60.83, -60.82, -60.86, -60.87,
        -60.90, -60.91, -60.96, -60.96, -61.00, -61.05, -61.06, -61.10, -61.10, -61.15,
        -61.20, -61.20, -61.25, -61.29, -61.29, -61.29, -61.28, -61.28, -61.27, -61.27,
        -61.34, -61.41, -61.46, -61.46, -61.52, -61.59, -61.64, -61.69, -61.78, -61.78,
        -61.83, -61.88, -61.92, -61.92, -61.96, -61.96, -62.01, -62.00, -61.99, -62.01,
        -62.01, -62.04, -62.00, -62.03, -62.00, -62.04, -62.00, -62.14, -62.10, -62.18,
        -62.23, -62.20, -62.19, -62.18, -62.23, -62.22, -62.30, -62.32, -62.37, -62.42,
        -62.44, -62.47, -62.51, -62.52, -62.56, -62.60, -62.61, -62.68, -62.68, -62.70,
        -62.67, -62.65, -62.57, -62.57, -62.62, -62.61, -62.66, -62.66, -62.70, -62.74,
        -62.76, -62.75, -62.71, -62.76, -62.80, -62.75, -62.85, -62.84, -62.85, -62.84,
        -62.89, -62.93, -62.98, -62.98, -62.98, -62.97, -63.02, -63.11, -63.11, -63.07,
        -63.12, -63.11, -63.07, -63.11, -63.13, -63.21, -63.19, -63.20, -63.28, -63.30,
        -63.30, -63.30, -63.30, -63.30, -63.29, -63.29, -63.29, -63.29, -63.30, -63.36,
        -63.36, -63.33, -63.32, -63.32, -63.32, -63.34, -63.34, -63.29, -63.31, -63.30,
        -63.30, -63.30, -63.30, -63.31, -63.32, -63.32, -63.32, -63.32, -63.32, -63.32,
        -63.31, -63.31, -63.21, -63.21, -63.11, -63.11, -63.11, -63.11, -63.11, -63.11,
        -63.11, -63.12, -63.16, -63.16, -63.15, -63.16, -63.12, -63.12, -63.12, -63.12,
        -63.12, -63.12, -63.12, -63.12, -63.12, -63.07, -63.07, -62.97, -62.91, -62.91,
        -62.91, -62.92, -62.92, -62.96, -62.98, -62.95, -62.89, -62.85, -62.87, -62.90,
        -62.96, -62.99, -62.96, -62.95, -62.91, -62.91, -62.91, -62.93, -62.90, -62.86,
        -62.83, -62.80, -62.76, -62.79, -62.76, -62.75, -62.76, -62.76, -62.81, -62.76,
        -62.67, -62.66, -62.62, -62.62, -62.53, -62.52, -62.43, -62.43, -62.43, -62.46,
        -62.43, -62.43, -62.39, -62.34, -62.28, -62.28, -62.27, -62.24, -62.24, -62.14,
        -62.10, -62.08, -62.11, -62.12, -62.10, -62.03, -62.02, -62.10, -62.09, -62.05,
        -62.01, -62.06, -61.97, -61.96, -61.88, -61.90, -61.83, -61.86, -61.88, -61.91,
        -61.91, -61.87, -61.89, -61.84, -61.85, -61.83, -61.82, -61.77, -61.81, -61.75,
        -61.76, -61.71, -61.73, -61.72, -61.72, -61.68, -61.70, -61.68, -61.66, -61.76,
        -61.68, -61.73, -61.64, -61.59, -61.62, -61.55, -61.59, -61.56, -61.54, -61.53,
        -61.47, -61.43, -61.40, -61.32, -61.32, -61.23, -61.18, -61.18, -61.24, -61.14,
        -61.17, -61.15, -61.18, -61.20, -61.15, -61.24, -61.24, -61.15, -61.13, -61.10,
        -61.06, -61.04, -61.06, -61.05, -61.05, -60.97, -61.00, -60.92, -60.92, -60.86,
        -60.93, -60.84, -60.87, -60.83, -60.74, -60.81, -60.73, -60.76, -60.73, -60.73,
        -60.73, -60.73, -60.73, -60.77, -60.71, -60.77, -60.77, -60.72, -60.63, -60.58,
        -60.57, -60.48, -60.48, -60.48, -60.47, -60.46, -60.47, -60.57, -60.59, -60.62,
        -60.66, -60.62, -60.65, -60.62, -60.57, -60.52, -60.54, -60.52, -60.48, -60.44,
        -60.44, -60.43, -60.46, -60.53, -60.63, -60.58, -60.61, -60.56, -60.57, -60.57,
        -60.53, -60.48, -60.50, -60.49, -60.50, -60.45, -60.49, -60.46, -60.48, -60.45,
        -60.44, -60.48, -60.47, -60.50, -60.50, -60.50, -60.50, -60.52, -60.52, -60.53,
        -60.53, -60.56, -60.49, -60.51, -60.49, -60.49, -60.53, -60.54, -60.54, -60.54,
        -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54,
        -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54, -60.54,
        -60.59, -60.59, -60.69, -60.74, -60.74, -60.74, -60.74, -60.74, -60.74, -60.74,
        -60.79, -60.88, -60.88, -60.90, -60.85, -60.94, -60.89, -60.94, -60.91, -60.96,
        -60.96, -60.92, -60.93, -60.93, -60.93, -60.95, -60.91, -60.97, -60.91, -60.99,
        -60.92, -60.99, -60.97, -61.08, -61.06, -61.10, -61.11, -61.11, -61.15, -61.13,
        -61.12, -61.14, -61.19, -61.16, -61.19, -61.23, -61.20, -61.20, -61.24, -61.24,
        -61.20, -61.34, -61.39, -61.43, -61.35, -61.39, -61.47, -61.58, -61.53, -61.48,
        -61.64, -61.60, -61.56, -61.56, -61.56, -61.59, -61.46, -61.46, -61.41, -61.45,
        -61.51, -61.56, -61.63, -61.59, -61.57, -61.61, -61.53, -61.54, -61.43, -61.52,
        -61.63, -61.59, -61.52, -61.47, -61.44, -61.64, -61.55, -61.54, -61.54, -61.54,
        -61.55, -61.59, -61.56, -61.45, -61.31, -61.32, -61.26, -61.27, -61.36, -61.31,
        -61.35, -61.41, -61.50, -61.42, -61.43, -61.42, -61.33, -61.30, -61.26, -61.23,
        -61.22, -61.20, -61.24, -61.20, -61.10, -61.09, -61.11, -61.12, -61.09, -61.04,
        -61.09, -60.96, -60.96, -60.94, -60.96, -60.95, -60.81, -60.86, -60.87, -60.78,
        -60.70, -60.68, -60.67, -60.64, -60.56, -60.54, -60.47, -60.47, -60.53, -60.59,
        -60.63, -60.64, -60.63, -60.63, -60.64, -60.58, -60.53, -60.46, -60.39, -60.33,
        -60.32, -60.23, -60.15, -60.05, -60.05, -60.00, -59.90, -59.85, -59.87, -59.80,
        -59.71, -59.62, -59.53, -59.49, -59.49, -59.49, -59.50, -59.54, -59.51, -59.47,
        -59.40, -59.40, -59.35, -59.26, -59.21, -59.21, -59.16, -59.11, -59.11, -59.03,
        -58.94, -58.94, -58.89, -58.89, -58.88, -58.89, -58.88, -58.79, -58.78, -58.78,
        -58.79, -58.78, -58.76, -58.71, -58.66, -58.58, -58.56, -58.47, -58.47, -58.42,
        -58.42, -58.43, -58.47, -58.43, -58.45, -58.48, -58.50, -58.46, -58.44, -58.41,
        -58.41, -58.44, -58.53, -58.52, -58.44, -58.43, -58.40, -58.47, -58.47, -58.48,
        -58.42, -58.45, -58.46, -58.41, -58.45, -58.41, -58.42, -58.39, -58.41, -58.40,
        -58.33, -58.33, -58.31, -58.35, -58.36, -58.36, -58.25, -58.22, -58.25, -58.27,
        -58.27, -58.21, -58.22, -58.27, -58.27, -58.30, -58.26, -58.32, -58.38, -58.36,
        -58.36, -58.31, -58.24, -58.25, -58.17, -58.12, -57.92, -57.92, -57.84, -57.84,
        -57.71, -57.67, -57.58, -57.53, -57.40, -57.35, -57.17, -57.06, -56.93, -56.89,
        -56.85, -56.67, -56.62, -56.50, -56.31, -56.17, -55.99, -55.87, -55.80, -55.65,
        -55.36, -55.17, -55.03, -54.79, -54.62, -54.17, -53.94, -53.53, -53.04, -52.83,
        -52.53, -52.44, -52.17, -51.69, -51.43, -51.16, -50.93, -50.81
    };

    static const float robinson_dadson_curve_30_phons[1468] =
    {
        -29.25, -29.22, -29.21, -29.23, -29.23, -29.26, -29.35, -29.41, -29.45, -29.48,
        -29.56, -29.59, -29.61, -29.70, -29.71, -29.77, -29.85, -29.90, -29.96, -29.96,
        -30.06, -30.06, -30.11, -30.21, -30.24, -30.25, -30.27, -30.31, -30.26, -30.31,
        -30.39, -30.47, -30.58, -30.74, -30.83, -30.82, -30.83, -30.91, -31.02, -31.04,
        -31.00, -30.99, -31.09, -31.07, -31.04, -31.03, -31.10, -31.18, -31.11, -31.13,
        -31.20, -31.28, -31.37, -31.41, -31.41, -31.40, -31.46, -31.54, -31.57, -31.58,
        -31.58, -31.60, -31.67, -31.71, -31.69, -31.78, -31.80, -31.84, -31.84, -32.00,
        -32.05, -32.06, -32.04, -32.10, -32.13, -32.08, -32.09, -32.10, -32.14, -32.21,
        -32.19, -32.30, -32.38, -32.48, -32.47, -32.39, -32.46, -32.46, -32.44, -32.59,
        -32.59, -32.66, -32.68, -32.79, -32.80, -32.86, -32.92, -32.93, -32.94, -32.99,
        -33.01, -33.06, -33.10, -33.17, -33.19, -33.24, -33.25, -33.23, -33.23, -33.24,
        -33.32, -33.37, -33.42, -33.47, -33.50, -33.57, -33.60, -33.58, -33.67, -33.64,
        -33.66, -33.71, -33.82, -33.81, -33.82, -33.88, -34.02, -34.08, -34.13, -34.16,
        -34.20, -34.25, -34.30, -34.31, -34.35, -34.39, -34.46, -34.50, -34.59, -34.62,
        -34.65, -34.76, -34.80, -34.83, -34.89, -35.00, -34.99, -34.98, -34.98, -35.10,
        -35.09, -35.08, -35.12, -35.21, -35.25, -35.36, -35.40, -35.39, -35.42, -35.48,
        -35.52, -35.61, -35.68, -35.76, -35.80, -35.84, -35.90, -35.97, -36.01, -36.08,
        -36.10, -36.14, -36.19, -36.21, -36.24, -36.27, -36.33, -36.38, -36.46, -36.50,
        -36.50, -36.53, -36.56, -36.62, -36.64, -36.69, -36.74, -36.82, -36.89, -36.93,
        -36.90, -37.01, -37.05, -36.99, -37.01, -37.09, -37.19, -37.31, -37.40, -37.48,
        -37.51, -37.56, -37.57, -37.62, -37.64, -37.72, -37.80, -37.83, -37.91, -37.93,
        -37.92, -37.88, -37.95, -38.03, -38.05, -38.11, -38.21, -38.26, -38.30, -38.35,
        -38.39, -38.47, -38.52, -38.56, -38.61, -38.62, -38.73, -38.74, -38.85, -38.88,
        -38.91, -38.91, -38.96, -39.04, -39.05, -39.13, -39.13, -39.24, -39.26, -39.32,
        -39.30, -39.35, -39.38, -39.48, -39.55, -39.55, -39.60, -39.66, -39.62, -39.69,
        -39.71, -39.75, -39.81, -39.81, -39.88, -39.89, -39.91, -39.96, -39.98, -39.99,
        -39.95, -40.04, -40.03, -40.16, -40.18, -40.27, -40.29, -40.38, -40.41, -40.49,
        -40.52, -40.60, -40.63, -40.60, -40.66, -40.71, -40.76, -40.76, -40.84, -40.87,
        -40.90, -40.92, -40.94, -41.02, -41.01, -41.07, -41.11, -41.21, -41.23, -41.23,
        -41.29, -41.34, -41.37, -41.42, -41.45, -41.43, -41.47, -41.47, -41.49, -41.53,
        -41.55, -41.61, -41.65, -41.71, -41.80, -41.91, -41.91, -42.00, -41.97, -41.89,
        -41.94, -42.06, -42.11, -42.09, -42.12, -42.19, -42.21, -42.13, -42.11, -42.13,
        -42.22, -42.25, -42.27, -42.37, -42.37, -42.38, -42.47, -42.46, -42.48, -42.48,
        -42.48, -42.53, -42.55, -42.55, -42.59, -42.61, -42.70, -42.72, -42.82, -42.81,
        -42.89, -42.89, -43.02, -42.99, -43.07, -43.11, -43.12, -43.14, -43.16, -43.16,
        -43.19, -43.22, -43.19, -43.15, -43.19, -43.24, -43.26, -43.26, -43.37, -43.35,
        -43.41, -43.39, -43.43, -43.44, -43.46, -43.49, -43.53, -43.56, -43.54, -43.58,
        -43.61, -43.60, -43.63, -43.70, -43.72, -43.72, -43.72, -43.84, -43.93, -43.96,
        -43.99, -44.01, -44.02, -44.05, -44.08, -44.13, -44.17, -44.17, -44.22, -44.21,
        -44.25, -44.26, -44.30, -44.32, -44.40, -44.46, -44.45, -44.49, -44.49, -44.54,
        -44.53, -44.54, -44.58, -44.64, -44.62, -44.59, -44.59, -44.64, -44.62, -44.69,
        -44.76, -44.76, -44.85, -44.91, -44.89, -44.88, -44.87, -44.84, -44.91, -44.86,
        -44.92, -44.88, -44.97, -44.91, -44.98, -45.05, -45.09, -45.13, -45.15, -45.22,
        -45.22, -45.24, -45.22, -45.27, -45.31, -45.26, -45.28, -45.27, -45.28, -45.24,
        -45.28, -45.35, -45.41, -45.42, -45.47, -45.49, -45.52, -45.57, -45.52, -45.58,
        -45.57, -45.60, -45.57, -45.63, -45.68, -45.68, -45.71, -45.71, -45.79, -45.74,
        -45.81, -45.75, -45.82, -45.85, -45.92, -45.89, -45.93, -45.88, -45.93, -45.90,
        -45.88, -45.95, -46.01, -46.07, -46.08, -46.10, -46.15, -46.23, -46.28, -46.35,
        -46.37, -46.33, -46.34, -46.27, -46.27, -46.24, -46.25, -46.21, -46.25, -46.28,
        -46.34, -46.40, -46.42, -46.43, -46.49, -46.53, -46.49, -46.49, -46.52, -46.51,
        -46.52, -46.58, -46.58, -46.63, -46.69, -46.74, -46.80, -46.85, -46.87, -46.88,
        -46.91, -46.94, -46.94, -46.98, -47.00, -46.98, -47.00, -47.02, -47.05, -47.05,
        -47.08, -47.06, -47.07, -47.05, -47.11, -47.08, -47.06, -47.09, -47.08, -47.12,
        -47.05, -47.07, -47.12, -47.17, -47.17, -47.21, -47.24, -47.30, -47.34, -47.29,
        -47.30, -47.32, -47.32, -47.36, -47.37, -47.43, -47.47, -47.45, -47.43, -47.44,
        -47.44, -47.49, -47.55, -47.58, -47.61, -47.62, -47.58, -47.61, -47.66, -47.70,
        -47.75, -47.76, -47.79, -47.77, -47.71, -47.69, -47.75, -47.80, -47.82, -47.82,
        -47.79, -47.82, -47.80, -47.80, -47.84, -47.84, -47.89, -47.92, -47.99, -48.01,
        -48.03, -48.06, -48.08, -48.10, -48.13, -48.23, -48.24, -48.23, -48.19, -48.25,
        -48.28, -48.34, -48.39, -48.42, -48.47, -48.51, -48.51, -48.51, -48.48, -48.46,
        -48.49, -48.54, -48.53, -48.51, -48.53, -48.56, -48.60, -48.63, -48.67, -48.71,
        -48.72, -48.74, -48.65, -48.61, -48.65, -48.71, -48.74, -48.77, -48.81, -48.84,
        -48.85, -48.88, -48.94, -48.95, -48.95, -48.97, -49.04, -49.05, -49.06, -49.09,
        -49.06, -49.05, -49.01, -49.01, -49.02, -49.05, -49.07, -49.08, -49.09, -49.15,
        -49.20, -49.22, -49.24, -49.24, -49.24, -49.27, -49.33, -49.36, -49.38, -49.41,
        -49.41, -49.46, -49.48, -49.50, -49.50, -49.54, -49.56, -49.56, -49.59, -49.62,
        -49.62, -49.62, -49.61, -49.61, -49.63, -49.64, -49.64, -49.68, -49.68, -49.70,
        -49.70, -49.70, -49.74, -49.72, -49.76, -49.77, -49.87, -49.90, -50.02, -50.03,
        -50.04, -50.04, -50.04, -50.04, -50.05, -50.05, -50.05, -50.11, -50.16, -50.21,
        -50.26, -50.26, -50.26, -50.27, -50.28, -50.28, -50.29, -50.30, -50.33, -50.38,
        -50.40, -50.41, -50.41, -50.42, -50.42, -50.42, -50.43, -50.46, -50.47, -50.50,
        -50.55, -50.58, -50.61, -50.61, -50.61, -50.61, -50.64, -50.65, -50.67, -50.69,
        -50.74, -50.78, -50.78, -50.77, -50.83, -50.87, -50.87, -50.86, -50.86, -50.86,
        -50.86, -50.85, -50.85, -50.85, -50.85, -50.90, -51.00, -51.05, -51.05, -51.06,
        -51.17, -51.22, -51.33, -51.34, -51.32, -51.32, -51.31, -51.30, -51.28, -51.27,
        -51.26, -51.31, -51.35, -51.42, -51.46, -51.46, -51.45, -51.45, -51.44, -51.44,
        -51.49, -51.54, -51.50, -51.53, -51.57, -51.56, -51.56, -51.56, -51.57, -51.59,
        -51.62, -51.63, -51.68, -51.68, -51.71, -51.74, -51.76, -51.75, -51.75, -51.78,
        -51.83, -51.82, -51.88, -51.92, -51.92, -51.91, -51.87, -51.86, -51.84, -51.81,
        -51.87, -51.95, -51.99, -51.98, -52.02, -52.08, -52.11, -52.13, -52.23, -52.23,
        -52.28, -52.32, -52.34, -52.34, -52.38, -52.37, -52.40, -52.39, -52.38, -52.41,
        -52.43, -52.47, -52.45, -52.47, -52.44, -52.47, -52.43, -52.57, -52.53, -52.58,
        -52.63, -52.58, -52.57, -52.55, -52.56, -52.53, -52.56, -52.58, -52.59, -52.62,
        -52.64, -52.67, -52.71, -52.72, -52.76, -52.80, -52.81, -52.88, -52.88, -52.89,
        -52.87, -52.82, -52.75, -52.77, -52.81, -52.81, -52.85, -52.81, -52.83, -52.85,
        -52.87, -52.84, -52.82, -52.82, -52.86, -52.84, -52.89, -52.88, -52.91, -52.88,
        -52.93, -52.97, -53.02, -52.99, -52.99, -52.94, -52.99, -53.04, -53.05, -53.01,
        -53.02, -53.02, -52.99, -53.02, -53.04, -53.12, -53.09, -53.09, -53.16, -53.17,
        -53.17, -53.17, -53.17, -53.16, -53.15, -53.18, -53.17, -53.18, -53.18, -53.23,
        -53.22, -53.20, -53.19, -53.17, -53.15, -53.14, -53.11, -53.08, -53.08, -53.07,
        -53.08, -53.08, -53.08, -53.08, -53.12, -53.14, -53.14, -53.16, -53.18, -53.18,
        -53.18, -53.17, -53.07, -53.07, -52.97, -52.97, -52.97, -52.97, -52.97, -52.97,
        -52.98, -52.98, -53.00, -52.97, -52.95, -52.94, -52.89, -52.89, -52.87, -52.87,
        -52.88, -52.90, -52.90, -52.90, -52.91, -52.86, -52.86, -52.78, -52.74, -52.74,
        -52.75, -52.75, -52.76, -52.79, -52.82, -52.78, -52.71, -52.66, -52.66, -52.68,
        -52.74, -52.79, -52.75, -52.77, -52.72, -52.71, -52.70, -52.70, -52.67, -52.63,
        -52.60, -52.57, -52.55, -52.56, -52.51, -52.54, -52.55, -52.53, -52.58, -52.53,
        -52.44, -52.43, -52.39, -52.39, -52.30, -52.30, -52.21, -52.22, -52.25, -52.28,
        -52.22, -52.22, -52.19, -52.15, -52.11, -52.09, -52.10, -52.07, -52.05, -51.98,
        -51.94, -51.90, -51.92, -51.91, -51.87, -51.82, -51.81, -51.85, -51.84, -51.80,
        -51.78, -51.81, -51.73, -51.75, -51.68, -51.70, -51.64, -51.67, -51.69, -51.70,
        -51.71, -51.68, -51.70, -51.63, -51.63, -51.60, -51.61, -51.55, -51.60, -51.56,
        -51.56, -51.51, -51.52, -51.49, -51.49, -51.47, -51.45, -51.44, -51.45, -51.51,
        -51.43, -51.48, -51.43, -51.41, -51.44, -51.40, -51.44, -51.44, -51.42, -51.39,
        -51.31, -51.24, -51.24, -51.18, -51.16, -51.07, -51.04, -51.01, -51.08, -51.01,
        -51.01, -51.01, -51.02, -51.06, -51.01, -51.07, -51.08, -51.02, -50.99, -50.98,
        -50.92, -50.93, -50.90, -50.91, -50.89, -50.85, -50.87, -50.82, -50.82, -50.79,
        -50.84, -50.77, -50.82, -50.78, -50.69, -50.73, -50.70, -50.70, -50.66, -50.64,
        -50.63, -50.61, -50.61, -50.68, -50.64, -50.68, -50.70, -50.65, -50.56, -50.50,
        -50.50, -50.45, -50.44, -50.44, -50.40, -50.39, -50.38, -50.48, -50.52, -50.52,
        -50.57, -50.53, -50.54, -50.51, -50.47, -50.44, -50.47, -50.45, -50.41, -50.39,
        -50.42, -50.41, -50.40, -50.46, -50.52, -50.49, -50.50, -50.47, -50.46, -50.47,
        -50.46, -50.44, -50.46, -50.43, -50.45, -50.42, -50.44, -50.39, -50.39, -50.38,
        -50.38, -50.42, -50.44, -50.48, -50.49, -50.46, -50.48, -50.51, -50.51, -50.51,
        -50.51, -50.52, -50.45, -50.43, -50.39, -50.37, -50.40, -50.44, -50.45, -50.49,
        -50.49, -50.49, -50.49, -50.49, -50.49, -50.53, -50.53, -50.53, -50.58, -50.58,
        -50.58, -50.58, -50.58, -50.58, -50.59, -50.58, -50.58, -50.58, -50.58, -50.58,
        -50.61, -50.58, -50.66, -50.67, -50.67, -50.65, -50.65, -50.64, -50.64, -50.65,
        -50.69, -50.76, -50.77, -50.80, -50.78, -50.87, -50.85, -50.91, -50.91, -50.96,
        -50.98, -50.94, -50.93, -50.94, -50.93, -50.97, -50.95, -51.01, -50.99, -51.05,
        -50.98, -51.01, -50.99, -51.06, -51.08, -51.15, -51.15, -51.15, -51.21, -51.21,
        -51.20, -51.23, -51.25, -51.20, -51.24, -51.28, -51.29, -51.28, -51.30, -51.28,
        -51.26, -51.36, -51.38, -51.39, -51.34, -51.36, -51.47, -51.57, -51.54, -51.48,
        -51.65, -51.69, -51.63, -51.60, -51.61, -51.63, -51.52, -51.52, -51.49, -51.52,
        -51.56, -51.61, -51.67, -51.64, -51.62, -51.69, -51.63, -51.61, -51.52, -51.60,
        -51.75, -51.72, -51.68, -51.63, -51.64, -51.84, -51.75, -51.73, -51.71, -51.77,
        -51.74, -51.79, -51.78, -51.70, -51.56, -51.57, -51.52, -51.51, -51.59, -51.53,
        -51.54, -51.57, -51.65, -51.60, -51.61, -51.60, -51.51, -51.48, -51.47, -51.47,
        -51.44, -51.45, -51.50, -51.49, -51.43, -51.43, -51.49, -51.52, -51.47, -51.46,
        -51.49, -51.36, -51.35, -51.35, -51.40, -51.35, -51.23, -51.29, -51.32, -51.25,
        -51.17, -51.17, -51.17, -51.16, -51.12, -51.10, -51.06, -51.07, -51.11, -51.16,
        -51.18, -51.18, -51.17, -51.20, -51.22, -51.19, -51.17, -51.12, -51.08, -51.00,
        -51.03, -50.95, -50.93, -50.83, -50.83, -50.77, -50.71, -50.67, -50.69, -50.63,
        -50.56, -50.47, -50.40, -50.36, -50.38, -50.38, -50.41, -50.46, -50.42, -50.38,
        -50.37, -50.34, -50.31, -50.27, -50.24, -50.24, -50.21, -50.19, -50.19, -50.13,
        -50.06, -50.06, -50.01, -49.99, -49.96, -49.97, -49.99, -49.94, -49.97, -49.99,
        -50.00, -50.01, -50.00, -49.99, -49.94, -49.89, -49.87, -49.83, -49.84, -49.82,
        -49.81, -49.84, -49.87, -49.83, -49.86, -49.89, -49.89, -49.87, -49.85, -49.82,
        -49.86, -49.88, -49.94, -49.93, -49.85, -49.89, -49.86, -49.91, -49.94, -49.96,
        -49.92, -49.97, -50.00, -50.00, -50.05, -50.03, -49.99, -49.96, -50.04, -50.00,
        -49.93, -49.93, -49.93, -49.96, -49.94, -49.93, -49.90, -49.90, -49.94, -49.95,
        -49.97, -49.95, -50.00, -50.03, -50.07, -50.10, -50.08, -50.12, -50.13, -50.17,
        -50.24, -50.17, -50.06, -50.09, -50.08, -50.05, -49.87, -49.88, -49.86, -49.89,
        -49.75, -49.75, -49.70, -49.68, -49.57, -49.53, -49.38, -49.31, -49.22, -49.20,
        -49.17, -49.07, -49.06, -48.97, -48.83, -48.73, -48.58, -48.47, -48.37, -48.23,
        -48.10, -47.89, -47.78, -47.54, -47.41, -46.99, -46.85, -46.43, -46.09, -45.93,
        -45.74, -45.59, -45.36, -45.03, -44.78, -44.56, -44.37, -44.29
    };

    static const float robinson_dadson_curve_40_phons[1468] =
    {
        -24.50, -24.45, -24.41, -24.41, -24.37, -24.38, -24.47, -24.53, -24.55, -24.55,
        -24.65, -24.67, -24.67, -24.80, -24.81, -24.84, -24.89, -24.96, -25.04, -25.02,
        -25.10, -25.08, -25.13, -25.26, -25.27, -25.29, -25.29, -25.37, -25.33, -25.34,
        -25.46, -25.53, -25.62, -25.77, -25.82, -25.78, -25.78, -25.81, -25.91, -25.94,
        -25.88, -25.83, -25.92, -25.90, -25.87, -25.86, -25.94, -25.97, -25.83, -25.89,
        -25.97, -26.11, -26.21, -26.25, -26.22, -26.22, -26.28, -26.35, -26.38, -26.38,
        -26.39, -26.41, -26.48, -26.53, -26.50, -26.58, -26.59, -26.56, -26.56, -26.67,
        -26.79, -26.77, -26.69, -26.69, -26.71, -26.66, -26.69, -26.71, -26.78, -26.84,
        -26.86, -26.97, -27.03, -27.06, -27.07, -27.00, -27.02, -27.02, -26.99, -27.20,
        -27.17, -27.24, -27.20, -27.31, -27.31, -27.40, -27.43, -27.44, -27.43, -27.51,
        -27.52, -27.60, -27.65, -27.71, -27.71, -27.74, -27.72, -27.69, -27.66, -27.66,
        -27.75, -27.75, -27.80, -27.89, -27.92, -27.99, -27.98, -27.94, -28.08, -28.02,
        -28.02, -28.06, -28.18, -28.17, -28.14, -28.15, -28.29, -28.33, -28.41, -28.45,
        -28.46, -28.48, -28.54, -28.52, -28.57, -28.58, -28.64, -28.67, -28.78, -28.79,
        -28.80, -28.93, -28.95, -28.99, -29.04, -29.17, -29.15, -29.12, -29.13, -29.23,
        -29.23, -29.18, -29.18, -29.28, -29.29, -29.38, -29.41, -29.38, -29.40, -29.43,
        -29.47, -29.56, -29.61, -29.65, -29.71, -29.72, -29.74, -29.81, -29.85, -29.94,
        -29.96, -29.99, -30.00, -30.04, -30.07, -30.09, -30.17, -30.27, -30.32, -30.34,
        -30.28, -30.28, -30.28, -30.33, -30.34, -30.41, -30.45, -30.51, -30.56, -30.60,
        -30.59, -30.67, -30.70, -30.63, -30.65, -30.73, -30.78, -30.92, -31.02, -31.07,
        -31.08, -31.16, -31.16, -31.21, -31.21, -31.27, -31.38, -31.41, -31.46, -31.49,
        -31.49, -31.44, -31.49, -31.58, -31.58, -31.64, -31.72, -31.74, -31.79, -31.83,
        -31.85, -31.89, -31.89, -31.92, -31.97, -31.99, -32.12, -32.13, -32.22, -32.25,
        -32.27, -32.26, -32.29, -32.37, -32.36, -32.48, -32.47, -32.57, -32.58, -32.62,
        -32.58, -32.58, -32.61, -32.64, -32.73, -32.74, -32.80, -32.83, -32.81, -32.86,
        -32.88, -32.91, -32.95, -32.92, -33.01, -33.03, -32.99, -33.04, -33.09, -33.09,
        -33.04, -33.18, -33.18, -33.27, -33.28, -33.37, -33.37, -33.39, -33.41, -33.47,
        -33.53, -33.59, -33.61, -33.54, -33.58, -33.65, -33.68, -33.68, -33.73, -33.74,
        -33.81, -33.83, -33.84, -33.89, -33.88, -33.94, -34.00, -34.06, -34.06, -34.04,
        -34.09, -34.12, -34.18, -34.21, -34.25, -34.25, -34.30, -34.30, -34.31, -34.35,
        -34.35, -34.40, -34.43, -34.50, -34.60, -34.70, -34.71, -34.79, -34.76, -34.65,
        -34.70, -34.79, -34.82, -34.80, -34.83, -34.88, -34.89, -34.79, -34.79, -34.82,
        -34.94, -34.96, -34.98, -35.09, -35.08, -35.08, -35.14, -35.12, -35.13, -35.13,
        -35.13, -35.17, -35.17, -35.16, -35.20, -35.23, -35.32, -35.33, -35.42, -35.39,
        -35.47, -35.47, -35.61, -35.57, -35.64, -35.66, -35.65, -35.64, -35.66, -35.66,
        -35.70, -35.74, -35.70, -35.62, -35.63, -35.67, -35.68, -35.69, -35.81, -35.81,
        -35.89, -35.89, -35.93, -35.97, -35.97, -35.98, -36.02, -36.04, -35.99, -35.98,
        -35.99, -35.96, -36.00, -36.05, -36.05, -36.05, -36.10, -36.25, -36.33, -36.34,
        -36.39, -36.39, -36.39, -36.41, -36.42, -36.46, -36.50, -36.51, -36.55, -36.55,
        -36.59, -36.57, -36.64, -36.65, -36.73, -36.77, -36.76, -36.79, -36.78, -36.85,
        -36.88, -36.88, -36.93, -36.98, -36.97, -36.92, -36.92, -36.96, -36.96, -37.01,
        -37.05, -37.06, -37.16, -37.16, -37.11, -37.11, -37.10, -37.06, -37.11, -37.06,
        -37.12, -37.11, -37.19, -37.15, -37.21, -37.25, -37.27, -37.28, -37.33, -37.37,
        -37.35, -37.38, -37.36, -37.41, -37.47, -37.45, -37.48, -37.45, -37.47, -37.43,
        -37.47, -37.52, -37.59, -37.59, -37.61, -37.59, -37.59, -37.64, -37.57, -37.64,
        -37.62, -37.66, -37.62, -37.74, -37.81, -37.83, -37.82, -37.85, -37.94, -37.86,
        -37.94, -37.86, -37.91, -37.93, -37.99, -37.91, -37.95, -37.86, -37.91, -37.90,
        -37.86, -37.95, -38.01, -38.10, -38.10, -38.14, -38.19, -38.29, -38.34, -38.39,
        -38.44, -38.39, -38.38, -38.29, -38.25, -38.20, -38.20, -38.18, -38.25, -38.30,
        -38.38, -38.44, -38.45, -38.47, -38.53, -38.56, -38.51, -38.47, -38.51, -38.50,
        -38.51, -38.55, -38.51, -38.56, -38.62, -38.67, -38.68, -38.78, -38.75, -38.77,
        -38.79, -38.84, -38.83, -38.93, -38.93, -38.89, -38.89, -38.95, -38.93, -38.92,
        -38.94, -38.93, -38.89, -38.89, -38.93, -38.92, -38.88, -38.91, -38.87, -38.91,
        -38.86, -38.91, -38.96, -39.03, -39.01, -39.05, -39.06, -39.15, -39.16, -39.14,
        -39.17, -39.18, -39.20, -39.21, -39.21, -39.30, -39.31, -39.29, -39.24, -39.26,
        -39.27, -39.31, -39.34, -39.39, -39.40, -39.43, -39.35, -39.38, -39.38, -39.41,
        -39.48, -39.49, -39.52, -39.51, -39.44, -39.43, -39.52, -39.58, -39.61, -39.61,
        -39.58, -39.59, -39.57, -39.55, -39.59, -39.61, -39.64, -39.69, -39.74, -39.78,
        -39.78, -39.77, -39.76, -39.76, -39.79, -39.91, -39.92, -39.87, -39.82, -39.87,
        -39.93, -39.96, -40.05, -40.10, -40.15, -40.19, -40.19, -40.20, -40.15, -40.10,
        -40.11, -40.15, -40.19, -40.20, -40.20, -40.21, -40.22, -40.23, -40.27, -40.27,
        -40.29, -40.31, -40.23, -40.20, -40.23, -40.26, -40.31, -40.32, -40.35, -40.36,
        -40.39, -40.41, -40.45, -40.46, -40.46, -40.46, -40.54, -40.56, -40.56, -40.57,
        -40.52, -40.51, -40.47, -40.49, -40.51, -40.53, -40.57, -40.55, -40.55, -40.59,
        -40.64, -40.68, -40.72, -40.72, -40.72, -40.73, -40.76, -40.77, -40.75, -40.75,
        -40.76, -40.80, -40.84, -40.89, -40.89, -40.93, -40.93, -40.93, -40.93, -40.93,
        -40.93, -40.93, -40.93, -40.93, -40.97, -40.98, -40.98, -41.07, -41.07, -41.07,
        -41.07, -41.07, -41.06, -41.03, -41.02, -41.02, -41.12, -41.13, -41.24, -41.26,
        -41.27, -41.27, -41.27, -41.27, -41.30, -41.30, -41.28, -41.33, -41.37, -41.42,
        -41.46, -41.45, -41.45, -41.45, -41.45, -41.45, -41.45, -41.45, -41.48, -41.53,
        -41.55, -41.55, -41.56, -41.56, -41.56, -41.56, -41.57, -41.61, -41.61, -41.62,
        -41.65, -41.66, -41.66, -41.66, -41.66, -41.66, -41.66, -41.66, -41.65, -41.65,
        -41.70, -41.74, -41.74, -41.74, -41.79, -41.83, -41.83, -41.82, -41.82, -41.82,
        -41.82, -41.82, -41.81, -41.81, -41.81, -41.86, -41.96, -42.02, -42.02, -42.02,
        -42.11, -42.12, -42.22, -42.20, -42.17, -42.17, -42.17, -42.16, -42.12, -42.10,
        -42.09, -42.13, -42.17, -42.22, -42.27, -42.27, -42.26, -42.26, -42.25, -42.25,
        -42.30, -42.34, -42.31, -42.32, -42.35, -42.32, -42.30, -42.29, -42.29, -42.31,
        -42.33, -42.34, -42.39, -42.39, -42.43, -42.43, -42.45, -42.40, -42.39, -42.40,
        -42.45, -42.45, -42.50, -42.55, -42.54, -42.54, -42.46, -42.44, -42.40, -42.35,
        -42.41, -42.49, -42.53, -42.49, -42.51, -42.57, -42.58, -42.58, -42.67, -42.68,
        -42.73, -42.75, -42.77, -42.76, -42.79, -42.78, -42.79, -42.78, -42.77, -42.82,
        -42.85, -42.90, -42.89, -42.90, -42.87, -42.89, -42.85, -42.99, -42.96, -42.99,
        -43.03, -42.96, -42.94, -42.92, -42.89, -42.84, -42.83, -42.85, -42.81, -42.82,
        -42.84, -42.87, -42.91, -42.92, -42.96, -42.99, -43.01, -43.08, -43.08, -43.08,
        -43.06, -42.98, -42.92, -42.97, -43.01, -43.01, -43.04, -42.96, -42.96, -42.97,
        -42.98, -42.92, -42.92, -42.89, -42.92, -42.92, -42.93, -42.92, -42.97, -42.93,
        -42.97, -43.01, -43.06, -43.01, -43.01, -42.92, -42.97, -42.97, -42.98, -42.96,
        -42.93, -42.93, -42.91, -42.92, -42.94, -43.02, -42.99, -42.98, -43.03, -43.03,
        -43.03, -43.03, -43.03, -43.02, -43.01, -43.06, -43.05, -43.06, -43.07, -43.10,
        -43.09, -43.07, -43.06, -43.02, -42.98, -42.94, -42.89, -42.87, -42.85, -42.85,
        -42.85, -42.85, -42.85, -42.85, -42.91, -42.96, -42.96, -43.00, -43.05, -43.04,
        -43.04, -43.03, -42.94, -42.93, -42.83, -42.83, -42.83, -42.83, -42.84, -42.83,
        -42.84, -42.84, -42.84, -42.79, -42.75, -42.71, -42.66, -42.66, -42.62, -42.62,
        -42.64, -42.67, -42.68, -42.68, -42.71, -42.66, -42.66, -42.59, -42.56, -42.57,
        -42.59, -42.59, -42.60, -42.62, -42.67, -42.62, -42.53, -42.47, -42.46, -42.46,
        -42.52, -42.58, -42.54, -42.58, -42.54, -42.50, -42.50, -42.47, -42.44, -42.40,
        -42.37, -42.34, -42.34, -42.33, -42.26, -42.34, -42.35, -42.31, -42.35, -42.30,
        -42.22, -42.21, -42.16, -42.17, -42.07, -42.07, -41.98, -42.02, -42.06, -42.09,
        -42.02, -42.01, -42.00, -41.96, -41.94, -41.91, -41.92, -41.90, -41.86, -41.82,
        -41.77, -41.72, -41.73, -41.71, -41.65, -41.62, -41.61, -41.61, -41.60, -41.56,
        -41.55, -41.55, -41.50, -41.54, -41.47, -41.49, -41.45, -41.47, -41.51, -41.49,
        -41.50, -41.50, -41.50, -41.42, -41.42, -41.38, -41.41, -41.33, -41.38, -41.37,
        -41.35, -41.32, -41.32, -41.27, -41.27, -41.25, -41.20, -41.21, -41.24, -41.27,
        -41.18, -41.23, -41.23, -41.23, -41.26, -41.25, -41.29, -41.32, -41.31, -41.25,
        -41.15, -41.06, -41.08, -41.05, -41.00, -40.91, -40.90, -40.85, -40.92, -40.88,
        -40.85, -40.87, -40.86, -40.92, -40.87, -40.90, -40.92, -40.88, -40.86, -40.86,
        -40.78, -40.81, -40.74, -40.77, -40.73, -40.72, -40.73, -40.73, -40.72, -40.72,
        -40.75, -40.70, -40.76, -40.73, -40.65, -40.66, -40.68, -40.63, -40.60, -40.55,
        -40.53, -40.50, -40.50, -40.59, -40.56, -40.58, -40.63, -40.58, -40.49, -40.43,
        -40.43, -40.43, -40.40, -40.39, -40.33, -40.32, -40.29, -40.38, -40.45, -40.43,
        -40.47, -40.43, -40.43, -40.40, -40.36, -40.36, -40.39, -40.38, -40.34, -40.34,
        -40.40, -40.38, -40.35, -40.39, -40.41, -40.39, -40.39, -40.38, -40.34, -40.38,
        -40.39, -40.39, -40.43, -40.37, -40.41, -40.38, -40.39, -40.32, -40.31, -40.30,
        -40.31, -40.35, -40.41, -40.46, -40.48, -40.42, -40.45, -40.51, -40.50, -40.50,
        -40.48, -40.47, -40.40, -40.36, -40.30, -40.26, -40.26, -40.35, -40.35, -40.44,
        -40.44, -40.44, -40.44, -40.44, -40.44, -40.53, -40.53, -40.53, -40.62, -40.62,
        -40.62, -40.63, -40.63, -40.63, -40.63, -40.63, -40.62, -40.62, -40.62, -40.62,
        -40.62, -40.56, -40.64, -40.61, -40.60, -40.56, -40.56, -40.54, -40.53, -40.55,
        -40.59, -40.65, -40.66, -40.70, -40.71, -40.79, -40.80, -40.88, -40.90, -40.95,
        -41.00, -40.96, -40.92, -40.95, -40.92, -40.99, -40.99, -41.06, -41.07, -41.11,
        -41.04, -41.03, -41.01, -41.05, -41.10, -41.19, -41.19, -41.20, -41.28, -41.28,
        -41.29, -41.31, -41.31, -41.24, -41.28, -41.33, -41.38, -41.37, -41.37, -41.32,
        -41.32, -41.37, -41.38, -41.34, -41.34, -41.34, -41.46, -41.57, -41.55, -41.48,
        -41.67, -41.77, -41.70, -41.64, -41.65, -41.68, -41.59, -41.59, -41.58, -41.58,
        -41.61, -41.65, -41.72, -41.68, -41.68, -41.77, -41.73, -41.69, -41.61, -41.69,
        -41.87, -41.85, -41.83, -41.78, -41.84, -42.04, -41.95, -41.92, -41.89, -42.00,
        -41.93, -41.99, -41.99, -41.95, -41.80, -41.82, -41.78, -41.76, -41.83, -41.75,
        -41.73, -41.74, -41.80, -41.77, -41.80, -41.78, -41.69, -41.66, -41.68, -41.71,
        -41.67, -41.69, -41.76, -41.79, -41.77, -41.78, -41.87, -41.92, -41.86, -41.89,
        -41.89, -41.76, -41.75, -41.76, -41.85, -41.75, -41.66, -41.71, -41.77, -41.71,
        -41.63, -41.66, -41.67, -41.69, -41.67, -41.67, -41.66, -41.68, -41.69, -41.74,
        -41.74, -41.72, -41.70, -41.76, -41.80, -41.81, -41.80, -41.78, -41.76, -41.67,
        -41.74, -41.67, -41.71, -41.61, -41.61, -41.55, -41.52, -41.49, -41.51, -41.46,
        -41.41, -41.32, -41.27, -41.23, -41.28, -41.28, -41.33, -41.38, -41.34, -41.30,
        -41.33, -41.28, -41.28, -41.27, -41.27, -41.27, -41.27, -41.27, -41.27, -41.22,
        -41.17, -41.18, -41.13, -41.08, -41.04, -41.05, -41.09, -41.10, -41.15, -41.20,
        -41.22, -41.24, -41.24, -41.26, -41.23, -41.20, -41.18, -41.19, -41.20, -41.23,
        -41.20, -41.26, -41.26, -41.24, -41.27, -41.31, -41.29, -41.28, -41.26, -41.23,
        -41.32, -41.32, -41.36, -41.34, -41.26, -41.35, -41.33, -41.35, -41.40, -41.45,
        -41.42, -41.50, -41.55, -41.59, -41.64, -41.64, -41.56, -41.53, -41.68, -41.60,
        -41.52, -41.52, -41.55, -41.56, -41.51, -41.51, -41.55, -41.58, -41.63, -41.64,
        -41.67, -41.68, -41.78, -41.79, -41.87, -41.89, -41.90, -41.93, -41.88, -41.99,
        -42.13, -42.03, -41.88, -41.92, -41.99, -41.98, -41.83, -41.83, -41.88, -41.93,
        -41.80, -41.84, -41.81, -41.84, -41.75, -41.70, -41.59, -41.55, -41.51, -41.51,
        -41.48, -41.47, -41.49, -41.44, -41.35, -41.28, -41.16, -41.06, -40.94, -40.80,
        -40.84, -40.61, -40.53, -40.30, -40.19, -39.82, -39.77, -39.33, -39.15, -39.03,
        -38.96, -38.73, -38.55, -38.36, -38.13, -37.96, -37.80, -37.78
    };

    static const float robinson_dadson_curve_50_phons[1468] =
    {
        -19.12, -19.07, -19.08, -19.10, -19.08, -19.09, -19.16, -19.21, -19.21, -19.21,
        -19.28, -19.32, -19.31, -19.39, -19.38, -19.42, -19.45, -19.48, -19.52, -19.49,
        -19.56, -19.55, -19.62, -19.71, -19.72, -19.75, -19.75, -19.83, -19.81, -19.86,
        -19.92, -19.99, -20.07, -20.17, -20.23, -20.21, -20.18, -20.24, -20.27, -20.27,
        -20.23, -20.20, -20.28, -20.25, -20.22, -20.19, -20.26, -20.30, -20.21, -20.24,
        -20.35, -20.42, -20.50, -20.54, -20.51, -20.53, -20.64, -20.72, -20.71, -20.74,
        -20.73, -20.72, -20.76, -20.75, -20.69, -20.76, -20.77, -20.73, -20.65, -20.74,
        -20.79, -20.73, -20.68, -20.68, -20.71, -20.66, -20.67, -20.69, -20.76, -20.84,
        -20.83, -20.90, -20.96, -20.97, -20.96, -20.91, -20.93, -20.94, -20.91, -21.02,
        -21.06, -21.17, -21.21, -21.31, -21.31, -21.33, -21.39, -21.40, -21.37, -21.48,
        -21.51, -21.56, -21.59, -21.63, -21.65, -21.66, -21.63, -21.62, -21.59, -21.60,
        -21.67, -21.66, -21.70, -21.76, -21.78, -21.83, -21.84, -21.81, -21.90, -21.85,
        -21.87, -21.89, -21.99, -21.98, -21.98, -22.00, -22.08, -22.08, -22.12, -22.13,
        -22.14, -22.21, -22.23, -22.22, -22.23, -22.24, -22.33, -22.35, -22.43, -22.44,
        -22.44, -22.56, -22.57, -22.59, -22.62, -22.71, -22.72, -22.69, -22.68, -22.76,
        -22.74, -22.71, -22.71, -22.80, -22.81, -22.88, -22.88, -22.85, -22.88, -22.94,
        -22.95, -22.99, -23.03, -23.06, -23.14, -23.16, -23.18, -23.20, -23.24, -23.28,
        -23.26, -23.30, -23.30, -23.32, -23.34, -23.37, -23.43, -23.48, -23.51, -23.52,
        -23.49, -23.49, -23.49, -23.52, -23.54, -23.59, -23.66, -23.72, -23.79, -23.80,
        -23.77, -23.83, -23.83, -23.80, -23.82, -23.89, -23.95, -24.06, -24.12, -24.17,
        -24.20, -24.24, -24.22, -24.27, -24.27, -24.32, -24.40, -24.43, -24.48, -24.49,
        -24.46, -24.41, -24.46, -24.50, -24.50, -24.56, -24.64, -24.66, -24.71, -24.73,
        -24.74, -24.81, -24.79, -24.80, -24.85, -24.84, -24.95, -24.96, -25.02, -25.05,
        -25.08, -25.04, -25.09, -25.15, -25.13, -25.23, -25.23, -25.33, -25.34, -25.37,
        -25.34, -25.35, -25.35, -25.37, -25.44, -25.42, -25.47, -25.50, -25.48, -25.53,
        -25.54, -25.56, -25.57, -25.57, -25.62, -25.62, -25.61, -25.64, -25.67, -25.66,
        -25.63, -25.69, -25.69, -25.79, -25.79, -25.89, -25.87, -25.93, -25.91, -25.97,
        -26.05, -26.13, -26.13, -26.08, -26.10, -26.16, -26.19, -26.19, -26.23, -26.27,
        -26.33, -26.35, -26.31, -26.37, -26.33, -26.39, -26.39, -26.46, -26.44, -26.46,
        -26.51, -26.55, -26.58, -26.61, -26.62, -26.61, -26.64, -26.64, -26.65, -26.69,
        -26.69, -26.74, -26.75, -26.82, -26.88, -26.98, -26.99, -27.05, -27.02, -26.93,
        -26.97, -27.04, -27.05, -27.01, -27.03, -27.08, -27.08, -26.98, -26.98, -27.03,
        -27.11, -27.14, -27.16, -27.26, -27.24, -27.23, -27.31, -27.30, -27.31, -27.28,
        -27.29, -27.33, -27.33, -27.31, -27.36, -27.38, -27.44, -27.44, -27.53, -27.51,
        -27.56, -27.56, -27.68, -27.61, -27.67, -27.71, -27.71, -27.70, -27.71, -27.70,
        -27.72, -27.75, -27.73, -27.69, -27.72, -27.75, -27.77, -27.79, -27.86, -27.84,
        -27.89, -27.86, -27.88, -27.89, -27.87, -27.86, -27.87, -27.89, -27.85, -27.87,
        -27.89, -27.89, -27.96, -28.01, -28.01, -28.01, -28.03, -28.15, -28.20, -28.23,
        -28.25, -28.28, -28.28, -28.32, -28.35, -28.39, -28.41, -28.41, -28.46, -28.46,
        -28.47, -28.46, -28.53, -28.51, -28.55, -28.60, -28.60, -28.61, -28.62, -28.66,
        -28.65, -28.65, -28.68, -28.73, -28.70, -28.66, -28.63, -28.67, -28.67, -28.72,
        -28.75, -28.74, -28.84, -28.83, -28.79, -28.79, -28.76, -28.74, -28.78, -28.74,
        -28.78, -28.77, -28.83, -28.82, -28.89, -28.91, -28.96, -29.01, -29.06, -29.08,
        -29.06, -29.08, -29.02, -29.05, -29.12, -29.07, -29.06, -29.04, -29.07, -29.03,
        -29.07, -29.10, -29.18, -29.16, -29.18, -29.17, -29.20, -29.25, -29.21, -29.29,
        -29.26, -29.30, -29.23, -29.29, -29.32, -29.36, -29.37, -29.40, -29.49, -29.43,
        -29.49, -29.43, -29.50, -29.48, -29.51, -29.48, -29.52, -29.44, -29.51, -29.48,
        -29.45, -29.51, -29.58, -29.64, -29.65, -29.67, -29.71, -29.78, -29.82, -29.87,
        -29.91, -29.87, -29.86, -29.77, -29.76, -29.73, -29.75, -29.71, -29.78, -29.82,
        -29.87, -29.92, -29.90, -29.89, -29.90, -29.94, -29.88, -29.84, -29.88, -29.87,
        -29.86, -29.90, -29.88, -29.91, -29.99, -30.04, -30.10, -30.17, -30.19, -30.18,
        -30.21, -30.25, -30.24, -30.28, -30.31, -30.27, -30.30, -30.32, -30.32, -30.30,
        -30.30, -30.29, -30.28, -30.28, -30.30, -30.27, -30.22, -30.24, -30.22, -30.24,
        -30.17, -30.24, -30.26, -30.32, -30.31, -30.32, -30.36, -30.43, -30.46, -30.41,
        -30.46, -30.46, -30.47, -30.49, -30.50, -30.56, -30.56, -30.53, -30.46, -30.51,
        -30.49, -30.56, -30.58, -30.61, -30.63, -30.63, -30.56, -30.55, -30.55, -30.59,
        -30.65, -30.66, -30.67, -30.66, -30.60, -30.57, -30.62, -30.70, -30.71, -30.73,
        -30.71, -30.76, -30.73, -30.76, -30.78, -30.79, -30.80, -30.85, -30.90, -30.90,
        -30.93, -30.93, -30.92, -30.92, -30.93, -31.00, -30.97, -30.95, -30.90, -30.92,
        -30.95, -30.97, -31.01, -31.06, -31.11, -31.14, -31.14, -31.14, -31.11, -31.09,
        -31.09, -31.12, -31.14, -31.14, -31.14, -31.18, -31.22, -31.23, -31.27, -31.30,
        -31.30, -31.30, -31.21, -31.17, -31.21, -31.22, -31.30, -31.33, -31.34, -31.35,
        -31.36, -31.37, -31.40, -31.40, -31.40, -31.40, -31.44, -31.49, -31.50, -31.55,
        -31.50, -31.50, -31.45, -31.46, -31.45, -31.45, -31.47, -31.45, -31.44, -31.47,
        -31.49, -31.50, -31.53, -31.53, -31.53, -31.53, -31.57, -31.60, -31.62, -31.65,
        -31.65, -31.67, -31.69, -31.72, -31.72, -31.74, -31.74, -31.74, -31.74, -31.74,
        -31.74, -31.74, -31.73, -31.72, -31.74, -31.75, -31.76, -31.80, -31.80, -31.80,
        -31.81, -31.81, -31.80, -31.79, -31.78, -31.78, -31.88, -31.89, -31.99, -32.01,
        -32.01, -32.01, -32.01, -32.01, -32.02, -32.03, -32.02, -32.07, -32.09, -32.11,
        -32.13, -32.10, -32.10, -32.10, -32.10, -32.10, -32.10, -32.10, -32.12, -32.18,
        -32.20, -32.20, -32.21, -32.21, -32.21, -32.21, -32.22, -32.25, -32.26, -32.27,
        -32.30, -32.30, -32.31, -32.31, -32.31, -32.31, -32.31, -32.31, -32.28, -32.28,
        -32.32, -32.33, -32.31, -32.30, -32.34, -32.37, -32.37, -32.34, -32.34, -32.33,
        -32.32, -32.31, -32.29, -32.28, -32.26, -32.33, -32.43, -32.48, -32.49, -32.49,
        -32.58, -32.59, -32.69, -32.66, -32.62, -32.61, -32.61, -32.59, -32.54, -32.53,
        -32.52, -32.57, -32.61, -32.67, -32.72, -32.71, -32.68, -32.66, -32.62, -32.62,
        -32.68, -32.72, -32.68, -32.71, -32.73, -32.70, -32.70, -32.67, -32.66, -32.68,
        -32.69, -32.68, -32.73, -32.70, -32.71, -32.74, -32.76, -32.75, -32.74, -32.77,
        -32.83, -32.81, -32.86, -32.88, -32.87, -32.85, -32.79, -32.78, -32.73, -32.68,
        -32.73, -32.79, -32.82, -32.78, -32.80, -32.82, -32.84, -32.85, -32.92, -32.90,
        -32.95, -32.98, -32.97, -32.96, -32.99, -32.97, -32.98, -32.94, -32.92, -32.97,
        -32.98, -33.03, -33.03, -33.03, -32.99, -33.03, -32.98, -33.10, -33.04, -33.07,
        -33.10, -33.06, -33.05, -33.01, -33.00, -32.95, -32.96, -32.98, -32.99, -33.01,
        -33.01, -33.04, -33.06, -33.05, -33.07, -33.10, -33.07, -33.14, -33.12, -33.11,
        -33.09, -33.05, -32.96, -32.98, -33.01, -32.99, -33.01, -32.97, -32.98, -32.99,
        -33.02, -32.97, -32.96, -32.95, -32.97, -32.96, -32.99, -32.97, -33.01, -32.95,
        -32.99, -33.01, -33.03, -33.01, -33.01, -32.94, -32.99, -33.03, -33.02, -33.01,
        -33.02, -32.98, -32.96, -32.97, -32.98, -33.06, -33.05, -33.05, -33.10, -33.10,
        -33.07, -33.07, -33.07, -33.04, -33.01, -33.03, -33.01, -33.01, -33.02, -33.05,
        -33.04, -33.02, -33.01, -32.99, -32.98, -32.96, -32.93, -32.89, -32.82, -32.80,
        -32.80, -32.80, -32.80, -32.83, -32.91, -32.94, -32.93, -32.95, -32.97, -32.96,
        -32.94, -32.94, -32.84, -32.83, -32.73, -32.73, -32.74, -32.74, -32.76, -32.75,
        -32.77, -32.77, -32.78, -32.76, -32.72, -32.72, -32.68, -32.70, -32.69, -32.69,
        -32.70, -32.71, -32.71, -32.72, -32.73, -32.68, -32.68, -32.59, -32.55, -32.55,
        -32.57, -32.57, -32.57, -32.61, -32.68, -32.66, -32.57, -32.51, -32.50, -32.50,
        -32.54, -32.58, -32.54, -32.54, -32.49, -32.46, -32.49, -32.47, -32.45, -32.42,
        -32.39, -32.36, -32.34, -32.33, -32.28, -32.31, -32.37, -32.32, -32.37, -32.35,
        -32.28, -32.27, -32.25, -32.28, -32.19, -32.20, -32.12, -32.15, -32.18, -32.20,
        -32.13, -32.15, -32.09, -32.07, -32.03, -32.00, -32.02, -31.97, -31.97, -31.92,
        -31.86, -31.85, -31.90, -31.87, -31.80, -31.77, -31.74, -31.74, -31.71, -31.68,
        -31.66, -31.68, -31.61, -31.62, -31.57, -31.60, -31.56, -31.59, -31.66, -31.65,
        -31.64, -31.65, -31.66, -31.62, -31.64, -31.58, -31.58, -31.52, -31.57, -31.55,
        -31.55, -31.52, -31.52, -31.47, -31.49, -31.46, -31.42, -31.44, -31.46, -31.49,
        -31.45, -31.50, -31.45, -31.47, -31.48, -31.46, -31.49, -31.51, -31.46, -31.41,
        -31.31, -31.24, -31.23, -31.22, -31.18, -31.12, -31.11, -31.05, -31.13, -31.07,
        -31.05, -31.08, -31.08, -31.16, -31.12, -31.18, -31.21, -31.17, -31.13, -31.13,
        -31.06, -31.06, -31.03, -31.05, -31.04, -31.01, -31.06, -31.07, -31.06, -31.08,
        -31.12, -31.08, -31.11, -31.06, -31.00, -31.02, -30.99, -30.98, -30.97, -30.93,
        -30.89, -30.87, -30.88, -30.94, -30.92, -30.93, -30.97, -30.91, -30.84, -30.79,
        -30.76, -30.76, -30.74, -30.74, -30.70, -30.71, -30.68, -30.75, -30.79, -30.78,
        -30.81, -30.78, -30.79, -30.77, -30.71, -30.73, -30.80, -30.76, -30.72, -30.74,
        -30.77, -30.75, -30.74, -30.77, -30.83, -30.80, -30.79, -30.74, -30.72, -30.74,
        -30.75, -30.77, -30.84, -30.81, -30.85, -30.82, -30.84, -30.79, -30.78, -30.75,
        -30.76, -30.78, -30.83, -30.87, -30.89, -30.83, -30.88, -30.91, -30.91, -30.91,
        -30.93, -30.94, -30.87, -30.83, -30.77, -30.73, -30.73, -30.77, -30.78, -30.82,
        -30.81, -30.81, -30.82, -30.82, -30.82, -30.86, -30.86, -30.87, -30.91, -30.92,
        -30.93, -30.94, -30.94, -30.94, -30.95, -30.94, -30.91, -30.91, -30.91, -30.91,
        -30.94, -30.91, -30.99, -31.00, -31.00, -30.98, -30.98, -30.97, -30.97, -30.98,
        -31.00, -31.05, -31.07, -31.10, -31.08, -31.17, -31.18, -31.25, -31.28, -31.33,
        -31.38, -31.34, -31.29, -31.33, -31.29, -31.33, -31.30, -31.35, -31.32, -31.38,
        -31.35, -31.34, -31.35, -31.41, -31.42, -31.48, -31.48, -31.51, -31.54, -31.55,
        -31.53, -31.56, -31.58, -31.50, -31.52, -31.58, -31.60, -31.57, -31.57, -31.55,
        -31.55, -31.62, -31.64, -31.62, -31.62, -31.62, -31.71, -31.79, -31.76, -31.70,
        -31.91, -31.97, -31.91, -31.88, -31.91, -31.94, -31.81, -31.81, -31.78, -31.79,
        -31.82, -31.85, -31.91, -31.88, -31.90, -32.00, -31.93, -31.92, -31.84, -31.93,
        -32.11, -32.07, -32.03, -31.98, -32.06, -32.24, -32.15, -32.13, -32.12, -32.25,
        -32.20, -32.24, -32.23, -32.19, -32.06, -32.10, -32.03, -32.02, -32.08, -32.03,
        -32.01, -32.02, -32.07, -32.04, -32.07, -32.06, -31.99, -31.98, -32.01, -32.05,
        -32.01, -31.99, -32.08, -32.13, -32.09, -32.07, -32.16, -32.19, -32.13, -32.13,
        -32.14, -32.04, -32.04, -32.05, -32.10, -32.03, -31.95, -32.00, -32.04, -32.00,
        -31.94, -31.95, -31.98, -32.03, -32.05, -32.05, -32.03, -32.05, -32.07, -32.12,
        -32.14, -32.14, -32.15, -32.20, -32.25, -32.26, -32.24, -32.24, -32.22, -32.18,
        -32.24, -32.16, -32.18, -32.10, -32.10, -32.07, -32.03, -32.03, -32.04, -31.98,
        -31.92, -31.88, -31.83, -31.81, -31.86, -31.89, -31.93, -31.96, -31.90, -31.88,
        -31.91, -31.88, -31.87, -31.85, -31.85, -31.84, -31.83, -31.84, -31.85, -31.81,
        -31.77, -31.78, -31.74, -31.73, -31.71, -31.74, -31.79, -31.77, -31.85, -31.90,
        -31.93, -31.94, -31.94, -31.98, -31.96, -31.94, -31.89, -31.89, -31.92, -31.93,
        -31.90, -31.95, -31.97, -31.94, -32.01, -32.08, -32.08, -32.09, -32.08, -32.11,
        -32.17, -32.18, -32.21, -32.17, -32.13, -32.17, -32.15, -32.18, -32.20, -32.24,
        -32.22, -32.30, -32.35, -32.36, -32.39, -32.40, -32.38, -32.36, -32.42, -32.43,
        -32.39, -32.39, -32.41, -32.41, -32.47, -32.47, -32.47, -32.50, -32.56, -32.59,
        -32.60, -32.61, -32.63, -32.65, -32.74, -32.81, -32.84, -32.89, -32.92, -33.02,
        -33.14, -33.07, -32.94, -32.96, -33.01, -33.01, -32.87, -32.89, -32.93, -32.98,
        -32.87, -32.91, -32.88, -32.93, -32.88, -32.85, -32.74, -32.70, -32.67, -32.72,
        -32.73, -32.72, -32.72, -32.71, -32.65, -32.62, -32.53, -32.42, -32.39, -32.30,
        -32.29, -32.11, -32.08, -31.86, -31.81, -31.57, -31.55, -31.12, -31.02, -30.98,
        -30.95, -30.76, -30.63, -30.44, -30.32, -30.22, -30.08, -30.05
    };

    static const float robinson_dadson_curve_60_phons[1468] =
    {
        -13.75, -13.70, -13.75, -13.79, -13.80, -13.81, -13.86, -13.89, -13.86, -13.86,
        -13.91, -13.98, -13.96, -13.98, -13.95, -14.00, -14.02, -14.00, -14.01, -13.97,
        -14.02, -14.02, -14.11, -14.16, -14.17, -14.21, -14.22, -14.30, -14.29, -14.37,
        -14.38, -14.45, -14.52, -14.58, -14.63, -14.64, -14.59, -14.66, -14.63, -14.61,
        -14.59, -14.58, -14.63, -14.61, -14.58, -14.52, -14.59, -14.64, -14.58, -14.59,
        -14.74, -14.73, -14.78, -14.82, -14.79, -14.85, -15.00, -15.10, -15.05, -15.10,
        -15.06, -15.03, -15.05, -14.98, -14.89, -14.94, -14.94, -14.91, -14.75, -14.80,
        -14.78, -14.69, -14.67, -14.68, -14.71, -14.65, -14.65, -14.66, -14.74, -14.84,
        -14.81, -14.83, -14.89, -14.88, -14.84, -14.83, -14.84, -14.85, -14.84, -14.84,
        -14.95, -15.10, -15.21, -15.30, -15.30, -15.26, -15.35, -15.36, -15.31, -15.45,
        -15.51, -15.52, -15.53, -15.55, -15.60, -15.58, -15.55, -15.56, -15.51, -15.54,
        -15.58, -15.57, -15.61, -15.64, -15.64, -15.68, -15.71, -15.67, -15.72, -15.69,
        -15.72, -15.72, -15.80, -15.80, -15.83, -15.86, -15.88, -15.83, -15.83, -15.82,
        -15.83, -15.93, -15.93, -15.93, -15.90, -15.90, -16.01, -16.03, -16.07, -16.08,
        -16.08, -16.18, -16.19, -16.18, -16.19, -16.25, -16.29, -16.25, -16.23, -16.29,
        -16.25, -16.23, -16.24, -16.33, -16.34, -16.38, -16.35, -16.31, -16.37, -16.44,
        -16.43, -16.42, -16.44, -16.48, -16.57, -16.60, -16.61, -16.59, -16.63, -16.62,
        -16.57, -16.60, -16.59, -16.60, -16.62, -16.65, -16.68, -16.69, -16.70, -16.70,
        -16.70, -16.70, -16.70, -16.71, -16.73, -16.76, -16.86, -16.92, -17.01, -17.01,
        -16.96, -17.00, -16.96, -16.96, -16.99, -17.05, -17.11, -17.20, -17.22, -17.27,
        -17.32, -17.32, -17.28, -17.33, -17.32, -17.38, -17.43, -17.46, -17.49, -17.49,
        -17.43, -17.38, -17.43, -17.43, -17.42, -17.47, -17.56, -17.58, -17.62, -17.63,
        -17.64, -17.73, -17.68, -17.69, -17.73, -17.69, -17.78, -17.79, -17.83, -17.86,
        -17.89, -17.83, -17.90, -17.93, -17.91, -17.99, -17.99, -18.10, -18.10, -18.12,
        -18.10, -18.12, -18.10, -18.10, -18.15, -18.10, -18.15, -18.18, -18.16, -18.21,
        -18.21, -18.21, -18.20, -18.22, -18.24, -18.21, -18.23, -18.25, -18.25, -18.23,
        -18.21, -18.21, -18.20, -18.30, -18.31, -18.41, -18.37, -18.46, -18.41, -18.46,
        -18.56, -18.66, -18.64, -18.61, -18.61, -18.67, -18.69, -18.71, -18.73, -18.79,
        -18.85, -18.87, -18.78, -18.85, -18.78, -18.84, -18.78, -18.87, -18.83, -18.88,
        -18.94, -18.97, -18.99, -19.01, -18.98, -18.97, -18.98, -18.98, -18.99, -19.03,
        -19.03, -19.08, -19.07, -19.13, -19.16, -19.25, -19.28, -19.32, -19.29, -19.21,
        -19.24, -19.29, -19.29, -19.23, -19.23, -19.28, -19.28, -19.17, -19.18, -19.24,
        -19.29, -19.32, -19.34, -19.44, -19.39, -19.39, -19.49, -19.49, -19.49, -19.44,
        -19.44, -19.49, -19.49, -19.46, -19.51, -19.53, -19.57, -19.55, -19.64, -19.62,
        -19.66, -19.65, -19.74, -19.65, -19.70, -19.75, -19.78, -19.76, -19.75, -19.74,
        -19.74, -19.75, -19.75, -19.75, -19.81, -19.83, -19.85, -19.90, -19.91, -19.88,
        -19.89, -19.83, -19.83, -19.80, -19.77, -19.75, -19.71, -19.75, -19.72, -19.76,
        -19.80, -19.83, -19.91, -19.96, -19.96, -19.96, -19.96, -20.06, -20.07, -20.11,
        -20.12, -20.17, -20.17, -20.22, -20.27, -20.32, -20.32, -20.32, -20.36, -20.37,
        -20.35, -20.34, -20.42, -20.37, -20.37, -20.42, -20.44, -20.43, -20.46, -20.46,
        -20.43, -20.42, -20.43, -20.47, -20.43, -20.40, -20.35, -20.39, -20.37, -20.42,
        -20.45, -20.42, -20.52, -20.51, -20.47, -20.47, -20.43, -20.42, -20.46, -20.43,
        -20.44, -20.43, -20.47, -20.48, -20.57, -20.58, -20.65, -20.74, -20.78, -20.78,
        -20.76, -20.78, -20.68, -20.69, -20.77, -20.68, -20.65, -20.63, -20.66, -20.63,
        -20.68, -20.69, -20.78, -20.72, -20.75, -20.74, -20.80, -20.86, -20.85, -20.94,
        -20.90, -20.94, -20.85, -20.83, -20.83, -20.88, -20.92, -20.95, -21.04, -21.00,
        -21.04, -21.00, -21.09, -21.04, -21.04, -21.05, -21.10, -21.03, -21.11, -21.05,
        -21.04, -21.07, -21.15, -21.19, -21.19, -21.19, -21.22, -21.27, -21.31, -21.35,
        -21.38, -21.35, -21.34, -21.25, -21.27, -21.25, -21.30, -21.25, -21.30, -21.34,
        -21.36, -21.40, -21.35, -21.30, -21.28, -21.32, -21.24, -21.22, -21.25, -21.25,
        -21.21, -21.25, -21.25, -21.27, -21.37, -21.41, -21.51, -21.56, -21.62, -21.60,
        -21.63, -21.67, -21.65, -21.63, -21.69, -21.66, -21.71, -21.69, -21.71, -21.68,
        -21.66, -21.66, -21.67, -21.67, -21.66, -21.61, -21.57, -21.56, -21.56, -21.56,
        -21.48, -21.56, -21.56, -21.62, -21.61, -21.59, -21.66, -21.70, -21.76, -21.67,
        -21.76, -21.73, -21.74, -21.77, -21.78, -21.82, -21.82, -21.77, -21.67, -21.77,
        -21.72, -21.82, -21.82, -21.82, -21.86, -21.84, -21.77, -21.72, -21.71, -21.77,
        -21.82, -21.82, -21.81, -21.80, -21.77, -21.71, -21.73, -21.82, -21.82, -21.85,
        -21.83, -21.92, -21.90, -21.97, -21.96, -21.98, -21.97, -22.01, -22.06, -22.03,
        -22.07, -22.09, -22.09, -22.08, -22.07, -22.09, -22.03, -22.02, -21.97, -21.98,
        -21.98, -21.98, -21.98, -22.02, -22.08, -22.08, -22.08, -22.09, -22.07, -22.07,
        -22.08, -22.08, -22.09, -22.08, -22.08, -22.15, -22.23, -22.23, -22.27, -22.32,
        -22.31, -22.28, -22.19, -22.13, -22.18, -22.19, -22.29, -22.34, -22.34, -22.34,
        -22.34, -22.34, -22.34, -22.34, -22.34, -22.34, -22.34, -22.42, -22.44, -22.53,
        -22.49, -22.48, -22.44, -22.42, -22.39, -22.37, -22.36, -22.34, -22.34, -22.34,
        -22.34, -22.33, -22.33, -22.34, -22.34, -22.34, -22.37, -22.42, -22.49, -22.54,
        -22.54, -22.54, -22.54, -22.54, -22.54, -22.54, -22.54, -22.54, -22.54, -22.54,
        -22.54, -22.54, -22.53, -22.51, -22.52, -22.53, -22.54, -22.54, -22.54, -22.54,
        -22.54, -22.54, -22.54, -22.54, -22.54, -22.54, -22.64, -22.65, -22.74, -22.75,
        -22.75, -22.75, -22.75, -22.75, -22.75, -22.75, -22.75, -22.81, -22.81, -22.81,
        -22.80, -22.75, -22.75, -22.75, -22.75, -22.75, -22.75, -22.75, -22.77, -22.82,
        -22.85, -22.85, -22.85, -22.86, -22.86, -22.86, -22.87, -22.90, -22.91, -22.92,
        -22.95, -22.95, -22.96, -22.96, -22.96, -22.96, -22.96, -22.95, -22.91, -22.91,
        -22.93, -22.92, -22.89, -22.86, -22.88, -22.90, -22.90, -22.85, -22.85, -22.83,
        -22.81, -22.79, -22.76, -22.74, -22.72, -22.80, -22.90, -22.95, -22.96, -22.96,
        -23.05, -23.06, -23.16, -23.11, -23.06, -23.06, -23.06, -23.01, -22.96, -22.96,
        -22.96, -23.01, -23.06, -23.12, -23.16, -23.16, -23.09, -23.06, -23.00, -23.00,
        -23.05, -23.10, -23.06, -23.10, -23.11, -23.08, -23.11, -23.06, -23.04, -23.06,
        -23.05, -23.01, -23.06, -23.01, -23.00, -23.05, -23.07, -23.10, -23.09, -23.13,
        -23.20, -23.16, -23.21, -23.22, -23.20, -23.15, -23.11, -23.11, -23.05, -23.01,
        -23.06, -23.09, -23.11, -23.06, -23.08, -23.07, -23.11, -23.12, -23.16, -23.12,
        -23.16, -23.21, -23.17, -23.16, -23.19, -23.16, -23.16, -23.11, -23.06, -23.12,
        -23.12, -23.15, -23.16, -23.16, -23.12, -23.16, -23.11, -23.20, -23.12, -23.16,
        -23.16, -23.16, -23.16, -23.10, -23.11, -23.05, -23.09, -23.12, -23.16, -23.21,
        -23.19, -23.21, -23.21, -23.18, -23.18, -23.21, -23.14, -23.20, -23.16, -23.14,
        -23.11, -23.11, -23.00, -23.00, -23.01, -22.97, -22.99, -22.98, -22.99, -23.01,
        -23.06, -23.01, -22.99, -23.02, -23.01, -23.00, -23.06, -23.01, -23.04, -22.97,
        -23.01, -23.01, -23.01, -23.01, -23.01, -22.96, -23.01, -23.10, -23.06, -23.06,
        -23.10, -23.04, -23.01, -23.01, -23.03, -23.11, -23.11, -23.11, -23.16, -23.16,
        -23.11, -23.11, -23.11, -23.06, -23.01, -23.01, -22.96, -22.96, -22.97, -23.00,
        -22.99, -22.97, -22.96, -22.97, -22.97, -22.97, -22.97, -22.91, -22.80, -22.75,
        -22.75, -22.75, -22.75, -22.80, -22.90, -22.92, -22.91, -22.90, -22.90, -22.88,
        -22.85, -22.84, -22.74, -22.73, -22.63, -22.63, -22.64, -22.65, -22.68, -22.67,
        -22.70, -22.70, -22.73, -22.73, -22.70, -22.73, -22.70, -22.75, -22.75, -22.75,
        -22.75, -22.75, -22.75, -22.75, -22.75, -22.70, -22.69, -22.59, -22.54, -22.54,
        -22.54, -22.54, -22.54, -22.59, -22.70, -22.69, -22.61, -22.55, -22.54, -22.54,
        -22.56, -22.58, -22.53, -22.49, -22.44, -22.41, -22.49, -22.47, -22.45, -22.44,
        -22.41, -22.38, -22.34, -22.33, -22.30, -22.29, -22.38, -22.34, -22.39, -22.39,
        -22.34, -22.34, -22.34, -22.38, -22.31, -22.33, -22.27, -22.28, -22.29, -22.31,
        -22.25, -22.28, -22.19, -22.18, -22.12, -22.09, -22.12, -22.03, -22.07, -22.03,
        -21.95, -21.98, -22.08, -22.03, -21.95, -21.93, -21.87, -21.87, -21.82, -21.80,
        -21.77, -21.81, -21.72, -21.71, -21.66, -21.70, -21.67, -21.72, -21.82, -21.80,
        -21.77, -21.81, -21.81, -21.82, -21.86, -21.78, -21.76, -21.72, -21.76, -21.72,
        -21.75, -21.72, -21.72, -21.67, -21.71, -21.67, -21.63, -21.67, -21.69, -21.71,
        -21.71, -21.77, -21.67, -21.72, -21.71, -21.67, -21.69, -21.71, -21.62, -21.57,
        -21.46, -21.43, -21.39, -21.40, -21.35, -21.33, -21.32, -21.25, -21.35, -21.27,
        -21.25, -21.30, -21.31, -21.40, -21.36, -21.46, -21.50, -21.46, -21.40, -21.40,
        -21.35, -21.30, -21.32, -21.33, -21.36, -21.30, -21.40, -21.40, -21.41, -21.43,
        -21.50, -21.46, -21.47, -21.39, -21.35, -21.37, -21.31, -21.34, -21.35, -21.30,
        -21.26, -21.25, -21.26, -21.30, -21.28, -21.27, -21.30, -21.25, -21.20, -21.14,
        -21.10, -21.10, -21.09, -21.10, -21.07, -21.09, -21.06, -21.11, -21.12, -21.13,
        -21.14, -21.12, -21.14, -21.14, -21.06, -21.10, -21.20, -21.14, -21.10, -21.13,
        -21.15, -21.13, -21.13, -21.15, -21.25, -21.20, -21.20, -21.10, -21.10, -21.10,
        -21.11, -21.15, -21.25, -21.25, -21.30, -21.25, -21.28, -21.26, -21.25, -21.20,
        -21.20, -21.20, -21.26, -21.27, -21.30, -21.23, -21.30, -21.32, -21.32, -21.31,
        -21.38, -21.41, -21.33, -21.30, -21.24, -21.20, -21.20, -21.20, -21.20, -21.19,
        -21.19, -21.19, -21.19, -21.20, -21.20, -21.20, -21.20, -21.20, -21.21, -21.22,
        -21.24, -21.25, -21.25, -21.25, -21.26, -21.25, -21.20, -21.20, -21.20, -21.20,
        -21.25, -21.26, -21.35, -21.40, -21.40, -21.40, -21.40, -21.40, -21.40, -21.40,
        -21.40, -21.45, -21.48, -21.50, -21.46, -21.55, -21.56, -21.63, -21.66, -21.71,
        -21.76, -21.72, -21.66, -21.71, -21.66, -21.67, -21.61, -21.63, -21.56, -21.65,
        -21.66, -21.66, -21.70, -21.78, -21.74, -21.77, -21.77, -21.82, -21.81, -21.81,
        -21.78, -21.80, -21.84, -21.75, -21.77, -21.82, -21.82, -21.77, -21.77, -21.78,
        -21.77, -21.86, -21.90, -21.90, -21.90, -21.90, -21.96, -22.02, -21.97, -21.92,
        -22.14, -22.16, -22.11, -22.11, -22.16, -22.21, -22.03, -22.03, -21.98, -22.01,
        -22.04, -22.05, -22.10, -22.08, -22.12, -22.22, -22.13, -22.15, -22.08, -22.18,
        -22.34, -22.29, -22.23, -22.18, -22.28, -22.44, -22.36, -22.34, -22.35, -22.50,
        -22.47, -22.48, -22.48, -22.43, -22.31, -22.38, -22.28, -22.28, -22.32, -22.31,
        -22.29, -22.30, -22.34, -22.31, -22.34, -22.33, -22.29, -22.30, -22.34, -22.38,
        -22.35, -22.28, -22.41, -22.48, -22.42, -22.36, -22.45, -22.46, -22.39, -22.36,
        -22.38, -22.32, -22.34, -22.33, -22.35, -22.31, -22.24, -22.28, -22.31, -22.28,
        -22.24, -22.24, -22.28, -22.38, -22.43, -22.43, -22.41, -22.43, -22.45, -22.50,
        -22.53, -22.57, -22.59, -22.65, -22.70, -22.70, -22.68, -22.70, -22.68, -22.70,
        -22.74, -22.65, -22.65, -22.59, -22.59, -22.58, -22.55, -22.56, -22.56, -22.50,
        -22.44, -22.44, -22.39, -22.39, -22.44, -22.49, -22.53, -22.54, -22.47, -22.46,
        -22.49, -22.49, -22.46, -22.43, -22.43, -22.41, -22.39, -22.42, -22.43, -22.40,
        -22.37, -22.39, -22.36, -22.37, -22.38, -22.43, -22.49, -22.44, -22.54, -22.59,
        -22.65, -22.65, -22.63, -22.70, -22.69, -22.68, -22.60, -22.59, -22.64, -22.63,
        -22.59, -22.64, -22.68, -22.65, -22.76, -22.84, -22.87, -22.91, -22.90, -22.98,
        -23.02, -23.04, -23.06, -23.01, -23.00, -23.00, -22.98, -23.01, -23.01, -23.03,
        -23.02, -23.11, -23.15, -23.12, -23.14, -23.17, -23.20, -23.19, -23.17, -23.27,
        -23.27, -23.26, -23.27, -23.26, -23.42, -23.44, -23.40, -23.42, -23.49, -23.53,
        -23.54, -23.53, -23.48, -23.52, -23.60, -23.73, -23.78, -23.85, -23.95, -24.05,
        -24.14, -24.10, -24.00, -23.99, -24.03, -24.04, -23.91, -23.94, -23.97, -24.04,
        -23.95, -23.99, -23.94, -24.03, -24.00, -23.99, -23.88, -23.84, -23.84, -23.92,
        -23.99, -23.96, -23.94, -23.99, -23.95, -23.96, -23.89, -23.79, -23.84, -23.80,
        -23.74, -23.61, -23.63, -23.43, -23.42, -23.33, -23.33, -22.90, -22.90, -22.93,
        -22.95, -22.78, -22.70, -22.51, -22.51, -22.48, -22.35, -22.32
    };

    static const float robinson_dadson_curve_70_phons[1468] =
    {
        -7.77, -7.74, -7.77, -7.79, -7.80, -7.80, -7.83, -7.85, -7.84, -7.83,
        -7.86, -7.90, -7.89, -7.90, -7.88, -7.91, -7.92, -7.91, -7.92, -7.89,
        -7.92, -7.92, -7.98, -8.00, -8.01, -8.03, -8.04, -8.08, -8.07, -8.12,
        -8.13, -8.17, -8.21, -8.24, -8.27, -8.28, -8.25, -8.29, -8.27, -8.26,
        -8.25, -8.24, -8.27, -8.26, -8.24, -8.21, -8.24, -8.27, -8.24, -8.25,
        -8.33, -8.33, -8.35, -8.38, -8.36, -8.39, -8.48, -8.53, -8.51, -8.53,
        -8.51, -8.49, -8.51, -8.47, -8.42, -8.44, -8.45, -8.42, -8.33, -8.37,
        -8.36, -8.31, -8.29, -8.30, -8.31, -8.28, -8.28, -8.29, -8.33, -8.39,
        -8.37, -8.38, -8.42, -8.41, -8.39, -8.38, -8.39, -8.40, -8.39, -8.39,
        -8.45, -8.54, -8.59, -8.65, -8.65, -8.63, -8.67, -8.68, -8.65, -8.73,
        -8.77, -8.77, -8.78, -8.79, -8.82, -8.81, -8.79, -8.79, -8.77, -8.78,
        -8.81, -8.80, -8.82, -8.84, -8.84, -8.86, -8.88, -8.86, -8.89, -8.87,
        -8.88, -8.88, -8.93, -8.93, -8.94, -8.96, -8.97, -8.95, -8.94, -8.94,
        -8.95, -9.01, -9.00, -9.00, -8.99, -8.99, -9.05, -9.06, -9.09, -9.09,
        -9.09, -9.15, -9.15, -9.15, -9.15, -9.19, -9.21, -9.19, -9.17, -9.21,
        -9.18, -9.18, -9.18, -9.23, -9.24, -9.26, -9.24, -9.22, -9.25, -9.29,
        -9.29, -9.28, -9.29, -9.31, -9.36, -9.38, -9.39, -9.38, -9.40, -9.39,
        -9.36, -9.38, -9.38, -9.38, -9.40, -9.41, -9.43, -9.43, -9.44, -9.44,
        -9.44, -9.44, -9.44, -9.45, -9.46, -9.48, -9.53, -9.56, -9.61, -9.62,
        -9.59, -9.61, -9.59, -9.59, -9.60, -9.64, -9.67, -9.72, -9.73, -9.76,
        -9.79, -9.79, -9.76, -9.80, -9.79, -9.82, -9.85, -9.87, -9.89, -9.88,
        -9.85, -9.83, -9.85, -9.85, -9.85, -9.88, -9.93, -9.94, -9.96, -9.96,
        -9.97, -10.02, -10.00, -10.00, -10.02, -10.00, -10.05, -10.06, -10.08, -10.09,
        -10.11, -10.08, -10.11, -10.14, -10.12, -10.17, -10.17, -10.23, -10.23, -10.24,
        -10.23, -10.24, -10.23, -10.23, -10.26, -10.23, -10.26, -10.27, -10.26, -10.29,
        -10.29, -10.29, -10.29, -10.30, -10.31, -10.29, -10.31, -10.31, -10.31, -10.30,
        -10.29, -10.29, -10.29, -10.34, -10.35, -10.40, -10.38, -10.43, -10.41, -10.43,
        -10.49, -10.55, -10.54, -10.52, -10.52, -10.55, -10.57, -10.58, -10.59, -10.62,
        -10.65, -10.66, -10.61, -10.65, -10.61, -10.65, -10.62, -10.66, -10.64, -10.67,
        -10.70, -10.72, -10.73, -10.75, -10.73, -10.72, -10.73, -10.73, -10.73, -10.76,
        -10.76, -10.78, -10.78, -10.81, -10.83, -10.88, -10.90, -10.92, -10.90, -10.86,
        -10.87, -10.91, -10.90, -10.87, -10.87, -10.90, -10.90, -10.83, -10.84, -10.87,
        -10.90, -10.92, -10.93, -10.99, -10.96, -10.96, -11.02, -11.02, -11.01, -10.99,
        -10.99, -11.02, -11.01, -11.00, -11.03, -11.04, -11.06, -11.05, -11.10, -11.09,
        -11.11, -11.11, -11.16, -11.11, -11.13, -11.16, -11.18, -11.17, -11.16, -11.16,
        -11.16, -11.16, -11.16, -11.16, -11.20, -11.21, -11.22, -11.25, -11.25, -11.23,
        -11.24, -11.21, -11.21, -11.19, -11.18, -11.16, -11.14, -11.16, -11.15, -11.17,
        -11.19, -11.21, -11.26, -11.28, -11.28, -11.28, -11.28, -11.34, -11.34, -11.37,
        -11.37, -11.40, -11.40, -11.43, -11.46, -11.49, -11.49, -11.49, -11.51, -11.51,
        -11.50, -11.50, -11.54, -11.52, -11.51, -11.54, -11.55, -11.54, -11.56, -11.57,
        -11.55, -11.54, -11.55, -11.57, -11.54, -11.53, -11.50, -11.53, -11.52, -11.54,
        -11.56, -11.54, -11.60, -11.59, -11.57, -11.57, -11.55, -11.54, -11.56, -11.54,
        -11.55, -11.55, -11.57, -11.57, -11.63, -11.63, -11.67, -11.72, -11.75, -11.75,
        -11.74, -11.74, -11.69, -11.69, -11.74, -11.69, -11.67, -11.66, -11.68, -11.66,
        -11.69, -11.69, -11.74, -11.71, -11.73, -11.72, -11.76, -11.79, -11.78, -11.84,
        -11.81, -11.83, -11.78, -11.78, -11.77, -11.80, -11.83, -11.84, -11.89, -11.87,
        -11.89, -11.87, -11.92, -11.89, -11.89, -11.90, -11.92, -11.89, -11.93, -11.90,
        -11.89, -11.91, -11.95, -11.98, -11.98, -11.98, -12.00, -12.02, -12.04, -12.07,
        -12.09, -12.07, -12.06, -12.01, -12.02, -12.01, -12.04, -12.01, -12.04, -12.06,
        -12.07, -12.10, -12.07, -12.04, -12.03, -12.05, -12.01, -11.99, -12.01, -12.01,
        -11.99, -12.01, -12.01, -12.02, -12.08, -12.10, -12.16, -12.19, -12.22, -12.21,
        -12.22, -12.25, -12.24, -12.23, -12.26, -12.24, -12.27, -12.26, -12.27, -12.25,
        -12.24, -12.24, -12.25, -12.25, -12.24, -12.22, -12.19, -12.19, -12.19, -12.19,
        -12.14, -12.18, -12.19, -12.22, -12.21, -12.20, -12.24, -12.27, -12.30, -12.25,
        -12.30, -12.28, -12.29, -12.30, -12.31, -12.33, -12.33, -12.30, -12.25, -12.30,
        -12.28, -12.33, -12.33, -12.33, -12.36, -12.34, -12.30, -12.27, -12.27, -12.30,
        -12.33, -12.33, -12.33, -12.32, -12.30, -12.27, -12.28, -12.33, -12.33, -12.35,
        -12.34, -12.39, -12.38, -12.42, -12.41, -12.42, -12.42, -12.44, -12.47, -12.45,
        -12.47, -12.49, -12.48, -12.48, -12.48, -12.49, -12.45, -12.44, -12.42, -12.42,
        -12.42, -12.42, -12.42, -12.45, -12.48, -12.48, -12.48, -12.48, -12.48, -12.48,
        -12.48, -12.48, -12.49, -12.48, -12.48, -12.52, -12.57, -12.57, -12.59, -12.61,
        -12.61, -12.59, -12.54, -12.51, -12.54, -12.54, -12.60, -12.63, -12.63, -12.63,
        -12.63, -12.63, -12.63, -12.63, -12.63, -12.63, -12.63, -12.67, -12.68, -12.73,
        -12.71, -12.71, -12.68, -12.67, -12.65, -12.64, -12.64, -12.63, -12.63, -12.63,
        -12.63, -12.62, -12.62, -12.62, -12.62, -12.63, -12.65, -12.67, -12.71, -12.74,
        -12.74, -12.74, -12.74, -12.74, -12.74, -12.74, -12.74, -12.74, -12.74, -12.74,
        -12.74, -12.74, -12.73, -12.72, -12.73, -12.74, -12.74, -12.74, -12.74, -12.74,
        -12.74, -12.74, -12.74, -12.74, -12.74, -12.74, -12.80, -12.80, -12.86, -12.86,
        -12.86, -12.86, -12.86, -12.86, -12.86, -12.86, -12.86, -12.89, -12.89, -12.89,
        -12.89, -12.86, -12.86, -12.86, -12.86, -12.86, -12.86, -12.86, -12.87, -12.90,
        -12.91, -12.92, -12.92, -12.92, -12.92, -12.92, -12.92, -12.95, -12.95, -12.95,
        -12.97, -12.97, -12.98, -12.98, -12.98, -12.98, -12.98, -12.97, -12.95, -12.95,
        -12.96, -12.96, -12.94, -12.92, -12.93, -12.95, -12.95, -12.92, -12.91, -12.90,
        -12.89, -12.88, -12.86, -12.85, -12.84, -12.88, -12.94, -12.97, -12.97, -12.98,
        -13.03, -13.04, -13.09, -13.06, -13.03, -13.03, -13.03, -13.01, -12.97, -12.97,
        -12.97, -13.00, -13.03, -13.07, -13.09, -13.09, -13.05, -13.03, -13.00, -13.00,
        -13.03, -13.05, -13.03, -13.06, -13.06, -13.05, -13.06, -13.03, -13.02, -13.03,
        -13.03, -13.01, -13.03, -13.01, -13.00, -13.03, -13.04, -13.06, -13.05, -13.07,
        -13.11, -13.09, -13.12, -13.12, -13.11, -13.09, -13.06, -13.06, -13.03, -13.01,
        -13.03, -13.05, -13.06, -13.04, -13.05, -13.04, -13.06, -13.07, -13.09, -13.07,
        -13.09, -13.12, -13.10, -13.09, -13.11, -13.09, -13.09, -13.06, -13.03, -13.07,
        -13.07, -13.09, -13.09, -13.09, -13.07, -13.09, -13.06, -13.11, -13.07, -13.09,
        -13.09, -13.09, -13.09, -13.06, -13.06, -13.03, -13.05, -13.07, -13.09, -13.12,
        -13.11, -13.12, -13.12, -13.10, -13.10, -13.12, -13.08, -13.12, -13.09, -13.08,
        -13.06, -13.06, -13.00, -13.00, -13.00, -12.98, -12.99, -12.99, -13.00, -13.01,
        -13.03, -13.00, -12.99, -13.01, -13.01, -13.00, -13.03, -13.00, -13.02, -12.98,
        -13.00, -13.01, -13.00, -13.00, -13.00, -12.98, -13.00, -13.05, -13.03, -13.03,
        -13.06, -13.02, -13.01, -13.00, -13.01, -13.06, -13.06, -13.06, -13.09, -13.09,
        -13.06, -13.06, -13.06, -13.03, -13.00, -13.00, -12.98, -12.98, -12.98, -13.00,
        -12.99, -12.98, -12.98, -12.98, -12.99, -12.99, -12.98, -12.95, -12.89, -12.86,
        -12.86, -12.86, -12.86, -12.89, -12.95, -12.96, -12.95, -12.95, -12.95, -12.93,
        -12.91, -12.91, -12.85, -12.85, -12.79, -12.79, -12.80, -12.80, -12.82, -12.81,
        -12.83, -12.83, -12.84, -12.85, -12.83, -12.85, -12.83, -12.86, -12.86, -12.86,
        -12.86, -12.86, -12.86, -12.86, -12.86, -12.83, -12.83, -12.77, -12.74, -12.74,
        -12.74, -12.74, -12.74, -12.77, -12.83, -12.83, -12.78, -12.75, -12.74, -12.74,
        -12.75, -12.76, -12.74, -12.71, -12.68, -12.67, -12.71, -12.70, -12.69, -12.68,
        -12.67, -12.65, -12.63, -12.62, -12.60, -12.60, -12.65, -12.63, -12.65, -12.66,
        -12.63, -12.62, -12.63, -12.65, -12.61, -12.62, -12.59, -12.59, -12.60, -12.61,
        -12.57, -12.59, -12.54, -12.54, -12.51, -12.49, -12.50, -12.45, -12.48, -12.45,
        -12.41, -12.42, -12.48, -12.45, -12.41, -12.39, -12.36, -12.36, -12.33, -12.32,
        -12.30, -12.33, -12.27, -12.27, -12.24, -12.26, -12.25, -12.27, -12.33, -12.32,
        -12.31, -12.33, -12.33, -12.33, -12.36, -12.31, -12.30, -12.28, -12.30, -12.28,
        -12.30, -12.28, -12.28, -12.25, -12.27, -12.25, -12.23, -12.25, -12.26, -12.27,
        -12.27, -12.30, -12.25, -12.27, -12.27, -12.25, -12.26, -12.27, -12.22, -12.19,
        -12.13, -12.11, -12.09, -12.09, -12.07, -12.05, -12.05, -12.01, -12.07, -12.02,
        -12.01, -12.04, -12.04, -12.09, -12.07, -12.13, -12.15, -12.13, -12.09, -12.09,
        -12.07, -12.04, -12.05, -12.06, -12.07, -12.04, -12.10, -12.10, -12.10, -12.11,
        -12.15, -12.13, -12.13, -12.09, -12.07, -12.08, -12.05, -12.06, -12.07, -12.04,
        -12.02, -12.01, -12.01, -12.04, -12.03, -12.02, -12.04, -12.01, -11.98, -11.95,
        -11.93, -11.93, -11.92, -11.93, -11.91, -11.92, -11.91, -11.93, -11.94, -11.94,
        -11.95, -11.94, -11.95, -11.95, -11.91, -11.92, -11.98, -11.95, -11.92, -11.94,
        -11.95, -11.94, -11.94, -11.95, -12.01, -11.98, -11.98, -11.93, -11.93, -11.93,
        -11.93, -11.95, -12.01, -12.01, -12.04, -12.01, -12.03, -12.02, -12.01, -11.98,
        -11.98, -11.99, -12.02, -12.02, -12.04, -12.00, -12.04, -12.05, -12.05, -12.05,
        -12.08, -12.10, -12.06, -12.04, -12.00, -11.98, -11.98, -11.98, -11.98, -11.98,
        -11.98, -11.98, -11.98, -11.98, -11.98, -11.98, -11.98, -11.98, -11.99, -11.99,
        -12.00, -12.01, -12.01, -12.01, -12.02, -12.01, -11.98, -11.98, -11.98, -11.98,
        -12.01, -12.01, -12.07, -12.10, -12.10, -12.10, -12.10, -12.10, -12.10, -12.10,
        -12.10, -12.12, -12.14, -12.15, -12.13, -12.18, -12.19, -12.23, -12.24, -12.27,
        -12.30, -12.27, -12.24, -12.27, -12.24, -12.25, -12.22, -12.23, -12.19, -12.24,
        -12.24, -12.24, -12.26, -12.31, -12.29, -12.30, -12.30, -12.33, -12.33, -12.33,
        -12.31, -12.32, -12.35, -12.30, -12.30, -12.33, -12.33, -12.30, -12.30, -12.31,
        -12.30, -12.36, -12.38, -12.38, -12.38, -12.38, -12.41, -12.44, -12.42, -12.39,
        -12.51, -12.53, -12.50, -12.50, -12.53, -12.55, -12.45, -12.45, -12.42, -12.44,
        -12.46, -12.46, -12.49, -12.48, -12.50, -12.56, -12.51, -12.52, -12.48, -12.54,
        -12.63, -12.60, -12.57, -12.54, -12.59, -12.68, -12.64, -12.63, -12.63, -12.72,
        -12.70, -12.71, -12.71, -12.68, -12.61, -12.65, -12.59, -12.60, -12.62, -12.61,
        -12.60, -12.60, -12.63, -12.61, -12.63, -12.62, -12.60, -12.60, -12.63, -12.65,
        -12.63, -12.59, -12.66, -12.70, -12.67, -12.64, -12.69, -12.69, -12.66, -12.64,
        -12.65, -12.62, -12.63, -12.62, -12.63, -12.61, -12.57, -12.59, -12.61, -12.59,
        -12.57, -12.57, -12.59, -12.65, -12.68, -12.68, -12.67, -12.68, -12.69, -12.72,
        -12.73, -12.76, -12.77, -12.80, -12.83, -12.83, -12.82, -12.83, -12.82, -12.83,
        -12.85, -12.80, -12.80, -12.77, -12.77, -12.76, -12.74, -12.75, -12.75, -12.72,
        -12.68, -12.68, -12.65, -12.65, -12.68, -12.71, -12.74, -12.74, -12.70, -12.70,
        -12.71, -12.71, -12.70, -12.68, -12.68, -12.66, -12.66, -12.67, -12.68, -12.66,
        -12.65, -12.66, -12.64, -12.64, -12.65, -12.68, -12.71, -12.68, -12.74, -12.77,
        -12.80, -12.80, -12.79, -12.83, -12.83, -12.82, -12.78, -12.77, -12.80, -12.79,
        -12.77, -12.80, -12.82, -12.80, -12.86, -12.91, -12.93, -12.95, -12.94, -12.99,
        -13.01, -13.02, -13.03, -13.01, -13.00, -13.00, -12.99, -13.00, -13.00, -13.02,
        -13.01, -13.06, -13.09, -13.07, -13.08, -13.09, -13.11, -13.11, -13.09, -13.15,
        -13.15, -13.15, -13.15, -13.15, -13.24, -13.25, -13.23, -13.24, -13.28, -13.30,
        -13.31, -13.30, -13.27, -13.29, -13.34, -13.41, -13.44, -13.48, -13.54, -13.59,
        -13.65, -13.62, -13.57, -13.56, -13.58, -13.59, -13.51, -13.53, -13.55, -13.59,
        -13.54, -13.56, -13.53, -13.58, -13.56, -13.56, -13.50, -13.47, -13.47, -13.52,
        -13.56, -13.54, -13.53, -13.56, -13.53, -13.54, -13.50, -13.45, -13.47, -13.45,
        -13.42, -13.35, -13.36, -13.24, -13.24, -13.19, -13.19, -12.95, -12.94, -12.96,
        -12.97, -12.88, -12.83, -12.72, -12.72, -12.71, -12.63, -12.61
    };

    static const float robinson_dadson_curve_80_phons[1468] =
    {
        -1.79, -1.79, -1.79, -1.80, -1.80, -1.80, -1.81, -1.81, -1.81, -1.81,
        -1.81, -1.82, -1.82, -1.82, -1.82, -1.83, -1.83, -1.83, -1.83, -1.82,
        -1.83, -1.83, -1.84, -1.85, -1.85, -1.85, -1.85, -1.86, -1.86, -1.87,
        -1.88, -1.88, -1.89, -1.90, -1.91, -1.91, -1.90, -1.91, -1.91, -1.91,
        -1.90, -1.90, -1.91, -1.91, -1.90, -1.89, -1.90, -1.91, -1.90, -1.90,
        -1.92, -1.92, -1.93, -1.93, -1.93, -1.94, -1.96, -1.97, -1.96, -1.97,
        -1.96, -1.96, -1.96, -1.95, -1.94, -1.95, -1.95, -1.94, -1.92, -1.93,
        -1.93, -1.92, -1.91, -1.91, -1.92, -1.91, -1.91, -1.91, -1.92, -1.94,
        -1.93, -1.93, -1.94, -1.94, -1.94, -1.93, -1.94, -1.94, -1.94, -1.94,
        -1.95, -1.97, -1.98, -2.00, -2.00, -1.99, -2.00, -2.00, -2.00, -2.02,
        -2.02, -2.02, -2.03, -2.03, -2.03, -2.03, -2.03, -2.03, -2.02, -2.03,
        -2.03, -2.03, -2.04, -2.04, -2.04, -2.04, -2.05, -2.04, -2.05, -2.05,
        -2.05, -2.05, -2.06, -2.06, -2.06, -2.07, -2.07, -2.06, -2.06, -2.06,
        -2.06, -2.08, -2.08, -2.08, -2.07, -2.07, -2.09, -2.09, -2.10, -2.10,
        -2.10, -2.11, -2.11, -2.11, -2.11, -2.12, -2.12, -2.12, -2.12, -2.12,
        -2.12, -2.12, -2.12, -2.13, -2.13, -2.14, -2.13, -2.13, -2.13, -2.14,
        -2.14, -2.14, -2.14, -2.15, -2.16, -2.16, -2.17, -2.16, -2.17, -2.17,
        -2.16, -2.17, -2.16, -2.16, -2.17, -2.17, -2.18, -2.18, -2.18, -2.18,
        -2.18, -2.18, -2.18, -2.18, -2.18, -2.19, -2.20, -2.21, -2.22, -2.22,
        -2.21, -2.22, -2.21, -2.21, -2.22, -2.22, -2.23, -2.24, -2.25, -2.25,
        -2.26, -2.26, -2.25, -2.26, -2.26, -2.27, -2.27, -2.28, -2.28, -2.28,
        -2.27, -2.27, -2.27, -2.27, -2.27, -2.28, -2.29, -2.29, -2.30, -2.30,
        -2.30, -2.31, -2.31, -2.31, -2.31, -2.31, -2.32, -2.32, -2.33, -2.33,
        -2.33, -2.33, -2.33, -2.34, -2.34, -2.35, -2.35, -2.36, -2.36, -2.36,
        -2.36, -2.36, -2.36, -2.36, -2.37, -2.36, -2.37, -2.37, -2.37, -2.37,
        -2.37, -2.38, -2.37, -2.38, -2.38, -2.38, -2.38, -2.38, -2.38, -2.38,
        -2.38, -2.38, -2.37, -2.39, -2.39, -2.40, -2.40, -2.41, -2.40, -2.41,
        -2.42, -2.43, -2.43, -2.43, -2.43, -2.44, -2.44, -2.44, -2.44, -2.45,
        -2.46, -2.46, -2.45, -2.46, -2.45, -2.46, -2.45, -2.46, -2.46, -2.46,
        -2.47, -2.47, -2.48, -2.48, -2.48, -2.47, -2.48, -2.48, -2.48, -2.48,
        -2.48, -2.49, -2.49, -2.50, -2.50, -2.51, -2.51, -2.52, -2.52, -2.51,
        -2.51, -2.52, -2.52, -2.51, -2.51, -2.51, -2.51, -2.50, -2.50, -2.51,
        -2.52, -2.52, -2.52, -2.54, -2.53, -2.53, -2.54, -2.54, -2.54, -2.54,
        -2.54, -2.54, -2.54, -2.54, -2.54, -2.55, -2.55, -2.55, -2.56, -2.56,
        -2.56, -2.56, -2.58, -2.56, -2.57, -2.58, -2.58, -2.58, -2.58, -2.58,
        -2.58, -2.58, -2.58, -2.58, -2.58, -2.59, -2.59, -2.60, -2.60, -2.59,
        -2.59, -2.59, -2.59, -2.58, -2.58, -2.58, -2.57, -2.58, -2.57, -2.58,
        -2.58, -2.59, -2.60, -2.60, -2.60, -2.60, -2.60, -2.62, -2.62, -2.62,
        -2.62, -2.63, -2.63, -2.64, -2.64, -2.65, -2.65, -2.65, -2.66, -2.66,
        -2.65, -2.65, -2.66, -2.66, -2.66, -2.66, -2.67, -2.66, -2.67, -2.67,
        -2.66, -2.66, -2.66, -2.67, -2.66, -2.66, -2.65, -2.66, -2.66, -2.66,
        -2.67, -2.66, -2.68, -2.68, -2.67, -2.67, -2.66, -2.66, -2.67, -2.66,
        -2.67, -2.66, -2.67, -2.67, -2.68, -2.68, -2.69, -2.70, -2.71, -2.71,
        -2.71, -2.71, -2.70, -2.70, -2.71, -2.70, -2.69, -2.69, -2.70, -2.69,
        -2.70, -2.70, -2.71, -2.70, -2.71, -2.70, -2.71, -2.72, -2.72, -2.73,
        -2.73, -2.73, -2.72, -2.72, -2.72, -2.72, -2.73, -2.73, -2.74, -2.74,
        -2.74, -2.74, -2.75, -2.74, -2.74, -2.75, -2.75, -2.74, -2.75, -2.75,
        -2.74, -2.75, -2.76, -2.76, -2.76, -2.76, -2.77, -2.77, -2.78, -2.79,
        -2.79, -2.78, -2.78, -2.77, -2.77, -2.77, -2.78, -2.77, -2.78, -2.78,
        -2.79, -2.79, -2.78, -2.78, -2.78, -2.78, -2.77, -2.77, -2.77, -2.77,
        -2.77, -2.77, -2.77, -2.77, -2.79, -2.79, -2.81, -2.81, -2.82, -2.82,
        -2.82, -2.83, -2.82, -2.82, -2.83, -2.83, -2.83, -2.83, -2.83, -2.83,
        -2.83, -2.83, -2.83, -2.83, -2.83, -2.82, -2.81, -2.81, -2.81, -2.81,
        -2.80, -2.81, -2.81, -2.82, -2.82, -2.82, -2.83, -2.83, -2.84, -2.83,
        -2.84, -2.83, -2.84, -2.84, -2.84, -2.85, -2.85, -2.84, -2.83, -2.84,
        -2.83, -2.85, -2.85, -2.85, -2.85, -2.85, -2.84, -2.83, -2.83, -2.84,
        -2.85, -2.85, -2.84, -2.84, -2.84, -2.83, -2.83, -2.85, -2.85, -2.85,
        -2.85, -2.86, -2.86, -2.87, -2.86, -2.87, -2.87, -2.87, -2.88, -2.87,
        -2.88, -2.88, -2.88, -2.88, -2.88, -2.88, -2.87, -2.87, -2.87, -2.87,
        -2.87, -2.87, -2.87, -2.87, -2.88, -2.88, -2.88, -2.88, -2.88, -2.88,
        -2.88, -2.88, -2.88, -2.88, -2.88, -2.89, -2.90, -2.90, -2.90, -2.91,
        -2.91, -2.91, -2.89, -2.89, -2.89, -2.89, -2.91, -2.91, -2.91, -2.91,
        -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.92, -2.93, -2.94,
        -2.93, -2.93, -2.93, -2.92, -2.92, -2.92, -2.92, -2.91, -2.91, -2.91,
        -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.92, -2.92, -2.93, -2.94,
        -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94,
        -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94,
        -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.95, -2.95, -2.97, -2.97,
        -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.98, -2.98,
        -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.98,
        -2.98, -2.98, -2.98, -2.98, -2.98, -2.98, -2.98, -2.99, -2.99, -2.99,
        -2.99, -2.99, -2.99, -2.99, -2.99, -2.99, -2.99, -2.99, -2.99, -2.99,
        -2.99, -2.99, -2.99, -2.98, -2.98, -2.99, -2.99, -2.98, -2.98, -2.98,
        -2.98, -2.97, -2.97, -2.97, -2.96, -2.97, -2.99, -2.99, -2.99, -2.99,
        -3.01, -3.01, -3.02, -3.01, -3.01, -3.01, -3.01, -3.00, -2.99, -2.99,
        -2.99, -3.00, -3.01, -3.02, -3.02, -3.02, -3.01, -3.01, -3.00, -3.00,
        -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01,
        -3.01, -3.00, -3.01, -3.00, -3.00, -3.01, -3.01, -3.01, -3.01, -3.02,
        -3.03, -3.02, -3.03, -3.03, -3.03, -3.02, -3.01, -3.01, -3.01, -3.00,
        -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.02, -3.02, -3.02,
        -3.02, -3.03, -3.02, -3.02, -3.02, -3.02, -3.02, -3.01, -3.01, -3.02,
        -3.02, -3.02, -3.02, -3.02, -3.02, -3.02, -3.01, -3.03, -3.02, -3.02,
        -3.02, -3.02, -3.02, -3.01, -3.01, -3.01, -3.01, -3.02, -3.02, -3.03,
        -3.02, -3.03, -3.03, -3.02, -3.02, -3.03, -3.02, -3.03, -3.02, -3.02,
        -3.01, -3.01, -3.00, -3.00, -3.00, -3.00, -3.00, -3.00, -3.00, -3.00,
        -3.01, -3.00, -3.00, -3.00, -3.00, -3.00, -3.01, -3.00, -3.01, -3.00,
        -3.00, -3.00, -3.00, -3.00, -3.00, -2.99, -3.00, -3.01, -3.01, -3.01,
        -3.01, -3.00, -3.00, -3.00, -3.00, -3.01, -3.01, -3.01, -3.02, -3.02,
        -3.01, -3.01, -3.01, -3.01, -3.00, -3.00, -2.99, -2.99, -3.00, -3.00,
        -3.00, -3.00, -3.00, -3.00, -3.00, -3.00, -3.00, -2.99, -2.97, -2.97,
        -2.97, -2.97, -2.97, -2.97, -2.99, -2.99, -2.99, -2.99, -2.99, -2.98,
        -2.98, -2.98, -2.97, -2.96, -2.95, -2.95, -2.95, -2.95, -2.96, -2.96,
        -2.96, -2.96, -2.96, -2.96, -2.96, -2.97, -2.96, -2.97, -2.97, -2.97,
        -2.97, -2.97, -2.97, -2.97, -2.97, -2.96, -2.96, -2.95, -2.94, -2.94,
        -2.94, -2.94, -2.94, -2.95, -2.96, -2.96, -2.95, -2.94, -2.94, -2.94,
        -2.94, -2.94, -2.94, -2.93, -2.93, -2.92, -2.93, -2.93, -2.93, -2.93,
        -2.92, -2.92, -2.91, -2.91, -2.91, -2.91, -2.92, -2.91, -2.92, -2.92,
        -2.91, -2.91, -2.91, -2.92, -2.91, -2.91, -2.90, -2.91, -2.91, -2.91,
        -2.90, -2.91, -2.89, -2.89, -2.89, -2.88, -2.89, -2.87, -2.88, -2.87,
        -2.86, -2.87, -2.88, -2.87, -2.86, -2.86, -2.85, -2.85, -2.85, -2.84,
        -2.84, -2.85, -2.83, -2.83, -2.83, -2.83, -2.83, -2.83, -2.85, -2.84,
        -2.84, -2.84, -2.85, -2.85, -2.85, -2.84, -2.84, -2.83, -2.84, -2.83,
        -2.84, -2.83, -2.83, -2.83, -2.83, -2.83, -2.82, -2.83, -2.83, -2.83,
        -2.83, -2.84, -2.83, -2.83, -2.83, -2.83, -2.83, -2.83, -2.82, -2.81,
        -2.80, -2.79, -2.79, -2.79, -2.78, -2.78, -2.78, -2.77, -2.78, -2.77,
        -2.77, -2.78, -2.78, -2.79, -2.79, -2.80, -2.80, -2.80, -2.79, -2.79,
        -2.79, -2.78, -2.78, -2.78, -2.79, -2.78, -2.79, -2.79, -2.79, -2.80,
        -2.80, -2.80, -2.80, -2.79, -2.79, -2.79, -2.78, -2.78, -2.79, -2.78,
        -2.77, -2.77, -2.77, -2.78, -2.78, -2.77, -2.78, -2.77, -2.77, -2.76,
        -2.75, -2.75, -2.75, -2.75, -2.75, -2.75, -2.75, -2.75, -2.76, -2.76,
        -2.76, -2.76, -2.76, -2.76, -2.75, -2.75, -2.76, -2.76, -2.75, -2.76,
        -2.76, -2.76, -2.76, -2.76, -2.77, -2.77, -2.76, -2.75, -2.75, -2.75,
        -2.75, -2.76, -2.77, -2.77, -2.78, -2.77, -2.78, -2.77, -2.77, -2.77,
        -2.77, -2.77, -2.77, -2.77, -2.78, -2.77, -2.78, -2.78, -2.78, -2.78,
        -2.79, -2.79, -2.78, -2.78, -2.77, -2.76, -2.76, -2.76, -2.76, -2.76,
        -2.76, -2.76, -2.76, -2.76, -2.76, -2.76, -2.77, -2.77, -2.77, -2.77,
        -2.77, -2.77, -2.77, -2.77, -2.77, -2.77, -2.76, -2.76, -2.76, -2.76,
        -2.77, -2.77, -2.79, -2.79, -2.79, -2.79, -2.79, -2.79, -2.79, -2.79,
        -2.79, -2.80, -2.80, -2.80, -2.80, -2.81, -2.81, -2.82, -2.83, -2.83,
        -2.84, -2.83, -2.83, -2.83, -2.83, -2.83, -2.82, -2.82, -2.81, -2.82,
        -2.83, -2.82, -2.83, -2.84, -2.84, -2.84, -2.84, -2.85, -2.84, -2.85,
        -2.84, -2.84, -2.85, -2.84, -2.84, -2.85, -2.85, -2.84, -2.84, -2.84,
        -2.84, -2.85, -2.86, -2.86, -2.86, -2.86, -2.86, -2.87, -2.87, -2.86,
        -2.89, -2.89, -2.88, -2.88, -2.89, -2.90, -2.87, -2.87, -2.87, -2.87,
        -2.87, -2.88, -2.88, -2.88, -2.89, -2.90, -2.89, -2.89, -2.88, -2.89,
        -2.91, -2.91, -2.90, -2.89, -2.91, -2.93, -2.92, -2.91, -2.92, -2.93,
        -2.93, -2.93, -2.93, -2.93, -2.91, -2.92, -2.91, -2.91, -2.91, -2.91,
        -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.91, -2.92,
        -2.92, -2.91, -2.92, -2.93, -2.92, -2.92, -2.93, -2.93, -2.92, -2.92,
        -2.92, -2.91, -2.91, -2.91, -2.91, -2.91, -2.90, -2.91, -2.91, -2.91,
        -2.90, -2.90, -2.91, -2.92, -2.93, -2.93, -2.92, -2.93, -2.93, -2.93,
        -2.94, -2.94, -2.95, -2.95, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96,
        -2.97, -2.95, -2.95, -2.95, -2.95, -2.95, -2.94, -2.94, -2.94, -2.94,
        -2.93, -2.93, -2.92, -2.92, -2.93, -2.93, -2.94, -2.94, -2.93, -2.93,
        -2.93, -2.93, -2.93, -2.93, -2.93, -2.92, -2.92, -2.92, -2.93, -2.92,
        -2.92, -2.92, -2.92, -2.92, -2.92, -2.93, -2.93, -2.93, -2.94, -2.95,
        -2.95, -2.95, -2.95, -2.96, -2.96, -2.96, -2.95, -2.95, -2.95, -2.95,
        -2.95, -2.95, -2.96, -2.95, -2.97, -2.98, -2.98, -2.99, -2.99, -3.00,
        -3.00, -3.00, -3.01, -3.00, -3.00, -3.00, -3.00, -3.00, -3.00, -3.00,
        -3.00, -3.01, -3.02, -3.02, -3.02, -3.02, -3.03, -3.02, -3.02, -3.03,
        -3.03, -3.03, -3.04, -3.03, -3.05, -3.06, -3.05, -3.05, -3.06, -3.07,
        -3.07, -3.07, -3.06, -3.07, -3.08, -3.10, -3.10, -3.11, -3.12, -3.14,
        -3.15, -3.14, -3.13, -3.13, -3.13, -3.14, -3.12, -3.12, -3.13, -3.14,
        -3.12, -3.13, -3.12, -3.13, -3.13, -3.13, -3.11, -3.11, -3.11, -3.12,
        -3.13, -3.13, -3.12, -3.13, -3.12, -3.12, -3.12, -3.10, -3.11, -3.10,
        -3.10, -3.08, -3.08, -3.06, -3.06, -3.04, -3.04, -2.99, -2.99, -2.99,
        -2.99, -2.97, -2.96, -2.94, -2.94, -2.93, -2.92, -2.91
    };

    static const float robinson_dadson_curve_90_phons[1468] =
    {
        4.18, 4.17, 4.19, 4.20, 4.20, 4.20, 4.22, 4.23, 4.22, 4.22,
        4.23, 4.25, 4.25, 4.26, 4.24, 4.26, 4.27, 4.26, 4.27, 4.25,
        4.27, 4.27, 4.30, 4.31, 4.31, 4.32, 4.33, 4.35, 4.35, 4.37,
        4.38, 4.40, 4.42, 4.44, 4.45, 4.46, 4.44, 4.46, 4.45, 4.45,
        4.44, 4.44, 4.45, 4.45, 4.44, 4.42, 4.44, 4.46, 4.44, 4.44,
        4.48, 4.48, 4.50, 4.51, 4.50, 4.52, 4.57, 4.59, 4.58, 4.59,
        4.58, 4.57, 4.58, 4.56, 4.53, 4.55, 4.55, 4.54, 4.49, 4.51,
        4.50, 4.47, 4.47, 4.47, 4.48, 4.46, 4.46, 4.46, 4.49, 4.52,
        4.51, 4.51, 4.53, 4.53, 4.52, 4.51, 4.52, 4.52, 4.52, 4.52,
        4.55, 4.60, 4.63, 4.66, 4.66, 4.64, 4.67, 4.67, 4.66, 4.70,
        4.72, 4.72, 4.73, 4.73, 4.75, 4.74, 4.73, 4.73, 4.72, 4.73,
        4.74, 4.74, 4.75, 4.76, 4.76, 4.77, 4.78, 4.77, 4.78, 4.78,
        4.78, 4.78, 4.81, 4.81, 4.82, 4.83, 4.83, 4.82, 4.82, 4.82,
        4.82, 4.85, 4.85, 4.85, 4.84, 4.84, 4.87, 4.88, 4.89, 4.89,
        4.89, 4.92, 4.93, 4.93, 4.93, 4.95, 4.96, 4.95, 4.94, 4.96,
        4.95, 4.94, 4.94, 4.97, 4.97, 4.99, 4.98, 4.96, 4.98, 5.00,
        5.00, 5.00, 5.00, 5.01, 5.04, 5.05, 5.06, 5.05, 5.06, 5.06,
        5.04, 5.05, 5.05, 5.05, 5.06, 5.07, 5.08, 5.08, 5.08, 5.08,
        5.08, 5.08, 5.08, 5.09, 5.09, 5.10, 5.13, 5.15, 5.18, 5.18,
        5.16, 5.17, 5.16, 5.16, 5.17, 5.19, 5.21, 5.23, 5.24, 5.26,
        5.27, 5.27, 5.26, 5.28, 5.27, 5.29, 5.30, 5.31, 5.32, 5.32,
        5.31, 5.29, 5.30, 5.30, 5.30, 5.32, 5.34, 5.35, 5.36, 5.36,
        5.37, 5.40, 5.38, 5.38, 5.40, 5.38, 5.41, 5.41, 5.43, 5.44,
        5.45, 5.43, 5.45, 5.46, 5.45, 5.48, 5.48, 5.51, 5.51, 5.51,
        5.51, 5.51, 5.51, 5.51, 5.52, 5.51, 5.52, 5.53, 5.53, 5.54,
        5.54, 5.54, 5.54, 5.55, 5.55, 5.54, 5.55, 5.55, 5.55, 5.55,
        5.54, 5.54, 5.54, 5.57, 5.57, 5.60, 5.59, 5.62, 5.60, 5.62,
        5.65, 5.68, 5.67, 5.66, 5.66, 5.68, 5.69, 5.70, 5.70, 5.72,
        5.74, 5.74, 5.72, 5.74, 5.72, 5.73, 5.72, 5.74, 5.73, 5.75,
        5.76, 5.77, 5.78, 5.79, 5.78, 5.77, 5.78, 5.78, 5.78, 5.79,
        5.79, 5.81, 5.80, 5.82, 5.83, 5.86, 5.87, 5.88, 5.87, 5.85,
        5.85, 5.87, 5.87, 5.85, 5.85, 5.87, 5.87, 5.83, 5.84, 5.85,
        5.87, 5.88, 5.89, 5.92, 5.90, 5.90, 5.93, 5.93, 5.93, 5.92,
        5.92, 5.93, 5.93, 5.92, 5.94, 5.94, 5.96, 5.95, 5.98, 5.97,
        5.98, 5.98, 6.01, 5.98, 6.00, 6.01, 6.02, 6.01, 6.01, 6.01,
        6.01, 6.01, 6.01, 6.01, 6.03, 6.04, 6.04, 6.06, 6.06, 6.05,
        6.05, 6.03, 6.04, 6.03, 6.02, 6.01, 6.00, 6.01, 6.00, 6.01,
        6.03, 6.03, 6.06, 6.08, 6.07, 6.07, 6.08, 6.11, 6.11, 6.12,
        6.12, 6.14, 6.14, 6.15, 6.17, 6.18, 6.18, 6.18, 6.20, 6.20,
        6.19, 6.19, 6.22, 6.20, 6.20, 6.21, 6.22, 6.22, 6.23, 6.23,
        6.22, 6.22, 6.22, 6.23, 6.22, 6.21, 6.19, 6.21, 6.20, 6.22,
        6.23, 6.22, 6.25, 6.24, 6.23, 6.23, 6.22, 6.21, 6.23, 6.22,
        6.22, 6.22, 6.23, 6.23, 6.26, 6.26, 6.28, 6.31, 6.33, 6.33,
        6.32, 6.32, 6.29, 6.30, 6.32, 6.29, 6.28, 6.28, 6.29, 6.28,
        6.29, 6.30, 6.32, 6.31, 6.31, 6.31, 6.33, 6.35, 6.34, 6.37,
        6.36, 6.37, 6.35, 6.34, 6.34, 6.36, 6.37, 6.37, 6.40, 6.39,
        6.40, 6.39, 6.42, 6.40, 6.40, 6.41, 6.42, 6.40, 6.43, 6.41,
        6.40, 6.41, 6.44, 6.45, 6.45, 6.45, 6.46, 6.47, 6.49, 6.50,
        6.51, 6.50, 6.49, 6.47, 6.47, 6.47, 6.48, 6.47, 6.48, 6.49,
        6.50, 6.51, 6.50, 6.48, 6.48, 6.49, 6.47, 6.46, 6.47, 6.47,
        6.46, 6.47, 6.47, 6.47, 6.50, 6.52, 6.55, 6.56, 6.58, 6.57,
        6.58, 6.59, 6.59, 6.58, 6.60, 6.59, 6.61, 6.60, 6.61, 6.60,
        6.59, 6.59, 6.59, 6.59, 6.59, 6.58, 6.56, 6.56, 6.56, 6.56,
        6.54, 6.56, 6.56, 6.58, 6.58, 6.57, 6.59, 6.61, 6.62, 6.60,
        6.62, 6.61, 6.62, 6.62, 6.63, 6.64, 6.64, 6.62, 6.60, 6.62,
        6.61, 6.64, 6.64, 6.64, 6.65, 6.65, 6.62, 6.61, 6.61, 6.62,
        6.64, 6.64, 6.64, 6.64, 6.62, 6.61, 6.61, 6.64, 6.64, 6.65,
        6.64, 6.67, 6.67, 6.69, 6.68, 6.69, 6.69, 6.70, 6.71, 6.70,
        6.72, 6.72, 6.72, 6.72, 6.72, 6.72, 6.71, 6.70, 6.69, 6.69,
        6.69, 6.69, 6.69, 6.70, 6.72, 6.72, 6.72, 6.72, 6.72, 6.72,
        6.72, 6.72, 6.72, 6.72, 6.72, 6.74, 6.77, 6.77, 6.78, 6.79,
        6.79, 6.78, 6.75, 6.74, 6.75, 6.75, 6.78, 6.80, 6.80, 6.80,
        6.80, 6.80, 6.80, 6.80, 6.80, 6.80, 6.80, 6.82, 6.83, 6.86,
        6.84, 6.84, 6.83, 6.82, 6.81, 6.81, 6.81, 6.80, 6.80, 6.80,
        6.80, 6.80, 6.80, 6.80, 6.80, 6.80, 6.81, 6.82, 6.85, 6.86,
        6.86, 6.86, 6.86, 6.86, 6.86, 6.86, 6.86, 6.86, 6.86, 6.86,
        6.86, 6.86, 6.86, 6.85, 6.85, 6.86, 6.86, 6.86, 6.86, 6.86,
        6.86, 6.86, 6.86, 6.86, 6.86, 6.86, 6.89, 6.89, 6.92, 6.92,
        6.92, 6.92, 6.92, 6.92, 6.92, 6.92, 6.92, 6.94, 6.94, 6.94,
        6.94, 6.92, 6.92, 6.92, 6.92, 6.92, 6.92, 6.92, 6.93, 6.95,
        6.95, 6.95, 6.96, 6.96, 6.96, 6.96, 6.96, 6.97, 6.97, 6.98,
        6.98, 6.99, 6.99, 6.99, 6.99, 6.99, 6.99, 6.99, 6.97, 6.97,
        6.98, 6.98, 6.97, 6.96, 6.96, 6.97, 6.97, 6.96, 6.95, 6.95,
        6.94, 6.94, 6.93, 6.92, 6.91, 6.94, 6.97, 6.99, 6.99, 6.99,
        7.02, 7.02, 7.05, 7.03, 7.02, 7.02, 7.02, 7.00, 6.99, 6.99,
        6.99, 7.00, 7.02, 7.04, 7.05, 7.05, 7.03, 7.02, 7.00, 7.00,
        7.02, 7.03, 7.02, 7.03, 7.03, 7.02, 7.03, 7.02, 7.01, 7.02,
        7.01, 7.00, 7.02, 7.00, 7.00, 7.02, 7.02, 7.03, 7.03, 7.04,
        7.06, 7.05, 7.06, 7.07, 7.06, 7.05, 7.03, 7.03, 7.02, 7.00,
        7.02, 7.03, 7.03, 7.02, 7.02, 7.02, 7.03, 7.04, 7.05, 7.04,
        7.05, 7.06, 7.05, 7.05, 7.06, 7.05, 7.05, 7.03, 7.02, 7.04,
        7.04, 7.05, 7.05, 7.05, 7.04, 7.05, 7.03, 7.06, 7.04, 7.05,
        7.05, 7.05, 7.05, 7.03, 7.03, 7.02, 7.03, 7.04, 7.05, 7.07,
        7.06, 7.06, 7.07, 7.06, 7.06, 7.06, 7.04, 7.06, 7.05, 7.04,
        7.03, 7.03, 7.00, 7.00, 7.00, 6.99, 7.00, 6.99, 7.00, 7.00,
        7.02, 7.00, 7.00, 7.00, 7.00, 7.00, 7.02, 7.00, 7.01, 6.99,
        7.00, 7.00, 7.00, 7.00, 7.00, 6.99, 7.00, 7.03, 7.02, 7.02,
        7.03, 7.01, 7.00, 7.00, 7.01, 7.03, 7.03, 7.03, 7.05, 7.05,
        7.03, 7.03, 7.03, 7.02, 7.00, 7.00, 6.99, 6.99, 6.99, 7.00,
        7.00, 6.99, 6.99, 6.99, 6.99, 6.99, 6.99, 6.97, 6.94, 6.92,
        6.92, 6.92, 6.92, 6.94, 6.97, 6.98, 6.97, 6.97, 6.97, 6.96,
        6.95, 6.95, 6.92, 6.92, 6.89, 6.89, 6.89, 6.89, 6.90, 6.90,
        6.91, 6.91, 6.92, 6.92, 6.91, 6.92, 6.91, 6.92, 6.92, 6.92,
        6.92, 6.92, 6.92, 6.92, 6.92, 6.91, 6.91, 6.88, 6.86, 6.86,
        6.86, 6.86, 6.86, 6.88, 6.91, 6.91, 6.88, 6.86, 6.86, 6.86,
        6.86, 6.87, 6.86, 6.84, 6.83, 6.82, 6.84, 6.84, 6.83, 6.83,
        6.82, 6.81, 6.80, 6.80, 6.79, 6.78, 6.81, 6.80, 6.81, 6.81,
        6.80, 6.80, 6.80, 6.81, 6.79, 6.80, 6.78, 6.78, 6.78, 6.79,
        6.77, 6.78, 6.75, 6.75, 6.73, 6.72, 6.73, 6.71, 6.72, 6.70,
        6.68, 6.69, 6.72, 6.70, 6.68, 6.67, 6.66, 6.65, 6.64, 6.63,
        6.62, 6.64, 6.61, 6.61, 6.59, 6.60, 6.59, 6.61, 6.64, 6.63,
        6.63, 6.64, 6.64, 6.64, 6.65, 6.63, 6.62, 6.61, 6.62, 6.61,
        6.62, 6.61, 6.61, 6.60, 6.61, 6.59, 6.58, 6.59, 6.60, 6.61,
        6.61, 6.62, 6.60, 6.61, 6.61, 6.59, 6.60, 6.61, 6.58, 6.57,
        6.53, 6.52, 6.51, 6.51, 6.50, 6.49, 6.49, 6.47, 6.50, 6.47,
        6.47, 6.48, 6.48, 6.51, 6.50, 6.53, 6.54, 6.53, 6.51, 6.51,
        6.50, 6.48, 6.49, 6.49, 6.50, 6.48, 6.51, 6.51, 6.52, 6.52,
        6.54, 6.53, 6.53, 6.51, 6.50, 6.50, 6.49, 6.49, 6.50, 6.48,
        6.47, 6.47, 6.47, 6.48, 6.48, 6.47, 6.48, 6.47, 6.45, 6.44,
        6.42, 6.42, 6.42, 6.42, 6.41, 6.42, 6.41, 6.43, 6.43, 6.43,
        6.44, 6.43, 6.44, 6.43, 6.41, 6.42, 6.45, 6.43, 6.42, 6.43,
        6.44, 6.43, 6.43, 6.44, 6.47, 6.45, 6.45, 6.42, 6.42, 6.42,
        6.42, 6.44, 6.47, 6.47, 6.48, 6.47, 6.48, 6.47, 6.47, 6.45,
        6.45, 6.45, 6.47, 6.47, 6.48, 6.46, 6.48, 6.49, 6.49, 6.49,
        6.51, 6.52, 6.49, 6.48, 6.46, 6.45, 6.45, 6.45, 6.45, 6.45,
        6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.46,
        6.46, 6.47, 6.47, 6.47, 6.47, 6.47, 6.45, 6.45, 6.45, 6.45,
        6.47, 6.47, 6.50, 6.51, 6.51, 6.51, 6.51, 6.51, 6.51, 6.51,
        6.51, 6.53, 6.54, 6.54, 6.53, 6.56, 6.56, 6.58, 6.59, 6.61,
        6.62, 6.61, 6.59, 6.61, 6.59, 6.60, 6.58, 6.58, 6.56, 6.59,
        6.59, 6.59, 6.60, 6.63, 6.62, 6.62, 6.62, 6.64, 6.64, 6.64,
        6.63, 6.64, 6.65, 6.62, 6.62, 6.64, 6.64, 6.62, 6.63, 6.63,
        6.63, 6.65, 6.66, 6.66, 6.67, 6.66, 6.68, 6.70, 6.69, 6.67,
        6.74, 6.75, 6.73, 6.73, 6.74, 6.76, 6.70, 6.70, 6.69, 6.70,
        6.71, 6.71, 6.73, 6.72, 6.73, 6.76, 6.74, 6.74, 6.72, 6.75,
        6.80, 6.78, 6.77, 6.75, 6.78, 6.83, 6.81, 6.80, 6.80, 6.85,
        6.84, 6.84, 6.84, 6.83, 6.79, 6.81, 6.78, 6.78, 6.79, 6.79,
        6.78, 6.79, 6.80, 6.79, 6.80, 6.80, 6.79, 6.79, 6.80, 6.81,
        6.80, 6.78, 6.82, 6.84, 6.82, 6.81, 6.83, 6.84, 6.82, 6.81,
        6.81, 6.79, 6.80, 6.80, 6.80, 6.79, 6.77, 6.78, 6.79, 6.78,
        6.77, 6.77, 6.78, 6.81, 6.83, 6.83, 6.82, 6.83, 6.83, 6.85,
        6.86, 6.87, 6.88, 6.89, 6.91, 6.91, 6.90, 6.91, 6.90, 6.91,
        6.92, 6.89, 6.89, 6.88, 6.88, 6.87, 6.86, 6.87, 6.87, 6.85,
        6.83, 6.83, 6.81, 6.81, 6.83, 6.84, 6.86, 6.86, 6.84, 6.84,
        6.84, 6.84, 6.84, 6.83, 6.83, 6.82, 6.81, 6.82, 6.83, 6.82,
        6.81, 6.81, 6.81, 6.81, 6.81, 6.83, 6.84, 6.83, 6.86, 6.88,
        6.89, 6.89, 6.89, 6.91, 6.91, 6.90, 6.88, 6.88, 6.89, 6.89,
        6.87, 6.89, 6.90, 6.89, 6.93, 6.95, 6.96, 6.97, 6.97, 6.99,
        7.01, 7.01, 7.02, 7.00, 7.00, 7.00, 6.99, 7.00, 7.00, 7.01,
        7.01, 7.03, 7.05, 7.04, 7.04, 7.05, 7.06, 7.06, 7.05, 7.08,
        7.08, 7.08, 7.08, 7.08, 7.13, 7.13, 7.12, 7.13, 7.15, 7.16,
        7.17, 7.16, 7.15, 7.16, 7.18, 7.22, 7.24, 7.26, 7.29, 7.32,
        7.35, 7.34, 7.31, 7.30, 7.31, 7.32, 7.28, 7.29, 7.30, 7.32,
        7.29, 7.30, 7.29, 7.31, 7.30, 7.30, 7.27, 7.26, 7.25, 7.28,
        7.30, 7.29, 7.29, 7.30, 7.29, 7.29, 7.27, 7.24, 7.26, 7.24,
        7.22, 7.19, 7.19, 7.13, 7.13, 7.10, 7.10, 6.97, 6.97, 6.98,
        6.98, 6.93, 6.91, 6.85, 6.85, 6.84, 6.80, 6.79
    };

    static const float * const robinson_dadson_curves[] =
    {
        robinson_dadson_curve_0_phons,
        robinson_dadson_curve_10_phons,
        robinson_dadson_curve_20_phons,
        robinson_dadson_curve_30_phons,
        robinson_dadson_curve_40_phons,
        robinson_dadson_curve_50_phons,
        robinson_dadson_curve_60_phons,
        robinson_dadson_curve_70_phons,
        robinson_dadson_curve_80_phons,
        robinson_dadson_curve_90_phons
    };

    static const freq_curve_t robinson_dadson_curve =
    {
        19.96, // fmin
        15087.35, // fmax
        0.00, // amin
        90.00, // amax
        1468, // hdots
        10, // curves
        robinson_dadson_curves // curve data
    };
}

#endif /* GENERATED_ISO226_ROBINSON_DADSON_H_ */

