/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.formatter;

import de.unkrig.commons.lang.PrettyPrinter;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class PrettyPrintFormatter
extends Formatter {
    private final Formatter delegate;

    public PrettyPrintFormatter() throws ParseException, EvaluationException {
        String propertyNamePrefix = this.getClass().getName();
        this.delegate = LogUtil.requireLoggingProperty(propertyNamePrefix + ".delegate", Formatter.class);
    }

    public PrettyPrintFormatter(Formatter delegate) {
        this.delegate = delegate;
    }

    @Override
    public String format(@Nullable LogRecord record) {
        if (record == null) {
            return "null";
        }
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return this.delegate.format(record);
        }
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = PrettyPrinter.toString(parameters[i]);
        }
        record.setParameters(parameters);
        return this.delegate.format(record);
    }
}

