/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.servlett;

import de.unkrig.commons.io.FixedLengthInputStream;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.net.http.HttpMessage;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.servlett.AbstractServlett;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FileServlett
extends AbstractServlett {
    private static final Logger LOGGER = Logger.getLogger(FileServlett.class.getName());
    private static final int LENGTH_LIMIT = 40;
    private static final Map<String, String> EXTENSION_TO_CONTENT_TYPE = new HashMap<String, String>();
    private static final Pattern RANGES_SPECIFIER;

    protected abstract File getFile(HttpRequest var1);

    @Override
    public HttpResponse get(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        String path;
        Matcher m;
        File file = this.getFile(httpRequest);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap(file.toString(), ioe);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Accessing file '" + file + "'");
        }
        long from = 0L;
        long to = Long.MAX_VALUE;
        String s = httpRequest.getHeader("Range");
        if (s != null && (m = RANGES_SPECIFIER.matcher(s)).matches()) {
            if (m.group(1) != null) {
                from = Long.parseLong(m.group(1));
            }
            if (m.group(2) != null) {
                to = Long.parseLong(m.group(2) + 1);
            }
        }
        if ((path = httpRequest.getUri().getPath()).endsWith("/") && file.isDirectory()) {
            File indexFile = new File(file, "index.html");
            if (indexFile.isFile()) {
                return FileServlett.processFileRequest(indexFile, from, to);
            }
            return FileServlett.processDirectoryListing(file);
        }
        if (file.isFile()) {
            HttpResponse rsp = FileServlett.processFileRequest(file, from, to);
            return rsp;
        }
        if (file.isDirectory()) {
            return HttpResponse.redirect(path + "/");
        }
        return HttpResponse.response(HttpResponse.Status.NOT_FOUND, "Sorry - resource '" + path + "' does not exist on this server.");
    }

    @Override
    protected HttpResponse head(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        HttpResponse httpResponse = this.get(httpRequest, sendProvisionalResponse);
        httpResponse.setBody(HttpMessage.NO_BODY);
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse put(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        File file = this.getFile(httpRequest);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap(file.toString(), ioe);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Accessing file '" + file + "'");
        }
        if (file.isFile() || !file.exists()) {
            FileOutputStream os = new FileOutputStream(file);
            try {
                httpRequest.removeBody().write(os);
                ((OutputStream)os).close();
            }
            finally {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
            return HttpResponse.response(HttpResponse.Status.OK);
        }
        return HttpResponse.response(HttpResponse.Status.NOT_FOUND, "Sorry - resource '" + httpRequest.getUri().getPath() + "' does not exist on this server.");
    }

    static HttpResponse processDirectoryListing(final File directory) {
        HttpResponse response = HttpResponse.response(HttpResponse.Status.OK, HttpMessage.body(new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream stream) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(stream);
                w.write("<html>\r\n  <head>\r\n    <title>Directory Listing</title>\r\n  </head>\r\n  <body>\r\n  <h2>Directory listing of '" + directory.toString() + "'</h2>\r\n  <pre><a href=\"../\">../</a>");
                for (File f : directory.listFiles()) {
                    String title;
                    String displayName;
                    String name = f.getName();
                    if (name.length() > 40) {
                        displayName = name.substring(0, 37) + "...";
                        title = name;
                    } else {
                        displayName = name;
                        title = null;
                    }
                    if (f.isDirectory()) {
                        name = name + '/';
                    }
                    new Formatter(w).format("\r\n<a href=\"" + name + "\"" + (title == null ? "" : " title=\"" + title + "\"") + ">%-" + 44 + "s %s", displayName + "</a>", new Date(f.lastModified()));
                }
                w.write("</pre>\r\n  </body>\r\n</html>\r\n");
                ((Writer)w).flush();
            }
        }));
        response.setHeader("Content-Type", "text/html");
        response.setHeader("Transfer-Encoding", "chunked");
        return response;
    }

    static HttpResponse processFileRequest(File file, long from, long to) throws IOException {
        long fileLength;
        String name = file.getName();
        int idx = name.lastIndexOf(47) + 1;
        String extension = (idx = name.indexOf(46, idx)) == -1 ? "" : name.substring(idx + 1);
        String contentType = EXTENSION_TO_CONTENT_TYPE.get(extension);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (to > (fileLength = file.length())) {
            to = fileLength;
        }
        if (from > to) {
            from = to;
        }
        long contentLength = to - from;
        FileInputStream is = new FileInputStream(file);
        if (InputStreams.skip(is, from) != from) {
            throw new IOException("Cannot skip " + from + " bytes of \"" + file + "\"");
        }
        HttpResponse httpResponse = HttpResponse.response(HttpResponse.Status.OK, new FixedLengthInputStream(is, contentLength));
        httpResponse.addHeader("Content-Length", contentLength);
        if (contentLength != fileLength) {
            httpResponse.addHeader("Content-Range", from + "-" + (to - 1L) + "/" + fileLength);
        }
        httpResponse.addHeader("Last-Modified", new Date(file.lastModified()));
        httpResponse.addHeader("Content-Type", contentType);
        return httpResponse;
    }

    static {
        EXTENSION_TO_CONTENT_TYPE.put("gif", "image/gif");
        EXTENSION_TO_CONTENT_TYPE.put("jpg", "image/jpeg");
        EXTENSION_TO_CONTENT_TYPE.put("jpeg", "image/jpeg");
        EXTENSION_TO_CONTENT_TYPE.put("css", "text/css");
        EXTENSION_TO_CONTENT_TYPE.put("html", "text/html");
        EXTENSION_TO_CONTENT_TYPE.put("java", "text/plain");
        EXTENSION_TO_CONTENT_TYPE.put("txt", "text/plain");
        EXTENSION_TO_CONTENT_TYPE.put("classpath", "text/xml");
        EXTENSION_TO_CONTENT_TYPE.put("launch", "text/xml");
        EXTENSION_TO_CONTENT_TYPE.put("project", "text/xml");
        EXTENSION_TO_CONTENT_TYPE.put("xml", "text/xml");
        RANGES_SPECIFIER = Pattern.compile("bytes=(\\d+)?-(\\d+)?");
    }
}

