/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.io.FileBufferedChannel;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.Multiplexer;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.InvalidHttpMessageException;
import de.unkrig.commons.net.http.servlett.Servlett;
import de.unkrig.commons.util.collections.IterableUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpClientConnectionHandler
implements TcpServer.ConnectionHandler,
Stoppable {
    private static final Logger LOGGER = Logger.getLogger(HttpClientConnectionHandler.class.getName());
    private Iterable<Servlett> servletts;
    private final Collection<Stoppable> stoppables = Collections.synchronizedCollection(new HashSet());
    private final String readRequestLogginPrefix;
    private final String writeResponseLoggingPrefix;

    public HttpClientConnectionHandler() {
        this(">>> ", "<<< ");
    }

    public HttpClientConnectionHandler(String readRequestLogginPrefix, String writeResponseLoggingPrefix) {
        this(Collections.emptyList(), readRequestLogginPrefix, writeResponseLoggingPrefix);
    }

    public HttpClientConnectionHandler(Servlett servlett) {
        this(servlett, ">>> ", "<<< ");
    }

    public HttpClientConnectionHandler(Servlett servlett, String readRequestLogginPrefix, String writeResponseLoggingPrefix) {
        this(Collections.singletonList(servlett), readRequestLogginPrefix, writeResponseLoggingPrefix);
    }

    public HttpClientConnectionHandler(Iterable<Servlett> servletts) {
        this(servletts, ">>> ", "<<< ");
    }

    public HttpClientConnectionHandler(Iterable<Servlett> servletts, String readRequestLogginPrefix, String writeResponseLoggingPrefix) {
        this.servletts = servletts;
        this.readRequestLogginPrefix = readRequestLogginPrefix;
        this.writeResponseLoggingPrefix = writeResponseLoggingPrefix;
    }

    public Iterable<Servlett> getServletts() {
        return IterableUtil.unmodifiableIterable(this.servletts);
    }

    public void setServlett(Servlett servlett) {
        this.servletts = Collections.singletonList(servlett);
    }

    public void setServletts(Iterable<Servlett> servletts) {
        this.servletts = servletts;
    }

    @Override
    public void handleConnection(InputStream in, OutputStream out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Stoppable stoppable) throws IOException, InvalidHttpMessageException {
        this.processRequests(in, out, stoppable);
    }

    public void handleConnection(ReadableByteChannel in, WritableByteChannel out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Multiplexer multiplexer, Stoppable stoppable) throws IOException {
        this.processRequests(in, out, multiplexer, stoppable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequests(InputStream in, OutputStream out, Stoppable stoppable) throws IOException, InvalidHttpMessageException {
        try {
            HttpResponse httpResponse;
            long t2;
            HttpRequest request;
            long t1;
            ConsumerUtil.Produmer responseSize;
            ConsumerUtil.Produmer requestSize;
            block15: {
                requestSize = null;
                responseSize = null;
                if (LOGGER.isLoggable(Level.FINE)) {
                    requestSize = ConsumerUtil.store();
                    responseSize = ConsumerUtil.store();
                    out = OutputStreams.tee(out, OutputStreams.lengthWritten(ConsumerUtil.cumulate(responseSize, 0L)));
                    in = InputStreams.wye(in, OutputStreams.lengthWritten(ConsumerUtil.cumulate(requestSize, 0L)));
                }
                this.stoppables.add(stoppable);
                LOGGER.fine(this.readRequestLogginPrefix + "Reading request from client");
                t1 = System.currentTimeMillis();
                request = HttpRequest.read(in, this.readRequestLogginPrefix);
                t2 = System.currentTimeMillis();
                for (Servlett servlett : this.servletts) {
                    boolean[] hadProvisionalResponses;
                    OutputStream finalOut;
                    httpResponse = servlett.handleRequest(request, new ConsumerWhichThrows<HttpResponse, IOException>(finalOut = out, hadProvisionalResponses = new boolean[1]){
                        final /* synthetic */ OutputStream val$finalOut;
                        final /* synthetic */ boolean[] val$hadProvisionalResponses;
                        {
                            this.val$finalOut = outputStream;
                            this.val$hadProvisionalResponses = blArray;
                        }

                        @Override
                        public void consume(HttpResponse provisionalResponse) throws IOException {
                            assert (provisionalResponse.isProvisional());
                            provisionalResponse.write(this.val$finalOut, HttpClientConnectionHandler.this.writeResponseLoggingPrefix);
                            this.val$hadProvisionalResponses[0] = true;
                        }
                    });
                    if (httpResponse == null) {
                        assert (!hadProvisionalResponses[0]) : "Servlett \"" + servlett + "\" sent provisional responses, but returned NULL";
                        continue;
                    }
                    break block15;
                }
                httpResponse = HttpResponse.response(HttpResponse.Status.INTERNAL_SERVER_ERROR, "None of " + this.servletts + " handled the request");
            }
            assert (httpResponse != null);
            LOGGER.fine(this.writeResponseLoggingPrefix + "Sending response to client");
            long t3 = System.currentTimeMillis();
            httpResponse.write(out, this.writeResponseLoggingPrefix);
            long t4 = System.currentTimeMillis();
            request.removeBody().dispose();
            if (requestSize != null && responseSize != null) {
                LOGGER.fine((Object)((Object)request.getMethod()) + " " + request.getUri() + " (" + requestSize.produce() + " bytes) => " + (Object)((Object)httpResponse.getStatus()) + " (" + responseSize.produce() + " bytes) completely processed; took " + NumberFormat.getNumberInstance(Locale.US).format(t3 - t2) + "/" + NumberFormat.getNumberInstance(Locale.US).format(t4 - t1) + " ms");
            }
        }
        finally {
            this.stoppables.remove(stoppable);
            if (this.stoppables.isEmpty()) {
                for (Servlett servlett : this.servletts) {
                    try {
                        servlett.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void processRequests(ReadableByteChannel in, WritableByteChannel out, Multiplexer multiplexer, Stoppable stoppable) throws IOException {
        this.stoppables.add(stoppable);
        final FileBufferedChannel fbc = new FileBufferedChannel(multiplexer, (SelectableChannel)((Object)out));
        ConsumerWhichThrows<HttpRequest, IOException> requestConsumer = new ConsumerWhichThrows<HttpRequest, IOException>(){

            @Override
            public void consume(HttpRequest request) throws IOException {
                HttpResponse response;
                block4: {
                    for (Servlett servlett : HttpClientConnectionHandler.this.servletts) {
                        boolean[] hadProvisionalResponses;
                        response = servlett.handleRequest(request, new ConsumerWhichThrows<HttpResponse, IOException>(hadProvisionalResponses = new boolean[1]){
                            final /* synthetic */ boolean[] val$hadProvisionalResponses;
                            {
                                this.val$hadProvisionalResponses = blArray;
                            }

                            @Override
                            public void consume(HttpResponse provisionalResponse) throws IOException {
                                assert (provisionalResponse.isProvisional());
                                provisionalResponse.write(Channels.newOutputStream(fbc), HttpClientConnectionHandler.this.writeResponseLoggingPrefix);
                                this.val$hadProvisionalResponses[0] = true;
                            }
                        });
                        if (response == null) {
                            assert (!hadProvisionalResponses[0]) : "Servlett \"" + servlett + "\" sent provisional responses, but returned NULL";
                            continue;
                        }
                        break block4;
                    }
                    response = HttpResponse.response(HttpResponse.Status.INTERNAL_SERVER_ERROR, "None of " + HttpClientConnectionHandler.this.servletts + " handled the request");
                }
                request.removeBody().dispose();
                LOGGER.fine(HttpClientConnectionHandler.this.writeResponseLoggingPrefix + "Sending response to client");
                assert (response != null);
                response.write(Channels.newOutputStream(fbc), HttpClientConnectionHandler.this.writeResponseLoggingPrefix);
            }
        };
        HttpRequest.read(in, multiplexer, requestConsumer, this.readRequestLogginPrefix);
    }

    @Override
    public void stop() {
        for (Stoppable stoppable : this.stoppables) {
            stoppable.stop();
        }
    }
}

