/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.crypto;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.crypto.Cryptor;
import de.unkrig.commons.lang.crypto.Decryptor;
import de.unkrig.commons.lang.crypto.Decryptors;
import de.unkrig.commons.lang.crypto.Encryptor;
import de.unkrig.commons.lang.crypto.Encryptors;
import de.unkrig.commons.lang.crypto.WrongKeyException;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;

public final class Cryptors {
    private Cryptors() {
    }

    public static Cryptor fromSecretKey(SecretKey secretKey) {
        return Cryptors.from(Encryptors.fromKey(secretKey), Decryptors.fromKey(secretKey));
    }

    public static Cryptor from(final Encryptor encryptor, final Decryptor decryptor) {
        return new Cryptor(){

            @Override
            public byte[] encrypt(byte[] unencrypted) {
                return encryptor.encrypt(unencrypted);
            }

            @Override
            public byte[] decrypt(byte[] encrypted) throws WrongKeyException {
                return decryptor.decrypt(encrypted);
            }

            @Override
            public void destroy() throws DestroyFailedException {
                encryptor.destroy();
                decryptor.destroy();
            }

            @Override
            public boolean isDestroyed() {
                return encryptor.isDestroyed() && decryptor.isDestroyed();
            }
        };
    }

    public static Cryptor addChecksum(Cryptor delegate) {
        return Cryptors.from(Encryptors.addChecksum(delegate), Decryptors.addChecksum(delegate));
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

