/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConstructorUtilsTest
extends AbstractLangTest {
    private final Map<Class<?>, Class<?>[]> classCache = new HashMap();

    private void expectMatchingAccessibleConstructorParameterTypes(Class<?> cls, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Constructor c = ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])requestTypes);
        Assertions.assertArrayEquals((Object[])actualTypes, (Object[])c.getParameterTypes(), (String)(this.toString(c.getParameterTypes()) + " not equals " + this.toString(actualTypes)));
    }

    @BeforeEach
    public void setUp() {
        this.classCache.clear();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    @Test
    public void testConstructor() throws Exception {
        Assertions.assertNotNull(MethodUtils.class.getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    @Test
    public void testGetAccessibleConstructor() throws Exception {
        Assertions.assertNotNull((Object)ConstructorUtils.getAccessibleConstructor(Object.class.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY)));
        Assertions.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.class.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY)));
        Assertions.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.PublicInnerClass.class, (Class[])new Class[0]));
    }

    @Test
    public void testGetAccessibleConstructorFromDescription() {
        Assertions.assertNotNull((Object)ConstructorUtils.getAccessibleConstructor(Object.class, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.class, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    @Test
    public void testGetMatchingAccessibleMethod() {
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Long.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Long.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, new Class[]{SubClass.class, String[].class}, new Class[]{BaseClass.class, String[].class});
    }

    @Test
    public void testInvokeConstructor() throws Exception {
        Assertions.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])ArrayUtils.EMPTY_CLASS_ARRAY)).toString());
        Assertions.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])null)).toString());
        Assertions.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[0])).toString());
        Assertions.assertEquals((Object)"(String)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{""})).toString());
        Assertions.assertEquals((Object)"(Object)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{new Object()})).toString());
        Assertions.assertEquals((Object)"(Object)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{Boolean.TRUE})).toString());
        Assertions.assertEquals((Object)"(Integer)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).toString());
        Assertions.assertEquals((Object)"(int)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.BYTE_ONE})).toString());
        Assertions.assertEquals((Object)"(double)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.LONG_ONE})).toString());
        Assertions.assertEquals((Object)"(double)", (Object)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.DOUBLE_ONE})).toString());
        ((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).verify("(Integer)", null);
        ((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{"a", "b"})).verify("(String...)", new String[]{"a", "b"});
        ((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE, "a", "b"})).verify("(Integer, String...)", new String[]{"a", "b"});
        ((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{new SubClass(), new String[]{"a", "b"}})).verify("(BaseClass, String...)", new String[]{"a", "b"});
    }

    @Test
    public void testInvokeExactConstructor() throws Exception {
        Assertions.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])ArrayUtils.EMPTY_CLASS_ARRAY)).toString());
        Assertions.assertEquals((Object)"()", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])null)).toString());
        Assertions.assertEquals((Object)"(String)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{""})).toString());
        Assertions.assertEquals((Object)"(Object)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{new Object()})).toString());
        Assertions.assertEquals((Object)"(Integer)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).toString());
        Assertions.assertEquals((Object)"(double)", (Object)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE})).toString());
        Assertions.assertThrows(NoSuchMethodException.class, () -> ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.LONG_ONE}));
        Assertions.assertThrows(NoSuchMethodException.class, () -> ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{Boolean.TRUE}));
    }

    @Test
    public void testNullArgument() {
        this.expectMatchingAccessibleConstructorParameterTypes(MutableObject.class, this.singletonArray(null), this.singletonArray(Object.class));
    }

    @Test
    public void testVarArgsUnboxing() throws Exception {
        TestBean testBean = (TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{1, 2, 3});
        Assertions.assertArrayEquals((Object[])new String[]{"2", "3"}, (Object[])testBean.varArgs);
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    static class PrivateClass {

        public static class PublicInnerClass {
        }
    }

    public static class TestBean {
        private final String toString;
        final String[] varArgs;

        public TestBean() {
            this.toString = "()";
            this.varArgs = null;
        }

        public TestBean(BaseClass bc, String ... s) {
            this.toString = "(BaseClass, String...)";
            this.varArgs = s;
        }

        public TestBean(double d) {
            this.toString = "(double)";
            this.varArgs = null;
        }

        public TestBean(int i) {
            this.toString = "(int)";
            this.varArgs = null;
        }

        public TestBean(Integer i) {
            this.toString = "(Integer)";
            this.varArgs = null;
        }

        public TestBean(Integer first, int ... args) {
            this.toString = "(Integer, String...)";
            this.varArgs = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.varArgs[i] = Integer.toString(args[i]);
            }
        }

        public TestBean(Integer i, String ... s) {
            this.toString = "(Integer, String...)";
            this.varArgs = s;
        }

        public TestBean(Object o) {
            this.toString = "(Object)";
            this.varArgs = null;
        }

        public TestBean(String s) {
            this.toString = "(String)";
            this.varArgs = null;
        }

        public TestBean(String ... s) {
            this.toString = "(String...)";
            this.varArgs = s;
        }

        public String toString() {
            return this.toString;
        }

        void verify(String str, String[] args) {
            Assertions.assertEquals((Object)str, (Object)this.toString);
            Assertions.assertArrayEquals((Object[])args, (Object[])this.varArgs);
        }
    }

    private static final class SubClass
    extends BaseClass {
        private SubClass() {
        }
    }

    private static class BaseClass {
        private BaseClass() {
        }
    }
}

