/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PreReadRequestControl
extends Control {
    @NotNull
    public static final String PRE_READ_REQUEST_OID = "1.3.6.1.1.13.1";
    @NotNull
    private static final String[] NO_ATTRIBUTES = StaticUtils.NO_STRINGS;
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTES = "attributes";
    private static final long serialVersionUID = 1205235290978028739L;
    @NotNull
    private final String[] attributes;

    public PreReadRequestControl(String ... attributes) {
        this(true, attributes);
    }

    public PreReadRequestControl(boolean isCritical, String ... attributes) {
        super(PRE_READ_REQUEST_OID, isCritical, PreReadRequestControl.encodeValue(attributes));
        this.attributes = attributes == null ? NO_ATTRIBUTES : attributes;
    }

    public PreReadRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.attributes = new String[attrElements.length];
            for (int i = 0; i < attrElements.length; ++i) {
                this.attributes[i] = ASN1OctetString.decodeAsOctetString(attrElements[i]).stringValue();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable String[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return new ASN1OctetString(new ASN1Sequence().encode());
        }
        ASN1Element[] elements = new ASN1OctetString[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            elements[i] = new ASN1OctetString(attributes[i]);
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PRE_READ_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (this.attributes != null && this.attributes.length > 0) {
            ArrayList<JSONString> attrValues = new ArrayList<JSONString>(this.attributes.length);
            for (String attribute : this.attributes) {
                attrValues.add(new JSONString(attribute));
            }
            valueFields.put(JSON_FIELD_ATTRIBUTES, new JSONArray(attrValues));
        }
        return new JSONObject(new JSONField("oid", PRE_READ_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PRE_READ_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static PreReadRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        String[] attributes;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new PreReadRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> attributesValues = valueObject.getFieldAsArray(JSON_FIELD_ATTRIBUTES);
        if (attributesValues == null) {
            attributes = null;
        } else {
            attributes = new String[attributesValues.size()];
            for (int i = 0; i < attributes.length; ++i) {
                JSONValue v = attributesValues.get(i);
                if (!(v instanceof JSONString)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_REQUEST_JSON_ATTR_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ATTRIBUTES));
                }
                attributes[i] = ((JSONString)v).stringValue();
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_ATTRIBUTES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PRE_READ_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new PreReadRequestControl(jsonControl.getCriticality(), attributes);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PreReadRequestControl(attributes={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\'');
            buffer.append(this.attributes[i]);
            buffer.append('\'');
        }
        buffer.append("}, isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

