/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.Database;

public class Table
extends DBElement {
    protected List columns = new Vector();
    private Map indexMap = new Hashtable();

    public Table() {
    }

    public Table(String sName) {
        super(sName);
    }

    public Table(String sName, Object objModel, Properties properties) {
        super(sName, objModel, properties);
    }

    public String getStereostring() {
        return Table.getStereotype();
    }

    public Column[] getColumns() {
        return this.columns.toArray(new Column[0]);
    }

    public Vector getColumnsVector() {
        return new Vector(this.columns);
    }

    public void addColumn(Column column) {
        if (this.hasOwningDatabase()) {
            column.setOwningDatabase(this.getOwningDatabase());
        }
        this.columns.add(column);
    }

    public void setColumns(Column[] cols) {
        this.columns.clear();
        this.columns.addAll(Arrays.asList(cols));
        for (Column col : this.columns) {
            col.setTable(this);
        }
    }

    public Column getColumn(String name) {
        Column col2 = null;
        boolean found = false;
        if (name != null) {
            for (Column col2 : this.columns) {
                if (!name.equals(col2.getName())) continue;
                found = true;
                break;
            }
        }
        return found ? col2 : null;
    }

    public void recordIndex(Column col) {
        String[] indexes = col.getIndexNames();
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == null) continue;
            HashSet<Column> set = (HashSet<Column>)this.indexMap.get(indexes[i]);
            if (set == null) {
                set = new HashSet<Column>();
                set.add(col);
                this.indexMap.put(indexes[i], set);
                continue;
            }
            set.add(col);
        }
    }

    public void markUniqueColumns() {
        for (Set set : this.indexMap.values()) {
            for (Column col : set) {
                if (set.size() > 1) {
                    col.isPartOfUniqueConstraint(true);
                    continue;
                }
                col.isUnique(true);
            }
        }
    }

    public Collection getIndexSets(Column col) {
        ArrayList<Set> isets = new ArrayList<Set>();
        String[] indeces = col.getIndexNames();
        for (int i = 0; i < indeces.length; ++i) {
            isets.add((Set)this.indexMap.get(indeces[i]));
        }
        return isets;
    }

    public Collection getIndexSetCollection() {
        return this.indexMap.values();
    }

    public Map getIndexMap() {
        return this.indexMap;
    }

    public static String getStereotype() {
        return "Table";
    }

    public void setOwningDatabase(Database db) {
        super.setOwningDatabase(db);
        for (Column col : this.columns) {
            col.setOwningDatabase(db);
        }
    }
}

