/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.factory;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Hashtable;
import org.dbuml.base.controller.ActionsInterface;
import org.dbuml.base.controller.FigureActionsInterface;
import org.dbuml.base.database.ConnectionFactory;
import org.dbuml.base.database.DBMetadata;
import org.dbuml.base.database.DBReservedWords;
import org.dbuml.base.database.QueryTransaction;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.transform.DBMetadataToDBUML;
import org.dbuml.base.transform.DBUMLToSQL;

public abstract class Factory {
    private static Hashtable factories = new Hashtable();
    protected DBUMLToSQL dbumltosql = null;
    protected DBMetadataToDBUML dbmetadatatodbuml = null;
    protected ConnectionFactory connectionfactory = null;
    protected ActionsInterface actionsinterface = null;
    protected FigureActionsInterface figureactionsinterface = null;
    protected DBReservedWords dbReservedWords = null;

    public static final Factory getFactory(String factoryName) {
        Factory factory;
        if (factoryName == null || factoryName == "") {
            factory = (Factory)factories.get("org.dbuml.base.factory.GenericFactory");
        } else {
            factory = (Factory)factories.get(factoryName);
            if (factory == null) {
                try {
                    Class<?> factClass = Class.forName(factoryName);
                    Constructor<?> c = factClass.getConstructor(new Class[0]);
                    factory = (Factory)c.newInstance(new Object[0]);
                    factories.put(factoryName, factory);
                }
                catch (Exception e) {
                    factory = null;
                }
            }
        }
        return factory;
    }

    public abstract DBMetadata newDBMetadata(DBElement var1, Object var2) throws SQLException, ClassNotFoundException, Exception;

    public abstract DBUMLToSQL getDBUMLToSQL();

    public abstract DBMetadataToDBUML getDBMetadataToDBUML();

    public abstract ConnectionFactory getConnectionFactory();

    public abstract FigureActionsInterface getFigureActionsInterface();

    public abstract ActionsInterface getActionsInterface();

    public abstract QueryTransaction getQueryTransaction();

    public abstract DBReservedWords getDBReservedWords();

    protected abstract void initDBReservedWords();

    static {
        try {
            Class<?> factClass = Class.forName("org.dbuml.base.factory.GenericFactory");
            Constructor<?> c = factClass.getConstructor(new Class[0]);
            Factory fact = (Factory)c.newInstance(new Object[0]);
            factories.put("org.dbuml.base.factory.GenericFactory", fact);
        }
        catch (Exception e) {
            System.err.println("Error initializing DB-UML factories");
        }
    }
}

