/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.actions;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.model.script.engine.action.ActionDoc;
import org.openhab.core.model.script.engine.action.ParamDoc;
import org.openhab.core.model.script.internal.engine.action.VoiceActionService;
import org.openhab.core.voice.DialogContext;
import org.openhab.core.voice.KSService;
import org.openhab.core.voice.STTService;
import org.openhab.core.voice.TTSService;
import org.openhab.core.voice.text.InterpretationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Voice {
    private static final Logger logger = LoggerFactory.getLogger(Voice.class);

    @ActionDoc(text="says a given text with the default voice")
    public static void say(@ParamDoc(name="text") Object text) {
        Voice.say(text, null, null, null);
    }

    @ActionDoc(text="says a given text with the default voice and the given volume")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="volume", text="the volume to be used") @Nullable PercentType volume) {
        Voice.say(text, null, null, volume);
    }

    @ActionDoc(text="says a given text with the default voice and the given volume")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="volume", text="volume in the range [0;1]") float volume) {
        Voice.say(text, null, null, Voice.floatVolumeToPercentType(volume));
    }

    @ActionDoc(text="says a given text with a given voice")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") @Nullable String voice) {
        Voice.say(text, voice, null, null);
    }

    @ActionDoc(text="says a given text with a given voice and the given volume")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="volume", text="the volume to be used") PercentType volume) {
        Voice.say(text, voice, null, volume);
    }

    @ActionDoc(text="says a given text with a given voice and the given volume")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="volume", text="volume in the range [0;1]") float volume) {
        Voice.say(text, voice, null, Voice.floatVolumeToPercentType(volume));
    }

    @ActionDoc(text="says a given text with a given voice through the given sink")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="sink") @Nullable String sink) {
        Voice.say(text, voice, sink, null);
    }

    @ActionDoc(text="says a given text with a given voice and the given volume through the given sink")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="sink") @Nullable String sink, @ParamDoc(name="volume", text="the volume to be used") @Nullable PercentType volume) {
        String output = text.toString();
        if (!output.isBlank()) {
            VoiceActionService.voiceManager.say(output, voice, sink, volume);
        }
    }

    @ActionDoc(text="says a given text with a given voice and the given volume through the given sink")
    public static void say(@ParamDoc(name="text") Object text, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="sink") @Nullable String sink, @ParamDoc(name="volume", text="volume in the range [0;1]") float volume) {
        Voice.say(text, voice, sink, Voice.floatVolumeToPercentType(volume));
    }

    @ActionDoc(text="interprets a given text by the default human language interpreter", returns="human language response")
    public static String interpret(@ParamDoc(name="text") Object text) {
        return Voice.interpret(text, null);
    }

    @ActionDoc(text="interprets a given text by given human language interpreter(s)", returns="human language response")
    public static String interpret(@ParamDoc(name="text") Object text, @ParamDoc(name="interpreters") @Nullable String interpreters) {
        String response;
        try {
            response = VoiceActionService.voiceManager.interpret(text.toString(), interpreters);
        }
        catch (InterpretationException e) {
            String message = Objects.requireNonNullElse(e.getMessage(), "");
            Voice.say(message);
            response = message;
        }
        return response;
    }

    @ActionDoc(text="interprets a given text by given human language interpreter(s) and using the given sink", returns="human language response")
    public static String interpret(@ParamDoc(name="text") Object text, @ParamDoc(name="interpreters") String interpreters, @ParamDoc(name="sink") @Nullable String sink) {
        String response;
        try {
            response = VoiceActionService.voiceManager.interpret(text.toString(), interpreters);
        }
        catch (InterpretationException e) {
            String message = Objects.requireNonNullElse(e.getMessage(), "");
            if (sink != null) {
                Voice.say((Object)message, null, sink);
            }
            response = message;
        }
        return response;
    }

    @ActionDoc(text="starts dialog processing for a given audio source")
    public static void startDialog(@ParamDoc(name="source") @Nullable String source, @ParamDoc(name="sink") @Nullable String sink) {
        Voice.startDialog(null, null, null, null, null, source, sink, null, null, null);
    }

    @ActionDoc(text="starts dialog processing for a given audio source")
    public static void startDialog(@ParamDoc(name="keyword spotting service") @Nullable String ks, @ParamDoc(name="speech-to-text service") @Nullable String stt, @ParamDoc(name="text-to-speech service") @Nullable String tts, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="interpreters") @Nullable String interpreters, @ParamDoc(name="source") @Nullable String source, @ParamDoc(name="sink") @Nullable String sink, @ParamDoc(name="locale") @Nullable String locale, @ParamDoc(name="keyword") @Nullable String keyword, @ParamDoc(name="listening item") @Nullable String listeningItem) {
        DialogContext.Builder dialogContextBuilder = VoiceActionService.voiceManager.getDialogContextBuilder();
        if (source != null) {
            AudioSource audioSource = VoiceActionService.audioManager.getSource(source);
            if (audioSource == null) {
                logger.warn("Failed starting dialog processing: audio source '{}' not found", (Object)source);
                return;
            }
            dialogContextBuilder.withSource(audioSource);
        }
        if (ks != null) {
            KSService ksService = VoiceActionService.voiceManager.getKS(ks);
            if (ksService == null) {
                logger.warn("Failed starting dialog processing: keyword spotting service '{}' not found", (Object)ks);
                return;
            }
            dialogContextBuilder.withKS(ksService);
        }
        if (keyword != null) {
            dialogContextBuilder.withKeyword(keyword);
        }
        if (stt != null) {
            STTService sttService = VoiceActionService.voiceManager.getSTT(stt);
            if (sttService == null) {
                logger.warn("Failed starting dialog processing: speech-to-text service '{}' not found", (Object)stt);
                return;
            }
            dialogContextBuilder.withSTT(sttService);
        }
        if (tts != null) {
            TTSService ttsService = VoiceActionService.voiceManager.getTTS(tts);
            if (ttsService == null) {
                logger.warn("Failed starting dialog processing: text-to-speech service '{}' not found", (Object)tts);
                return;
            }
            dialogContextBuilder.withTTS(ttsService);
        }
        if (voice != null) {
            org.openhab.core.voice.Voice prefVoice = Voice.getVoice(voice);
            if (prefVoice == null) {
                logger.warn("Failed starting dialog processing: voice '{}' not found", (Object)voice);
                return;
            }
            dialogContextBuilder.withVoice(prefVoice);
        }
        if (interpreters != null) {
            List hliServices = VoiceActionService.voiceManager.getHLIsByIds(interpreters);
            if (hliServices.isEmpty()) {
                logger.warn("Failed starting dialog processing: interpreters '{}' not found", (Object)interpreters);
                return;
            }
            dialogContextBuilder.withHLIs(hliServices);
        }
        if (sink != null) {
            AudioSink audioSink = VoiceActionService.audioManager.getSink(sink);
            if (audioSink == null) {
                logger.warn("Failed starting dialog processing: audio sink '{}' not found", (Object)sink);
                return;
            }
            dialogContextBuilder.withSink(audioSink);
        }
        if (listeningItem != null) {
            dialogContextBuilder.withListeningItem(listeningItem);
        }
        if (locale != null) {
            String[] split = locale.split("-");
            Locale loc = split.length == 2 ? Locale.of(split[0], split[1]) : Locale.of(split[0]);
            dialogContextBuilder.withLocale(loc);
        }
        try {
            VoiceActionService.voiceManager.startDialog(dialogContextBuilder.build());
        }
        catch (IllegalStateException e) {
            logger.warn("Failed starting dialog processing: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="stops dialog processing for a given audio source")
    public static void stopDialog(@ParamDoc(name="source") @Nullable String source) {
        try {
            AudioSource audioSource = null;
            if (source != null && (audioSource = VoiceActionService.audioManager.getSource(source)) == null) {
                logger.warn("Failed stopping dialog processing: audio source '{}' not found", (Object)source);
                return;
            }
            VoiceActionService.voiceManager.stopDialog(audioSource);
        }
        catch (IllegalStateException e) {
            logger.warn("Failed stopping dialog processing: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="executes a simple dialog sequence without keyword spotting for a given audio source")
    public static void listenAndAnswer(@ParamDoc(name="source") @Nullable String source, @ParamDoc(name="sink") @Nullable String sink) {
        Voice.listenAndAnswer(null, null, null, null, source, sink, null, null);
    }

    @ActionDoc(text="executes a simple dialog sequence without keyword spotting for a given audio source")
    public static void listenAndAnswer(@ParamDoc(name="speech-to-text service") @Nullable String stt, @ParamDoc(name="text-to-speech service") @Nullable String tts, @ParamDoc(name="voice") @Nullable String voice, @ParamDoc(name="interpreters") @Nullable String interpreters, @ParamDoc(name="source") @Nullable String source, @ParamDoc(name="sink") @Nullable String sink, @ParamDoc(name="locale") @Nullable String locale, @ParamDoc(name="listening item") @Nullable String listeningItem) {
        try {
            DialogContext.Builder dialogContextBuilder = VoiceActionService.voiceManager.getDialogContextBuilder();
            if (source != null) {
                AudioSource audioSource = VoiceActionService.audioManager.getSource(source);
                if (audioSource == null) {
                    logger.warn("Failed executing simple dialog: audio source '{}' not found", (Object)source);
                    return;
                }
                dialogContextBuilder.withSource(audioSource);
            }
            if (stt != null) {
                STTService sttService = VoiceActionService.voiceManager.getSTT(stt);
                if (sttService == null) {
                    logger.warn("Failed executing simple dialog: speech-to-text service '{}' not found", (Object)stt);
                    return;
                }
                dialogContextBuilder.withSTT(sttService);
            }
            if (tts != null) {
                TTSService ttsService = VoiceActionService.voiceManager.getTTS(tts);
                if (ttsService == null) {
                    logger.warn("Failed executing simple dialog: text-to-speech service '{}' not found", (Object)tts);
                    return;
                }
                dialogContextBuilder.withTTS(ttsService);
            }
            if (voice != null) {
                org.openhab.core.voice.Voice prefVoice = Voice.getVoice(voice);
                if (prefVoice == null) {
                    logger.warn("Failed executing simple dialog: voice '{}' not found", (Object)voice);
                    return;
                }
                dialogContextBuilder.withVoice(prefVoice);
            }
            if (interpreters != null) {
                List hliServices = VoiceActionService.voiceManager.getHLIsByIds(interpreters);
                if (hliServices.isEmpty()) {
                    logger.warn("Failed executing simple dialog: interpreters '{}' not found", (Object)interpreters);
                    return;
                }
                dialogContextBuilder.withHLIs(hliServices);
            }
            if (sink != null) {
                AudioSink audioSink = VoiceActionService.audioManager.getSink(sink);
                if (audioSink == null) {
                    logger.warn("Failed executing simple dialog: audio sink '{}' not found", (Object)sink);
                    return;
                }
                dialogContextBuilder.withSink(audioSink);
            }
            if (listeningItem != null) {
                dialogContextBuilder.withListeningItem(listeningItem);
            }
            if (locale != null) {
                String[] split = locale.split("-");
                Locale loc = split.length == 2 ? Locale.of(split[0], split[1]) : Locale.of(split[0]);
                dialogContextBuilder.withLocale(loc);
            }
            VoiceActionService.voiceManager.listenAndAnswer(dialogContextBuilder.build());
        }
        catch (IllegalStateException e) {
            logger.warn("Failed executing simple dialog: {}", (Object)e.getMessage());
        }
    }

    private static @Nullable org.openhab.core.voice.Voice getVoice(String id) {
        return VoiceActionService.voiceManager.getAllVoices().stream().filter(voice -> voice.getUID().equals(id)).findAny().orElse(null);
    }

    private static PercentType floatVolumeToPercentType(float volume) {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Volume value must be in the range [0;1]!");
        }
        return new PercentType(new BigDecimal(volume * 100.0f));
    }
}

