/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.internal;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.persistence.PersistenceServiceRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, configurationPid={"org.openhab.persistence"}, property={"service.pid=org.openhab.persistence"})
@ConfigurableService(category="system", label="Persistence", description_uri="system:persistence")
@NonNullByDefault
public class PersistenceServiceRegistryImpl
implements ConfigOptionProvider,
PersistenceServiceRegistry {
    protected static final String CONFIG_URI = "system:persistence";
    private static final String CONFIG_DEFAULT = "default";
    private final Map<String, PersistenceService> persistenceServices = new HashMap<String, PersistenceService>();
    private @Nullable String defaultServiceId;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addPersistenceService(PersistenceService persistenceService) {
        this.persistenceServices.put(persistenceService.getId(), persistenceService);
    }

    public void removePersistenceService(PersistenceService persistenceService) {
        this.persistenceServices.remove(persistenceService.getId());
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.defaultServiceId = (String)config.get(CONFIG_DEFAULT);
    }

    @Override
    public @Nullable PersistenceService getDefault() {
        return this.get(this.getDefaultId());
    }

    @Override
    public @Nullable PersistenceService get(@Nullable String serviceId) {
        return serviceId != null ? this.persistenceServices.get(serviceId) : null;
    }

    @Override
    public @Nullable String getDefaultId() {
        if (this.defaultServiceId != null) {
            return this.defaultServiceId;
        }
        return this.persistenceServices.size() == 1 ? this.persistenceServices.keySet().iterator().next() : null;
    }

    @Override
    public Set<PersistenceService> getAll() {
        return new HashSet<PersistenceService>(this.persistenceServices.values());
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        if (CONFIG_URI.equals(uri.toString()) && CONFIG_DEFAULT.equals(param)) {
            HashSet<ParameterOption> options = new HashSet<ParameterOption>();
            for (PersistenceService service : this.getAll()) {
                options.add(new ParameterOption(service.getId(), service.getLabel(locale)));
            }
            return options;
        }
        return null;
    }
}

