/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.ip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonMatchProperty;
import org.openhab.core.addon.AddonParameter;
import org.openhab.core.addon.AddonService;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.net.CidrAddress;
import org.openhab.core.net.NetUtil;
import org.openhab.core.net.NetworkAddressChangeListener;
import org.openhab.core.net.NetworkAddressService;
import org.openhab.core.util.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="ip-addon-suggestion-finder")
public class IpAddonFinder
extends BaseAddonFinder
implements NetworkAddressChangeListener {
    public static final String SERVICE_TYPE = "ip";
    public static final String SERVICE_NAME = "ip-addon-suggestion-finder";
    private static final String TYPE_IP_BROADCAST = "ipBroadcast";
    private static final String TYPE_IP_MULTICAST = "ipMulticast";
    private static final String MATCH_PROPERTY_RESPONSE = "response";
    private static final String PARAMETER_DEST_IP = "destIp";
    private static final String PARAMETER_DEST_PORT = "destPort";
    private static final String PARAMETER_LISTEN_PORT = "listenPort";
    private static final String PARAMETER_REQUEST = "request";
    private static final String PARAMETER_REQUEST_PLAIN = "requestPlain";
    private static final String PARAMETER_SRC_IP = "srcIp";
    private static final String PARAMETER_SRC_PORT = "srcPort";
    private static final String PARAMETER_SRC_MAC = "srcMac";
    private static final String PARAMETER_MAC_FORMAT = "fmtMac";
    private static final String PARAMETER_TIMEOUT_MS = "timeoutMs";
    private static final String REPLACEMENT_UUID = "uuid";
    private final Logger logger = LoggerFactory.getLogger(IpAddonFinder.class);
    private final NetworkAddressService networkAddressService;
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final Set<AddonService> addonServices = new CopyOnWriteArraySet<AddonService>();
    private @Nullable Future<?> scanJob = null;
    Set<AddonInfo> suggestions = new HashSet<AddonInfo>();

    @Activate
    public IpAddonFinder(@Reference NetworkAddressService networkAddressService) {
        this.logger.trace("IpAddonFinder::IpAddonFinder");
        this.networkAddressService = networkAddressService;
        this.networkAddressService.addNetworkAddressChangeListener((NetworkAddressChangeListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.logger.trace("IpAddonFinder::deactivate");
        this.networkAddressService.removeNetworkAddressChangeListener((NetworkAddressChangeListener)this);
        this.stopScan();
    }

    public void setAddonCandidates(List<AddonInfo> candidates) {
        this.logger.debug("IpAddonFinder::setAddonCandidates({})", (Object)candidates.size());
        super.setAddonCandidates(candidates);
        this.startScan(20L);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAddonService(AddonService featureService) {
        this.addonServices.add(featureService);
    }

    protected void removeAddonService(AddonService featureService) {
        this.addonServices.remove(featureService);
    }

    public void onChanged(List<CidrAddress> added, List<CidrAddress> removed) {
    }

    public void onPrimaryAddressChanged(@Nullable String oldPrimaryAddress, @Nullable String newPrimaryAddress) {
        this.startScan(0L);
    }

    private void startScan(long delayInSeconds) {
        this.stopScan();
        this.logger.trace("Scheduling new IP scan");
        this.scanJob = this.scheduler.schedule(this::scan, delayInSeconds, TimeUnit.SECONDS);
    }

    private void stopScan() {
        Future<?> tmpScanJob = this.scanJob;
        if (tmpScanJob != null) {
            if (!tmpScanJob.isDone()) {
                this.logger.trace("Trying to cancel IP scan");
                tmpScanJob.cancel(true);
            }
            this.scanJob = null;
        }
    }

    private void scan() {
        this.logger.trace("IpAddonFinder::scan started");
        for (AddonInfo candidate : this.addonCandidates) {
            for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                String macFormat;
                int destPort;
                InetAddress destIp;
                int timeoutMs;
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                if (this.isAddonInstalled(candidate.getUID())) {
                    this.logger.trace("Skipping {}, already installed", (Object)candidate.getUID());
                    continue;
                }
                Map<String, String> parameters = method2.getParameters().stream().collect(Collectors.toMap(AddonParameter::getName, AddonParameter::getValue));
                Map<String, String> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(AddonMatchProperty::getName, AddonMatchProperty::getRegex));
                String type = Objects.toString(parameters.get("type"), "");
                String request = Objects.requireNonNull(Objects.toString(parameters.get(PARAMETER_REQUEST), ""));
                String requestPlain = Objects.requireNonNull(Objects.toString(parameters.get(PARAMETER_REQUEST_PLAIN), ""));
                if (!("".equals(request) ^ "".equals(requestPlain))) {
                    this.logger.warn("{}: discovery-parameter '{}' or '{}' required", new Object[]{candidate.getUID(), PARAMETER_REQUEST, PARAMETER_REQUEST_PLAIN});
                    continue;
                }
                String response = Objects.requireNonNull(Objects.toString(matchProperties.get(MATCH_PROPERTY_RESPONSE), ""));
                try {
                    timeoutMs = Integer.parseInt(Objects.toString(parameters.get(PARAMETER_TIMEOUT_MS)));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_TIMEOUT_MS);
                    continue;
                }
                try {
                    destIp = InetAddress.getByName(parameters.get(PARAMETER_DEST_IP));
                }
                catch (UnknownHostException e) {
                    this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_DEST_IP);
                    continue;
                }
                try {
                    destPort = Integer.parseInt(Objects.toString(parameters.get(PARAMETER_DEST_PORT)));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_DEST_PORT);
                    continue;
                }
                int listenPort = 0;
                if (parameters.get(PARAMETER_LISTEN_PORT) != null) {
                    try {
                        listenPort = Integer.parseInt(Objects.toString(parameters.get(PARAMETER_LISTEN_PORT)));
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_LISTEN_PORT);
                        continue;
                    }
                    if (listenPort < 1024) {
                        this.logger.warn("{}: discovery-parameter '{}' not allowed, privileged port", (Object)candidate.getUID(), (Object)PARAMETER_LISTEN_PORT);
                        continue;
                    }
                }
                if (!this.macFormatValid(macFormat = parameters.getOrDefault(PARAMETER_MAC_FORMAT, "%02X:"))) {
                    this.logger.warn("{}: discovery-parameter '{}' invalid format specifier", (Object)candidate.getUID(), (Object)macFormat);
                    continue;
                }
                try {
                    switch (Objects.toString(type)) {
                        case "ipBroadcast": {
                            this.scanBroadcast(candidate, request, requestPlain, response, timeoutMs, destPort, macFormat);
                            break;
                        }
                        case "ipMulticast": {
                            this.scanMulticast(candidate, request, requestPlain, response, timeoutMs, listenPort, destIp, destPort, macFormat);
                            break;
                        }
                        default: {
                            this.logger.warn("{}: discovery-parameter type \"{}\" is unknown", (Object)candidate.getUID(), (Object)type);
                            break;
                        }
                    }
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
            }
        }
        this.logger.trace("IpAddonFinder::scan completed");
    }

    private void scanBroadcast(AddonInfo candidate, String request, String requestPlain, String response, int timeoutMs, int destPort, String macFormat) throws ParseException {
        if (request.isEmpty() && requestPlain.isEmpty()) {
            this.logger.warn("{}: match-property request and requestPlain \"{}\" is unknown", (Object)candidate.getUID(), (Object)TYPE_IP_BROADCAST);
            return;
        }
        if (!request.isEmpty() && !requestPlain.isEmpty()) {
            this.logger.warn("{}: match-properties request and requestPlain \"{}\" are both present", (Object)candidate.getUID(), (Object)TYPE_IP_BROADCAST);
            return;
        }
        if (response.isEmpty()) {
            this.logger.warn("{}: match-property response \"{}\" is unknown", (Object)candidate.getUID(), (Object)TYPE_IP_BROADCAST);
            return;
        }
        String broadcastAddress = this.networkAddressService.getConfiguredBroadcastAddress();
        this.logger.debug("Starting broadcast scan with address {}", (Object)broadcastAddress);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (DatagramSocket socket = new DatagramSocket();){
                socket.setBroadcast(true);
                socket.setSoTimeout(timeoutMs);
                byte[] sendBuffer = requestPlain.isEmpty() ? this.buildRequestArray(socket.getLocalSocketAddress(), request) : this.buildRequestArrayPlain(socket.getLocalSocketAddress(), requestPlain, macFormat);
                DatagramPacket sendPacket = new DatagramPacket(sendBuffer, sendBuffer.length, InetAddress.getByName(broadcastAddress), destPort);
                socket.send(sendPacket);
                while (!Thread.currentThread().isInterrupted()) {
                    byte[] discoverReceive = this.buildByteArray(response);
                    byte[] receiveBuffer = new byte[discoverReceive.length];
                    DatagramPacket receivePacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
                    try {
                        socket.receive(receivePacket);
                    }
                    catch (SocketTimeoutException e) {
                        break;
                    }
                    byte[] data = receivePacket.getData();
                    if (!Arrays.equals(data, discoverReceive)) continue;
                    this.suggestions.add(candidate);
                    this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.debug("{}: network error", (Object)candidate.getUID(), (Object)e);
        }
    }

    private byte[] buildByteArray(String input) {
        ByteArrayOutputStream requestFrame = new ByteArrayOutputStream();
        StringTokenizer parts = new StringTokenizer(input);
        while (parts.hasMoreTokens()) {
            String token = parts.nextToken();
            int i = Integer.decode(token);
            requestFrame.write((byte)i);
        }
        return requestFrame.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    private void scanMulticast(AddonInfo candidate, String request, String requestPlain, String response, int timeoutMs, int listenPort, @Nullable InetAddress destIp, int destPort, String macFormat) throws ParseException {
        ipAddresses = NetUtil.getAllInterfaceAddresses().stream().filter((Predicate<CidrAddress>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$6(org.openhab.core.net.CidrAddress ), (Lorg/openhab/core/net/CidrAddress;)Z)()).map((Function<CidrAddress, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$7(org.openhab.core.net.CidrAddress ), (Lorg/openhab/core/net/CidrAddress;)Ljava/lang/String;)()).toList();
        for (String localIp : ipAddresses) {
            try {
                var13_13 = null;
                var14_16 = null;
                try {
                    channel = (DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true).bind(new InetSocketAddress(localIp, listenPort)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)64).configureBlocking(false);
                    try {
                        selector = Selector.open();
                        try {
                            v0 = requestArray = "".equals(requestPlain) != false ? this.buildRequestArray(channel.getLocalAddress(), Objects.toString(request)) : this.buildRequestArrayPlain(channel.getLocalAddress(), Objects.toString(requestPlain), macFormat);
                            if (this.logger.isTraceEnabled()) {
                                sock = (InetSocketAddress)channel.getLocalAddress();
                                id = candidate.getUID();
                                this.logger.trace("{}: probing {} -> {}:{}", new Object[]{id, localIp, destIp != null ? destIp.getHostAddress() : "", destPort});
                                if (!"".equals(requestPlain)) {
                                    this.logger.trace("{}: '{}'", (Object)id, (Object)new String(requestArray));
                                }
                                this.logger.trace("{}: {}", (Object)id, (Object)HexFormat.of().withDelimiter(" ").formatHex(requestArray));
                                this.logger.trace("{}: listening on {}:{} for {} ms", new Object[]{id, sock.getAddress().getHostAddress(), sock.getPort(), timeoutMs});
                            }
                            channel.send(ByteBuffer.wrap(requestArray), new InetSocketAddress(destIp, destPort));
                            buffer = ByteBuffer.wrap(new byte[50]);
                            channel.register(selector, 1);
                            selector.select(timeoutMs);
                            it = selector.selectedKeys().iterator();
                            var20_24 = Objects.toString(response);
                            tmp = -1;
                            switch (var20_24.hashCode()) {
                                case 1468: {
                                    if (var20_24.equals(".*")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    if (it.hasNext()) {
                                        source = ((DatagramChannel)it.next().channel()).receive(buffer);
                                        this.logger.debug("Received return frame from {}", (Object)((InetSocketAddress)source).getAddress().getHostAddress());
                                        this.suggestions.add(candidate);
                                        this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                                        ** break;
lbl47:
                                        // 1 sources

                                    } else {
                                        this.logger.trace("{}: no response received on {}", (Object)candidate.getUID(), (Object)localIp);
                                        ** break;
                                    }
lbl50:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    this.logger.warn("{}: match-property response \"{}\" is unknown", (Object)candidate.getUID(), (Object)"ipMulticast");
                                    break;
                                }
                            }
                        }
                        finally {
                            if (selector != null) {
                                selector.close();
                            }
                        }
                        if (channel == null) continue;
                    }
                    catch (Throwable var14_17) {
                        if (var13_13 == null) {
                            var13_13 = var14_17;
                        } else if (var13_13 != var14_17) {
                            var13_13.addSuppressed(var14_17);
                        }
                        if (channel != null) {
                            channel.close();
                        }
                        throw var13_13;
                    }
                    channel.close();
                }
                catch (Throwable var14_18) {
                    if (var13_13 == null) {
                        var13_13 = var14_18;
                    } else if (var13_13 != var14_18) {
                        var13_13.addSuppressed(var14_18);
                    }
                    throw var13_13;
                }
            }
            catch (IOException e) {
                this.logger.debug("{}: network error", (Object)candidate.getUID(), (Object)e);
            }
        }
    }

    private byte[] buildRequestArrayPlain(SocketAddress address, String request, String macFormat) throws IOException, ParseException {
        int p;
        InetSocketAddress sock = (InetSocketAddress)address;
        StringBuilder req = new StringBuilder(request);
        while ((p = req.indexOf("$srcIp")) != -1) {
            req.replace(p, p + PARAMETER_SRC_IP.length() + 1, sock.getAddress().getHostAddress());
        }
        while ((p = req.indexOf("$srcPort")) != -1) {
            req.replace(p, p + PARAMETER_SRC_PORT.length() + 1, "" + sock.getPort());
        }
        while ((p = req.indexOf("$srcMac")) != -1) {
            req.replace(p, p + PARAMETER_SRC_MAC.length() + 1, this.macFormat(macFormat, this.macBytesFrom(sock)));
        }
        while ((p = req.indexOf("$uuid")) != -1) {
            req.replace(p, p + REPLACEMENT_UUID.length() + 1, UUID.randomUUID().toString());
        }
        @Nullable String reqUnEscaped = StringUtils.unEscapeXml((String)req.toString());
        return reqUnEscaped != null ? reqUnEscaped.translateEscapes().getBytes() : new byte[]{};
    }

    private byte[] buildRequestArray(SocketAddress address, String request) throws IOException, ParseException {
        InetSocketAddress sock = (InetSocketAddress)address;
        ByteArrayOutputStream requestFrame = new ByteArrayOutputStream();
        StringTokenizer parts = new StringTokenizer(request);
        block12: while (parts.hasMoreTokens()) {
            String token;
            block17: {
                token = parts.nextToken();
                if (!token.startsWith("$")) break block17;
                switch (token) {
                    case "$srcIp": {
                        byte[] adr = sock.getAddress().getAddress();
                        requestFrame.write(adr);
                        continue block12;
                    }
                    case "$srcPort": {
                        int dPort = sock.getPort();
                        requestFrame.write((byte)(dPort >> 8 & 0xFF));
                        requestFrame.write((byte)(dPort & 0xFF));
                        continue block12;
                    }
                    case "$srcMac": {
                        byte[] mac = this.macBytesFrom(sock);
                        requestFrame.write(mac);
                        continue block12;
                    }
                    case "$uuid": {
                        String uuid = UUID.randomUUID().toString();
                        requestFrame.write(uuid.getBytes());
                        continue block12;
                    }
                    default: {
                        this.logger.warn("Unknown token in request frame \"{}\"", (Object)token);
                        throw new ParseException(token, 0);
                    }
                }
            }
            int i = Integer.decode(token);
            requestFrame.write((byte)i);
        }
        return requestFrame.toByteArray();
    }

    public Set<AddonInfo> getSuggestedAddons() {
        this.logger.trace("IpAddonFinder::getSuggestedAddons {}/{}", (Object)this.suggestions.size(), (Object)this.addonCandidates.size());
        return this.suggestions;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private boolean isAddonInstalled(String addonId) {
        for (AddonService addonService : this.addonServices) {
            Addon addon = addonService.getAddon(addonId, null);
            if (addon == null || !addon.isInstalled()) continue;
            return true;
        }
        return false;
    }

    private byte[] macBytesFrom(InetSocketAddress inetSocketAddress) throws SocketException {
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetSocketAddress.getAddress());
        if (networkInterface == null) {
            throw new SocketException("No network interface");
        }
        return networkInterface.getHardwareAddress();
    }

    private String macFormat(String format, byte[] bytes) {
        StringBuilder result = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte byt = byArray[n2];
            result.append(String.format(format, byt));
            ++n2;
        }
        boolean isDelimited = !Character.isLetterOrDigit(format.charAt(format.length() - 1));
        return (isDelimited ? result.substring(0, result.length() - 1) : result).toString();
    }

    private boolean macFormatValid(String format) {
        try {
            String.format(format, (byte)123);
        }
        catch (IllegalFormatException e) {
            return false;
        }
        int last = format.length() - 1;
        int index = 0;
        while (index <= last) {
            if (Character.isLetter(format.charAt(index))) break;
            ++index;
        }
        switch (last - index) {
            case 0: {
                return true;
            }
            case 1: {
                return !Character.isLetterOrDigit(format.charAt(last));
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$6(CidrAddress a) {
        return a.getAddress() instanceof Inet4Address;
    }

    private static /* synthetic */ String lambda$7(CidrAddress a) {
        return a.getAddress().getHostAddress();
    }
}

