/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.spockframework.runtime.IConfigurationRegistry;
import org.spockframework.runtime.IExtensionRegistry;
import org.spockframework.runtime.extension.ExtensionAnnotation;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;

public class ExtensionRunner {
    private final SpecInfo spec;
    private final IExtensionRegistry extensionRegistry;
    private final IConfigurationRegistry configurationRegistry;
    private final Map<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension> localExtensions = new HashMap<Class<? extends IAnnotationDrivenExtension>, IAnnotationDrivenExtension>();

    public ExtensionRunner(SpecInfo spec, IExtensionRegistry extensionRegistry, IConfigurationRegistry configurationRegistry) {
        this.spec = spec;
        this.extensionRegistry = extensionRegistry;
        this.configurationRegistry = configurationRegistry;
    }

    public void run() {
        this.runGlobalExtensions();
        this.runAnnotationDrivenExtensions();
    }

    private void runGlobalExtensions() {
        for (IGlobalExtension extension : this.extensionRegistry.getGlobalExtensions()) {
            extension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions() {
        this.runAnnotationDrivenExtensions(this.spec);
        for (IAnnotationDrivenExtension extension : this.localExtensions.values()) {
            extension.visitSpec(this.spec);
        }
    }

    public void runAnnotationDrivenExtensions(SpecInfo spec) {
        if (spec == null) {
            return;
        }
        this.runAnnotationDrivenExtensions(spec.getSuperSpec());
        this.doRunAnnotationDrivenExtensions(spec);
        for (FieldInfo field : spec.getFields()) {
            this.doRunAnnotationDrivenExtensions(field);
        }
        this.doRunAnnotationDrivenExtensions(spec.getSetupSpecMethods());
        this.doRunAnnotationDrivenExtensions(spec.getSetupMethods());
        this.doRunAnnotationDrivenExtensions(spec.getCleanupMethods());
        this.doRunAnnotationDrivenExtensions(spec.getCleanupSpecMethods());
        for (FeatureInfo feature : spec.getFeatures()) {
            this.doRunAnnotationDrivenExtensions(feature.getFeatureMethod());
        }
    }

    private void doRunAnnotationDrivenExtensions(Iterable<MethodInfo> nodes) {
        for (MethodInfo node : nodes) {
            this.doRunAnnotationDrivenExtensions(node);
        }
    }

    private void doRunAnnotationDrivenExtensions(NodeInfo<?, ?> node) {
        for (Annotation ann : node.getAnnotations()) {
            ExtensionAnnotation extAnn = ann.annotationType().getAnnotation(ExtensionAnnotation.class);
            if (extAnn == null) continue;
            IAnnotationDrivenExtension extension = this.getOrCreateExtension(extAnn.value());
            if (node instanceof SpecInfo) {
                extension.visitSpecAnnotation(ann, (SpecInfo)node);
                continue;
            }
            if (node instanceof MethodInfo) {
                MethodInfo method = (MethodInfo)node;
                if (method.getKind() == MethodKind.FEATURE) {
                    extension.visitFeatureAnnotation(ann, method.getFeature());
                    continue;
                }
                extension.visitFixtureAnnotation(ann, method);
                continue;
            }
            extension.visitFieldAnnotation(ann, (FieldInfo)node);
        }
    }

    private IAnnotationDrivenExtension getOrCreateExtension(Class<? extends IAnnotationDrivenExtension> clazz) {
        IAnnotationDrivenExtension extension = this.localExtensions.get(clazz);
        if (extension == null) {
            try {
                extension = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ExtensionException("Failed to instantiate extension '%s'", e).withArgs(clazz);
            }
            catch (IllegalAccessException e) {
                throw new ExtensionException("No-arg constructor of extension '%s' is not public", e).withArgs(clazz);
            }
            this.configurationRegistry.configureExtension(extension);
            this.localExtensions.put(clazz, extension);
        }
        return extension;
    }
}

