# Configure paths for nestedsums
# Christian Bauer 24.Mar.2003
# stolen from Sam Lantinga
# stolen from Manish Singh
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_NESTEDSUMS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for nestedsums, and define NESTEDSUMS_CPPFLAGS and NESTEDSUMS_LIBS
dnl
AC_DEFUN([AM_PATH_NESTEDSUMS],
[dnl 
dnl Get the cppflags and libraries from the nestedsums-config script
dnl
AC_ARG_WITH(nestedsums-prefix,[  --with-nestedsums-prefix=PFX Prefix where nestedsums is installed (optional)],
            nestedsums_prefix="$withval", nestedsums_prefix="")
AC_ARG_WITH(nestedsums-exec-prefix,[  --with-nestedsums-exec-prefix=PFX Exec prefix where nestedsums is installed (optional)],
            nestedsums_exec_prefix="$withval", nestedsums_exec_prefix="")
AC_ARG_ENABLE(nestedsumstest, [  --disable-nestedsumstest     Do not try to compile and run a test nestedsums program],
              , enable_nestedsumstest=yes)

if test x$nestedsums_exec_prefix != x ; then
    nestedsums_args="$nestedsums_args --exec-prefix=$nestedsums_exec_prefix"
    if test x${NESTEDSUMS_CONFIG+set} != xset ; then
        NESTEDSUMS_CONFIG=$nestedsums_exec_prefix/bin/nestedsums-config
    fi
fi
if test x$nestedsums_prefix != x ; then
    nestedsums_args="$nestedsums_args --prefix=$nestedsums_prefix"
    if test x${NESTEDSUMS_CONFIG+set} != xset ; then
        NESTEDSUMS_CONFIG=$nestedsums_prefix/bin/nestedsums-config
    fi
fi

AC_PATH_PROG(NESTEDSUMS_CONFIG, nestedsums-config, no)
nestedsums_min_version=ifelse([$1], ,1.1.0,$1)
AC_MSG_CHECKING(for nestedsums - version >= $nestedsums_min_version)
if test "$NESTEDSUMS_CONFIG" = "no" ; then
    AC_MSG_RESULT(no)
    echo "*** The nestedsums-config script installed by nestedsums could not be found"
    echo "*** If nestedsums was installed in PREFIX, make sure PREFIX/bin is in"
    echo "*** your path, or set the NESTEDSUMS_CONFIG environment variable to the"
    echo "*** full path to nestedsums-config."
    ifelse([$3], , :, [$3])
else
dnl Parse required version and the result of nestedsums-config.
    nestedsums_min_major_version=`echo $nestedsums_min_version | \
            sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    nestedsums_min_minor_version=`echo $nestedsums_min_version | \
            sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    nestedsums_min_micro_version=`echo $nestedsums_min_version | \
            sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    NESTEDSUMS_CPPFLAGS=`$NESTEDSUMS_CONFIG $nestedsums_args --cppflags`
    NESTEDSUMS_LIBS=`$NESTEDSUMS_CONFIG $nestedsums_args --libs`
    nestedsums_config_version=`$NESTEDSUMS_CONFIG $nestedsums_args --version`
    nestedsums_config_major_version=`echo $nestedsums_config_version | \
            sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    nestedsums_config_minor_version=`echo $nestedsums_config_version | \
            sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    nestedsums_config_micro_version=`echo $nestedsums_config_version | \
            sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
dnl Check if the installed nestedsums is sufficiently new according to nestedsums-config.
    if test \( $nestedsums_config_major_version -lt $nestedsums_min_major_version \) -o \
            \( $nestedsums_config_major_version -eq $nestedsums_min_major_version -a $nestedsums_config_minor_version -lt $nestedsums_min_minor_version \) -o \
            \( $nestedsums_config_major_version -eq $nestedsums_min_major_version -a $nestedsums_config_minor_version -eq $nestedsums_min_minor_version -a $nestedsums_config_micro_version -lt $nestedsums_min_micro_version \); then
        echo -e "\n*** 'nestedsums-config --version' returned $nestedsums_config_major_version.$nestedsums_config_minor_version.$nestedsums_config_micro_version, but the minimum version"
        echo "*** of nestedsums required is $nestedsums_min_major_version.$nestedsums_min_minor_version.$nestedsums_min_micro_version. If nestedsums-config is correct, then it is"
        echo "*** best to upgrade to the required version."
        echo "*** If nestedsums-config was wrong, set the environment variable NESTEDSUMS_CONFIG"
        echo "*** to point to the correct copy of nestedsums-config, and remove the file"
        echo "*** config.cache before re-running configure."
        ifelse([$3], , :, [$3])
    else
dnl The versions match so far.  Now do a sanity check: Does the result of nestedsums-config
dnl match the version of the headers and the version built into the library, too?
        no_nestedsums=""
        if test "x$enable_nestedsumstest" = "xyes" ; then
            ac_save_CPPFLAGS="$CPPFLAGS"
            ac_save_LIBS="$LIBS"
            CPPFLAGS="$CPPFLAGS $NESTEDSUMS_CPPFLAGS"
            LIBS="$LIBS $NESTEDSUMS_LIBS"
            rm -f conf.nestedsumstest
            AC_TRY_RUN([
#include <stdio.h>
#include <string.h>
#include <nestedsums/version.h>

/* we do not #include <stdlib.h> because autoconf in C++ mode inserts a
   prototype for exit() that conflicts with the one in stdlib.h */
extern "C" int system(const char *);

int main(void)
{
    int major, minor, micro;
    char *tmp_version;

    system("touch conf.nestedsumstest");

    if ((NESTEDSUMS_MAJOR != $nestedsums_config_major_version) ||
        (NESTEDSUMS_MINOR != $nestedsums_config_minor_version) ||
        (NESTEDSUMS_MICRO != $nestedsums_config_micro_version)) {
        printf("\n*** 'nestedsums-config --version' returned %d.%d.%d, but the header file I found\n", $nestedsums_config_major_version, $nestedsums_config_minor_version, $nestedsums_config_micro_version);
        printf("*** corresponds to %d.%d.%d. This mismatch suggests your installation of nestedsums\n", NESTEDSUMS_MAJOR, NESTEDSUMS_MINOR, NESTEDSUMS_MICRO);
        printf("*** is corrupted or you have specified some wrong -I compiler flags.\n");
        printf("*** Please inquire and consider reinstalling nestedsums.\n");
        return 1;
    }
    if ((nestedsums::version_major != $nestedsums_config_major_version) ||
        (nestedsums::version_minor != $nestedsums_config_minor_version) ||
        (nestedsums::version_micro != $nestedsums_config_micro_version)) {
        printf("\n*** 'nestedsums-config --version' returned %d.%d.%d, but the library I found\n", $nestedsums_config_major_version, $nestedsums_config_minor_version, $nestedsums_config_micro_version);
        printf("*** corresponds to %d.%d.%d. This mismatch suggests your installation of nestedsums\n", nestedsums::version_major, nestedsums::version_minor, nestedsums::version_micro);
        printf("*** is corrupted or you have specified some wrong -L compiler flags.\n");
        printf("*** Please inquire and consider reinstalling nestedsums.\n");
        return 1;
    }
    return 0;
}
],, no_nestedsums=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
            CPPFLAGS="$ac_save_CPPFLAGS"
            LIBS="$ac_save_LIBS"
        fi
        if test "x$no_nestedsums" = x ; then
            AC_MSG_RESULT([yes, $nestedsums_config_version])
            ifelse([$2], , :, [$2])
        else
            AC_MSG_RESULT(no)
            if test ! -f conf.nestedsumstest ; then
                echo "*** Could not run nestedsums test program, checking why..."
                CPPFLAGS="$CFLAGS $NESTEDSUMS_CPPFLAGS"
                LIBS="$LIBS $NESTEDSUMS_LIBS"
                AC_TRY_LINK([
#include <stdio.h>
#include <nestedsums/version.h>
],              [ return 0; ],
                [ echo "*** The test program compiled, but did not run. This usually means"
                  echo "*** that the run-time linker is not finding nestedsums or finding the wrong"
                  echo "*** version of nestedsums. If it is not finding nestedsums, you'll need to set your"
                  echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
                  echo "*** to the installed location. Also, make sure you have run ldconfig if that"
                  echo "*** is required on your system."],
                [ echo "*** The test program failed to compile or link. See the file config.log for the"
                  echo "*** exact error that occured. This usually means nestedsums was incorrectly installed"
                  echo "*** or that you have moved nestedsums since it was installed. In the latter case, you"
                  echo "*** may want to edit the nestedsums-config script: $NESTEDSUMS_CONFIG." ])
                CPPFLAGS="$ac_save_CPPFLAGS"
                LIBS="$ac_save_LIBS"
            fi
            NESTEDSUMS_CPPFLAGS=""
            NESTEDSUMS_LIBS=""
            ifelse([$3], , :, [$3])
        fi
    fi
fi
AC_SUBST(NESTEDSUMS_CPPFLAGS)
AC_SUBST(NESTEDSUMS_LIBS)
rm -f conf.nestedsumstest
])
