// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-tracer'; DO NOT EDIT

package trace

import (
	"context"
	"encoding/json"
	"log"
	"sync"

	"github.com/sacloud/iaas-api-go"
	"github.com/sacloud/iaas-api-go/types"
)

var initOnce sync.Once

// AddClientFactoryHooks add client factory hooks
func AddClientFactoryHooks() {
	initOnce.Do(func() {
		addClientFactoryHooks()
	})
}

func addClientFactoryHooks() {
	iaas.AddClientFacotyHookFunc("Archive", func(in interface{}) interface{} {
		return NewArchiveTracer(in.(iaas.ArchiveAPI))
	})
	iaas.AddClientFacotyHookFunc("AuthStatus", func(in interface{}) interface{} {
		return NewAuthStatusTracer(in.(iaas.AuthStatusAPI))
	})
	iaas.AddClientFacotyHookFunc("AutoBackup", func(in interface{}) interface{} {
		return NewAutoBackupTracer(in.(iaas.AutoBackupAPI))
	})
	iaas.AddClientFacotyHookFunc("AutoScale", func(in interface{}) interface{} {
		return NewAutoScaleTracer(in.(iaas.AutoScaleAPI))
	})
	iaas.AddClientFacotyHookFunc("Bill", func(in interface{}) interface{} {
		return NewBillTracer(in.(iaas.BillAPI))
	})
	iaas.AddClientFacotyHookFunc("Bridge", func(in interface{}) interface{} {
		return NewBridgeTracer(in.(iaas.BridgeAPI))
	})
	iaas.AddClientFacotyHookFunc("CDROM", func(in interface{}) interface{} {
		return NewCDROMTracer(in.(iaas.CDROMAPI))
	})
	iaas.AddClientFacotyHookFunc("CertificateAuthority", func(in interface{}) interface{} {
		return NewCertificateAuthorityTracer(in.(iaas.CertificateAuthorityAPI))
	})
	iaas.AddClientFacotyHookFunc("ContainerRegistry", func(in interface{}) interface{} {
		return NewContainerRegistryTracer(in.(iaas.ContainerRegistryAPI))
	})
	iaas.AddClientFacotyHookFunc("Coupon", func(in interface{}) interface{} {
		return NewCouponTracer(in.(iaas.CouponAPI))
	})
	iaas.AddClientFacotyHookFunc("Database", func(in interface{}) interface{} {
		return NewDatabaseTracer(in.(iaas.DatabaseAPI))
	})
	iaas.AddClientFacotyHookFunc("Disk", func(in interface{}) interface{} {
		return NewDiskTracer(in.(iaas.DiskAPI))
	})
	iaas.AddClientFacotyHookFunc("DiskPlan", func(in interface{}) interface{} {
		return NewDiskPlanTracer(in.(iaas.DiskPlanAPI))
	})
	iaas.AddClientFacotyHookFunc("DNS", func(in interface{}) interface{} {
		return NewDNSTracer(in.(iaas.DNSAPI))
	})
	iaas.AddClientFacotyHookFunc("EnhancedDB", func(in interface{}) interface{} {
		return NewEnhancedDBTracer(in.(iaas.EnhancedDBAPI))
	})
	iaas.AddClientFacotyHookFunc("ESME", func(in interface{}) interface{} {
		return NewESMETracer(in.(iaas.ESMEAPI))
	})
	iaas.AddClientFacotyHookFunc("GSLB", func(in interface{}) interface{} {
		return NewGSLBTracer(in.(iaas.GSLBAPI))
	})
	iaas.AddClientFacotyHookFunc("Icon", func(in interface{}) interface{} {
		return NewIconTracer(in.(iaas.IconAPI))
	})
	iaas.AddClientFacotyHookFunc("Interface", func(in interface{}) interface{} {
		return NewInterfaceTracer(in.(iaas.InterfaceAPI))
	})
	iaas.AddClientFacotyHookFunc("Internet", func(in interface{}) interface{} {
		return NewInternetTracer(in.(iaas.InternetAPI))
	})
	iaas.AddClientFacotyHookFunc("InternetPlan", func(in interface{}) interface{} {
		return NewInternetPlanTracer(in.(iaas.InternetPlanAPI))
	})
	iaas.AddClientFacotyHookFunc("IPAddress", func(in interface{}) interface{} {
		return NewIPAddressTracer(in.(iaas.IPAddressAPI))
	})
	iaas.AddClientFacotyHookFunc("IPv6Net", func(in interface{}) interface{} {
		return NewIPv6NetTracer(in.(iaas.IPv6NetAPI))
	})
	iaas.AddClientFacotyHookFunc("IPv6Addr", func(in interface{}) interface{} {
		return NewIPv6AddrTracer(in.(iaas.IPv6AddrAPI))
	})
	iaas.AddClientFacotyHookFunc("License", func(in interface{}) interface{} {
		return NewLicenseTracer(in.(iaas.LicenseAPI))
	})
	iaas.AddClientFacotyHookFunc("LicenseInfo", func(in interface{}) interface{} {
		return NewLicenseInfoTracer(in.(iaas.LicenseInfoAPI))
	})
	iaas.AddClientFacotyHookFunc("LoadBalancer", func(in interface{}) interface{} {
		return NewLoadBalancerTracer(in.(iaas.LoadBalancerAPI))
	})
	iaas.AddClientFacotyHookFunc("LocalRouter", func(in interface{}) interface{} {
		return NewLocalRouterTracer(in.(iaas.LocalRouterAPI))
	})
	iaas.AddClientFacotyHookFunc("MobileGateway", func(in interface{}) interface{} {
		return NewMobileGatewayTracer(in.(iaas.MobileGatewayAPI))
	})
	iaas.AddClientFacotyHookFunc("NFS", func(in interface{}) interface{} {
		return NewNFSTracer(in.(iaas.NFSAPI))
	})
	iaas.AddClientFacotyHookFunc("Note", func(in interface{}) interface{} {
		return NewNoteTracer(in.(iaas.NoteAPI))
	})
	iaas.AddClientFacotyHookFunc("PacketFilter", func(in interface{}) interface{} {
		return NewPacketFilterTracer(in.(iaas.PacketFilterAPI))
	})
	iaas.AddClientFacotyHookFunc("PrivateHost", func(in interface{}) interface{} {
		return NewPrivateHostTracer(in.(iaas.PrivateHostAPI))
	})
	iaas.AddClientFacotyHookFunc("PrivateHostPlan", func(in interface{}) interface{} {
		return NewPrivateHostPlanTracer(in.(iaas.PrivateHostPlanAPI))
	})
	iaas.AddClientFacotyHookFunc("ProxyLB", func(in interface{}) interface{} {
		return NewProxyLBTracer(in.(iaas.ProxyLBAPI))
	})
	iaas.AddClientFacotyHookFunc("Region", func(in interface{}) interface{} {
		return NewRegionTracer(in.(iaas.RegionAPI))
	})
	iaas.AddClientFacotyHookFunc("Server", func(in interface{}) interface{} {
		return NewServerTracer(in.(iaas.ServerAPI))
	})
	iaas.AddClientFacotyHookFunc("ServerPlan", func(in interface{}) interface{} {
		return NewServerPlanTracer(in.(iaas.ServerPlanAPI))
	})
	iaas.AddClientFacotyHookFunc("ServiceClass", func(in interface{}) interface{} {
		return NewServiceClassTracer(in.(iaas.ServiceClassAPI))
	})
	iaas.AddClientFacotyHookFunc("SIM", func(in interface{}) interface{} {
		return NewSIMTracer(in.(iaas.SIMAPI))
	})
	iaas.AddClientFacotyHookFunc("SimpleMonitor", func(in interface{}) interface{} {
		return NewSimpleMonitorTracer(in.(iaas.SimpleMonitorAPI))
	})
	iaas.AddClientFacotyHookFunc("SimpleNotificationDestination", func(in interface{}) interface{} {
		return NewSimpleNotificationDestinationTracer(in.(iaas.SimpleNotificationDestinationAPI))
	})
	iaas.AddClientFacotyHookFunc("SimpleNotificationGroup", func(in interface{}) interface{} {
		return NewSimpleNotificationGroupTracer(in.(iaas.SimpleNotificationGroupAPI))
	})
	iaas.AddClientFacotyHookFunc("SSHKey", func(in interface{}) interface{} {
		return NewSSHKeyTracer(in.(iaas.SSHKeyAPI))
	})
	iaas.AddClientFacotyHookFunc("Subnet", func(in interface{}) interface{} {
		return NewSubnetTracer(in.(iaas.SubnetAPI))
	})
	iaas.AddClientFacotyHookFunc("Switch", func(in interface{}) interface{} {
		return NewSwitchTracer(in.(iaas.SwitchAPI))
	})
	iaas.AddClientFacotyHookFunc("VPCRouter", func(in interface{}) interface{} {
		return NewVPCRouterTracer(in.(iaas.VPCRouterAPI))
	})
	iaas.AddClientFacotyHookFunc("Zone", func(in interface{}) interface{} {
		return NewZoneTracer(in.(iaas.ZoneAPI))
	})
}

/*************************************************
* ArchiveTracer
*************************************************/

// ArchiveTracer is for trace ArchiveOp operations
type ArchiveTracer struct {
	Internal iaas.ArchiveAPI
}

// NewArchiveTracer creates new ArchiveTracer instance
func NewArchiveTracer(in iaas.ArchiveAPI) iaas.ArchiveAPI {
	return &ArchiveTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ArchiveTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ArchiveFindResult, error) {
	log.Println("[TRACE] ArchiveAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.ArchiveFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *ArchiveTracer) Create(ctx context.Context, zone string, param *iaas.ArchiveCreateRequest) (*iaas.Archive, error) {
	log.Println("[TRACE] ArchiveAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.ArchiveCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Create end")
	}()

	resultArchive, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Archive *iaas.Archive
		Error   error
	}{
		Archive: resultArchive,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchive, err
}

// CreateBlank is API call with trace log
func (t *ArchiveTracer) CreateBlank(ctx context.Context, zone string, param *iaas.ArchiveCreateBlankRequest) (*iaas.Archive, *iaas.FTPServer, error) {
	log.Println("[TRACE] ArchiveAPI.CreateBlank start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.ArchiveCreateBlankRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.CreateBlank end")
	}()

	resultArchive, resultFTPServer, err := t.Internal.CreateBlank(ctx, zone, param)
	targetResults := struct {
		Archive   *iaas.Archive
		FTPServer *iaas.FTPServer
		Error     error
	}{
		Archive:   resultArchive,
		FTPServer: resultFTPServer,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchive, resultFTPServer, err
}

// Read is API call with trace log
func (t *ArchiveTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Archive, error) {
	log.Println("[TRACE] ArchiveAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Read end")
	}()

	resultArchive, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Archive *iaas.Archive
		Error   error
	}{
		Archive: resultArchive,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchive, err
}

// Update is API call with trace log
func (t *ArchiveTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.ArchiveUpdateRequest) (*iaas.Archive, error) {
	log.Println("[TRACE] ArchiveAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                   `json:"id"`
		Argparam *iaas.ArchiveUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Update end")
	}()

	resultArchive, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Archive *iaas.Archive
		Error   error
	}{
		Archive: resultArchive,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchive, err
}

// Delete is API call with trace log
func (t *ArchiveTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] ArchiveAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// OpenFTP is API call with trace log
func (t *ArchiveTracer) OpenFTP(ctx context.Context, zone string, id types.ID, openOption *iaas.OpenFTPRequest) (*iaas.FTPServer, error) {
	log.Println("[TRACE] ArchiveAPI.OpenFTP start")
	targetArguments := struct {
		Argzone       string
		Argid         types.ID             `json:"id"`
		ArgopenOption *iaas.OpenFTPRequest `json:"openOption"`
	}{
		Argzone:       zone,
		Argid:         id,
		ArgopenOption: openOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.OpenFTP end")
	}()

	resultFTPServer, err := t.Internal.OpenFTP(ctx, zone, id, openOption)
	targetResults := struct {
		FTPServer *iaas.FTPServer
		Error     error
	}{
		FTPServer: resultFTPServer,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultFTPServer, err
}

// CloseFTP is API call with trace log
func (t *ArchiveTracer) CloseFTP(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] ArchiveAPI.CloseFTP start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.CloseFTP end")
	}()

	err := t.Internal.CloseFTP(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Share is API call with trace log
func (t *ArchiveTracer) Share(ctx context.Context, zone string, id types.ID) (*iaas.ArchiveShareInfo, error) {
	log.Println("[TRACE] ArchiveAPI.Share start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Share end")
	}()

	resultArchiveShareInfo, err := t.Internal.Share(ctx, zone, id)
	targetResults := struct {
		ArchiveShareInfo *iaas.ArchiveShareInfo
		Error            error
	}{
		ArchiveShareInfo: resultArchiveShareInfo,
		Error:            err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchiveShareInfo, err
}

// CreateFromShared is API call with trace log
func (t *ArchiveTracer) CreateFromShared(ctx context.Context, zone string, sourceArchiveID types.ID, destZoneID types.ID, param *iaas.ArchiveCreateRequestFromShared) (*iaas.Archive, error) {
	log.Println("[TRACE] ArchiveAPI.CreateFromShared start")
	targetArguments := struct {
		Argzone            string
		ArgsourceArchiveID types.ID                             `json:"sourceArchiveID"`
		ArgdestZoneID      types.ID                             `json:"destZoneID"`
		Argparam           *iaas.ArchiveCreateRequestFromShared `json:"param"`
	}{
		Argzone:            zone,
		ArgsourceArchiveID: sourceArchiveID,
		ArgdestZoneID:      destZoneID,
		Argparam:           param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.CreateFromShared end")
	}()

	resultArchive, err := t.Internal.CreateFromShared(ctx, zone, sourceArchiveID, destZoneID, param)
	targetResults := struct {
		Archive *iaas.Archive
		Error   error
	}{
		Archive: resultArchive,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchive, err
}

// Transfer is API call with trace log
func (t *ArchiveTracer) Transfer(ctx context.Context, zone string, sourceArchiveID types.ID, destZoneID types.ID, param *iaas.ArchiveTransferRequest) (*iaas.Archive, error) {
	log.Println("[TRACE] ArchiveAPI.Transfer start")
	targetArguments := struct {
		Argzone            string
		ArgsourceArchiveID types.ID                     `json:"sourceArchiveID"`
		ArgdestZoneID      types.ID                     `json:"destZoneID"`
		Argparam           *iaas.ArchiveTransferRequest `json:"param"`
	}{
		Argzone:            zone,
		ArgsourceArchiveID: sourceArchiveID,
		ArgdestZoneID:      destZoneID,
		Argparam:           param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ArchiveAPI.Transfer end")
	}()

	resultArchive, err := t.Internal.Transfer(ctx, zone, sourceArchiveID, destZoneID, param)
	targetResults := struct {
		Archive *iaas.Archive
		Error   error
	}{
		Archive: resultArchive,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultArchive, err
}

/*************************************************
* AuthStatusTracer
*************************************************/

// AuthStatusTracer is for trace AuthStatusOp operations
type AuthStatusTracer struct {
	Internal iaas.AuthStatusAPI
}

// NewAuthStatusTracer creates new AuthStatusTracer instance
func NewAuthStatusTracer(in iaas.AuthStatusAPI) iaas.AuthStatusAPI {
	return &AuthStatusTracer{
		Internal: in,
	}
}

// Read is API call with trace log
func (t *AuthStatusTracer) Read(ctx context.Context) (*iaas.AuthStatus, error) {
	log.Println("[TRACE] AuthStatusAPI.Read start")
	targetArguments := struct {
	}{}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AuthStatusAPI.Read end")
	}()

	resultAuthStatus, err := t.Internal.Read(ctx)
	targetResults := struct {
		AuthStatus *iaas.AuthStatus
		Error      error
	}{
		AuthStatus: resultAuthStatus,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAuthStatus, err
}

/*************************************************
* AutoBackupTracer
*************************************************/

// AutoBackupTracer is for trace AutoBackupOp operations
type AutoBackupTracer struct {
	Internal iaas.AutoBackupAPI
}

// NewAutoBackupTracer creates new AutoBackupTracer instance
func NewAutoBackupTracer(in iaas.AutoBackupAPI) iaas.AutoBackupAPI {
	return &AutoBackupTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *AutoBackupTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.AutoBackupFindResult, error) {
	log.Println("[TRACE] AutoBackupAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoBackupAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.AutoBackupFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *AutoBackupTracer) Create(ctx context.Context, zone string, param *iaas.AutoBackupCreateRequest) (*iaas.AutoBackup, error) {
	log.Println("[TRACE] AutoBackupAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.AutoBackupCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoBackupAPI.Create end")
	}()

	resultAutoBackup, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		AutoBackup *iaas.AutoBackup
		Error      error
	}{
		AutoBackup: resultAutoBackup,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoBackup, err
}

// Read is API call with trace log
func (t *AutoBackupTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.AutoBackup, error) {
	log.Println("[TRACE] AutoBackupAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoBackupAPI.Read end")
	}()

	resultAutoBackup, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		AutoBackup *iaas.AutoBackup
		Error      error
	}{
		AutoBackup: resultAutoBackup,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoBackup, err
}

// Update is API call with trace log
func (t *AutoBackupTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.AutoBackupUpdateRequest) (*iaas.AutoBackup, error) {
	log.Println("[TRACE] AutoBackupAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                      `json:"id"`
		Argparam *iaas.AutoBackupUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoBackupAPI.Update end")
	}()

	resultAutoBackup, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		AutoBackup *iaas.AutoBackup
		Error      error
	}{
		AutoBackup: resultAutoBackup,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoBackup, err
}

// UpdateSettings is API call with trace log
func (t *AutoBackupTracer) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.AutoBackupUpdateSettingsRequest) (*iaas.AutoBackup, error) {
	log.Println("[TRACE] AutoBackupAPI.UpdateSettings start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                              `json:"id"`
		Argparam *iaas.AutoBackupUpdateSettingsRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoBackupAPI.UpdateSettings end")
	}()

	resultAutoBackup, err := t.Internal.UpdateSettings(ctx, zone, id, param)
	targetResults := struct {
		AutoBackup *iaas.AutoBackup
		Error      error
	}{
		AutoBackup: resultAutoBackup,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoBackup, err
}

// Delete is API call with trace log
func (t *AutoBackupTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] AutoBackupAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoBackupAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* AutoScaleTracer
*************************************************/

// AutoScaleTracer is for trace AutoScaleOp operations
type AutoScaleTracer struct {
	Internal iaas.AutoScaleAPI
}

// NewAutoScaleTracer creates new AutoScaleTracer instance
func NewAutoScaleTracer(in iaas.AutoScaleAPI) iaas.AutoScaleAPI {
	return &AutoScaleTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *AutoScaleTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.AutoScaleFindResult, error) {
	log.Println("[TRACE] AutoScaleAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.AutoScaleFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *AutoScaleTracer) Create(ctx context.Context, param *iaas.AutoScaleCreateRequest) (*iaas.AutoScale, error) {
	log.Println("[TRACE] AutoScaleAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.AutoScaleCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.Create end")
	}()

	resultAutoScale, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		AutoScale *iaas.AutoScale
		Error     error
	}{
		AutoScale: resultAutoScale,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoScale, err
}

// Read is API call with trace log
func (t *AutoScaleTracer) Read(ctx context.Context, id types.ID) (*iaas.AutoScale, error) {
	log.Println("[TRACE] AutoScaleAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.Read end")
	}()

	resultAutoScale, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		AutoScale *iaas.AutoScale
		Error     error
	}{
		AutoScale: resultAutoScale,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoScale, err
}

// Update is API call with trace log
func (t *AutoScaleTracer) Update(ctx context.Context, id types.ID, param *iaas.AutoScaleUpdateRequest) (*iaas.AutoScale, error) {
	log.Println("[TRACE] AutoScaleAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                     `json:"id"`
		Argparam *iaas.AutoScaleUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.Update end")
	}()

	resultAutoScale, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		AutoScale *iaas.AutoScale
		Error     error
	}{
		AutoScale: resultAutoScale,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoScale, err
}

// UpdateSettings is API call with trace log
func (t *AutoScaleTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.AutoScaleUpdateSettingsRequest) (*iaas.AutoScale, error) {
	log.Println("[TRACE] AutoScaleAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                             `json:"id"`
		Argparam *iaas.AutoScaleUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.UpdateSettings end")
	}()

	resultAutoScale, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		AutoScale *iaas.AutoScale
		Error     error
	}{
		AutoScale: resultAutoScale,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoScale, err
}

// Delete is API call with trace log
func (t *AutoScaleTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] AutoScaleAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Status is API call with trace log
func (t *AutoScaleTracer) Status(ctx context.Context, id types.ID) (*iaas.AutoScaleStatus, error) {
	log.Println("[TRACE] AutoScaleAPI.Status start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.Status end")
	}()

	resultAutoScaleStatus, err := t.Internal.Status(ctx, id)
	targetResults := struct {
		AutoScaleStatus *iaas.AutoScaleStatus
		Error           error
	}{
		AutoScaleStatus: resultAutoScaleStatus,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultAutoScaleStatus, err
}

// ScaleUp is API call with trace log
func (t *AutoScaleTracer) ScaleUp(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] AutoScaleAPI.ScaleUp start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.ScaleUp end")
	}()

	err := t.Internal.ScaleUp(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ScaleDown is API call with trace log
func (t *AutoScaleTracer) ScaleDown(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] AutoScaleAPI.ScaleDown start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] AutoScaleAPI.ScaleDown end")
	}()

	err := t.Internal.ScaleDown(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* BillTracer
*************************************************/

// BillTracer is for trace BillOp operations
type BillTracer struct {
	Internal iaas.BillAPI
}

// NewBillTracer creates new BillTracer instance
func NewBillTracer(in iaas.BillAPI) iaas.BillAPI {
	return &BillTracer{
		Internal: in,
	}
}

// ByContract is API call with trace log
func (t *BillTracer) ByContract(ctx context.Context, accountID types.ID) (*iaas.BillByContractResult, error) {
	log.Println("[TRACE] BillAPI.ByContract start")
	targetArguments := struct {
		ArgaccountID types.ID `json:"accountID"`
	}{
		ArgaccountID: accountID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BillAPI.ByContract end")
	}()

	result, err := t.Internal.ByContract(ctx, accountID)
	targetResults := struct {
		Result *iaas.BillByContractResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// ByContractYear is API call with trace log
func (t *BillTracer) ByContractYear(ctx context.Context, accountID types.ID, year int) (*iaas.BillByContractYearResult, error) {
	log.Println("[TRACE] BillAPI.ByContractYear start")
	targetArguments := struct {
		ArgaccountID types.ID `json:"accountID"`
		Argyear      int      `json:"year"`
	}{
		ArgaccountID: accountID,
		Argyear:      year,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BillAPI.ByContractYear end")
	}()

	result, err := t.Internal.ByContractYear(ctx, accountID, year)
	targetResults := struct {
		Result *iaas.BillByContractYearResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// ByContractYearMonth is API call with trace log
func (t *BillTracer) ByContractYearMonth(ctx context.Context, accountID types.ID, year int, month int) (*iaas.BillByContractYearMonthResult, error) {
	log.Println("[TRACE] BillAPI.ByContractYearMonth start")
	targetArguments := struct {
		ArgaccountID types.ID `json:"accountID"`
		Argyear      int      `json:"year"`
		Argmonth     int      `json:"month"`
	}{
		ArgaccountID: accountID,
		Argyear:      year,
		Argmonth:     month,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BillAPI.ByContractYearMonth end")
	}()

	result, err := t.Internal.ByContractYearMonth(ctx, accountID, year, month)
	targetResults := struct {
		Result *iaas.BillByContractYearMonthResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *BillTracer) Read(ctx context.Context, id types.ID) (*iaas.BillReadResult, error) {
	log.Println("[TRACE] BillAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BillAPI.Read end")
	}()

	result, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		Result *iaas.BillReadResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Details is API call with trace log
func (t *BillTracer) Details(ctx context.Context, MemberCode string, id types.ID) (*iaas.BillDetailsResult, error) {
	log.Println("[TRACE] BillAPI.Details start")
	targetArguments := struct {
		ArgMemberCode string   `json:"MemberCode"`
		Argid         types.ID `json:"id"`
	}{
		ArgMemberCode: MemberCode,
		Argid:         id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BillAPI.Details end")
	}()

	result, err := t.Internal.Details(ctx, MemberCode, id)
	targetResults := struct {
		Result *iaas.BillDetailsResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// DetailsCSV is API call with trace log
func (t *BillTracer) DetailsCSV(ctx context.Context, MemberCode string, id types.ID) (*iaas.BillDetailCSV, error) {
	log.Println("[TRACE] BillAPI.DetailsCSV start")
	targetArguments := struct {
		ArgMemberCode string   `json:"MemberCode"`
		Argid         types.ID `json:"id"`
	}{
		ArgMemberCode: MemberCode,
		Argid:         id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BillAPI.DetailsCSV end")
	}()

	resultBillDetailCSV, err := t.Internal.DetailsCSV(ctx, MemberCode, id)
	targetResults := struct {
		BillDetailCSV *iaas.BillDetailCSV
		Error         error
	}{
		BillDetailCSV: resultBillDetailCSV,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultBillDetailCSV, err
}

/*************************************************
* BridgeTracer
*************************************************/

// BridgeTracer is for trace BridgeOp operations
type BridgeTracer struct {
	Internal iaas.BridgeAPI
}

// NewBridgeTracer creates new BridgeTracer instance
func NewBridgeTracer(in iaas.BridgeAPI) iaas.BridgeAPI {
	return &BridgeTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *BridgeTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.BridgeFindResult, error) {
	log.Println("[TRACE] BridgeAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BridgeAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.BridgeFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *BridgeTracer) Create(ctx context.Context, zone string, param *iaas.BridgeCreateRequest) (*iaas.Bridge, error) {
	log.Println("[TRACE] BridgeAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.BridgeCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BridgeAPI.Create end")
	}()

	resultBridge, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Bridge *iaas.Bridge
		Error  error
	}{
		Bridge: resultBridge,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultBridge, err
}

// Read is API call with trace log
func (t *BridgeTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Bridge, error) {
	log.Println("[TRACE] BridgeAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BridgeAPI.Read end")
	}()

	resultBridge, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Bridge *iaas.Bridge
		Error  error
	}{
		Bridge: resultBridge,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultBridge, err
}

// Update is API call with trace log
func (t *BridgeTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.BridgeUpdateRequest) (*iaas.Bridge, error) {
	log.Println("[TRACE] BridgeAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                  `json:"id"`
		Argparam *iaas.BridgeUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BridgeAPI.Update end")
	}()

	resultBridge, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Bridge *iaas.Bridge
		Error  error
	}{
		Bridge: resultBridge,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultBridge, err
}

// Delete is API call with trace log
func (t *BridgeTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] BridgeAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] BridgeAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* CDROMTracer
*************************************************/

// CDROMTracer is for trace CDROMOp operations
type CDROMTracer struct {
	Internal iaas.CDROMAPI
}

// NewCDROMTracer creates new CDROMTracer instance
func NewCDROMTracer(in iaas.CDROMAPI) iaas.CDROMAPI {
	return &CDROMTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *CDROMTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.CDROMFindResult, error) {
	log.Println("[TRACE] CDROMAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.CDROMFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *CDROMTracer) Create(ctx context.Context, zone string, param *iaas.CDROMCreateRequest) (*iaas.CDROM, *iaas.FTPServer, error) {
	log.Println("[TRACE] CDROMAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.CDROMCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.Create end")
	}()

	resultCDROM, resultFTPServer, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		CDROM     *iaas.CDROM
		FTPServer *iaas.FTPServer
		Error     error
	}{
		CDROM:     resultCDROM,
		FTPServer: resultFTPServer,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCDROM, resultFTPServer, err
}

// Read is API call with trace log
func (t *CDROMTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.CDROM, error) {
	log.Println("[TRACE] CDROMAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.Read end")
	}()

	resultCDROM, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		CDROM *iaas.CDROM
		Error error
	}{
		CDROM: resultCDROM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCDROM, err
}

// Update is API call with trace log
func (t *CDROMTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.CDROMUpdateRequest) (*iaas.CDROM, error) {
	log.Println("[TRACE] CDROMAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                 `json:"id"`
		Argparam *iaas.CDROMUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.Update end")
	}()

	resultCDROM, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		CDROM *iaas.CDROM
		Error error
	}{
		CDROM: resultCDROM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCDROM, err
}

// Delete is API call with trace log
func (t *CDROMTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] CDROMAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// OpenFTP is API call with trace log
func (t *CDROMTracer) OpenFTP(ctx context.Context, zone string, id types.ID, openOption *iaas.OpenFTPRequest) (*iaas.FTPServer, error) {
	log.Println("[TRACE] CDROMAPI.OpenFTP start")
	targetArguments := struct {
		Argzone       string
		Argid         types.ID             `json:"id"`
		ArgopenOption *iaas.OpenFTPRequest `json:"openOption"`
	}{
		Argzone:       zone,
		Argid:         id,
		ArgopenOption: openOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.OpenFTP end")
	}()

	resultFTPServer, err := t.Internal.OpenFTP(ctx, zone, id, openOption)
	targetResults := struct {
		FTPServer *iaas.FTPServer
		Error     error
	}{
		FTPServer: resultFTPServer,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultFTPServer, err
}

// CloseFTP is API call with trace log
func (t *CDROMTracer) CloseFTP(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] CDROMAPI.CloseFTP start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CDROMAPI.CloseFTP end")
	}()

	err := t.Internal.CloseFTP(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* CertificateAuthorityTracer
*************************************************/

// CertificateAuthorityTracer is for trace CertificateAuthorityOp operations
type CertificateAuthorityTracer struct {
	Internal iaas.CertificateAuthorityAPI
}

// NewCertificateAuthorityTracer creates new CertificateAuthorityTracer instance
func NewCertificateAuthorityTracer(in iaas.CertificateAuthorityAPI) iaas.CertificateAuthorityAPI {
	return &CertificateAuthorityTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *CertificateAuthorityTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.CertificateAuthorityFindResult, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.CertificateAuthorityFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *CertificateAuthorityTracer) Create(ctx context.Context, param *iaas.CertificateAuthorityCreateRequest) (*iaas.CertificateAuthority, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.CertificateAuthorityCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.Create end")
	}()

	resultCertificateAuthority, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthority
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// Read is API call with trace log
func (t *CertificateAuthorityTracer) Read(ctx context.Context, id types.ID) (*iaas.CertificateAuthority, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.Read end")
	}()

	resultCertificateAuthority, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthority
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// Update is API call with trace log
func (t *CertificateAuthorityTracer) Update(ctx context.Context, id types.ID, param *iaas.CertificateAuthorityUpdateRequest) (*iaas.CertificateAuthority, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                                `json:"id"`
		Argparam *iaas.CertificateAuthorityUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.Update end")
	}()

	resultCertificateAuthority, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthority
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// Delete is API call with trace log
func (t *CertificateAuthorityTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] CertificateAuthorityAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Detail is API call with trace log
func (t *CertificateAuthorityTracer) Detail(ctx context.Context, id types.ID) (*iaas.CertificateAuthorityDetail, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.Detail start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.Detail end")
	}()

	resultCertificateAuthority, err := t.Internal.Detail(ctx, id)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthorityDetail
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// AddClient is API call with trace log
func (t *CertificateAuthorityTracer) AddClient(ctx context.Context, id types.ID, param *iaas.CertificateAuthorityAddClientParam) (*iaas.CertificateAuthorityAddClientOrServerResult, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.AddClient start")
	targetArguments := struct {
		Argid    types.ID                                 `json:"id"`
		Argparam *iaas.CertificateAuthorityAddClientParam `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.AddClient end")
	}()

	resultCertificateAuthority, err := t.Internal.AddClient(ctx, id, param)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthorityAddClientOrServerResult
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// ListClients is API call with trace log
func (t *CertificateAuthorityTracer) ListClients(ctx context.Context, id types.ID) (*iaas.CertificateAuthorityListClientsResult, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.ListClients start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.ListClients end")
	}()

	result, err := t.Internal.ListClients(ctx, id)
	targetResults := struct {
		Result *iaas.CertificateAuthorityListClientsResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// ReadClient is API call with trace log
func (t *CertificateAuthorityTracer) ReadClient(ctx context.Context, id types.ID, clientID string) (*iaas.CertificateAuthorityClient, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.ReadClient start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgclientID string   `json:"clientID"`
	}{
		Argid:       id,
		ArgclientID: clientID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.ReadClient end")
	}()

	resultCertificateAuthority, err := t.Internal.ReadClient(ctx, id, clientID)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthorityClient
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// RevokeClient is API call with trace log
func (t *CertificateAuthorityTracer) RevokeClient(ctx context.Context, id types.ID, clientID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.RevokeClient start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgclientID string   `json:"clientID"`
	}{
		Argid:       id,
		ArgclientID: clientID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.RevokeClient end")
	}()

	err := t.Internal.RevokeClient(ctx, id, clientID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// HoldClient is API call with trace log
func (t *CertificateAuthorityTracer) HoldClient(ctx context.Context, id types.ID, clientID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.HoldClient start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgclientID string   `json:"clientID"`
	}{
		Argid:       id,
		ArgclientID: clientID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.HoldClient end")
	}()

	err := t.Internal.HoldClient(ctx, id, clientID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ResumeClient is API call with trace log
func (t *CertificateAuthorityTracer) ResumeClient(ctx context.Context, id types.ID, clientID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.ResumeClient start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgclientID string   `json:"clientID"`
	}{
		Argid:       id,
		ArgclientID: clientID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.ResumeClient end")
	}()

	err := t.Internal.ResumeClient(ctx, id, clientID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DenyClient is API call with trace log
func (t *CertificateAuthorityTracer) DenyClient(ctx context.Context, id types.ID, clientID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.DenyClient start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgclientID string   `json:"clientID"`
	}{
		Argid:       id,
		ArgclientID: clientID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.DenyClient end")
	}()

	err := t.Internal.DenyClient(ctx, id, clientID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// AddServer is API call with trace log
func (t *CertificateAuthorityTracer) AddServer(ctx context.Context, id types.ID, param *iaas.CertificateAuthorityAddServerParam) (*iaas.CertificateAuthorityAddClientOrServerResult, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.AddServer start")
	targetArguments := struct {
		Argid    types.ID                                 `json:"id"`
		Argparam *iaas.CertificateAuthorityAddServerParam `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.AddServer end")
	}()

	resultCertificateAuthority, err := t.Internal.AddServer(ctx, id, param)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthorityAddClientOrServerResult
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// ListServers is API call with trace log
func (t *CertificateAuthorityTracer) ListServers(ctx context.Context, id types.ID) (*iaas.CertificateAuthorityListServersResult, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.ListServers start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.ListServers end")
	}()

	result, err := t.Internal.ListServers(ctx, id)
	targetResults := struct {
		Result *iaas.CertificateAuthorityListServersResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// ReadServer is API call with trace log
func (t *CertificateAuthorityTracer) ReadServer(ctx context.Context, id types.ID, serverID string) (*iaas.CertificateAuthorityServer, error) {
	log.Println("[TRACE] CertificateAuthorityAPI.ReadServer start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgserverID string   `json:"serverID"`
	}{
		Argid:       id,
		ArgserverID: serverID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.ReadServer end")
	}()

	resultCertificateAuthority, err := t.Internal.ReadServer(ctx, id, serverID)
	targetResults := struct {
		CertificateAuthority *iaas.CertificateAuthorityServer
		Error                error
	}{
		CertificateAuthority: resultCertificateAuthority,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCertificateAuthority, err
}

// RevokeServer is API call with trace log
func (t *CertificateAuthorityTracer) RevokeServer(ctx context.Context, id types.ID, serverID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.RevokeServer start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgserverID string   `json:"serverID"`
	}{
		Argid:       id,
		ArgserverID: serverID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.RevokeServer end")
	}()

	err := t.Internal.RevokeServer(ctx, id, serverID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// HoldServer is API call with trace log
func (t *CertificateAuthorityTracer) HoldServer(ctx context.Context, id types.ID, serverID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.HoldServer start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgserverID string   `json:"serverID"`
	}{
		Argid:       id,
		ArgserverID: serverID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.HoldServer end")
	}()

	err := t.Internal.HoldServer(ctx, id, serverID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ResumeServer is API call with trace log
func (t *CertificateAuthorityTracer) ResumeServer(ctx context.Context, id types.ID, serverID string) error {
	log.Println("[TRACE] CertificateAuthorityAPI.ResumeServer start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		ArgserverID string   `json:"serverID"`
	}{
		Argid:       id,
		ArgserverID: serverID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CertificateAuthorityAPI.ResumeServer end")
	}()

	err := t.Internal.ResumeServer(ctx, id, serverID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* ContainerRegistryTracer
*************************************************/

// ContainerRegistryTracer is for trace ContainerRegistryOp operations
type ContainerRegistryTracer struct {
	Internal iaas.ContainerRegistryAPI
}

// NewContainerRegistryTracer creates new ContainerRegistryTracer instance
func NewContainerRegistryTracer(in iaas.ContainerRegistryAPI) iaas.ContainerRegistryAPI {
	return &ContainerRegistryTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ContainerRegistryTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ContainerRegistryFindResult, error) {
	log.Println("[TRACE] ContainerRegistryAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.ContainerRegistryFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *ContainerRegistryTracer) Create(ctx context.Context, param *iaas.ContainerRegistryCreateRequest) (*iaas.ContainerRegistry, error) {
	log.Println("[TRACE] ContainerRegistryAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.ContainerRegistryCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.Create end")
	}()

	resultContainerRegistry, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		ContainerRegistry *iaas.ContainerRegistry
		Error             error
	}{
		ContainerRegistry: resultContainerRegistry,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultContainerRegistry, err
}

// Read is API call with trace log
func (t *ContainerRegistryTracer) Read(ctx context.Context, id types.ID) (*iaas.ContainerRegistry, error) {
	log.Println("[TRACE] ContainerRegistryAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.Read end")
	}()

	resultContainerRegistry, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		ContainerRegistry *iaas.ContainerRegistry
		Error             error
	}{
		ContainerRegistry: resultContainerRegistry,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultContainerRegistry, err
}

// Update is API call with trace log
func (t *ContainerRegistryTracer) Update(ctx context.Context, id types.ID, param *iaas.ContainerRegistryUpdateRequest) (*iaas.ContainerRegistry, error) {
	log.Println("[TRACE] ContainerRegistryAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                             `json:"id"`
		Argparam *iaas.ContainerRegistryUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.Update end")
	}()

	resultContainerRegistry, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		ContainerRegistry *iaas.ContainerRegistry
		Error             error
	}{
		ContainerRegistry: resultContainerRegistry,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultContainerRegistry, err
}

// UpdateSettings is API call with trace log
func (t *ContainerRegistryTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.ContainerRegistryUpdateSettingsRequest) (*iaas.ContainerRegistry, error) {
	log.Println("[TRACE] ContainerRegistryAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                                     `json:"id"`
		Argparam *iaas.ContainerRegistryUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.UpdateSettings end")
	}()

	resultContainerRegistry, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		ContainerRegistry *iaas.ContainerRegistry
		Error             error
	}{
		ContainerRegistry: resultContainerRegistry,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultContainerRegistry, err
}

// Delete is API call with trace log
func (t *ContainerRegistryTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] ContainerRegistryAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ListUsers is API call with trace log
func (t *ContainerRegistryTracer) ListUsers(ctx context.Context, id types.ID) (*iaas.ContainerRegistryUsers, error) {
	log.Println("[TRACE] ContainerRegistryAPI.ListUsers start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.ListUsers end")
	}()

	resultContainerRegistryUsers, err := t.Internal.ListUsers(ctx, id)
	targetResults := struct {
		ContainerRegistryUsers *iaas.ContainerRegistryUsers
		Error                  error
	}{
		ContainerRegistryUsers: resultContainerRegistryUsers,
		Error:                  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultContainerRegistryUsers, err
}

// AddUser is API call with trace log
func (t *ContainerRegistryTracer) AddUser(ctx context.Context, id types.ID, param *iaas.ContainerRegistryUserCreateRequest) error {
	log.Println("[TRACE] ContainerRegistryAPI.AddUser start")
	targetArguments := struct {
		Argid    types.ID                                 `json:"id"`
		Argparam *iaas.ContainerRegistryUserCreateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.AddUser end")
	}()

	err := t.Internal.AddUser(ctx, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// UpdateUser is API call with trace log
func (t *ContainerRegistryTracer) UpdateUser(ctx context.Context, id types.ID, username string, param *iaas.ContainerRegistryUserUpdateRequest) error {
	log.Println("[TRACE] ContainerRegistryAPI.UpdateUser start")
	targetArguments := struct {
		Argid       types.ID                                 `json:"id"`
		Argusername string                                   `json:"username"`
		Argparam    *iaas.ContainerRegistryUserUpdateRequest `json:"param"`
	}{
		Argid:       id,
		Argusername: username,
		Argparam:    param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.UpdateUser end")
	}()

	err := t.Internal.UpdateUser(ctx, id, username, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DeleteUser is API call with trace log
func (t *ContainerRegistryTracer) DeleteUser(ctx context.Context, id types.ID, username string) error {
	log.Println("[TRACE] ContainerRegistryAPI.DeleteUser start")
	targetArguments := struct {
		Argid       types.ID `json:"id"`
		Argusername string   `json:"username"`
	}{
		Argid:       id,
		Argusername: username,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ContainerRegistryAPI.DeleteUser end")
	}()

	err := t.Internal.DeleteUser(ctx, id, username)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* CouponTracer
*************************************************/

// CouponTracer is for trace CouponOp operations
type CouponTracer struct {
	Internal iaas.CouponAPI
}

// NewCouponTracer creates new CouponTracer instance
func NewCouponTracer(in iaas.CouponAPI) iaas.CouponAPI {
	return &CouponTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *CouponTracer) Find(ctx context.Context, accountID types.ID) (*iaas.CouponFindResult, error) {
	log.Println("[TRACE] CouponAPI.Find start")
	targetArguments := struct {
		ArgaccountID types.ID `json:"accountID"`
	}{
		ArgaccountID: accountID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] CouponAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, accountID)
	targetResults := struct {
		Result *iaas.CouponFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

/*************************************************
* DatabaseTracer
*************************************************/

// DatabaseTracer is for trace DatabaseOp operations
type DatabaseTracer struct {
	Internal iaas.DatabaseAPI
}

// NewDatabaseTracer creates new DatabaseTracer instance
func NewDatabaseTracer(in iaas.DatabaseAPI) iaas.DatabaseAPI {
	return &DatabaseTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *DatabaseTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.DatabaseFindResult, error) {
	log.Println("[TRACE] DatabaseAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.DatabaseFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *DatabaseTracer) Create(ctx context.Context, zone string, param *iaas.DatabaseCreateRequest) (*iaas.Database, error) {
	log.Println("[TRACE] DatabaseAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.DatabaseCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Create end")
	}()

	resultDatabase, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Database *iaas.Database
		Error    error
	}{
		Database: resultDatabase,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabase, err
}

// Read is API call with trace log
func (t *DatabaseTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Database, error) {
	log.Println("[TRACE] DatabaseAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Read end")
	}()

	resultDatabase, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Database *iaas.Database
		Error    error
	}{
		Database: resultDatabase,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabase, err
}

// Update is API call with trace log
func (t *DatabaseTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.DatabaseUpdateRequest) (*iaas.Database, error) {
	log.Println("[TRACE] DatabaseAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                    `json:"id"`
		Argparam *iaas.DatabaseUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Update end")
	}()

	resultDatabase, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Database *iaas.Database
		Error    error
	}{
		Database: resultDatabase,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabase, err
}

// UpdateSettings is API call with trace log
func (t *DatabaseTracer) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.DatabaseUpdateSettingsRequest) (*iaas.Database, error) {
	log.Println("[TRACE] DatabaseAPI.UpdateSettings start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                            `json:"id"`
		Argparam *iaas.DatabaseUpdateSettingsRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.UpdateSettings end")
	}()

	resultDatabase, err := t.Internal.UpdateSettings(ctx, zone, id, param)
	targetResults := struct {
		Database *iaas.Database
		Error    error
	}{
		Database: resultDatabase,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabase, err
}

// Delete is API call with trace log
func (t *DatabaseTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] DatabaseAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Config is API call with trace log
func (t *DatabaseTracer) Config(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] DatabaseAPI.Config start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Config end")
	}()

	err := t.Internal.Config(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Boot is API call with trace log
func (t *DatabaseTracer) Boot(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] DatabaseAPI.Boot start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Boot end")
	}()

	err := t.Internal.Boot(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Shutdown is API call with trace log
func (t *DatabaseTracer) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	log.Println("[TRACE] DatabaseAPI.Shutdown start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID             `json:"id"`
		ArgshutdownOption *iaas.ShutdownOption `json:"shutdownOption"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgshutdownOption: shutdownOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Shutdown end")
	}()

	err := t.Internal.Shutdown(ctx, zone, id, shutdownOption)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Reset is API call with trace log
func (t *DatabaseTracer) Reset(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] DatabaseAPI.Reset start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Reset end")
	}()

	err := t.Internal.Reset(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// MonitorCPU is API call with trace log
func (t *DatabaseTracer) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	log.Println("[TRACE] DatabaseAPI.MonitorCPU start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.MonitorCPU end")
	}()

	resultCPUTimeActivity, err := t.Internal.MonitorCPU(ctx, zone, id, condition)
	targetResults := struct {
		CPUTimeActivity *iaas.CPUTimeActivity
		Error           error
	}{
		CPUTimeActivity: resultCPUTimeActivity,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCPUTimeActivity, err
}

// MonitorDisk is API call with trace log
func (t *DatabaseTracer) MonitorDisk(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DiskActivity, error) {
	log.Println("[TRACE] DatabaseAPI.MonitorDisk start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.MonitorDisk end")
	}()

	resultDiskActivity, err := t.Internal.MonitorDisk(ctx, zone, id, condition)
	targetResults := struct {
		DiskActivity *iaas.DiskActivity
		Error        error
	}{
		DiskActivity: resultDiskActivity,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDiskActivity, err
}

// MonitorInterface is API call with trace log
func (t *DatabaseTracer) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	log.Println("[TRACE] DatabaseAPI.MonitorInterface start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.MonitorInterface end")
	}()

	resultInterfaceActivity, err := t.Internal.MonitorInterface(ctx, zone, id, condition)
	targetResults := struct {
		InterfaceActivity *iaas.InterfaceActivity
		Error             error
	}{
		InterfaceActivity: resultInterfaceActivity,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterfaceActivity, err
}

// MonitorDatabase is API call with trace log
func (t *DatabaseTracer) MonitorDatabase(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DatabaseActivity, error) {
	log.Println("[TRACE] DatabaseAPI.MonitorDatabase start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.MonitorDatabase end")
	}()

	resultDatabaseActivity, err := t.Internal.MonitorDatabase(ctx, zone, id, condition)
	targetResults := struct {
		DatabaseActivity *iaas.DatabaseActivity
		Error            error
	}{
		DatabaseActivity: resultDatabaseActivity,
		Error:            err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabaseActivity, err
}

// Status is API call with trace log
func (t *DatabaseTracer) Status(ctx context.Context, zone string, id types.ID) (*iaas.DatabaseStatus, error) {
	log.Println("[TRACE] DatabaseAPI.Status start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.Status end")
	}()

	resultDatabaseStatus, err := t.Internal.Status(ctx, zone, id)
	targetResults := struct {
		DatabaseStatus *iaas.DatabaseStatus
		Error          error
	}{
		DatabaseStatus: resultDatabaseStatus,
		Error:          err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabaseStatus, err
}

// GetParameter is API call with trace log
func (t *DatabaseTracer) GetParameter(ctx context.Context, zone string, id types.ID) (*iaas.DatabaseParameter, error) {
	log.Println("[TRACE] DatabaseAPI.GetParameter start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.GetParameter end")
	}()

	resultDatabaseParameter, err := t.Internal.GetParameter(ctx, zone, id)
	targetResults := struct {
		DatabaseParameter *iaas.DatabaseParameter
		Error             error
	}{
		DatabaseParameter: resultDatabaseParameter,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDatabaseParameter, err
}

// SetParameter is API call with trace log
func (t *DatabaseTracer) SetParameter(ctx context.Context, zone string, id types.ID, param map[string]interface{}) error {
	log.Println("[TRACE] DatabaseAPI.SetParameter start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID               `json:"id"`
		Argparam map[string]interface{} `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DatabaseAPI.SetParameter end")
	}()

	err := t.Internal.SetParameter(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* DiskTracer
*************************************************/

// DiskTracer is for trace DiskOp operations
type DiskTracer struct {
	Internal iaas.DiskAPI
}

// NewDiskTracer creates new DiskTracer instance
func NewDiskTracer(in iaas.DiskAPI) iaas.DiskAPI {
	return &DiskTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *DiskTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.DiskFindResult, error) {
	log.Println("[TRACE] DiskAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.DiskFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *DiskTracer) Create(ctx context.Context, zone string, createParam *iaas.DiskCreateRequest, distantFrom []types.ID) (*iaas.Disk, error) {
	log.Println("[TRACE] DiskAPI.Create start")
	targetArguments := struct {
		Argzone        string
		ArgcreateParam *iaas.DiskCreateRequest `json:"createParam"`
		ArgdistantFrom []types.ID              `json:"distantFrom"`
	}{
		Argzone:        zone,
		ArgcreateParam: createParam,
		ArgdistantFrom: distantFrom,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Create end")
	}()

	resultDisk, err := t.Internal.Create(ctx, zone, createParam, distantFrom)
	targetResults := struct {
		Disk  *iaas.Disk
		Error error
	}{
		Disk:  resultDisk,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDisk, err
}

// Config is API call with trace log
func (t *DiskTracer) Config(ctx context.Context, zone string, id types.ID, edit *iaas.DiskEditRequest) error {
	log.Println("[TRACE] DiskAPI.Config start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID              `json:"id"`
		Argedit *iaas.DiskEditRequest `json:"edit"`
	}{
		Argzone: zone,
		Argid:   id,
		Argedit: edit,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Config end")
	}()

	err := t.Internal.Config(ctx, zone, id, edit)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// CreateWithConfig is API call with trace log
func (t *DiskTracer) CreateWithConfig(ctx context.Context, zone string, createParam *iaas.DiskCreateRequest, editParam *iaas.DiskEditRequest, bootAtAvailable bool, distantFrom []types.ID) (*iaas.Disk, error) {
	log.Println("[TRACE] DiskAPI.CreateWithConfig start")
	targetArguments := struct {
		Argzone            string
		ArgcreateParam     *iaas.DiskCreateRequest `json:"createParam"`
		ArgeditParam       *iaas.DiskEditRequest   `json:"editParam"`
		ArgbootAtAvailable bool                    `json:"bootAtAvailable"`
		ArgdistantFrom     []types.ID              `json:"distantFrom"`
	}{
		Argzone:            zone,
		ArgcreateParam:     createParam,
		ArgeditParam:       editParam,
		ArgbootAtAvailable: bootAtAvailable,
		ArgdistantFrom:     distantFrom,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.CreateWithConfig end")
	}()

	resultDisk, err := t.Internal.CreateWithConfig(ctx, zone, createParam, editParam, bootAtAvailable, distantFrom)
	targetResults := struct {
		Disk  *iaas.Disk
		Error error
	}{
		Disk:  resultDisk,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDisk, err
}

// ResizePartition is API call with trace log
func (t *DiskTracer) ResizePartition(ctx context.Context, zone string, id types.ID, param *iaas.DiskResizePartitionRequest) error {
	log.Println("[TRACE] DiskAPI.ResizePartition start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                         `json:"id"`
		Argparam *iaas.DiskResizePartitionRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.ResizePartition end")
	}()

	err := t.Internal.ResizePartition(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ConnectToServer is API call with trace log
func (t *DiskTracer) ConnectToServer(ctx context.Context, zone string, id types.ID, serverID types.ID) error {
	log.Println("[TRACE] DiskAPI.ConnectToServer start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgserverID types.ID `json:"serverID"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgserverID: serverID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.ConnectToServer end")
	}()

	err := t.Internal.ConnectToServer(ctx, zone, id, serverID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DisconnectFromServer is API call with trace log
func (t *DiskTracer) DisconnectFromServer(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] DiskAPI.DisconnectFromServer start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.DisconnectFromServer end")
	}()

	err := t.Internal.DisconnectFromServer(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Read is API call with trace log
func (t *DiskTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Disk, error) {
	log.Println("[TRACE] DiskAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Read end")
	}()

	resultDisk, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Disk  *iaas.Disk
		Error error
	}{
		Disk:  resultDisk,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDisk, err
}

// Update is API call with trace log
func (t *DiskTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.DiskUpdateRequest) (*iaas.Disk, error) {
	log.Println("[TRACE] DiskAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                `json:"id"`
		Argparam *iaas.DiskUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Update end")
	}()

	resultDisk, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Disk  *iaas.Disk
		Error error
	}{
		Disk:  resultDisk,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDisk, err
}

// Delete is API call with trace log
func (t *DiskTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] DiskAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Monitor is API call with trace log
func (t *DiskTracer) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DiskActivity, error) {
	log.Println("[TRACE] DiskAPI.Monitor start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.Monitor end")
	}()

	resultDiskActivity, err := t.Internal.Monitor(ctx, zone, id, condition)
	targetResults := struct {
		DiskActivity *iaas.DiskActivity
		Error        error
	}{
		DiskActivity: resultDiskActivity,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDiskActivity, err
}

// MonitorDisk is API call with trace log
func (t *DiskTracer) MonitorDisk(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DiskActivity, error) {
	log.Println("[TRACE] DiskAPI.MonitorDisk start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskAPI.MonitorDisk end")
	}()

	resultDiskActivity, err := t.Internal.MonitorDisk(ctx, zone, id, condition)
	targetResults := struct {
		DiskActivity *iaas.DiskActivity
		Error        error
	}{
		DiskActivity: resultDiskActivity,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDiskActivity, err
}

/*************************************************
* DiskPlanTracer
*************************************************/

// DiskPlanTracer is for trace DiskPlanOp operations
type DiskPlanTracer struct {
	Internal iaas.DiskPlanAPI
}

// NewDiskPlanTracer creates new DiskPlanTracer instance
func NewDiskPlanTracer(in iaas.DiskPlanAPI) iaas.DiskPlanAPI {
	return &DiskPlanTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *DiskPlanTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.DiskPlanFindResult, error) {
	log.Println("[TRACE] DiskPlanAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskPlanAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.DiskPlanFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *DiskPlanTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.DiskPlan, error) {
	log.Println("[TRACE] DiskPlanAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DiskPlanAPI.Read end")
	}()

	resultDiskPlan, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		DiskPlan *iaas.DiskPlan
		Error    error
	}{
		DiskPlan: resultDiskPlan,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDiskPlan, err
}

/*************************************************
* DNSTracer
*************************************************/

// DNSTracer is for trace DNSOp operations
type DNSTracer struct {
	Internal iaas.DNSAPI
}

// NewDNSTracer creates new DNSTracer instance
func NewDNSTracer(in iaas.DNSAPI) iaas.DNSAPI {
	return &DNSTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *DNSTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.DNSFindResult, error) {
	log.Println("[TRACE] DNSAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DNSAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.DNSFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *DNSTracer) Create(ctx context.Context, param *iaas.DNSCreateRequest) (*iaas.DNS, error) {
	log.Println("[TRACE] DNSAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.DNSCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DNSAPI.Create end")
	}()

	resultDNS, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		DNS   *iaas.DNS
		Error error
	}{
		DNS:   resultDNS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDNS, err
}

// Read is API call with trace log
func (t *DNSTracer) Read(ctx context.Context, id types.ID) (*iaas.DNS, error) {
	log.Println("[TRACE] DNSAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DNSAPI.Read end")
	}()

	resultDNS, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		DNS   *iaas.DNS
		Error error
	}{
		DNS:   resultDNS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDNS, err
}

// Update is API call with trace log
func (t *DNSTracer) Update(ctx context.Context, id types.ID, param *iaas.DNSUpdateRequest) (*iaas.DNS, error) {
	log.Println("[TRACE] DNSAPI.Update start")
	targetArguments := struct {
		Argid    types.ID               `json:"id"`
		Argparam *iaas.DNSUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DNSAPI.Update end")
	}()

	resultDNS, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		DNS   *iaas.DNS
		Error error
	}{
		DNS:   resultDNS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDNS, err
}

// UpdateSettings is API call with trace log
func (t *DNSTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.DNSUpdateSettingsRequest) (*iaas.DNS, error) {
	log.Println("[TRACE] DNSAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                       `json:"id"`
		Argparam *iaas.DNSUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DNSAPI.UpdateSettings end")
	}()

	resultDNS, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		DNS   *iaas.DNS
		Error error
	}{
		DNS:   resultDNS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultDNS, err
}

// Delete is API call with trace log
func (t *DNSTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] DNSAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] DNSAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* EnhancedDBTracer
*************************************************/

// EnhancedDBTracer is for trace EnhancedDBOp operations
type EnhancedDBTracer struct {
	Internal iaas.EnhancedDBAPI
}

// NewEnhancedDBTracer creates new EnhancedDBTracer instance
func NewEnhancedDBTracer(in iaas.EnhancedDBAPI) iaas.EnhancedDBAPI {
	return &EnhancedDBTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *EnhancedDBTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.EnhancedDBFindResult, error) {
	log.Println("[TRACE] EnhancedDBAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.EnhancedDBFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *EnhancedDBTracer) Create(ctx context.Context, param *iaas.EnhancedDBCreateRequest) (*iaas.EnhancedDB, error) {
	log.Println("[TRACE] EnhancedDBAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.EnhancedDBCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.Create end")
	}()

	resultEnhancedDB, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		EnhancedDB *iaas.EnhancedDB
		Error      error
	}{
		EnhancedDB: resultEnhancedDB,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultEnhancedDB, err
}

// Read is API call with trace log
func (t *EnhancedDBTracer) Read(ctx context.Context, id types.ID) (*iaas.EnhancedDB, error) {
	log.Println("[TRACE] EnhancedDBAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.Read end")
	}()

	resultEnhancedDB, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		EnhancedDB *iaas.EnhancedDB
		Error      error
	}{
		EnhancedDB: resultEnhancedDB,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultEnhancedDB, err
}

// Update is API call with trace log
func (t *EnhancedDBTracer) Update(ctx context.Context, id types.ID, param *iaas.EnhancedDBUpdateRequest) (*iaas.EnhancedDB, error) {
	log.Println("[TRACE] EnhancedDBAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                      `json:"id"`
		Argparam *iaas.EnhancedDBUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.Update end")
	}()

	resultEnhancedDB, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		EnhancedDB *iaas.EnhancedDB
		Error      error
	}{
		EnhancedDB: resultEnhancedDB,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultEnhancedDB, err
}

// Delete is API call with trace log
func (t *EnhancedDBTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] EnhancedDBAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// SetPassword is API call with trace log
func (t *EnhancedDBTracer) SetPassword(ctx context.Context, id types.ID, param *iaas.EnhancedDBSetPasswordRequest) error {
	log.Println("[TRACE] EnhancedDBAPI.SetPassword start")
	targetArguments := struct {
		Argid    types.ID                           `json:"id"`
		Argparam *iaas.EnhancedDBSetPasswordRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.SetPassword end")
	}()

	err := t.Internal.SetPassword(ctx, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// GetConfig is API call with trace log
func (t *EnhancedDBTracer) GetConfig(ctx context.Context, id types.ID) (*iaas.EnhancedDBConfig, error) {
	log.Println("[TRACE] EnhancedDBAPI.GetConfig start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.GetConfig end")
	}()

	resultEnhancedDBConfig, err := t.Internal.GetConfig(ctx, id)
	targetResults := struct {
		EnhancedDBConfig *iaas.EnhancedDBConfig
		Error            error
	}{
		EnhancedDBConfig: resultEnhancedDBConfig,
		Error:            err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultEnhancedDBConfig, err
}

// SetConfig is API call with trace log
func (t *EnhancedDBTracer) SetConfig(ctx context.Context, id types.ID, param *iaas.EnhancedDBSetConfigRequest) error {
	log.Println("[TRACE] EnhancedDBAPI.SetConfig start")
	targetArguments := struct {
		Argid    types.ID                         `json:"id"`
		Argparam *iaas.EnhancedDBSetConfigRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] EnhancedDBAPI.SetConfig end")
	}()

	err := t.Internal.SetConfig(ctx, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* ESMETracer
*************************************************/

// ESMETracer is for trace ESMEOp operations
type ESMETracer struct {
	Internal iaas.ESMEAPI
}

// NewESMETracer creates new ESMETracer instance
func NewESMETracer(in iaas.ESMEAPI) iaas.ESMEAPI {
	return &ESMETracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ESMETracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ESMEFindResult, error) {
	log.Println("[TRACE] ESMEAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.ESMEFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *ESMETracer) Create(ctx context.Context, param *iaas.ESMECreateRequest) (*iaas.ESME, error) {
	log.Println("[TRACE] ESMEAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.ESMECreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.Create end")
	}()

	resultESME, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		ESME  *iaas.ESME
		Error error
	}{
		ESME:  resultESME,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultESME, err
}

// Read is API call with trace log
func (t *ESMETracer) Read(ctx context.Context, id types.ID) (*iaas.ESME, error) {
	log.Println("[TRACE] ESMEAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.Read end")
	}()

	resultESME, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		ESME  *iaas.ESME
		Error error
	}{
		ESME:  resultESME,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultESME, err
}

// Update is API call with trace log
func (t *ESMETracer) Update(ctx context.Context, id types.ID, param *iaas.ESMEUpdateRequest) (*iaas.ESME, error) {
	log.Println("[TRACE] ESMEAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                `json:"id"`
		Argparam *iaas.ESMEUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.Update end")
	}()

	resultESME, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		ESME  *iaas.ESME
		Error error
	}{
		ESME:  resultESME,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultESME, err
}

// Delete is API call with trace log
func (t *ESMETracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] ESMEAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// SendMessageWithGeneratedOTP is API call with trace log
func (t *ESMETracer) SendMessageWithGeneratedOTP(ctx context.Context, id types.ID, param *iaas.ESMESendMessageWithGeneratedOTPRequest) (*iaas.ESMESendMessageResult, error) {
	log.Println("[TRACE] ESMEAPI.SendMessageWithGeneratedOTP start")
	targetArguments := struct {
		Argid    types.ID                                     `json:"id"`
		Argparam *iaas.ESMESendMessageWithGeneratedOTPRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.SendMessageWithGeneratedOTP end")
	}()

	resultESMESendMessageResult, err := t.Internal.SendMessageWithGeneratedOTP(ctx, id, param)
	targetResults := struct {
		ESMESendMessageResult *iaas.ESMESendMessageResult
		Error                 error
	}{
		ESMESendMessageResult: resultESMESendMessageResult,
		Error:                 err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultESMESendMessageResult, err
}

// SendMessageWithInputtedOTP is API call with trace log
func (t *ESMETracer) SendMessageWithInputtedOTP(ctx context.Context, id types.ID, param *iaas.ESMESendMessageWithInputtedOTPRequest) (*iaas.ESMESendMessageResult, error) {
	log.Println("[TRACE] ESMEAPI.SendMessageWithInputtedOTP start")
	targetArguments := struct {
		Argid    types.ID                                    `json:"id"`
		Argparam *iaas.ESMESendMessageWithInputtedOTPRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.SendMessageWithInputtedOTP end")
	}()

	resultESMESendMessageResult, err := t.Internal.SendMessageWithInputtedOTP(ctx, id, param)
	targetResults := struct {
		ESMESendMessageResult *iaas.ESMESendMessageResult
		Error                 error
	}{
		ESMESendMessageResult: resultESMESendMessageResult,
		Error:                 err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultESMESendMessageResult, err
}

// Logs is API call with trace log
func (t *ESMETracer) Logs(ctx context.Context, id types.ID) ([]*iaas.ESMELogs, error) {
	log.Println("[TRACE] ESMEAPI.Logs start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ESMEAPI.Logs end")
	}()

	resultLogs, err := t.Internal.Logs(ctx, id)
	targetResults := struct {
		Logs  []*iaas.ESMELogs
		Error error
	}{
		Logs:  resultLogs,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLogs, err
}

/*************************************************
* GSLBTracer
*************************************************/

// GSLBTracer is for trace GSLBOp operations
type GSLBTracer struct {
	Internal iaas.GSLBAPI
}

// NewGSLBTracer creates new GSLBTracer instance
func NewGSLBTracer(in iaas.GSLBAPI) iaas.GSLBAPI {
	return &GSLBTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *GSLBTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.GSLBFindResult, error) {
	log.Println("[TRACE] GSLBAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] GSLBAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.GSLBFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *GSLBTracer) Create(ctx context.Context, param *iaas.GSLBCreateRequest) (*iaas.GSLB, error) {
	log.Println("[TRACE] GSLBAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.GSLBCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] GSLBAPI.Create end")
	}()

	resultGSLB, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		GSLB  *iaas.GSLB
		Error error
	}{
		GSLB:  resultGSLB,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultGSLB, err
}

// Read is API call with trace log
func (t *GSLBTracer) Read(ctx context.Context, id types.ID) (*iaas.GSLB, error) {
	log.Println("[TRACE] GSLBAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] GSLBAPI.Read end")
	}()

	resultGSLB, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		GSLB  *iaas.GSLB
		Error error
	}{
		GSLB:  resultGSLB,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultGSLB, err
}

// Update is API call with trace log
func (t *GSLBTracer) Update(ctx context.Context, id types.ID, param *iaas.GSLBUpdateRequest) (*iaas.GSLB, error) {
	log.Println("[TRACE] GSLBAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                `json:"id"`
		Argparam *iaas.GSLBUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] GSLBAPI.Update end")
	}()

	resultGSLB, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		GSLB  *iaas.GSLB
		Error error
	}{
		GSLB:  resultGSLB,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultGSLB, err
}

// UpdateSettings is API call with trace log
func (t *GSLBTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.GSLBUpdateSettingsRequest) (*iaas.GSLB, error) {
	log.Println("[TRACE] GSLBAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                        `json:"id"`
		Argparam *iaas.GSLBUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] GSLBAPI.UpdateSettings end")
	}()

	resultGSLB, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		GSLB  *iaas.GSLB
		Error error
	}{
		GSLB:  resultGSLB,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultGSLB, err
}

// Delete is API call with trace log
func (t *GSLBTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] GSLBAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] GSLBAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* IconTracer
*************************************************/

// IconTracer is for trace IconOp operations
type IconTracer struct {
	Internal iaas.IconAPI
}

// NewIconTracer creates new IconTracer instance
func NewIconTracer(in iaas.IconAPI) iaas.IconAPI {
	return &IconTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *IconTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.IconFindResult, error) {
	log.Println("[TRACE] IconAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IconAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.IconFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *IconTracer) Create(ctx context.Context, param *iaas.IconCreateRequest) (*iaas.Icon, error) {
	log.Println("[TRACE] IconAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.IconCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IconAPI.Create end")
	}()

	resultIcon, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		Icon  *iaas.Icon
		Error error
	}{
		Icon:  resultIcon,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIcon, err
}

// Read is API call with trace log
func (t *IconTracer) Read(ctx context.Context, id types.ID) (*iaas.Icon, error) {
	log.Println("[TRACE] IconAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IconAPI.Read end")
	}()

	resultIcon, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		Icon  *iaas.Icon
		Error error
	}{
		Icon:  resultIcon,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIcon, err
}

// Update is API call with trace log
func (t *IconTracer) Update(ctx context.Context, id types.ID, param *iaas.IconUpdateRequest) (*iaas.Icon, error) {
	log.Println("[TRACE] IconAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                `json:"id"`
		Argparam *iaas.IconUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IconAPI.Update end")
	}()

	resultIcon, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		Icon  *iaas.Icon
		Error error
	}{
		Icon:  resultIcon,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIcon, err
}

// Delete is API call with trace log
func (t *IconTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] IconAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IconAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* InterfaceTracer
*************************************************/

// InterfaceTracer is for trace InterfaceOp operations
type InterfaceTracer struct {
	Internal iaas.InterfaceAPI
}

// NewInterfaceTracer creates new InterfaceTracer instance
func NewInterfaceTracer(in iaas.InterfaceAPI) iaas.InterfaceAPI {
	return &InterfaceTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *InterfaceTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.InterfaceFindResult, error) {
	log.Println("[TRACE] InterfaceAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.InterfaceFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *InterfaceTracer) Create(ctx context.Context, zone string, param *iaas.InterfaceCreateRequest) (*iaas.Interface, error) {
	log.Println("[TRACE] InterfaceAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.InterfaceCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.Create end")
	}()

	resultInterface, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Interface *iaas.Interface
		Error     error
	}{
		Interface: resultInterface,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterface, err
}

// Read is API call with trace log
func (t *InterfaceTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Interface, error) {
	log.Println("[TRACE] InterfaceAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.Read end")
	}()

	resultInterface, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Interface *iaas.Interface
		Error     error
	}{
		Interface: resultInterface,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterface, err
}

// Update is API call with trace log
func (t *InterfaceTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.InterfaceUpdateRequest) (*iaas.Interface, error) {
	log.Println("[TRACE] InterfaceAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                     `json:"id"`
		Argparam *iaas.InterfaceUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.Update end")
	}()

	resultInterface, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Interface *iaas.Interface
		Error     error
	}{
		Interface: resultInterface,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterface, err
}

// Delete is API call with trace log
func (t *InterfaceTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] InterfaceAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Monitor is API call with trace log
func (t *InterfaceTracer) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	log.Println("[TRACE] InterfaceAPI.Monitor start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.Monitor end")
	}()

	resultInterfaceActivity, err := t.Internal.Monitor(ctx, zone, id, condition)
	targetResults := struct {
		InterfaceActivity *iaas.InterfaceActivity
		Error             error
	}{
		InterfaceActivity: resultInterfaceActivity,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterfaceActivity, err
}

// ConnectToSharedSegment is API call with trace log
func (t *InterfaceTracer) ConnectToSharedSegment(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] InterfaceAPI.ConnectToSharedSegment start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.ConnectToSharedSegment end")
	}()

	err := t.Internal.ConnectToSharedSegment(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ConnectToSwitch is API call with trace log
func (t *InterfaceTracer) ConnectToSwitch(ctx context.Context, zone string, id types.ID, switchID types.ID) error {
	log.Println("[TRACE] InterfaceAPI.ConnectToSwitch start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgswitchID types.ID `json:"switchID"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgswitchID: switchID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.ConnectToSwitch end")
	}()

	err := t.Internal.ConnectToSwitch(ctx, zone, id, switchID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DisconnectFromSwitch is API call with trace log
func (t *InterfaceTracer) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] InterfaceAPI.DisconnectFromSwitch start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.DisconnectFromSwitch end")
	}()

	err := t.Internal.DisconnectFromSwitch(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ConnectToPacketFilter is API call with trace log
func (t *InterfaceTracer) ConnectToPacketFilter(ctx context.Context, zone string, id types.ID, packetFilterID types.ID) error {
	log.Println("[TRACE] InterfaceAPI.ConnectToPacketFilter start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID `json:"id"`
		ArgpacketFilterID types.ID `json:"packetFilterID"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgpacketFilterID: packetFilterID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.ConnectToPacketFilter end")
	}()

	err := t.Internal.ConnectToPacketFilter(ctx, zone, id, packetFilterID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DisconnectFromPacketFilter is API call with trace log
func (t *InterfaceTracer) DisconnectFromPacketFilter(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] InterfaceAPI.DisconnectFromPacketFilter start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InterfaceAPI.DisconnectFromPacketFilter end")
	}()

	err := t.Internal.DisconnectFromPacketFilter(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* InternetTracer
*************************************************/

// InternetTracer is for trace InternetOp operations
type InternetTracer struct {
	Internal iaas.InternetAPI
}

// NewInternetTracer creates new InternetTracer instance
func NewInternetTracer(in iaas.InternetAPI) iaas.InternetAPI {
	return &InternetTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *InternetTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.InternetFindResult, error) {
	log.Println("[TRACE] InternetAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.InternetFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *InternetTracer) Create(ctx context.Context, zone string, param *iaas.InternetCreateRequest) (*iaas.Internet, error) {
	log.Println("[TRACE] InternetAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.InternetCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.Create end")
	}()

	resultInternet, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Internet *iaas.Internet
		Error    error
	}{
		Internet: resultInternet,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInternet, err
}

// Read is API call with trace log
func (t *InternetTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Internet, error) {
	log.Println("[TRACE] InternetAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.Read end")
	}()

	resultInternet, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Internet *iaas.Internet
		Error    error
	}{
		Internet: resultInternet,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInternet, err
}

// Update is API call with trace log
func (t *InternetTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.InternetUpdateRequest) (*iaas.Internet, error) {
	log.Println("[TRACE] InternetAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                    `json:"id"`
		Argparam *iaas.InternetUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.Update end")
	}()

	resultInternet, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Internet *iaas.Internet
		Error    error
	}{
		Internet: resultInternet,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInternet, err
}

// Delete is API call with trace log
func (t *InternetTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] InternetAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// UpdateBandWidth is API call with trace log
func (t *InternetTracer) UpdateBandWidth(ctx context.Context, zone string, id types.ID, param *iaas.InternetUpdateBandWidthRequest) (*iaas.Internet, error) {
	log.Println("[TRACE] InternetAPI.UpdateBandWidth start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                             `json:"id"`
		Argparam *iaas.InternetUpdateBandWidthRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.UpdateBandWidth end")
	}()

	resultInternet, err := t.Internal.UpdateBandWidth(ctx, zone, id, param)
	targetResults := struct {
		Internet *iaas.Internet
		Error    error
	}{
		Internet: resultInternet,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInternet, err
}

// AddSubnet is API call with trace log
func (t *InternetTracer) AddSubnet(ctx context.Context, zone string, id types.ID, param *iaas.InternetAddSubnetRequest) (*iaas.InternetSubnetOperationResult, error) {
	log.Println("[TRACE] InternetAPI.AddSubnet start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                       `json:"id"`
		Argparam *iaas.InternetAddSubnetRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.AddSubnet end")
	}()

	resultSubnet, err := t.Internal.AddSubnet(ctx, zone, id, param)
	targetResults := struct {
		Subnet *iaas.InternetSubnetOperationResult
		Error  error
	}{
		Subnet: resultSubnet,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSubnet, err
}

// UpdateSubnet is API call with trace log
func (t *InternetTracer) UpdateSubnet(ctx context.Context, zone string, id types.ID, subnetID types.ID, param *iaas.InternetUpdateSubnetRequest) (*iaas.InternetSubnetOperationResult, error) {
	log.Println("[TRACE] InternetAPI.UpdateSubnet start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID                          `json:"id"`
		ArgsubnetID types.ID                          `json:"subnetID"`
		Argparam    *iaas.InternetUpdateSubnetRequest `json:"param"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgsubnetID: subnetID,
		Argparam:    param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.UpdateSubnet end")
	}()

	resultSubnet, err := t.Internal.UpdateSubnet(ctx, zone, id, subnetID, param)
	targetResults := struct {
		Subnet *iaas.InternetSubnetOperationResult
		Error  error
	}{
		Subnet: resultSubnet,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSubnet, err
}

// DeleteSubnet is API call with trace log
func (t *InternetTracer) DeleteSubnet(ctx context.Context, zone string, id types.ID, subnetID types.ID) error {
	log.Println("[TRACE] InternetAPI.DeleteSubnet start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgsubnetID types.ID `json:"subnetID"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgsubnetID: subnetID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.DeleteSubnet end")
	}()

	err := t.Internal.DeleteSubnet(ctx, zone, id, subnetID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Monitor is API call with trace log
func (t *InternetTracer) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.RouterActivity, error) {
	log.Println("[TRACE] InternetAPI.Monitor start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.Monitor end")
	}()

	resultRouterActivity, err := t.Internal.Monitor(ctx, zone, id, condition)
	targetResults := struct {
		RouterActivity *iaas.RouterActivity
		Error          error
	}{
		RouterActivity: resultRouterActivity,
		Error:          err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultRouterActivity, err
}

// MonitorRouter is API call with trace log
func (t *InternetTracer) MonitorRouter(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.RouterActivity, error) {
	log.Println("[TRACE] InternetAPI.MonitorRouter start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.MonitorRouter end")
	}()

	resultRouterActivity, err := t.Internal.MonitorRouter(ctx, zone, id, condition)
	targetResults := struct {
		RouterActivity *iaas.RouterActivity
		Error          error
	}{
		RouterActivity: resultRouterActivity,
		Error:          err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultRouterActivity, err
}

// EnableIPv6 is API call with trace log
func (t *InternetTracer) EnableIPv6(ctx context.Context, zone string, id types.ID) (*iaas.IPv6NetInfo, error) {
	log.Println("[TRACE] InternetAPI.EnableIPv6 start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.EnableIPv6 end")
	}()

	resultIPv6Net, err := t.Internal.EnableIPv6(ctx, zone, id)
	targetResults := struct {
		IPv6Net *iaas.IPv6NetInfo
		Error   error
	}{
		IPv6Net: resultIPv6Net,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPv6Net, err
}

// DisableIPv6 is API call with trace log
func (t *InternetTracer) DisableIPv6(ctx context.Context, zone string, id types.ID, ipv6netID types.ID) error {
	log.Println("[TRACE] InternetAPI.DisableIPv6 start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID `json:"id"`
		Argipv6netID types.ID `json:"ipv6netID"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argipv6netID: ipv6netID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetAPI.DisableIPv6 end")
	}()

	err := t.Internal.DisableIPv6(ctx, zone, id, ipv6netID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* InternetPlanTracer
*************************************************/

// InternetPlanTracer is for trace InternetPlanOp operations
type InternetPlanTracer struct {
	Internal iaas.InternetPlanAPI
}

// NewInternetPlanTracer creates new InternetPlanTracer instance
func NewInternetPlanTracer(in iaas.InternetPlanAPI) iaas.InternetPlanAPI {
	return &InternetPlanTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *InternetPlanTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.InternetPlanFindResult, error) {
	log.Println("[TRACE] InternetPlanAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetPlanAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.InternetPlanFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *InternetPlanTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.InternetPlan, error) {
	log.Println("[TRACE] InternetPlanAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] InternetPlanAPI.Read end")
	}()

	resultInternetPlan, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		InternetPlan *iaas.InternetPlan
		Error        error
	}{
		InternetPlan: resultInternetPlan,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInternetPlan, err
}

/*************************************************
* IPAddressTracer
*************************************************/

// IPAddressTracer is for trace IPAddressOp operations
type IPAddressTracer struct {
	Internal iaas.IPAddressAPI
}

// NewIPAddressTracer creates new IPAddressTracer instance
func NewIPAddressTracer(in iaas.IPAddressAPI) iaas.IPAddressAPI {
	return &IPAddressTracer{
		Internal: in,
	}
}

// List is API call with trace log
func (t *IPAddressTracer) List(ctx context.Context, zone string) (*iaas.IPAddressListResult, error) {
	log.Println("[TRACE] IPAddressAPI.List start")
	targetArguments := struct {
		Argzone string
	}{
		Argzone: zone,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPAddressAPI.List end")
	}()

	result, err := t.Internal.List(ctx, zone)
	targetResults := struct {
		Result *iaas.IPAddressListResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *IPAddressTracer) Read(ctx context.Context, zone string, ipAddress string) (*iaas.IPAddress, error) {
	log.Println("[TRACE] IPAddressAPI.Read start")
	targetArguments := struct {
		Argzone      string
		ArgipAddress string `json:"ipAddress"`
	}{
		Argzone:      zone,
		ArgipAddress: ipAddress,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPAddressAPI.Read end")
	}()

	resultIPAddress, err := t.Internal.Read(ctx, zone, ipAddress)
	targetResults := struct {
		IPAddress *iaas.IPAddress
		Error     error
	}{
		IPAddress: resultIPAddress,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPAddress, err
}

// UpdateHostName is API call with trace log
func (t *IPAddressTracer) UpdateHostName(ctx context.Context, zone string, ipAddress string, hostName string) (*iaas.IPAddress, error) {
	log.Println("[TRACE] IPAddressAPI.UpdateHostName start")
	targetArguments := struct {
		Argzone      string
		ArgipAddress string `json:"ipAddress"`
		ArghostName  string `json:"hostName"`
	}{
		Argzone:      zone,
		ArgipAddress: ipAddress,
		ArghostName:  hostName,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPAddressAPI.UpdateHostName end")
	}()

	resultIPAddress, err := t.Internal.UpdateHostName(ctx, zone, ipAddress, hostName)
	targetResults := struct {
		IPAddress *iaas.IPAddress
		Error     error
	}{
		IPAddress: resultIPAddress,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPAddress, err
}

/*************************************************
* IPv6NetTracer
*************************************************/

// IPv6NetTracer is for trace IPv6NetOp operations
type IPv6NetTracer struct {
	Internal iaas.IPv6NetAPI
}

// NewIPv6NetTracer creates new IPv6NetTracer instance
func NewIPv6NetTracer(in iaas.IPv6NetAPI) iaas.IPv6NetAPI {
	return &IPv6NetTracer{
		Internal: in,
	}
}

// List is API call with trace log
func (t *IPv6NetTracer) List(ctx context.Context, zone string) (*iaas.IPv6NetListResult, error) {
	log.Println("[TRACE] IPv6NetAPI.List start")
	targetArguments := struct {
		Argzone string
	}{
		Argzone: zone,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6NetAPI.List end")
	}()

	result, err := t.Internal.List(ctx, zone)
	targetResults := struct {
		Result *iaas.IPv6NetListResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Find is API call with trace log
func (t *IPv6NetTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.IPv6NetFindResult, error) {
	log.Println("[TRACE] IPv6NetAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6NetAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.IPv6NetFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *IPv6NetTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.IPv6Net, error) {
	log.Println("[TRACE] IPv6NetAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6NetAPI.Read end")
	}()

	resultIPv6Net, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		IPv6Net *iaas.IPv6Net
		Error   error
	}{
		IPv6Net: resultIPv6Net,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPv6Net, err
}

/*************************************************
* IPv6AddrTracer
*************************************************/

// IPv6AddrTracer is for trace IPv6AddrOp operations
type IPv6AddrTracer struct {
	Internal iaas.IPv6AddrAPI
}

// NewIPv6AddrTracer creates new IPv6AddrTracer instance
func NewIPv6AddrTracer(in iaas.IPv6AddrAPI) iaas.IPv6AddrAPI {
	return &IPv6AddrTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *IPv6AddrTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.IPv6AddrFindResult, error) {
	log.Println("[TRACE] IPv6AddrAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6AddrAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.IPv6AddrFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *IPv6AddrTracer) Create(ctx context.Context, zone string, param *iaas.IPv6AddrCreateRequest) (*iaas.IPv6Addr, error) {
	log.Println("[TRACE] IPv6AddrAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.IPv6AddrCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6AddrAPI.Create end")
	}()

	resultIPv6Addr, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		IPv6Addr *iaas.IPv6Addr
		Error    error
	}{
		IPv6Addr: resultIPv6Addr,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPv6Addr, err
}

// Read is API call with trace log
func (t *IPv6AddrTracer) Read(ctx context.Context, zone string, ipv6addr string) (*iaas.IPv6Addr, error) {
	log.Println("[TRACE] IPv6AddrAPI.Read start")
	targetArguments := struct {
		Argzone     string
		Argipv6addr string `json:"ipv6addr"`
	}{
		Argzone:     zone,
		Argipv6addr: ipv6addr,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6AddrAPI.Read end")
	}()

	resultIPv6Addr, err := t.Internal.Read(ctx, zone, ipv6addr)
	targetResults := struct {
		IPv6Addr *iaas.IPv6Addr
		Error    error
	}{
		IPv6Addr: resultIPv6Addr,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPv6Addr, err
}

// Update is API call with trace log
func (t *IPv6AddrTracer) Update(ctx context.Context, zone string, ipv6addr string, param *iaas.IPv6AddrUpdateRequest) (*iaas.IPv6Addr, error) {
	log.Println("[TRACE] IPv6AddrAPI.Update start")
	targetArguments := struct {
		Argzone     string
		Argipv6addr string                      `json:"ipv6addr"`
		Argparam    *iaas.IPv6AddrUpdateRequest `json:"param"`
	}{
		Argzone:     zone,
		Argipv6addr: ipv6addr,
		Argparam:    param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6AddrAPI.Update end")
	}()

	resultIPv6Addr, err := t.Internal.Update(ctx, zone, ipv6addr, param)
	targetResults := struct {
		IPv6Addr *iaas.IPv6Addr
		Error    error
	}{
		IPv6Addr: resultIPv6Addr,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultIPv6Addr, err
}

// Delete is API call with trace log
func (t *IPv6AddrTracer) Delete(ctx context.Context, zone string, ipv6addr string) error {
	log.Println("[TRACE] IPv6AddrAPI.Delete start")
	targetArguments := struct {
		Argzone     string
		Argipv6addr string `json:"ipv6addr"`
	}{
		Argzone:     zone,
		Argipv6addr: ipv6addr,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] IPv6AddrAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, ipv6addr)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* LicenseTracer
*************************************************/

// LicenseTracer is for trace LicenseOp operations
type LicenseTracer struct {
	Internal iaas.LicenseAPI
}

// NewLicenseTracer creates new LicenseTracer instance
func NewLicenseTracer(in iaas.LicenseAPI) iaas.LicenseAPI {
	return &LicenseTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *LicenseTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.LicenseFindResult, error) {
	log.Println("[TRACE] LicenseAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.LicenseFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *LicenseTracer) Create(ctx context.Context, param *iaas.LicenseCreateRequest) (*iaas.License, error) {
	log.Println("[TRACE] LicenseAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.LicenseCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseAPI.Create end")
	}()

	resultLicense, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		License *iaas.License
		Error   error
	}{
		License: resultLicense,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLicense, err
}

// Read is API call with trace log
func (t *LicenseTracer) Read(ctx context.Context, id types.ID) (*iaas.License, error) {
	log.Println("[TRACE] LicenseAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseAPI.Read end")
	}()

	resultLicense, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		License *iaas.License
		Error   error
	}{
		License: resultLicense,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLicense, err
}

// Update is API call with trace log
func (t *LicenseTracer) Update(ctx context.Context, id types.ID, param *iaas.LicenseUpdateRequest) (*iaas.License, error) {
	log.Println("[TRACE] LicenseAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                   `json:"id"`
		Argparam *iaas.LicenseUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseAPI.Update end")
	}()

	resultLicense, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		License *iaas.License
		Error   error
	}{
		License: resultLicense,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLicense, err
}

// Delete is API call with trace log
func (t *LicenseTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] LicenseAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* LicenseInfoTracer
*************************************************/

// LicenseInfoTracer is for trace LicenseInfoOp operations
type LicenseInfoTracer struct {
	Internal iaas.LicenseInfoAPI
}

// NewLicenseInfoTracer creates new LicenseInfoTracer instance
func NewLicenseInfoTracer(in iaas.LicenseInfoAPI) iaas.LicenseInfoAPI {
	return &LicenseInfoTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *LicenseInfoTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.LicenseInfoFindResult, error) {
	log.Println("[TRACE] LicenseInfoAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseInfoAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.LicenseInfoFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *LicenseInfoTracer) Read(ctx context.Context, id types.ID) (*iaas.LicenseInfo, error) {
	log.Println("[TRACE] LicenseInfoAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LicenseInfoAPI.Read end")
	}()

	resultLicenseInfo, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		LicenseInfo *iaas.LicenseInfo
		Error       error
	}{
		LicenseInfo: resultLicenseInfo,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLicenseInfo, err
}

/*************************************************
* LoadBalancerTracer
*************************************************/

// LoadBalancerTracer is for trace LoadBalancerOp operations
type LoadBalancerTracer struct {
	Internal iaas.LoadBalancerAPI
}

// NewLoadBalancerTracer creates new LoadBalancerTracer instance
func NewLoadBalancerTracer(in iaas.LoadBalancerAPI) iaas.LoadBalancerAPI {
	return &LoadBalancerTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *LoadBalancerTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.LoadBalancerFindResult, error) {
	log.Println("[TRACE] LoadBalancerAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.LoadBalancerFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *LoadBalancerTracer) Create(ctx context.Context, zone string, param *iaas.LoadBalancerCreateRequest) (*iaas.LoadBalancer, error) {
	log.Println("[TRACE] LoadBalancerAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.LoadBalancerCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Create end")
	}()

	resultLoadBalancer, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		LoadBalancer *iaas.LoadBalancer
		Error        error
	}{
		LoadBalancer: resultLoadBalancer,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLoadBalancer, err
}

// Read is API call with trace log
func (t *LoadBalancerTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.LoadBalancer, error) {
	log.Println("[TRACE] LoadBalancerAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Read end")
	}()

	resultLoadBalancer, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		LoadBalancer *iaas.LoadBalancer
		Error        error
	}{
		LoadBalancer: resultLoadBalancer,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLoadBalancer, err
}

// Update is API call with trace log
func (t *LoadBalancerTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.LoadBalancerUpdateRequest) (*iaas.LoadBalancer, error) {
	log.Println("[TRACE] LoadBalancerAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                        `json:"id"`
		Argparam *iaas.LoadBalancerUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Update end")
	}()

	resultLoadBalancer, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		LoadBalancer *iaas.LoadBalancer
		Error        error
	}{
		LoadBalancer: resultLoadBalancer,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLoadBalancer, err
}

// UpdateSettings is API call with trace log
func (t *LoadBalancerTracer) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.LoadBalancerUpdateSettingsRequest) (*iaas.LoadBalancer, error) {
	log.Println("[TRACE] LoadBalancerAPI.UpdateSettings start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                                `json:"id"`
		Argparam *iaas.LoadBalancerUpdateSettingsRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.UpdateSettings end")
	}()

	resultLoadBalancer, err := t.Internal.UpdateSettings(ctx, zone, id, param)
	targetResults := struct {
		LoadBalancer *iaas.LoadBalancer
		Error        error
	}{
		LoadBalancer: resultLoadBalancer,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLoadBalancer, err
}

// Delete is API call with trace log
func (t *LoadBalancerTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] LoadBalancerAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Config is API call with trace log
func (t *LoadBalancerTracer) Config(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] LoadBalancerAPI.Config start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Config end")
	}()

	err := t.Internal.Config(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Boot is API call with trace log
func (t *LoadBalancerTracer) Boot(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] LoadBalancerAPI.Boot start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Boot end")
	}()

	err := t.Internal.Boot(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Shutdown is API call with trace log
func (t *LoadBalancerTracer) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	log.Println("[TRACE] LoadBalancerAPI.Shutdown start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID             `json:"id"`
		ArgshutdownOption *iaas.ShutdownOption `json:"shutdownOption"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgshutdownOption: shutdownOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Shutdown end")
	}()

	err := t.Internal.Shutdown(ctx, zone, id, shutdownOption)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Reset is API call with trace log
func (t *LoadBalancerTracer) Reset(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] LoadBalancerAPI.Reset start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Reset end")
	}()

	err := t.Internal.Reset(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// MonitorCPU is API call with trace log
func (t *LoadBalancerTracer) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	log.Println("[TRACE] LoadBalancerAPI.MonitorCPU start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.MonitorCPU end")
	}()

	resultCPUTimeActivity, err := t.Internal.MonitorCPU(ctx, zone, id, condition)
	targetResults := struct {
		CPUTimeActivity *iaas.CPUTimeActivity
		Error           error
	}{
		CPUTimeActivity: resultCPUTimeActivity,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCPUTimeActivity, err
}

// MonitorInterface is API call with trace log
func (t *LoadBalancerTracer) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	log.Println("[TRACE] LoadBalancerAPI.MonitorInterface start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.MonitorInterface end")
	}()

	resultInterfaceActivity, err := t.Internal.MonitorInterface(ctx, zone, id, condition)
	targetResults := struct {
		InterfaceActivity *iaas.InterfaceActivity
		Error             error
	}{
		InterfaceActivity: resultInterfaceActivity,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterfaceActivity, err
}

// Status is API call with trace log
func (t *LoadBalancerTracer) Status(ctx context.Context, zone string, id types.ID) (*iaas.LoadBalancerStatusResult, error) {
	log.Println("[TRACE] LoadBalancerAPI.Status start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LoadBalancerAPI.Status end")
	}()

	result, err := t.Internal.Status(ctx, zone, id)
	targetResults := struct {
		Result *iaas.LoadBalancerStatusResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

/*************************************************
* LocalRouterTracer
*************************************************/

// LocalRouterTracer is for trace LocalRouterOp operations
type LocalRouterTracer struct {
	Internal iaas.LocalRouterAPI
}

// NewLocalRouterTracer creates new LocalRouterTracer instance
func NewLocalRouterTracer(in iaas.LocalRouterAPI) iaas.LocalRouterAPI {
	return &LocalRouterTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *LocalRouterTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.LocalRouterFindResult, error) {
	log.Println("[TRACE] LocalRouterAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.LocalRouterFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *LocalRouterTracer) Create(ctx context.Context, param *iaas.LocalRouterCreateRequest) (*iaas.LocalRouter, error) {
	log.Println("[TRACE] LocalRouterAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.LocalRouterCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.Create end")
	}()

	resultLocalRouter, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		LocalRouter *iaas.LocalRouter
		Error       error
	}{
		LocalRouter: resultLocalRouter,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLocalRouter, err
}

// Read is API call with trace log
func (t *LocalRouterTracer) Read(ctx context.Context, id types.ID) (*iaas.LocalRouter, error) {
	log.Println("[TRACE] LocalRouterAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.Read end")
	}()

	resultLocalRouter, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		LocalRouter *iaas.LocalRouter
		Error       error
	}{
		LocalRouter: resultLocalRouter,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLocalRouter, err
}

// Update is API call with trace log
func (t *LocalRouterTracer) Update(ctx context.Context, id types.ID, param *iaas.LocalRouterUpdateRequest) (*iaas.LocalRouter, error) {
	log.Println("[TRACE] LocalRouterAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                       `json:"id"`
		Argparam *iaas.LocalRouterUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.Update end")
	}()

	resultLocalRouter, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		LocalRouter *iaas.LocalRouter
		Error       error
	}{
		LocalRouter: resultLocalRouter,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLocalRouter, err
}

// UpdateSettings is API call with trace log
func (t *LocalRouterTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.LocalRouterUpdateSettingsRequest) (*iaas.LocalRouter, error) {
	log.Println("[TRACE] LocalRouterAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                               `json:"id"`
		Argparam *iaas.LocalRouterUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.UpdateSettings end")
	}()

	resultLocalRouter, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		LocalRouter *iaas.LocalRouter
		Error       error
	}{
		LocalRouter: resultLocalRouter,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLocalRouter, err
}

// Delete is API call with trace log
func (t *LocalRouterTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] LocalRouterAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// HealthStatus is API call with trace log
func (t *LocalRouterTracer) HealthStatus(ctx context.Context, id types.ID) (*iaas.LocalRouterHealth, error) {
	log.Println("[TRACE] LocalRouterAPI.HealthStatus start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.HealthStatus end")
	}()

	resultLocalRouterHealth, err := t.Internal.HealthStatus(ctx, id)
	targetResults := struct {
		LocalRouterHealth *iaas.LocalRouterHealth
		Error             error
	}{
		LocalRouterHealth: resultLocalRouterHealth,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLocalRouterHealth, err
}

// MonitorLocalRouter is API call with trace log
func (t *LocalRouterTracer) MonitorLocalRouter(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.LocalRouterActivity, error) {
	log.Println("[TRACE] LocalRouterAPI.MonitorLocalRouter start")
	targetArguments := struct {
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] LocalRouterAPI.MonitorLocalRouter end")
	}()

	resultLocalRouterActivity, err := t.Internal.MonitorLocalRouter(ctx, id, condition)
	targetResults := struct {
		LocalRouterActivity *iaas.LocalRouterActivity
		Error               error
	}{
		LocalRouterActivity: resultLocalRouterActivity,
		Error:               err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLocalRouterActivity, err
}

/*************************************************
* MobileGatewayTracer
*************************************************/

// MobileGatewayTracer is for trace MobileGatewayOp operations
type MobileGatewayTracer struct {
	Internal iaas.MobileGatewayAPI
}

// NewMobileGatewayTracer creates new MobileGatewayTracer instance
func NewMobileGatewayTracer(in iaas.MobileGatewayAPI) iaas.MobileGatewayAPI {
	return &MobileGatewayTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *MobileGatewayTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.MobileGatewayFindResult, error) {
	log.Println("[TRACE] MobileGatewayAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.MobileGatewayFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *MobileGatewayTracer) Create(ctx context.Context, zone string, param *iaas.MobileGatewayCreateRequest) (*iaas.MobileGateway, error) {
	log.Println("[TRACE] MobileGatewayAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.MobileGatewayCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Create end")
	}()

	resultMobileGateway, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		MobileGateway *iaas.MobileGateway
		Error         error
	}{
		MobileGateway: resultMobileGateway,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultMobileGateway, err
}

// Read is API call with trace log
func (t *MobileGatewayTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.MobileGateway, error) {
	log.Println("[TRACE] MobileGatewayAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Read end")
	}()

	resultMobileGateway, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		MobileGateway *iaas.MobileGateway
		Error         error
	}{
		MobileGateway: resultMobileGateway,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultMobileGateway, err
}

// Update is API call with trace log
func (t *MobileGatewayTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayUpdateRequest) (*iaas.MobileGateway, error) {
	log.Println("[TRACE] MobileGatewayAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                         `json:"id"`
		Argparam *iaas.MobileGatewayUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Update end")
	}()

	resultMobileGateway, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		MobileGateway *iaas.MobileGateway
		Error         error
	}{
		MobileGateway: resultMobileGateway,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultMobileGateway, err
}

// UpdateSettings is API call with trace log
func (t *MobileGatewayTracer) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayUpdateSettingsRequest) (*iaas.MobileGateway, error) {
	log.Println("[TRACE] MobileGatewayAPI.UpdateSettings start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                                 `json:"id"`
		Argparam *iaas.MobileGatewayUpdateSettingsRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.UpdateSettings end")
	}()

	resultMobileGateway, err := t.Internal.UpdateSettings(ctx, zone, id, param)
	targetResults := struct {
		MobileGateway *iaas.MobileGateway
		Error         error
	}{
		MobileGateway: resultMobileGateway,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultMobileGateway, err
}

// Delete is API call with trace log
func (t *MobileGatewayTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Config is API call with trace log
func (t *MobileGatewayTracer) Config(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.Config start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Config end")
	}()

	err := t.Internal.Config(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Boot is API call with trace log
func (t *MobileGatewayTracer) Boot(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.Boot start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Boot end")
	}()

	err := t.Internal.Boot(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Shutdown is API call with trace log
func (t *MobileGatewayTracer) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	log.Println("[TRACE] MobileGatewayAPI.Shutdown start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID             `json:"id"`
		ArgshutdownOption *iaas.ShutdownOption `json:"shutdownOption"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgshutdownOption: shutdownOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Shutdown end")
	}()

	err := t.Internal.Shutdown(ctx, zone, id, shutdownOption)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Reset is API call with trace log
func (t *MobileGatewayTracer) Reset(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.Reset start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Reset end")
	}()

	err := t.Internal.Reset(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ConnectToSwitch is API call with trace log
func (t *MobileGatewayTracer) ConnectToSwitch(ctx context.Context, zone string, id types.ID, switchID types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.ConnectToSwitch start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgswitchID types.ID `json:"switchID"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgswitchID: switchID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.ConnectToSwitch end")
	}()

	err := t.Internal.ConnectToSwitch(ctx, zone, id, switchID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DisconnectFromSwitch is API call with trace log
func (t *MobileGatewayTracer) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.DisconnectFromSwitch start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.DisconnectFromSwitch end")
	}()

	err := t.Internal.DisconnectFromSwitch(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// GetDNS is API call with trace log
func (t *MobileGatewayTracer) GetDNS(ctx context.Context, zone string, id types.ID) (*iaas.MobileGatewayDNSSetting, error) {
	log.Println("[TRACE] MobileGatewayAPI.GetDNS start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.GetDNS end")
	}()

	resultSIMGroup, err := t.Internal.GetDNS(ctx, zone, id)
	targetResults := struct {
		SIMGroup *iaas.MobileGatewayDNSSetting
		Error    error
	}{
		SIMGroup: resultSIMGroup,
		Error:    err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIMGroup, err
}

// SetDNS is API call with trace log
func (t *MobileGatewayTracer) SetDNS(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayDNSSetting) error {
	log.Println("[TRACE] MobileGatewayAPI.SetDNS start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                      `json:"id"`
		Argparam *iaas.MobileGatewayDNSSetting `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.SetDNS end")
	}()

	err := t.Internal.SetDNS(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// GetSIMRoutes is API call with trace log
func (t *MobileGatewayTracer) GetSIMRoutes(ctx context.Context, zone string, id types.ID) (iaas.MobileGatewaySIMRoutes, error) {
	log.Println("[TRACE] MobileGatewayAPI.GetSIMRoutes start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.GetSIMRoutes end")
	}()

	resultSIMRoutes, err := t.Internal.GetSIMRoutes(ctx, zone, id)
	targetResults := struct {
		SIMRoutes iaas.MobileGatewaySIMRoutes
		Error     error
	}{
		SIMRoutes: resultSIMRoutes,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIMRoutes, err
}

// SetSIMRoutes is API call with trace log
func (t *MobileGatewayTracer) SetSIMRoutes(ctx context.Context, zone string, id types.ID, param []*iaas.MobileGatewaySIMRouteParam) error {
	log.Println("[TRACE] MobileGatewayAPI.SetSIMRoutes start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                           `json:"id"`
		Argparam []*iaas.MobileGatewaySIMRouteParam `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.SetSIMRoutes end")
	}()

	err := t.Internal.SetSIMRoutes(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ListSIM is API call with trace log
func (t *MobileGatewayTracer) ListSIM(ctx context.Context, zone string, id types.ID) (iaas.MobileGatewaySIMs, error) {
	log.Println("[TRACE] MobileGatewayAPI.ListSIM start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.ListSIM end")
	}()

	resultSIM, err := t.Internal.ListSIM(ctx, zone, id)
	targetResults := struct {
		SIM   iaas.MobileGatewaySIMs
		Error error
	}{
		SIM:   resultSIM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIM, err
}

// AddSIM is API call with trace log
func (t *MobileGatewayTracer) AddSIM(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayAddSIMRequest) error {
	log.Println("[TRACE] MobileGatewayAPI.AddSIM start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                         `json:"id"`
		Argparam *iaas.MobileGatewayAddSIMRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.AddSIM end")
	}()

	err := t.Internal.AddSIM(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DeleteSIM is API call with trace log
func (t *MobileGatewayTracer) DeleteSIM(ctx context.Context, zone string, id types.ID, simID types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.DeleteSIM start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID `json:"id"`
		ArgsimID types.ID `json:"simID"`
	}{
		Argzone:  zone,
		Argid:    id,
		ArgsimID: simID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.DeleteSIM end")
	}()

	err := t.Internal.DeleteSIM(ctx, zone, id, simID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Logs is API call with trace log
func (t *MobileGatewayTracer) Logs(ctx context.Context, zone string, id types.ID) ([]*iaas.MobileGatewaySIMLogs, error) {
	log.Println("[TRACE] MobileGatewayAPI.Logs start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.Logs end")
	}()

	resultLogs, err := t.Internal.Logs(ctx, zone, id)
	targetResults := struct {
		Logs  []*iaas.MobileGatewaySIMLogs
		Error error
	}{
		Logs:  resultLogs,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLogs, err
}

// GetTrafficConfig is API call with trace log
func (t *MobileGatewayTracer) GetTrafficConfig(ctx context.Context, zone string, id types.ID) (*iaas.MobileGatewayTrafficControl, error) {
	log.Println("[TRACE] MobileGatewayAPI.GetTrafficConfig start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.GetTrafficConfig end")
	}()

	resultTrafficMonitoring, err := t.Internal.GetTrafficConfig(ctx, zone, id)
	targetResults := struct {
		TrafficMonitoring *iaas.MobileGatewayTrafficControl
		Error             error
	}{
		TrafficMonitoring: resultTrafficMonitoring,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultTrafficMonitoring, err
}

// SetTrafficConfig is API call with trace log
func (t *MobileGatewayTracer) SetTrafficConfig(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayTrafficControl) error {
	log.Println("[TRACE] MobileGatewayAPI.SetTrafficConfig start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                          `json:"id"`
		Argparam *iaas.MobileGatewayTrafficControl `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.SetTrafficConfig end")
	}()

	err := t.Internal.SetTrafficConfig(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DeleteTrafficConfig is API call with trace log
func (t *MobileGatewayTracer) DeleteTrafficConfig(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] MobileGatewayAPI.DeleteTrafficConfig start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.DeleteTrafficConfig end")
	}()

	err := t.Internal.DeleteTrafficConfig(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// TrafficStatus is API call with trace log
func (t *MobileGatewayTracer) TrafficStatus(ctx context.Context, zone string, id types.ID) (*iaas.MobileGatewayTrafficStatus, error) {
	log.Println("[TRACE] MobileGatewayAPI.TrafficStatus start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.TrafficStatus end")
	}()

	resultTrafficStatus, err := t.Internal.TrafficStatus(ctx, zone, id)
	targetResults := struct {
		TrafficStatus *iaas.MobileGatewayTrafficStatus
		Error         error
	}{
		TrafficStatus: resultTrafficStatus,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultTrafficStatus, err
}

// MonitorInterface is API call with trace log
func (t *MobileGatewayTracer) MonitorInterface(ctx context.Context, zone string, id types.ID, index int, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	log.Println("[TRACE] MobileGatewayAPI.MonitorInterface start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argindex     int                    `json:"index"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argindex:     index,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] MobileGatewayAPI.MonitorInterface end")
	}()

	resultInterfaceActivity, err := t.Internal.MonitorInterface(ctx, zone, id, index, condition)
	targetResults := struct {
		InterfaceActivity *iaas.InterfaceActivity
		Error             error
	}{
		InterfaceActivity: resultInterfaceActivity,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterfaceActivity, err
}

/*************************************************
* NFSTracer
*************************************************/

// NFSTracer is for trace NFSOp operations
type NFSTracer struct {
	Internal iaas.NFSAPI
}

// NewNFSTracer creates new NFSTracer instance
func NewNFSTracer(in iaas.NFSAPI) iaas.NFSAPI {
	return &NFSTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *NFSTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.NFSFindResult, error) {
	log.Println("[TRACE] NFSAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.NFSFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *NFSTracer) Create(ctx context.Context, zone string, param *iaas.NFSCreateRequest) (*iaas.NFS, error) {
	log.Println("[TRACE] NFSAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.NFSCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Create end")
	}()

	resultNFS, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		NFS   *iaas.NFS
		Error error
	}{
		NFS:   resultNFS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultNFS, err
}

// Read is API call with trace log
func (t *NFSTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.NFS, error) {
	log.Println("[TRACE] NFSAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Read end")
	}()

	resultNFS, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		NFS   *iaas.NFS
		Error error
	}{
		NFS:   resultNFS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultNFS, err
}

// Update is API call with trace log
func (t *NFSTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.NFSUpdateRequest) (*iaas.NFS, error) {
	log.Println("[TRACE] NFSAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID               `json:"id"`
		Argparam *iaas.NFSUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Update end")
	}()

	resultNFS, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		NFS   *iaas.NFS
		Error error
	}{
		NFS:   resultNFS,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultNFS, err
}

// Delete is API call with trace log
func (t *NFSTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] NFSAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Boot is API call with trace log
func (t *NFSTracer) Boot(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] NFSAPI.Boot start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Boot end")
	}()

	err := t.Internal.Boot(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Shutdown is API call with trace log
func (t *NFSTracer) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	log.Println("[TRACE] NFSAPI.Shutdown start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID             `json:"id"`
		ArgshutdownOption *iaas.ShutdownOption `json:"shutdownOption"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgshutdownOption: shutdownOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Shutdown end")
	}()

	err := t.Internal.Shutdown(ctx, zone, id, shutdownOption)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Reset is API call with trace log
func (t *NFSTracer) Reset(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] NFSAPI.Reset start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.Reset end")
	}()

	err := t.Internal.Reset(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// MonitorCPU is API call with trace log
func (t *NFSTracer) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	log.Println("[TRACE] NFSAPI.MonitorCPU start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.MonitorCPU end")
	}()

	resultCPUTimeActivity, err := t.Internal.MonitorCPU(ctx, zone, id, condition)
	targetResults := struct {
		CPUTimeActivity *iaas.CPUTimeActivity
		Error           error
	}{
		CPUTimeActivity: resultCPUTimeActivity,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCPUTimeActivity, err
}

// MonitorFreeDiskSize is API call with trace log
func (t *NFSTracer) MonitorFreeDiskSize(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.FreeDiskSizeActivity, error) {
	log.Println("[TRACE] NFSAPI.MonitorFreeDiskSize start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.MonitorFreeDiskSize end")
	}()

	resultFreeDiskSizeActivity, err := t.Internal.MonitorFreeDiskSize(ctx, zone, id, condition)
	targetResults := struct {
		FreeDiskSizeActivity *iaas.FreeDiskSizeActivity
		Error                error
	}{
		FreeDiskSizeActivity: resultFreeDiskSizeActivity,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultFreeDiskSizeActivity, err
}

// MonitorInterface is API call with trace log
func (t *NFSTracer) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	log.Println("[TRACE] NFSAPI.MonitorInterface start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NFSAPI.MonitorInterface end")
	}()

	resultInterfaceActivity, err := t.Internal.MonitorInterface(ctx, zone, id, condition)
	targetResults := struct {
		InterfaceActivity *iaas.InterfaceActivity
		Error             error
	}{
		InterfaceActivity: resultInterfaceActivity,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterfaceActivity, err
}

/*************************************************
* NoteTracer
*************************************************/

// NoteTracer is for trace NoteOp operations
type NoteTracer struct {
	Internal iaas.NoteAPI
}

// NewNoteTracer creates new NoteTracer instance
func NewNoteTracer(in iaas.NoteAPI) iaas.NoteAPI {
	return &NoteTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *NoteTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.NoteFindResult, error) {
	log.Println("[TRACE] NoteAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NoteAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.NoteFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *NoteTracer) Create(ctx context.Context, param *iaas.NoteCreateRequest) (*iaas.Note, error) {
	log.Println("[TRACE] NoteAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.NoteCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NoteAPI.Create end")
	}()

	resultNote, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		Note  *iaas.Note
		Error error
	}{
		Note:  resultNote,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultNote, err
}

// Read is API call with trace log
func (t *NoteTracer) Read(ctx context.Context, id types.ID) (*iaas.Note, error) {
	log.Println("[TRACE] NoteAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NoteAPI.Read end")
	}()

	resultNote, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		Note  *iaas.Note
		Error error
	}{
		Note:  resultNote,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultNote, err
}

// Update is API call with trace log
func (t *NoteTracer) Update(ctx context.Context, id types.ID, param *iaas.NoteUpdateRequest) (*iaas.Note, error) {
	log.Println("[TRACE] NoteAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                `json:"id"`
		Argparam *iaas.NoteUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NoteAPI.Update end")
	}()

	resultNote, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		Note  *iaas.Note
		Error error
	}{
		Note:  resultNote,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultNote, err
}

// Delete is API call with trace log
func (t *NoteTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] NoteAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] NoteAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* PacketFilterTracer
*************************************************/

// PacketFilterTracer is for trace PacketFilterOp operations
type PacketFilterTracer struct {
	Internal iaas.PacketFilterAPI
}

// NewPacketFilterTracer creates new PacketFilterTracer instance
func NewPacketFilterTracer(in iaas.PacketFilterAPI) iaas.PacketFilterAPI {
	return &PacketFilterTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *PacketFilterTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.PacketFilterFindResult, error) {
	log.Println("[TRACE] PacketFilterAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PacketFilterAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.PacketFilterFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *PacketFilterTracer) Create(ctx context.Context, zone string, param *iaas.PacketFilterCreateRequest) (*iaas.PacketFilter, error) {
	log.Println("[TRACE] PacketFilterAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.PacketFilterCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PacketFilterAPI.Create end")
	}()

	resultPacketFilter, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		PacketFilter *iaas.PacketFilter
		Error        error
	}{
		PacketFilter: resultPacketFilter,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPacketFilter, err
}

// Read is API call with trace log
func (t *PacketFilterTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.PacketFilter, error) {
	log.Println("[TRACE] PacketFilterAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PacketFilterAPI.Read end")
	}()

	resultPacketFilter, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		PacketFilter *iaas.PacketFilter
		Error        error
	}{
		PacketFilter: resultPacketFilter,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPacketFilter, err
}

// Update is API call with trace log
func (t *PacketFilterTracer) Update(ctx context.Context, zone string, id types.ID, updateParam *iaas.PacketFilterUpdateRequest, originalExpressionHash string) (*iaas.PacketFilter, error) {
	log.Println("[TRACE] PacketFilterAPI.Update start")
	targetArguments := struct {
		Argzone                   string
		Argid                     types.ID                        `json:"id"`
		ArgupdateParam            *iaas.PacketFilterUpdateRequest `json:"updateParam"`
		ArgoriginalExpressionHash string                          `json:"originalExpressionHash"`
	}{
		Argzone:                   zone,
		Argid:                     id,
		ArgupdateParam:            updateParam,
		ArgoriginalExpressionHash: originalExpressionHash,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PacketFilterAPI.Update end")
	}()

	resultPacketFilter, err := t.Internal.Update(ctx, zone, id, updateParam, originalExpressionHash)
	targetResults := struct {
		PacketFilter *iaas.PacketFilter
		Error        error
	}{
		PacketFilter: resultPacketFilter,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPacketFilter, err
}

// Delete is API call with trace log
func (t *PacketFilterTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] PacketFilterAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PacketFilterAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* PrivateHostTracer
*************************************************/

// PrivateHostTracer is for trace PrivateHostOp operations
type PrivateHostTracer struct {
	Internal iaas.PrivateHostAPI
}

// NewPrivateHostTracer creates new PrivateHostTracer instance
func NewPrivateHostTracer(in iaas.PrivateHostAPI) iaas.PrivateHostAPI {
	return &PrivateHostTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *PrivateHostTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.PrivateHostFindResult, error) {
	log.Println("[TRACE] PrivateHostAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.PrivateHostFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *PrivateHostTracer) Create(ctx context.Context, zone string, param *iaas.PrivateHostCreateRequest) (*iaas.PrivateHost, error) {
	log.Println("[TRACE] PrivateHostAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.PrivateHostCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostAPI.Create end")
	}()

	resultPrivateHost, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		PrivateHost *iaas.PrivateHost
		Error       error
	}{
		PrivateHost: resultPrivateHost,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPrivateHost, err
}

// Read is API call with trace log
func (t *PrivateHostTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.PrivateHost, error) {
	log.Println("[TRACE] PrivateHostAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostAPI.Read end")
	}()

	resultPrivateHost, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		PrivateHost *iaas.PrivateHost
		Error       error
	}{
		PrivateHost: resultPrivateHost,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPrivateHost, err
}

// Update is API call with trace log
func (t *PrivateHostTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.PrivateHostUpdateRequest) (*iaas.PrivateHost, error) {
	log.Println("[TRACE] PrivateHostAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                       `json:"id"`
		Argparam *iaas.PrivateHostUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostAPI.Update end")
	}()

	resultPrivateHost, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		PrivateHost *iaas.PrivateHost
		Error       error
	}{
		PrivateHost: resultPrivateHost,
		Error:       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPrivateHost, err
}

// Delete is API call with trace log
func (t *PrivateHostTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] PrivateHostAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* PrivateHostPlanTracer
*************************************************/

// PrivateHostPlanTracer is for trace PrivateHostPlanOp operations
type PrivateHostPlanTracer struct {
	Internal iaas.PrivateHostPlanAPI
}

// NewPrivateHostPlanTracer creates new PrivateHostPlanTracer instance
func NewPrivateHostPlanTracer(in iaas.PrivateHostPlanAPI) iaas.PrivateHostPlanAPI {
	return &PrivateHostPlanTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *PrivateHostPlanTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.PrivateHostPlanFindResult, error) {
	log.Println("[TRACE] PrivateHostPlanAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostPlanAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.PrivateHostPlanFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *PrivateHostPlanTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.PrivateHostPlan, error) {
	log.Println("[TRACE] PrivateHostPlanAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] PrivateHostPlanAPI.Read end")
	}()

	resultPrivateHostPlan, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		PrivateHostPlan *iaas.PrivateHostPlan
		Error           error
	}{
		PrivateHostPlan: resultPrivateHostPlan,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultPrivateHostPlan, err
}

/*************************************************
* ProxyLBTracer
*************************************************/

// ProxyLBTracer is for trace ProxyLBOp operations
type ProxyLBTracer struct {
	Internal iaas.ProxyLBAPI
}

// NewProxyLBTracer creates new ProxyLBTracer instance
func NewProxyLBTracer(in iaas.ProxyLBAPI) iaas.ProxyLBAPI {
	return &ProxyLBTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ProxyLBTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ProxyLBFindResult, error) {
	log.Println("[TRACE] ProxyLBAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.ProxyLBFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *ProxyLBTracer) Create(ctx context.Context, param *iaas.ProxyLBCreateRequest) (*iaas.ProxyLB, error) {
	log.Println("[TRACE] ProxyLBAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.ProxyLBCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.Create end")
	}()

	resultProxyLB, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		ProxyLB *iaas.ProxyLB
		Error   error
	}{
		ProxyLB: resultProxyLB,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLB, err
}

// Read is API call with trace log
func (t *ProxyLBTracer) Read(ctx context.Context, id types.ID) (*iaas.ProxyLB, error) {
	log.Println("[TRACE] ProxyLBAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.Read end")
	}()

	resultProxyLB, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		ProxyLB *iaas.ProxyLB
		Error   error
	}{
		ProxyLB: resultProxyLB,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLB, err
}

// Update is API call with trace log
func (t *ProxyLBTracer) Update(ctx context.Context, id types.ID, param *iaas.ProxyLBUpdateRequest) (*iaas.ProxyLB, error) {
	log.Println("[TRACE] ProxyLBAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                   `json:"id"`
		Argparam *iaas.ProxyLBUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.Update end")
	}()

	resultProxyLB, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		ProxyLB *iaas.ProxyLB
		Error   error
	}{
		ProxyLB: resultProxyLB,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLB, err
}

// UpdateSettings is API call with trace log
func (t *ProxyLBTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.ProxyLBUpdateSettingsRequest) (*iaas.ProxyLB, error) {
	log.Println("[TRACE] ProxyLBAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                           `json:"id"`
		Argparam *iaas.ProxyLBUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.UpdateSettings end")
	}()

	resultProxyLB, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		ProxyLB *iaas.ProxyLB
		Error   error
	}{
		ProxyLB: resultProxyLB,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLB, err
}

// Delete is API call with trace log
func (t *ProxyLBTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] ProxyLBAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ChangePlan is API call with trace log
func (t *ProxyLBTracer) ChangePlan(ctx context.Context, id types.ID, param *iaas.ProxyLBChangePlanRequest) (*iaas.ProxyLB, error) {
	log.Println("[TRACE] ProxyLBAPI.ChangePlan start")
	targetArguments := struct {
		Argid    types.ID                       `json:"id"`
		Argparam *iaas.ProxyLBChangePlanRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.ChangePlan end")
	}()

	resultProxyLB, err := t.Internal.ChangePlan(ctx, id, param)
	targetResults := struct {
		ProxyLB *iaas.ProxyLB
		Error   error
	}{
		ProxyLB: resultProxyLB,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLB, err
}

// GetCertificates is API call with trace log
func (t *ProxyLBTracer) GetCertificates(ctx context.Context, id types.ID) (*iaas.ProxyLBCertificates, error) {
	log.Println("[TRACE] ProxyLBAPI.GetCertificates start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.GetCertificates end")
	}()

	resultProxyLBCertificates, err := t.Internal.GetCertificates(ctx, id)
	targetResults := struct {
		ProxyLBCertificates *iaas.ProxyLBCertificates
		Error               error
	}{
		ProxyLBCertificates: resultProxyLBCertificates,
		Error:               err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLBCertificates, err
}

// SetCertificates is API call with trace log
func (t *ProxyLBTracer) SetCertificates(ctx context.Context, id types.ID, param *iaas.ProxyLBSetCertificatesRequest) (*iaas.ProxyLBCertificates, error) {
	log.Println("[TRACE] ProxyLBAPI.SetCertificates start")
	targetArguments := struct {
		Argid    types.ID                            `json:"id"`
		Argparam *iaas.ProxyLBSetCertificatesRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.SetCertificates end")
	}()

	resultProxyLBCertificates, err := t.Internal.SetCertificates(ctx, id, param)
	targetResults := struct {
		ProxyLBCertificates *iaas.ProxyLBCertificates
		Error               error
	}{
		ProxyLBCertificates: resultProxyLBCertificates,
		Error:               err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLBCertificates, err
}

// DeleteCertificates is API call with trace log
func (t *ProxyLBTracer) DeleteCertificates(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] ProxyLBAPI.DeleteCertificates start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.DeleteCertificates end")
	}()

	err := t.Internal.DeleteCertificates(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// RenewLetsEncryptCert is API call with trace log
func (t *ProxyLBTracer) RenewLetsEncryptCert(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] ProxyLBAPI.RenewLetsEncryptCert start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.RenewLetsEncryptCert end")
	}()

	err := t.Internal.RenewLetsEncryptCert(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// HealthStatus is API call with trace log
func (t *ProxyLBTracer) HealthStatus(ctx context.Context, id types.ID) (*iaas.ProxyLBHealth, error) {
	log.Println("[TRACE] ProxyLBAPI.HealthStatus start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.HealthStatus end")
	}()

	resultProxyLBHealth, err := t.Internal.HealthStatus(ctx, id)
	targetResults := struct {
		ProxyLBHealth *iaas.ProxyLBHealth
		Error         error
	}{
		ProxyLBHealth: resultProxyLBHealth,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultProxyLBHealth, err
}

// MonitorConnection is API call with trace log
func (t *ProxyLBTracer) MonitorConnection(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.ConnectionActivity, error) {
	log.Println("[TRACE] ProxyLBAPI.MonitorConnection start")
	targetArguments := struct {
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ProxyLBAPI.MonitorConnection end")
	}()

	resultConnectionActivity, err := t.Internal.MonitorConnection(ctx, id, condition)
	targetResults := struct {
		ConnectionActivity *iaas.ConnectionActivity
		Error              error
	}{
		ConnectionActivity: resultConnectionActivity,
		Error:              err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultConnectionActivity, err
}

/*************************************************
* RegionTracer
*************************************************/

// RegionTracer is for trace RegionOp operations
type RegionTracer struct {
	Internal iaas.RegionAPI
}

// NewRegionTracer creates new RegionTracer instance
func NewRegionTracer(in iaas.RegionAPI) iaas.RegionAPI {
	return &RegionTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *RegionTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.RegionFindResult, error) {
	log.Println("[TRACE] RegionAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] RegionAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.RegionFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *RegionTracer) Read(ctx context.Context, id types.ID) (*iaas.Region, error) {
	log.Println("[TRACE] RegionAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] RegionAPI.Read end")
	}()

	resultRegion, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		Region *iaas.Region
		Error  error
	}{
		Region: resultRegion,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultRegion, err
}

/*************************************************
* ServerTracer
*************************************************/

// ServerTracer is for trace ServerOp operations
type ServerTracer struct {
	Internal iaas.ServerAPI
}

// NewServerTracer creates new ServerTracer instance
func NewServerTracer(in iaas.ServerAPI) iaas.ServerAPI {
	return &ServerTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ServerTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ServerFindResult, error) {
	log.Println("[TRACE] ServerAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.ServerFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *ServerTracer) Create(ctx context.Context, zone string, param *iaas.ServerCreateRequest) (*iaas.Server, error) {
	log.Println("[TRACE] ServerAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.ServerCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Create end")
	}()

	resultServer, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Server *iaas.Server
		Error  error
	}{
		Server: resultServer,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultServer, err
}

// Read is API call with trace log
func (t *ServerTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Server, error) {
	log.Println("[TRACE] ServerAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Read end")
	}()

	resultServer, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Server *iaas.Server
		Error  error
	}{
		Server: resultServer,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultServer, err
}

// Update is API call with trace log
func (t *ServerTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.ServerUpdateRequest) (*iaas.Server, error) {
	log.Println("[TRACE] ServerAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                  `json:"id"`
		Argparam *iaas.ServerUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Update end")
	}()

	resultServer, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Server *iaas.Server
		Error  error
	}{
		Server: resultServer,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultServer, err
}

// Delete is API call with trace log
func (t *ServerTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] ServerAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DeleteWithDisks is API call with trace log
func (t *ServerTracer) DeleteWithDisks(ctx context.Context, zone string, id types.ID, disks *iaas.ServerDeleteWithDisksRequest) error {
	log.Println("[TRACE] ServerAPI.DeleteWithDisks start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                           `json:"id"`
		Argdisks *iaas.ServerDeleteWithDisksRequest `json:"disks"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argdisks: disks,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.DeleteWithDisks end")
	}()

	err := t.Internal.DeleteWithDisks(ctx, zone, id, disks)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ChangePlan is API call with trace log
func (t *ServerTracer) ChangePlan(ctx context.Context, zone string, id types.ID, plan *iaas.ServerChangePlanRequest) (*iaas.Server, error) {
	log.Println("[TRACE] ServerAPI.ChangePlan start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID                      `json:"id"`
		Argplan *iaas.ServerChangePlanRequest `json:"plan"`
	}{
		Argzone: zone,
		Argid:   id,
		Argplan: plan,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.ChangePlan end")
	}()

	resultServer, err := t.Internal.ChangePlan(ctx, zone, id, plan)
	targetResults := struct {
		Server *iaas.Server
		Error  error
	}{
		Server: resultServer,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultServer, err
}

// InsertCDROM is API call with trace log
func (t *ServerTracer) InsertCDROM(ctx context.Context, zone string, id types.ID, insertParam *iaas.InsertCDROMRequest) error {
	log.Println("[TRACE] ServerAPI.InsertCDROM start")
	targetArguments := struct {
		Argzone        string
		Argid          types.ID                 `json:"id"`
		ArginsertParam *iaas.InsertCDROMRequest `json:"insertParam"`
	}{
		Argzone:        zone,
		Argid:          id,
		ArginsertParam: insertParam,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.InsertCDROM end")
	}()

	err := t.Internal.InsertCDROM(ctx, zone, id, insertParam)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// EjectCDROM is API call with trace log
func (t *ServerTracer) EjectCDROM(ctx context.Context, zone string, id types.ID, ejectParam *iaas.EjectCDROMRequest) error {
	log.Println("[TRACE] ServerAPI.EjectCDROM start")
	targetArguments := struct {
		Argzone       string
		Argid         types.ID                `json:"id"`
		ArgejectParam *iaas.EjectCDROMRequest `json:"ejectParam"`
	}{
		Argzone:       zone,
		Argid:         id,
		ArgejectParam: ejectParam,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.EjectCDROM end")
	}()

	err := t.Internal.EjectCDROM(ctx, zone, id, ejectParam)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Boot is API call with trace log
func (t *ServerTracer) Boot(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] ServerAPI.Boot start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Boot end")
	}()

	err := t.Internal.Boot(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Shutdown is API call with trace log
func (t *ServerTracer) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	log.Println("[TRACE] ServerAPI.Shutdown start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID             `json:"id"`
		ArgshutdownOption *iaas.ShutdownOption `json:"shutdownOption"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgshutdownOption: shutdownOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Shutdown end")
	}()

	err := t.Internal.Shutdown(ctx, zone, id, shutdownOption)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Reset is API call with trace log
func (t *ServerTracer) Reset(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] ServerAPI.Reset start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Reset end")
	}()

	err := t.Internal.Reset(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// BootWithVariables is API call with trace log
func (t *ServerTracer) BootWithVariables(ctx context.Context, zone string, id types.ID, param *iaas.ServerBootVariables) error {
	log.Println("[TRACE] ServerAPI.BootWithVariables start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                  `json:"id"`
		Argparam *iaas.ServerBootVariables `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.BootWithVariables end")
	}()

	err := t.Internal.BootWithVariables(ctx, zone, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// SendKey is API call with trace log
func (t *ServerTracer) SendKey(ctx context.Context, zone string, id types.ID, keyboardParam *iaas.SendKeyRequest) error {
	log.Println("[TRACE] ServerAPI.SendKey start")
	targetArguments := struct {
		Argzone          string
		Argid            types.ID             `json:"id"`
		ArgkeyboardParam *iaas.SendKeyRequest `json:"keyboardParam"`
	}{
		Argzone:          zone,
		Argid:            id,
		ArgkeyboardParam: keyboardParam,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.SendKey end")
	}()

	err := t.Internal.SendKey(ctx, zone, id, keyboardParam)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// SendNMI is API call with trace log
func (t *ServerTracer) SendNMI(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] ServerAPI.SendNMI start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.SendNMI end")
	}()

	err := t.Internal.SendNMI(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// GetVNCProxy is API call with trace log
func (t *ServerTracer) GetVNCProxy(ctx context.Context, zone string, id types.ID) (*iaas.VNCProxyInfo, error) {
	log.Println("[TRACE] ServerAPI.GetVNCProxy start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.GetVNCProxy end")
	}()

	resultVNCProxyInfo, err := t.Internal.GetVNCProxy(ctx, zone, id)
	targetResults := struct {
		VNCProxyInfo *iaas.VNCProxyInfo
		Error        error
	}{
		VNCProxyInfo: resultVNCProxyInfo,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVNCProxyInfo, err
}

// Monitor is API call with trace log
func (t *ServerTracer) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	log.Println("[TRACE] ServerAPI.Monitor start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.Monitor end")
	}()

	resultCPUTimeActivity, err := t.Internal.Monitor(ctx, zone, id, condition)
	targetResults := struct {
		CPUTimeActivity *iaas.CPUTimeActivity
		Error           error
	}{
		CPUTimeActivity: resultCPUTimeActivity,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCPUTimeActivity, err
}

// MonitorCPU is API call with trace log
func (t *ServerTracer) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	log.Println("[TRACE] ServerAPI.MonitorCPU start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerAPI.MonitorCPU end")
	}()

	resultCPUTimeActivity, err := t.Internal.MonitorCPU(ctx, zone, id, condition)
	targetResults := struct {
		CPUTimeActivity *iaas.CPUTimeActivity
		Error           error
	}{
		CPUTimeActivity: resultCPUTimeActivity,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCPUTimeActivity, err
}

/*************************************************
* ServerPlanTracer
*************************************************/

// ServerPlanTracer is for trace ServerPlanOp operations
type ServerPlanTracer struct {
	Internal iaas.ServerPlanAPI
}

// NewServerPlanTracer creates new ServerPlanTracer instance
func NewServerPlanTracer(in iaas.ServerPlanAPI) iaas.ServerPlanAPI {
	return &ServerPlanTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ServerPlanTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ServerPlanFindResult, error) {
	log.Println("[TRACE] ServerPlanAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerPlanAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.ServerPlanFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *ServerPlanTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.ServerPlan, error) {
	log.Println("[TRACE] ServerPlanAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServerPlanAPI.Read end")
	}()

	resultServerPlan, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		ServerPlan *iaas.ServerPlan
		Error      error
	}{
		ServerPlan: resultServerPlan,
		Error:      err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultServerPlan, err
}

/*************************************************
* ServiceClassTracer
*************************************************/

// ServiceClassTracer is for trace ServiceClassOp operations
type ServiceClassTracer struct {
	Internal iaas.ServiceClassAPI
}

// NewServiceClassTracer creates new ServiceClassTracer instance
func NewServiceClassTracer(in iaas.ServiceClassAPI) iaas.ServiceClassAPI {
	return &ServiceClassTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ServiceClassTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ServiceClassFindResult, error) {
	log.Println("[TRACE] ServiceClassAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ServiceClassAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.ServiceClassFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

/*************************************************
* SIMTracer
*************************************************/

// SIMTracer is for trace SIMOp operations
type SIMTracer struct {
	Internal iaas.SIMAPI
}

// NewSIMTracer creates new SIMTracer instance
func NewSIMTracer(in iaas.SIMAPI) iaas.SIMAPI {
	return &SIMTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SIMTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SIMFindResult, error) {
	log.Println("[TRACE] SIMAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.SIMFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *SIMTracer) Create(ctx context.Context, param *iaas.SIMCreateRequest) (*iaas.SIM, error) {
	log.Println("[TRACE] SIMAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.SIMCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Create end")
	}()

	resultSIM, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		SIM   *iaas.SIM
		Error error
	}{
		SIM:   resultSIM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIM, err
}

// Read is API call with trace log
func (t *SIMTracer) Read(ctx context.Context, id types.ID) (*iaas.SIM, error) {
	log.Println("[TRACE] SIMAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Read end")
	}()

	resultSIM, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		SIM   *iaas.SIM
		Error error
	}{
		SIM:   resultSIM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIM, err
}

// Update is API call with trace log
func (t *SIMTracer) Update(ctx context.Context, id types.ID, param *iaas.SIMUpdateRequest) (*iaas.SIM, error) {
	log.Println("[TRACE] SIMAPI.Update start")
	targetArguments := struct {
		Argid    types.ID               `json:"id"`
		Argparam *iaas.SIMUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Update end")
	}()

	resultSIM, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		SIM   *iaas.SIM
		Error error
	}{
		SIM:   resultSIM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIM, err
}

// Delete is API call with trace log
func (t *SIMTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SIMAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Activate is API call with trace log
func (t *SIMTracer) Activate(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SIMAPI.Activate start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Activate end")
	}()

	err := t.Internal.Activate(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Deactivate is API call with trace log
func (t *SIMTracer) Deactivate(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SIMAPI.Deactivate start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Deactivate end")
	}()

	err := t.Internal.Deactivate(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// AssignIP is API call with trace log
func (t *SIMTracer) AssignIP(ctx context.Context, id types.ID, param *iaas.SIMAssignIPRequest) error {
	log.Println("[TRACE] SIMAPI.AssignIP start")
	targetArguments := struct {
		Argid    types.ID                 `json:"id"`
		Argparam *iaas.SIMAssignIPRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.AssignIP end")
	}()

	err := t.Internal.AssignIP(ctx, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ClearIP is API call with trace log
func (t *SIMTracer) ClearIP(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SIMAPI.ClearIP start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.ClearIP end")
	}()

	err := t.Internal.ClearIP(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// IMEILock is API call with trace log
func (t *SIMTracer) IMEILock(ctx context.Context, id types.ID, param *iaas.SIMIMEILockRequest) error {
	log.Println("[TRACE] SIMAPI.IMEILock start")
	targetArguments := struct {
		Argid    types.ID                 `json:"id"`
		Argparam *iaas.SIMIMEILockRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.IMEILock end")
	}()

	err := t.Internal.IMEILock(ctx, id, param)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// IMEIUnlock is API call with trace log
func (t *SIMTracer) IMEIUnlock(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SIMAPI.IMEIUnlock start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.IMEIUnlock end")
	}()

	err := t.Internal.IMEIUnlock(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Logs is API call with trace log
func (t *SIMTracer) Logs(ctx context.Context, id types.ID) (*iaas.SIMLogsResult, error) {
	log.Println("[TRACE] SIMAPI.Logs start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Logs end")
	}()

	result, err := t.Internal.Logs(ctx, id)
	targetResults := struct {
		Result *iaas.SIMLogsResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// GetNetworkOperator is API call with trace log
func (t *SIMTracer) GetNetworkOperator(ctx context.Context, id types.ID) ([]*iaas.SIMNetworkOperatorConfig, error) {
	log.Println("[TRACE] SIMAPI.GetNetworkOperator start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.GetNetworkOperator end")
	}()

	resultConfigs, err := t.Internal.GetNetworkOperator(ctx, id)
	targetResults := struct {
		Configs []*iaas.SIMNetworkOperatorConfig
		Error   error
	}{
		Configs: resultConfigs,
		Error:   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultConfigs, err
}

// SetNetworkOperator is API call with trace log
func (t *SIMTracer) SetNetworkOperator(ctx context.Context, id types.ID, configs []*iaas.SIMNetworkOperatorConfig) error {
	log.Println("[TRACE] SIMAPI.SetNetworkOperator start")
	targetArguments := struct {
		Argid      types.ID                         `json:"id"`
		Argconfigs []*iaas.SIMNetworkOperatorConfig `json:"configs"`
	}{
		Argid:      id,
		Argconfigs: configs,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.SetNetworkOperator end")
	}()

	err := t.Internal.SetNetworkOperator(ctx, id, configs)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// MonitorSIM is API call with trace log
func (t *SIMTracer) MonitorSIM(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.LinkActivity, error) {
	log.Println("[TRACE] SIMAPI.MonitorSIM start")
	targetArguments := struct {
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.MonitorSIM end")
	}()

	resultLinkActivity, err := t.Internal.MonitorSIM(ctx, id, condition)
	targetResults := struct {
		LinkActivity *iaas.LinkActivity
		Error        error
	}{
		LinkActivity: resultLinkActivity,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultLinkActivity, err
}

// Status is API call with trace log
func (t *SIMTracer) Status(ctx context.Context, id types.ID) (*iaas.SIMInfo, error) {
	log.Println("[TRACE] SIMAPI.Status start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SIMAPI.Status end")
	}()

	resultSIM, err := t.Internal.Status(ctx, id)
	targetResults := struct {
		SIM   *iaas.SIMInfo
		Error error
	}{
		SIM:   resultSIM,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSIM, err
}

/*************************************************
* SimpleMonitorTracer
*************************************************/

// SimpleMonitorTracer is for trace SimpleMonitorOp operations
type SimpleMonitorTracer struct {
	Internal iaas.SimpleMonitorAPI
}

// NewSimpleMonitorTracer creates new SimpleMonitorTracer instance
func NewSimpleMonitorTracer(in iaas.SimpleMonitorAPI) iaas.SimpleMonitorAPI {
	return &SimpleMonitorTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SimpleMonitorTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SimpleMonitorFindResult, error) {
	log.Println("[TRACE] SimpleMonitorAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.SimpleMonitorFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *SimpleMonitorTracer) Create(ctx context.Context, param *iaas.SimpleMonitorCreateRequest) (*iaas.SimpleMonitor, error) {
	log.Println("[TRACE] SimpleMonitorAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.SimpleMonitorCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.Create end")
	}()

	resultSimpleMonitor, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		SimpleMonitor *iaas.SimpleMonitor
		Error         error
	}{
		SimpleMonitor: resultSimpleMonitor,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleMonitor, err
}

// Read is API call with trace log
func (t *SimpleMonitorTracer) Read(ctx context.Context, id types.ID) (*iaas.SimpleMonitor, error) {
	log.Println("[TRACE] SimpleMonitorAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.Read end")
	}()

	resultSimpleMonitor, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		SimpleMonitor *iaas.SimpleMonitor
		Error         error
	}{
		SimpleMonitor: resultSimpleMonitor,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleMonitor, err
}

// Update is API call with trace log
func (t *SimpleMonitorTracer) Update(ctx context.Context, id types.ID, param *iaas.SimpleMonitorUpdateRequest) (*iaas.SimpleMonitor, error) {
	log.Println("[TRACE] SimpleMonitorAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                         `json:"id"`
		Argparam *iaas.SimpleMonitorUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.Update end")
	}()

	resultSimpleMonitor, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		SimpleMonitor *iaas.SimpleMonitor
		Error         error
	}{
		SimpleMonitor: resultSimpleMonitor,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleMonitor, err
}

// UpdateSettings is API call with trace log
func (t *SimpleMonitorTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.SimpleMonitorUpdateSettingsRequest) (*iaas.SimpleMonitor, error) {
	log.Println("[TRACE] SimpleMonitorAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                                 `json:"id"`
		Argparam *iaas.SimpleMonitorUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.UpdateSettings end")
	}()

	resultSimpleMonitor, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		SimpleMonitor *iaas.SimpleMonitor
		Error         error
	}{
		SimpleMonitor: resultSimpleMonitor,
		Error:         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleMonitor, err
}

// Delete is API call with trace log
func (t *SimpleMonitorTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SimpleMonitorAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// MonitorResponseTime is API call with trace log
func (t *SimpleMonitorTracer) MonitorResponseTime(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.ResponseTimeSecActivity, error) {
	log.Println("[TRACE] SimpleMonitorAPI.MonitorResponseTime start")
	targetArguments := struct {
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.MonitorResponseTime end")
	}()

	resultResponseTimeSecActivity, err := t.Internal.MonitorResponseTime(ctx, id, condition)
	targetResults := struct {
		ResponseTimeSecActivity *iaas.ResponseTimeSecActivity
		Error                   error
	}{
		ResponseTimeSecActivity: resultResponseTimeSecActivity,
		Error:                   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultResponseTimeSecActivity, err
}

// HealthStatus is API call with trace log
func (t *SimpleMonitorTracer) HealthStatus(ctx context.Context, id types.ID) (*iaas.SimpleMonitorHealthStatus, error) {
	log.Println("[TRACE] SimpleMonitorAPI.HealthStatus start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleMonitorAPI.HealthStatus end")
	}()

	resultSimpleMonitorHealthStatus, err := t.Internal.HealthStatus(ctx, id)
	targetResults := struct {
		SimpleMonitorHealthStatus *iaas.SimpleMonitorHealthStatus
		Error                     error
	}{
		SimpleMonitorHealthStatus: resultSimpleMonitorHealthStatus,
		Error:                     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleMonitorHealthStatus, err
}

/*************************************************
* SimpleNotificationDestinationTracer
*************************************************/

// SimpleNotificationDestinationTracer is for trace SimpleNotificationDestinationOp operations
type SimpleNotificationDestinationTracer struct {
	Internal iaas.SimpleNotificationDestinationAPI
}

// NewSimpleNotificationDestinationTracer creates new SimpleNotificationDestinationTracer instance
func NewSimpleNotificationDestinationTracer(in iaas.SimpleNotificationDestinationAPI) iaas.SimpleNotificationDestinationAPI {
	return &SimpleNotificationDestinationTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SimpleNotificationDestinationTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SimpleNotificationDestinationFindResult, error) {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.SimpleNotificationDestinationFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *SimpleNotificationDestinationTracer) Create(ctx context.Context, param *iaas.SimpleNotificationDestinationCreateRequest) (*iaas.SimpleNotificationDestination, error) {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.SimpleNotificationDestinationCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.Create end")
	}()

	resultSimpleNotificationDestination, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		SimpleNotificationDestination *iaas.SimpleNotificationDestination
		Error                         error
	}{
		SimpleNotificationDestination: resultSimpleNotificationDestination,
		Error:                         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationDestination, err
}

// Read is API call with trace log
func (t *SimpleNotificationDestinationTracer) Read(ctx context.Context, id types.ID) (*iaas.SimpleNotificationDestination, error) {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.Read end")
	}()

	resultSimpleNotificationDestination, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		SimpleNotificationDestination *iaas.SimpleNotificationDestination
		Error                         error
	}{
		SimpleNotificationDestination: resultSimpleNotificationDestination,
		Error:                         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationDestination, err
}

// Update is API call with trace log
func (t *SimpleNotificationDestinationTracer) Update(ctx context.Context, id types.ID, param *iaas.SimpleNotificationDestinationUpdateRequest) (*iaas.SimpleNotificationDestination, error) {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                                         `json:"id"`
		Argparam *iaas.SimpleNotificationDestinationUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.Update end")
	}()

	resultSimpleNotificationDestination, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		SimpleNotificationDestination *iaas.SimpleNotificationDestination
		Error                         error
	}{
		SimpleNotificationDestination: resultSimpleNotificationDestination,
		Error:                         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationDestination, err
}

// UpdateSettings is API call with trace log
func (t *SimpleNotificationDestinationTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.SimpleNotificationDestinationUpdateSettingsRequest) (*iaas.SimpleNotificationDestination, error) {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                                                 `json:"id"`
		Argparam *iaas.SimpleNotificationDestinationUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.UpdateSettings end")
	}()

	resultSimpleNotificationDestination, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		SimpleNotificationDestination *iaas.SimpleNotificationDestination
		Error                         error
	}{
		SimpleNotificationDestination: resultSimpleNotificationDestination,
		Error:                         err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationDestination, err
}

// Delete is API call with trace log
func (t *SimpleNotificationDestinationTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Status is API call with trace log
func (t *SimpleNotificationDestinationTracer) Status(ctx context.Context, id types.ID) (*iaas.SimpleNotificationDestinationStatus, error) {
	log.Println("[TRACE] SimpleNotificationDestinationAPI.Status start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationDestinationAPI.Status end")
	}()

	resultSimpleNotificationDestinationStatus, err := t.Internal.Status(ctx, id)
	targetResults := struct {
		SimpleNotificationDestinationStatus *iaas.SimpleNotificationDestinationStatus
		Error                               error
	}{
		SimpleNotificationDestinationStatus: resultSimpleNotificationDestinationStatus,
		Error:                               err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationDestinationStatus, err
}

/*************************************************
* SimpleNotificationGroupTracer
*************************************************/

// SimpleNotificationGroupTracer is for trace SimpleNotificationGroupOp operations
type SimpleNotificationGroupTracer struct {
	Internal iaas.SimpleNotificationGroupAPI
}

// NewSimpleNotificationGroupTracer creates new SimpleNotificationGroupTracer instance
func NewSimpleNotificationGroupTracer(in iaas.SimpleNotificationGroupAPI) iaas.SimpleNotificationGroupAPI {
	return &SimpleNotificationGroupTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SimpleNotificationGroupTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SimpleNotificationGroupFindResult, error) {
	log.Println("[TRACE] SimpleNotificationGroupAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.SimpleNotificationGroupFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *SimpleNotificationGroupTracer) Create(ctx context.Context, param *iaas.SimpleNotificationGroupCreateRequest) (*iaas.SimpleNotificationGroup, error) {
	log.Println("[TRACE] SimpleNotificationGroupAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.SimpleNotificationGroupCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.Create end")
	}()

	resultSimpleNotificationGroup, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		SimpleNotificationGroup *iaas.SimpleNotificationGroup
		Error                   error
	}{
		SimpleNotificationGroup: resultSimpleNotificationGroup,
		Error:                   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationGroup, err
}

// Read is API call with trace log
func (t *SimpleNotificationGroupTracer) Read(ctx context.Context, id types.ID) (*iaas.SimpleNotificationGroup, error) {
	log.Println("[TRACE] SimpleNotificationGroupAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.Read end")
	}()

	resultSimpleNotificationGroup, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		SimpleNotificationGroup *iaas.SimpleNotificationGroup
		Error                   error
	}{
		SimpleNotificationGroup: resultSimpleNotificationGroup,
		Error:                   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationGroup, err
}

// Update is API call with trace log
func (t *SimpleNotificationGroupTracer) Update(ctx context.Context, id types.ID, param *iaas.SimpleNotificationGroupUpdateRequest) (*iaas.SimpleNotificationGroup, error) {
	log.Println("[TRACE] SimpleNotificationGroupAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                                   `json:"id"`
		Argparam *iaas.SimpleNotificationGroupUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.Update end")
	}()

	resultSimpleNotificationGroup, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		SimpleNotificationGroup *iaas.SimpleNotificationGroup
		Error                   error
	}{
		SimpleNotificationGroup: resultSimpleNotificationGroup,
		Error:                   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationGroup, err
}

// UpdateSettings is API call with trace log
func (t *SimpleNotificationGroupTracer) UpdateSettings(ctx context.Context, id types.ID, param *iaas.SimpleNotificationGroupUpdateSettingsRequest) (*iaas.SimpleNotificationGroup, error) {
	log.Println("[TRACE] SimpleNotificationGroupAPI.UpdateSettings start")
	targetArguments := struct {
		Argid    types.ID                                           `json:"id"`
		Argparam *iaas.SimpleNotificationGroupUpdateSettingsRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.UpdateSettings end")
	}()

	resultSimpleNotificationGroup, err := t.Internal.UpdateSettings(ctx, id, param)
	targetResults := struct {
		SimpleNotificationGroup *iaas.SimpleNotificationGroup
		Error                   error
	}{
		SimpleNotificationGroup: resultSimpleNotificationGroup,
		Error:                   err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationGroup, err
}

// Delete is API call with trace log
func (t *SimpleNotificationGroupTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SimpleNotificationGroupAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// PostMessage is API call with trace log
func (t *SimpleNotificationGroupTracer) PostMessage(ctx context.Context, id types.ID, message string) error {
	log.Println("[TRACE] SimpleNotificationGroupAPI.PostMessage start")
	targetArguments := struct {
		Argid      types.ID `json:"id"`
		Argmessage string   `json:"message"`
	}{
		Argid:      id,
		Argmessage: message,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.PostMessage end")
	}()

	err := t.Internal.PostMessage(ctx, id, message)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// History is API call with trace log
func (t *SimpleNotificationGroupTracer) History(ctx context.Context) (*iaas.SimpleNotificationHistories, error) {
	log.Println("[TRACE] SimpleNotificationGroupAPI.History start")
	targetArguments := struct {
	}{}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SimpleNotificationGroupAPI.History end")
	}()

	resultSimpleNotificationHistories, err := t.Internal.History(ctx)
	targetResults := struct {
		SimpleNotificationHistories *iaas.SimpleNotificationHistories
		Error                       error
	}{
		SimpleNotificationHistories: resultSimpleNotificationHistories,
		Error:                       err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSimpleNotificationHistories, err
}

/*************************************************
* SSHKeyTracer
*************************************************/

// SSHKeyTracer is for trace SSHKeyOp operations
type SSHKeyTracer struct {
	Internal iaas.SSHKeyAPI
}

// NewSSHKeyTracer creates new SSHKeyTracer instance
func NewSSHKeyTracer(in iaas.SSHKeyAPI) iaas.SSHKeyAPI {
	return &SSHKeyTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SSHKeyTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SSHKeyFindResult, error) {
	log.Println("[TRACE] SSHKeyAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SSHKeyAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.SSHKeyFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *SSHKeyTracer) Create(ctx context.Context, param *iaas.SSHKeyCreateRequest) (*iaas.SSHKey, error) {
	log.Println("[TRACE] SSHKeyAPI.Create start")
	targetArguments := struct {
		Argparam *iaas.SSHKeyCreateRequest `json:"param"`
	}{
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SSHKeyAPI.Create end")
	}()

	resultSSHKey, err := t.Internal.Create(ctx, param)
	targetResults := struct {
		SSHKey *iaas.SSHKey
		Error  error
	}{
		SSHKey: resultSSHKey,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSSHKey, err
}

// Read is API call with trace log
func (t *SSHKeyTracer) Read(ctx context.Context, id types.ID) (*iaas.SSHKey, error) {
	log.Println("[TRACE] SSHKeyAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SSHKeyAPI.Read end")
	}()

	resultSSHKey, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		SSHKey *iaas.SSHKey
		Error  error
	}{
		SSHKey: resultSSHKey,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSSHKey, err
}

// Update is API call with trace log
func (t *SSHKeyTracer) Update(ctx context.Context, id types.ID, param *iaas.SSHKeyUpdateRequest) (*iaas.SSHKey, error) {
	log.Println("[TRACE] SSHKeyAPI.Update start")
	targetArguments := struct {
		Argid    types.ID                  `json:"id"`
		Argparam *iaas.SSHKeyUpdateRequest `json:"param"`
	}{
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SSHKeyAPI.Update end")
	}()

	resultSSHKey, err := t.Internal.Update(ctx, id, param)
	targetResults := struct {
		SSHKey *iaas.SSHKey
		Error  error
	}{
		SSHKey: resultSSHKey,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSSHKey, err
}

// Delete is API call with trace log
func (t *SSHKeyTracer) Delete(ctx context.Context, id types.ID) error {
	log.Println("[TRACE] SSHKeyAPI.Delete start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SSHKeyAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

/*************************************************
* SubnetTracer
*************************************************/

// SubnetTracer is for trace SubnetOp operations
type SubnetTracer struct {
	Internal iaas.SubnetAPI
}

// NewSubnetTracer creates new SubnetTracer instance
func NewSubnetTracer(in iaas.SubnetAPI) iaas.SubnetAPI {
	return &SubnetTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SubnetTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.SubnetFindResult, error) {
	log.Println("[TRACE] SubnetAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SubnetAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.SubnetFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *SubnetTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Subnet, error) {
	log.Println("[TRACE] SubnetAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SubnetAPI.Read end")
	}()

	resultSubnet, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Subnet *iaas.Subnet
		Error  error
	}{
		Subnet: resultSubnet,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSubnet, err
}

/*************************************************
* SwitchTracer
*************************************************/

// SwitchTracer is for trace SwitchOp operations
type SwitchTracer struct {
	Internal iaas.SwitchAPI
}

// NewSwitchTracer creates new SwitchTracer instance
func NewSwitchTracer(in iaas.SwitchAPI) iaas.SwitchAPI {
	return &SwitchTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *SwitchTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.SwitchFindResult, error) {
	log.Println("[TRACE] SwitchAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.SwitchFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *SwitchTracer) Create(ctx context.Context, zone string, param *iaas.SwitchCreateRequest) (*iaas.Switch, error) {
	log.Println("[TRACE] SwitchAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.SwitchCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.Create end")
	}()

	resultSwitch, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		Switch *iaas.Switch
		Error  error
	}{
		Switch: resultSwitch,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSwitch, err
}

// Read is API call with trace log
func (t *SwitchTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.Switch, error) {
	log.Println("[TRACE] SwitchAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.Read end")
	}()

	resultSwitch, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		Switch *iaas.Switch
		Error  error
	}{
		Switch: resultSwitch,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSwitch, err
}

// Update is API call with trace log
func (t *SwitchTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.SwitchUpdateRequest) (*iaas.Switch, error) {
	log.Println("[TRACE] SwitchAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                  `json:"id"`
		Argparam *iaas.SwitchUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.Update end")
	}()

	resultSwitch, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		Switch *iaas.Switch
		Error  error
	}{
		Switch: resultSwitch,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultSwitch, err
}

// Delete is API call with trace log
func (t *SwitchTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] SwitchAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ConnectToBridge is API call with trace log
func (t *SwitchTracer) ConnectToBridge(ctx context.Context, zone string, id types.ID, bridgeID types.ID) error {
	log.Println("[TRACE] SwitchAPI.ConnectToBridge start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgbridgeID types.ID `json:"bridgeID"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgbridgeID: bridgeID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.ConnectToBridge end")
	}()

	err := t.Internal.ConnectToBridge(ctx, zone, id, bridgeID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DisconnectFromBridge is API call with trace log
func (t *SwitchTracer) DisconnectFromBridge(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] SwitchAPI.DisconnectFromBridge start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.DisconnectFromBridge end")
	}()

	err := t.Internal.DisconnectFromBridge(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// GetServers is API call with trace log
func (t *SwitchTracer) GetServers(ctx context.Context, zone string, id types.ID) (*iaas.SwitchGetServersResult, error) {
	log.Println("[TRACE] SwitchAPI.GetServers start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] SwitchAPI.GetServers end")
	}()

	result, err := t.Internal.GetServers(ctx, zone, id)
	targetResults := struct {
		Result *iaas.SwitchGetServersResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

/*************************************************
* VPCRouterTracer
*************************************************/

// VPCRouterTracer is for trace VPCRouterOp operations
type VPCRouterTracer struct {
	Internal iaas.VPCRouterAPI
}

// NewVPCRouterTracer creates new VPCRouterTracer instance
func NewVPCRouterTracer(in iaas.VPCRouterAPI) iaas.VPCRouterAPI {
	return &VPCRouterTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *VPCRouterTracer) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.VPCRouterFindResult, error) {
	log.Println("[TRACE] VPCRouterAPI.Find start")
	targetArguments := struct {
		Argzone       string
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argzone:       zone,
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, zone, conditions)
	targetResults := struct {
		Result *iaas.VPCRouterFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Create is API call with trace log
func (t *VPCRouterTracer) Create(ctx context.Context, zone string, param *iaas.VPCRouterCreateRequest) (*iaas.VPCRouter, error) {
	log.Println("[TRACE] VPCRouterAPI.Create start")
	targetArguments := struct {
		Argzone  string
		Argparam *iaas.VPCRouterCreateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Create end")
	}()

	resultVPCRouter, err := t.Internal.Create(ctx, zone, param)
	targetResults := struct {
		VPCRouter *iaas.VPCRouter
		Error     error
	}{
		VPCRouter: resultVPCRouter,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouter, err
}

// Read is API call with trace log
func (t *VPCRouterTracer) Read(ctx context.Context, zone string, id types.ID) (*iaas.VPCRouter, error) {
	log.Println("[TRACE] VPCRouterAPI.Read start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Read end")
	}()

	resultVPCRouter, err := t.Internal.Read(ctx, zone, id)
	targetResults := struct {
		VPCRouter *iaas.VPCRouter
		Error     error
	}{
		VPCRouter: resultVPCRouter,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouter, err
}

// Update is API call with trace log
func (t *VPCRouterTracer) Update(ctx context.Context, zone string, id types.ID, param *iaas.VPCRouterUpdateRequest) (*iaas.VPCRouter, error) {
	log.Println("[TRACE] VPCRouterAPI.Update start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                     `json:"id"`
		Argparam *iaas.VPCRouterUpdateRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Update end")
	}()

	resultVPCRouter, err := t.Internal.Update(ctx, zone, id, param)
	targetResults := struct {
		VPCRouter *iaas.VPCRouter
		Error     error
	}{
		VPCRouter: resultVPCRouter,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouter, err
}

// UpdateSettings is API call with trace log
func (t *VPCRouterTracer) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.VPCRouterUpdateSettingsRequest) (*iaas.VPCRouter, error) {
	log.Println("[TRACE] VPCRouterAPI.UpdateSettings start")
	targetArguments := struct {
		Argzone  string
		Argid    types.ID                             `json:"id"`
		Argparam *iaas.VPCRouterUpdateSettingsRequest `json:"param"`
	}{
		Argzone:  zone,
		Argid:    id,
		Argparam: param,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.UpdateSettings end")
	}()

	resultVPCRouter, err := t.Internal.UpdateSettings(ctx, zone, id, param)
	targetResults := struct {
		VPCRouter *iaas.VPCRouter
		Error     error
	}{
		VPCRouter: resultVPCRouter,
		Error:     err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouter, err
}

// Delete is API call with trace log
func (t *VPCRouterTracer) Delete(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] VPCRouterAPI.Delete start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Delete end")
	}()

	err := t.Internal.Delete(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Config is API call with trace log
func (t *VPCRouterTracer) Config(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] VPCRouterAPI.Config start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Config end")
	}()

	err := t.Internal.Config(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Boot is API call with trace log
func (t *VPCRouterTracer) Boot(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] VPCRouterAPI.Boot start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Boot end")
	}()

	err := t.Internal.Boot(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Shutdown is API call with trace log
func (t *VPCRouterTracer) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	log.Println("[TRACE] VPCRouterAPI.Shutdown start")
	targetArguments := struct {
		Argzone           string
		Argid             types.ID             `json:"id"`
		ArgshutdownOption *iaas.ShutdownOption `json:"shutdownOption"`
	}{
		Argzone:           zone,
		Argid:             id,
		ArgshutdownOption: shutdownOption,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Shutdown end")
	}()

	err := t.Internal.Shutdown(ctx, zone, id, shutdownOption)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// Reset is API call with trace log
func (t *VPCRouterTracer) Reset(ctx context.Context, zone string, id types.ID) error {
	log.Println("[TRACE] VPCRouterAPI.Reset start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Reset end")
	}()

	err := t.Internal.Reset(ctx, zone, id)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// ConnectToSwitch is API call with trace log
func (t *VPCRouterTracer) ConnectToSwitch(ctx context.Context, zone string, id types.ID, nicIndex int, switchID types.ID) error {
	log.Println("[TRACE] VPCRouterAPI.ConnectToSwitch start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgnicIndex int      `json:"nicIndex"`
		ArgswitchID types.ID `json:"switchID"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgnicIndex: nicIndex,
		ArgswitchID: switchID,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.ConnectToSwitch end")
	}()

	err := t.Internal.ConnectToSwitch(ctx, zone, id, nicIndex, switchID)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// DisconnectFromSwitch is API call with trace log
func (t *VPCRouterTracer) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID, nicIndex int) error {
	log.Println("[TRACE] VPCRouterAPI.DisconnectFromSwitch start")
	targetArguments := struct {
		Argzone     string
		Argid       types.ID `json:"id"`
		ArgnicIndex int      `json:"nicIndex"`
	}{
		Argzone:     zone,
		Argid:       id,
		ArgnicIndex: nicIndex,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.DisconnectFromSwitch end")
	}()

	err := t.Internal.DisconnectFromSwitch(ctx, zone, id, nicIndex)
	targetResults := struct {
		Error error
	}{
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return err
}

// MonitorCPU is API call with trace log
func (t *VPCRouterTracer) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	log.Println("[TRACE] VPCRouterAPI.MonitorCPU start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.MonitorCPU end")
	}()

	resultCPUTimeActivity, err := t.Internal.MonitorCPU(ctx, zone, id, condition)
	targetResults := struct {
		CPUTimeActivity *iaas.CPUTimeActivity
		Error           error
	}{
		CPUTimeActivity: resultCPUTimeActivity,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultCPUTimeActivity, err
}

// MonitorInterface is API call with trace log
func (t *VPCRouterTracer) MonitorInterface(ctx context.Context, zone string, id types.ID, index int, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	log.Println("[TRACE] VPCRouterAPI.MonitorInterface start")
	targetArguments := struct {
		Argzone      string
		Argid        types.ID               `json:"id"`
		Argindex     int                    `json:"index"`
		Argcondition *iaas.MonitorCondition `json:"condition"`
	}{
		Argzone:      zone,
		Argid:        id,
		Argindex:     index,
		Argcondition: condition,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.MonitorInterface end")
	}()

	resultInterfaceActivity, err := t.Internal.MonitorInterface(ctx, zone, id, index, condition)
	targetResults := struct {
		InterfaceActivity *iaas.InterfaceActivity
		Error             error
	}{
		InterfaceActivity: resultInterfaceActivity,
		Error:             err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultInterfaceActivity, err
}

// Status is API call with trace log
func (t *VPCRouterTracer) Status(ctx context.Context, zone string, id types.ID) (*iaas.VPCRouterStatus, error) {
	log.Println("[TRACE] VPCRouterAPI.Status start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Status end")
	}()

	resultVPCRouterStatus, err := t.Internal.Status(ctx, zone, id)
	targetResults := struct {
		VPCRouterStatus *iaas.VPCRouterStatus
		Error           error
	}{
		VPCRouterStatus: resultVPCRouterStatus,
		Error:           err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouterStatus, err
}

// Logs is API call with trace log
func (t *VPCRouterTracer) Logs(ctx context.Context, zone string, id types.ID) (*iaas.VPCRouterLog, error) {
	log.Println("[TRACE] VPCRouterAPI.Logs start")
	targetArguments := struct {
		Argzone string
		Argid   types.ID `json:"id"`
	}{
		Argzone: zone,
		Argid:   id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Logs end")
	}()

	resultVPCRouterLog, err := t.Internal.Logs(ctx, zone, id)
	targetResults := struct {
		VPCRouterLog *iaas.VPCRouterLog
		Error        error
	}{
		VPCRouterLog: resultVPCRouterLog,
		Error:        err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouterLog, err
}

// Ping is API call with trace log
func (t *VPCRouterTracer) Ping(ctx context.Context, zone string, id types.ID, destination string) (*iaas.VPCRouterPingResults, error) {
	log.Println("[TRACE] VPCRouterAPI.Ping start")
	targetArguments := struct {
		Argzone        string
		Argid          types.ID `json:"id"`
		Argdestination string   `json:"destination"`
	}{
		Argzone:        zone,
		Argid:          id,
		Argdestination: destination,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] VPCRouterAPI.Ping end")
	}()

	resultVPCRouterPingResults, err := t.Internal.Ping(ctx, zone, id, destination)
	targetResults := struct {
		VPCRouterPingResults *iaas.VPCRouterPingResults
		Error                error
	}{
		VPCRouterPingResults: resultVPCRouterPingResults,
		Error:                err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultVPCRouterPingResults, err
}

/*************************************************
* ZoneTracer
*************************************************/

// ZoneTracer is for trace ZoneOp operations
type ZoneTracer struct {
	Internal iaas.ZoneAPI
}

// NewZoneTracer creates new ZoneTracer instance
func NewZoneTracer(in iaas.ZoneAPI) iaas.ZoneAPI {
	return &ZoneTracer{
		Internal: in,
	}
}

// Find is API call with trace log
func (t *ZoneTracer) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ZoneFindResult, error) {
	log.Println("[TRACE] ZoneAPI.Find start")
	targetArguments := struct {
		Argconditions *iaas.FindCondition `json:"conditions"`
	}{
		Argconditions: conditions,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ZoneAPI.Find end")
	}()

	result, err := t.Internal.Find(ctx, conditions)
	targetResults := struct {
		Result *iaas.ZoneFindResult
		Error  error
	}{
		Result: result,
		Error:  err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return result, err
}

// Read is API call with trace log
func (t *ZoneTracer) Read(ctx context.Context, id types.ID) (*iaas.Zone, error) {
	log.Println("[TRACE] ZoneAPI.Read start")
	targetArguments := struct {
		Argid types.ID `json:"id"`
	}{
		Argid: id,
	}
	if d, err := json.Marshal(targetArguments); err == nil {
		log.Printf("[TRACE] \targs: %s\n", string(d))
	}

	defer func() {
		log.Println("[TRACE] ZoneAPI.Read end")
	}()

	resultZone, err := t.Internal.Read(ctx, id)
	targetResults := struct {
		Zone  *iaas.Zone
		Error error
	}{
		Zone:  resultZone,
		Error: err,
	}
	if d, err := json.Marshal(targetResults); err == nil {
		log.Printf("[TRACE] \tresults: %s\n", string(d))
	}

	return resultZone, err
}
