/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.wine;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.clipsrules.jni.CLIPSException;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.FactAddressValue;
import net.sf.clipsrules.jni.LexemeValue;
import net.sf.clipsrules.jni.MultifieldValue;
import net.sf.clipsrules.jni.NumberValue;
import net.sf.clipsrules.jni.PrimitiveValue;

class WineDemo
implements ActionListener {
    JFrame jfrm;
    DefaultTableModel wineList;
    JComboBox<String> preferredColor;
    JComboBox<String> preferredBody;
    JComboBox<String> preferredSweetness;
    JComboBox<String> mainCourse;
    JComboBox<String> sauce;
    JComboBox<String> flavor;
    JLabel jlab;
    String[] preferredColorNames = new String[]{"Don't Care", "Red", "White"};
    String[] preferredBodyNames = new String[]{"Don't Care", "Light", "Medium", "Full"};
    String[] preferredSweetnessNames = new String[]{"Don't Care", "Dry", "Medium", "Sweet"};
    String[] mainCourseNames = new String[]{"Don't Know", "Beef", "Pork", "Lamb", "Turkey", "Chicken", "Duck", "Fish", "Other"};
    String[] sauceNames = new String[]{"Don't Know", "None", "Spicy", "Sweet", "Cream", "Other"};
    String[] flavorNames = new String[]{"Don't Know", "Delicate", "Average", "Strong"};
    String[] preferredColorChoices = new String[3];
    String[] preferredBodyChoices = new String[4];
    String[] preferredSweetnessChoices = new String[4];
    String[] mainCourseChoices = new String[9];
    String[] sauceChoices = new String[6];
    String[] flavorChoices = new String[4];
    ResourceBundle wineResources;
    Environment clips;
    boolean isExecuting = false;
    Thread executionThread;

    WineDemo() {
        try {
            this.wineResources = ResourceBundle.getBundle("net.sf.clipsrules.jni.examples.wine.resources.WineResources", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return;
        }
        this.preferredColorChoices[0] = this.wineResources.getString("Don'tCare");
        this.preferredColorChoices[1] = this.wineResources.getString("Red");
        this.preferredColorChoices[2] = this.wineResources.getString("White");
        this.preferredBodyChoices[0] = this.wineResources.getString("Don'tCare");
        this.preferredBodyChoices[1] = this.wineResources.getString("Light");
        this.preferredBodyChoices[2] = this.wineResources.getString("MediumBody");
        this.preferredBodyChoices[3] = this.wineResources.getString("Full");
        this.preferredSweetnessChoices[0] = this.wineResources.getString("Don'tCare");
        this.preferredSweetnessChoices[1] = this.wineResources.getString("Dry");
        this.preferredSweetnessChoices[2] = this.wineResources.getString("MediumSweetness");
        this.preferredSweetnessChoices[3] = this.wineResources.getString("Sweet");
        this.mainCourseChoices[0] = this.wineResources.getString("Don'tKnow");
        this.mainCourseChoices[1] = this.wineResources.getString("Beef");
        this.mainCourseChoices[2] = this.wineResources.getString("Pork");
        this.mainCourseChoices[3] = this.wineResources.getString("Lamb");
        this.mainCourseChoices[4] = this.wineResources.getString("Turkey");
        this.mainCourseChoices[5] = this.wineResources.getString("Chicken");
        this.mainCourseChoices[6] = this.wineResources.getString("Duck");
        this.mainCourseChoices[7] = this.wineResources.getString("Fish");
        this.mainCourseChoices[8] = this.wineResources.getString("Other");
        this.sauceChoices[0] = this.wineResources.getString("Don'tKnow");
        this.sauceChoices[1] = this.wineResources.getString("None");
        this.sauceChoices[2] = this.wineResources.getString("Spicy");
        this.sauceChoices[3] = this.wineResources.getString("Sweet");
        this.sauceChoices[4] = this.wineResources.getString("Cream");
        this.sauceChoices[5] = this.wineResources.getString("Other");
        this.flavorChoices[0] = this.wineResources.getString("Don'tKnow");
        this.flavorChoices[1] = this.wineResources.getString("Delicate");
        this.flavorChoices[2] = this.wineResources.getString("Average");
        this.flavorChoices[3] = this.wineResources.getString("Strong");
        this.jfrm = new JFrame(this.wineResources.getString("WineDemo"));
        this.jfrm.getContentPane().setLayout(new BoxLayout(this.jfrm.getContentPane(), 1));
        this.jfrm.setSize(480, 390);
        this.jfrm.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 2);
        jPanel.setLayout(gridLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.wineResources.getString("PreferencesTitle"), 2, 1));
        jPanel.add(new JLabel(this.wineResources.getString("ColorLabel")));
        this.preferredColor = new JComboBox<String>(this.preferredColorChoices);
        jPanel.add(this.preferredColor);
        this.preferredColor.addActionListener(this);
        jPanel.add(new JLabel(this.wineResources.getString("BodyLabel")));
        this.preferredBody = new JComboBox<String>(this.preferredBodyChoices);
        jPanel.add(this.preferredBody);
        this.preferredBody.addActionListener(this);
        jPanel.add(new JLabel(this.wineResources.getString("SweetnessLabel")));
        this.preferredSweetness = new JComboBox<String>(this.preferredSweetnessChoices);
        jPanel.add(this.preferredSweetness);
        this.preferredSweetness.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        gridLayout = new GridLayout(3, 2);
        jPanel2.setLayout(gridLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.wineResources.getString("MealTitle"), 2, 1));
        jPanel2.add(new JLabel(this.wineResources.getString("MainCourseLabel")));
        this.mainCourse = new JComboBox<String>(this.mainCourseChoices);
        jPanel2.add(this.mainCourse);
        this.mainCourse.addActionListener(this);
        jPanel2.add(new JLabel(this.wineResources.getString("SauceLabel")));
        this.sauce = new JComboBox<String>(this.sauceChoices);
        jPanel2.add(this.sauce);
        this.sauce.addActionListener(this);
        jPanel2.add(new JLabel(this.wineResources.getString("FlavorLabel")));
        this.flavor = new JComboBox<String>(this.flavorChoices);
        jPanel2.add(this.flavor);
        this.flavor.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.jfrm.getContentPane().add(jPanel3);
        this.wineList = new DefaultTableModel();
        this.wineList.setDataVector(new Object[0][], new Object[]{this.wineResources.getString("WineTitle"), this.wineResources.getString("RecommendationTitle")});
        JTable jTable = new JTable(this.wineList){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setCellSelectionEnabled(false);
        WeightCellRenderer weightCellRenderer = new WeightCellRenderer();
        weightCellRenderer.setBackground(jTable.getBackground());
        jTable.getColumnModel().getColumn(1).setCellRenderer(weightCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 210));
        this.jfrm.getContentPane().add(jScrollPane);
        this.preferredColor.setSelectedIndex(0);
        this.preferredBody.setSelectedIndex(0);
        this.preferredSweetness.setSelectedIndex(0);
        this.mainCourse.setSelectedIndex(0);
        this.sauce.setSelectedIndex(0);
        this.flavor.setSelectedIndex(0);
        this.clips = new Environment();
        try {
            this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/wine/resources/wine.clp");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            this.runWine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.jfrm.pack();
        this.jfrm.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.clips == null) {
            return;
        }
        try {
            this.runWine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runWine() throws Exception {
        if (this.isExecuting) {
            return;
        }
        this.clips.reset();
        String string = this.preferredColorNames[this.preferredColor.getSelectedIndex()];
        if (string.equals("Red")) {
            this.clips.assertString("(attribute (name preferred-color) (value red))");
        } else if (string.equals("White")) {
            this.clips.assertString("(attribute (name preferred-color) (value white))");
        } else {
            this.clips.assertString("(attribute (name preferred-color) (value unknown))");
        }
        string = this.preferredBodyNames[this.preferredBody.getSelectedIndex()];
        if (string.equals("Light")) {
            this.clips.assertString("(attribute (name preferred-body) (value light))");
        } else if (string.equals("Medium")) {
            this.clips.assertString("(attribute (name preferred-body) (value medium))");
        } else if (string.equals("Full")) {
            this.clips.assertString("(attribute (name preferred-body) (value full))");
        } else {
            this.clips.assertString("(attribute (name preferred-body) (value unknown))");
        }
        string = this.preferredSweetnessNames[this.preferredSweetness.getSelectedIndex()];
        if (string.equals("Dry")) {
            this.clips.assertString("(attribute (name preferred-sweetness) (value dry))");
        } else if (string.equals("Medium")) {
            this.clips.assertString("(attribute (name preferred-sweetness) (value medium))");
        } else if (string.equals("Sweet")) {
            this.clips.assertString("(attribute (name preferred-sweetness) (value sweet))");
        } else {
            this.clips.assertString("(attribute (name preferred-sweetness) (value unknown))");
        }
        string = this.mainCourseNames[this.mainCourse.getSelectedIndex()];
        if (string.equals("Beef") || string.equals("Pork") || string.equals("Lamb")) {
            this.clips.assertString("(attribute (name main-component) (value meat))");
            this.clips.assertString("(attribute (name has-turkey) (value no))");
        } else if (string.equals("Turkey")) {
            this.clips.assertString("(attribute (name main-component) (value poultry))");
            this.clips.assertString("(attribute (name has-turkey) (value yes))");
        } else if (string.equals("Chicken") || string.equals("Duck")) {
            this.clips.assertString("(attribute (name main-component) (value poultry))");
            this.clips.assertString("(attribute (name has-turkey) (value no))");
        } else if (string.equals("Fish")) {
            this.clips.assertString("(attribute (name main-component) (value fish))");
            this.clips.assertString("(attribute (name has-turkey) (value no))");
        } else if (string.equals("Other")) {
            this.clips.assertString("(attribute (name main-component) (value unknown))");
            this.clips.assertString("(attribute (name has-turkey) (value no))");
        } else {
            this.clips.assertString("(attribute (name main-component) (value unknown))");
            this.clips.assertString("(attribute (name has-turkey) (value unknown))");
        }
        string = this.sauceNames[this.sauce.getSelectedIndex()];
        if (string.equals("None")) {
            this.clips.assertString("(attribute (name has-sauce) (value no))");
        } else if (string.equals("Spicy")) {
            this.clips.assertString("(attribute (name has-sauce) (value yes))");
            this.clips.assertString("(attribute (name sauce) (value spicy))");
        } else if (string.equals("Sweet")) {
            this.clips.assertString("(attribute (name has-sauce) (value yes))");
            this.clips.assertString("(attribute (name sauce) (value sweet))");
        } else if (string.equals("Cream")) {
            this.clips.assertString("(attribute (name has-sauce) (value yes))");
            this.clips.assertString("(attribute (name sauce) (value cream))");
        } else if (string.equals("Other")) {
            this.clips.assertString("(attribute (name has-sauce) (value yes))");
            this.clips.assertString("(attribute (name sauce) (value unknown))");
        } else {
            this.clips.assertString("(attribute (name has-sauce) (value unknown))");
            this.clips.assertString("(attribute (name sauce) (value unknown))");
        }
        string = this.flavorNames[this.flavor.getSelectedIndex()];
        if (string.equals("Delicate")) {
            this.clips.assertString("(attribute (name tastiness) (value delicate))");
        } else if (string.equals("Average")) {
            this.clips.assertString("(attribute (name tastiness) (value average))");
        } else if (string.equals("Strong")) {
            this.clips.assertString("(attribute (name tastiness) (value strong))");
        } else {
            this.clips.assertString("(attribute (name tastiness) (value unknown))");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    WineDemo.this.clips.run();
                }
                catch (CLIPSException cLIPSException) {
                    cLIPSException.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WineDemo.this.updateWines();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        };
        this.isExecuting = true;
        this.executionThread = new Thread(runnable);
        this.executionThread.start();
    }

    private void updateWines() throws Exception {
        String string = "(WINES::get-wine-list)";
        MultifieldValue multifieldValue = (MultifieldValue)this.clips.eval(string);
        this.wineList.setRowCount(0);
        for (PrimitiveValue primitiveValue : multifieldValue) {
            FactAddressValue factAddressValue = (FactAddressValue)primitiveValue;
            int n = ((NumberValue)factAddressValue.getSlotValue("certainty")).intValue();
            String string2 = ((LexemeValue)factAddressValue.getSlotValue("value")).getValue();
            this.wineList.addRow(new Object[]{string2, n});
        }
        this.jfrm.pack();
        this.executionThread = null;
        this.isExecuting = false;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new WineDemo();
            }
        });
    }

    class WeightCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        public WeightCellRenderer() {
            super(0, 0, 100);
            this.setStringPainted(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setValue(((Number)object).intValue());
            return this;
        }
    }
}

