/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.clipsrules.jni.examples.ide.FontProperties;
import net.sf.clipsrules.jni.examples.ide.FontSample;

public class FontDialog
extends JDialog
implements ActionListener {
    protected FontProperties propertiesPanel;
    protected FontSample samplePanel;
    private Font selectedFont = null;
    private String selectedFontDescription = "";

    public FontDialog(Frame frame, Component component, String string, Font font) {
        super(frame, string, true);
        this.FontDialogBuilder(string, font);
        this.setLocationRelativeTo(component);
    }

    public FontDialog(JDialog jDialog, Component component, String string, Font font) {
        super(jDialog, string, true);
        this.FontDialogBuilder(string, font);
        this.setLocationRelativeTo(jDialog);
    }

    public void FontDialogBuilder(String string, Font font) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.propertiesPanel = new FontProperties(this);
        gridBagConstraints.weighty = 0.85;
        gridBagLayout.setConstraints(this.propertiesPanel, gridBagConstraints);
        container.add(this.propertiesPanel);
        this.samplePanel = new FontSample(0);
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), "Sample");
        this.samplePanel.setBorder(titledBorder);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.samplePanel, gridBagConstraints);
        container.add(this.samplePanel);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Set");
        jButton2.setActionCommand("Set");
        jButton2.addActionListener(this);
        this.getRootPane().setDefaultButton(jButton2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jButton2);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        this.refreshDisplayFont();
        this.setValue(font);
        this.pack();
    }

    public Font showDialog() {
        this.setMinimumSize(new Dimension(410, 230));
        this.setVisible(true);
        return this.selectedFont;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Set".equals(actionEvent.getActionCommand())) {
            this.selectedFontDescription = FontDialog.getSelectedFontDescription(this.selectedFont);
        } else {
            this.selectedFont = null;
        }
        this.setVisible(false);
    }

    public void refreshDisplayFont() {
        Font font = this.getSelectedFont();
        String string = FontDialog.getSelectedFontDescription(font);
        this.samplePanel.refreshSampleText(string, font);
    }

    public Font getSelectedFont() {
        String string = this.propertiesPanel.getSelectedFontName();
        int n = 0;
        n += this.propertiesPanel.isBoldSelected() ? 1 : 0;
        int n2 = this.propertiesPanel.isItalicSelected() ? 2 : 0;
        int n3 = this.propertiesPanel.getSelectedFontSize();
        this.selectedFont = new Font(string, n += n2, n3);
        return this.selectedFont;
    }

    public static String getSelectedFontDescription(Font font) {
        String string = font.isBold() ? (font.isItalic() ? " Bold Italic" : " Bold") : (font.isItalic() ? " Italic" : "");
        return font.getFamily() + " " + font.getSize() + string;
    }

    private void setValue(Font font) {
        this.selectedFont = font;
        String string = this.selectedFont.isBold() ? (this.selectedFont.isItalic() ? "Bold Italic" : "Bold") : (this.selectedFont.isItalic() ? "Italic" : "Regular");
        this.propertiesPanel.setFont(this.selectedFont.getFamily(), string, this.selectedFont.getSize());
    }
}

