/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import net.sf.clipsrules.jni.CommandExecutionEvent;
import net.sf.clipsrules.jni.CommandExecutionListener;
import net.sf.clipsrules.jni.CommandPromptTextArea;
import net.sf.clipsrules.jni.Environment;

public class DialogFrame
extends JInternalFrame
implements ActionListener,
CommandExecutionListener {
    private JFrame ideFrame;
    private CommandPromptTextArea commandTextArea;
    private JLabel currentDirectoryLabel;
    private JToggleButton pauseButton = null;
    private Environment clips;
    static final String pauseAction = "Pause";

    DialogFrame() {
        this(new Environment(), null, new Font("monospaced", 0, 12));
    }

    DialogFrame(Environment environment) {
        this(environment, null, new Font("monospaced", 0, 12));
    }

    DialogFrame(File file, Font font) {
        this(new Environment(), file, font);
    }

    DialogFrame(Environment environment, File file, Font font) {
        super("Dialog", true, false, true, true);
        this.clips = environment;
        if (file == null) {
            File file2 = new File(System.getProperty("user.dir"));
            file = file2.getAbsoluteFile();
        }
        int n = this.clips.changeDirectory(file.getAbsolutePath());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setSize(600, 400);
        this.setMinimumSize(new Dimension(550, 250));
        this.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(600, 40));
        this.currentDirectoryLabel = new JLabel("Dir: ");
        if (n == 1) {
            this.currentDirectoryLabel.setText("Dir: " + file.getAbsolutePath());
        } else {
            this.currentDirectoryLabel.setText("Dir: ");
        }
        jPanel.add(this.currentDirectoryLabel);
        this.pauseButton = new JToggleButton(pauseAction);
        this.pauseButton.setEnabled(false);
        this.pauseButton.setActionCommand(pauseAction);
        this.pauseButton.addActionListener(this);
        jPanel.add(this.pauseButton);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.currentDirectoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pauseButton));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.currentDirectoryLabel).addComponent(this.pauseButton));
        this.getContentPane().add(jPanel);
        try {
            this.commandTextArea = new CommandPromptTextArea(this.clips, font);
            this.commandTextArea.addCommandExecutionListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        JScrollPane jScrollPane = new JScrollPane(this.commandTextArea);
        jScrollPane.setPreferredSize(new Dimension(600, 360));
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.getContentPane().add(jScrollPane);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(86, 128);
        InputMap inputMap = this.commandTextArea.getInputMap();
        inputMap.put(keyStroke, "none");
        inputMap.put(keyStroke2, "none");
        inputMap.put(keyStroke3, "none");
        this.pack();
    }

    public void addCommandExecutionListener(CommandExecutionListener commandExecutionListener) {
        this.commandTextArea.addCommandExecutionListener(commandExecutionListener);
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals(pauseAction)) {
            this.pause();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pause() {
        if (this.commandTextArea.isPaused()) {
            this.commandTextArea.setPaused(false);
        } else {
            this.commandTextArea.setPaused(true);
        }
    }

    public void updatePauseButton(final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.pauseButton.setEnabled(bl);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DialogFrame.this.pauseButton.setEnabled(bl);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void commandExecutionEventOccurred(CommandExecutionEvent commandExecutionEvent) {
        if (commandExecutionEvent.getExecutionEvent().equals("start")) {
            this.updatePauseButton(true);
        } else if (commandExecutionEvent.getExecutionEvent().equals("finish")) {
            this.updatePauseButton(false);
        }
    }

    public Environment getEnvironment() {
        return this.clips;
    }

    public boolean hasCuttableSelection() {
        return this.commandTextArea.hasCuttableSelection();
    }

    public boolean hasPasteableSelection() {
        return this.commandTextArea.hasPasteableSelection();
    }

    public boolean hasSelection() {
        return this.commandTextArea.hasSelection();
    }

    public void cut() {
        this.commandTextArea.cut();
    }

    public void copy() {
        this.commandTextArea.copy();
    }

    public void paste() {
        this.commandTextArea.paste();
    }

    public boolean isExecuting() {
        return this.commandTextArea.getExecuting();
    }

    public void haltRules() {
        this.clips.setHaltRules(true);
    }

    public void haltExecution() {
        this.clips.setHaltExecution(true);
    }

    public void replaceCommand(String string) {
        this.commandTextArea.replaceCommand(string);
    }

    public void clearScrollback() {
        this.commandTextArea.clear();
        this.clips.printPrompt();
        this.clips.print(this.clips.getInputBuffer());
    }

    public void executeBatch() {
        this.commandTextArea.executeBatch();
    }

    @Override
    public void setFont(Font font) {
        this.commandTextArea.setFont(font);
    }

    public boolean setDirectory(File file) {
        int n = this.clips.changeDirectory(file.getAbsolutePath());
        if (n == 1) {
            this.currentDirectoryLabel.setText("Dir: " + file.getAbsolutePath());
            return true;
        }
        return false;
    }
}

