/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.Router;

public class RouterTextArea
extends JTextArea
implements Router,
KeyListener,
CaretListener,
FocusListener,
DropTargetListener,
ActionListener {
    protected Environment clips;
    static final int bufferSize = 32768;
    private static int TextAreaRouterNameIndex = 0;
    private String routerName;
    private boolean charNeeded = false;
    private List<Byte> charList = new ArrayList<Byte>();
    private StringBuffer outputBuffer = new StringBuffer(32768);
    private int maxLines = 1000;
    private boolean hasFocus = false;
    private Timer dumpTimer = null;
    Border activeBorder;
    Border inactiveBorder;
    static final String dumpOutputAction = "dumpOutput";

    public RouterTextArea(Environment environment) {
        this(environment, new Font("monospaced", 0, 12));
    }

    public RouterTextArea(Environment environment, Font font) {
        this.clips = environment;
        this.setEditable(false);
        this.setDragEnabled(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setBorders(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.white, 3), BorderFactory.createEmptyBorder(5, 5, 5, 0)), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray, 3), BorderFactory.createEmptyBorder(5, 5, 5, 0)));
        this.setFont(font);
        this.routerName = "JTextAreaRouter" + TextAreaRouterNameIndex++;
        this.clips.addRouter(this);
        this.setDropTarget(new DropTarget(this, this));
        ((DefaultCaret)this.getCaret()).setUpdatePolicy(2);
        this.addCaretListener(this);
    }

    public void setBorders(Border border, Border border2) {
        this.inactiveBorder = border;
        this.activeBorder = border2;
        if (this.hasFocus) {
            this.setBorder(this.activeBorder);
        } else {
            this.setBorder(this.inactiveBorder);
        }
    }

    public void setPlainBorder() {
        this.setBorders(BorderFactory.createEmptyBorder(5, 5, 5, 0), BorderFactory.createEmptyBorder(5, 5, 5, 0));
    }

    public Environment getEnvironment() {
        return this.clips;
    }

    public synchronized boolean appendChars(String string) {
        if (!this.charNeeded) {
            return false;
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                this.charList.add(byArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.charNeeded = false;
        this.notifyAll();
        return true;
    }

    public synchronized int pushChar(int n) {
        this.charList.add(0, (byte)n);
        return n;
    }

    public synchronized int requestChar() {
        if (this.clips.getInputBufferCount() == 0L && this.charList.size() != 0) {
            this.charList.clear();
        }
        if (this.charList.size() == 0) {
            this.charNeeded = true;
            while (this.charNeeded) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        Byte by = this.charList.get(0);
        this.charList.remove(0);
        return by.intValue();
    }

    public synchronized boolean supplyChar(char c) {
        if (!this.charNeeded) {
            return false;
        }
        String string = String.valueOf(c);
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                this.charList.add(byArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.charNeeded = false;
        this.notifyAll();
        return true;
    }

    public boolean hasSelection() {
        int n;
        int n2 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        return n2 != (n = Math.max(this.getCaret().getDot(), this.getCaret().getMark()));
    }

    public synchronized boolean hasCuttableSelection() {
        return false;
    }

    public synchronized boolean hasPasteableSelection() {
        int n;
        if (!this.charNeeded) {
            return false;
        }
        int n2 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        if (n2 != (n = Math.max(this.getCaret().getDot(), this.getCaret().getMark()))) {
            return false;
        }
        return n2 == this.getText().length();
    }

    @Override
    public void paste() {
        if (!this.hasPasteableSelection()) {
            return;
        }
        try {
            String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            if (this.appendChars(string)) {
                this.dumpOutput();
                this.setCaretPosition(this.getText().length());
                this.append(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public String getName() {
        return this.routerName;
    }

    @Override
    public boolean query(String string) {
        return string.equals("stdout") || string.equals("stdin") || string.equals("stdwrn") || string.equals("stderr");
    }

    private synchronized void clearOutput() {
        if (this.dumpTimer != null) {
            this.dumpTimer.stop();
        }
        this.outputBuffer.setLength(0);
        this.outputBuffer.ensureCapacity(32768);
        this.replaceRange("", 0, this.getText().length());
        this.dumpTimer = null;
    }

    public void clear() {
        if (EventQueue.isDispatchThread()) {
            this.clearOutput();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RouterTextArea.this.clearOutput();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized boolean createTimer(String string) {
        this.outputBuffer.append(string);
        if (this.dumpTimer == null) {
            this.dumpTimer = new Timer(100, this);
            this.dumpTimer.setRepeats(false);
            this.dumpTimer.setActionCommand(dumpOutputAction);
            this.dumpTimer.start();
            return true;
        }
        return false;
    }

    protected void dumpOutput() {
        if (this.outputBuffer.length() == 0) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.checkTimer();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RouterTextArea.this.checkTimer();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void write(String string, String string2) {
        this.createTimer(string2);
    }

    public void checkLineCount() {
        if (this.getLineCount() > this.maxLines) {
            try {
                int n = this.getLineStartOffset(0);
                int n2 = this.getLineStartOffset(this.getLineCount() - this.maxLines);
                this.replaceRange("", n, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int read(String string) {
        return this.requestChar();
    }

    @Override
    public int unread(String string, int n) {
        return this.pushChar(n);
    }

    @Override
    public void exit(boolean bl) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\b' || c == '\u007f') {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\b' || c == '\u007f') {
            keyEvent.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if ((keyEvent.getModifiersEx() & 0x380) != 0) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if ((c == '\b' || c == '\u007f') && this.clips.getInputBufferCount() == 0L) {
            keyEvent.consume();
            return;
        }
        this.dumpOutput();
        if (this.supplyChar(c)) {
            if (c == '\b' || c == '\u007f') {
                this.replaceRange("", this.getText().length() - 1, this.getText().length());
            } else {
                this.append(String.valueOf(c));
            }
            keyEvent.consume();
        }
    }

    private synchronized boolean checkTimer() {
        if (this.dumpTimer != null) {
            this.dumpTimer.stop();
        }
        this.append(this.outputBuffer.toString());
        this.checkLineCount();
        this.outputBuffer.setLength(0);
        this.outputBuffer.ensureCapacity(32768);
        this.dumpTimer = null;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(dumpOutputAction)) {
            this.checkTimer();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.setBorder(this.activeBorder);
        this.getCaret().setVisible(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.setBorder(this.inactiveBorder);
        this.getCaret().setVisible(false);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = true;
        this.dragUnderFeedback(dropTargetDragEvent, bl);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = this.acceptOrRejectDrag(dropTargetDragEvent);
        this.dragUnderFeedback(dropTargetDragEvent, bl);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.dragUnderFeedback(null, false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = this.acceptOrRejectDrag(dropTargetDragEvent);
        this.dragUnderFeedback(dropTargetDragEvent, bl);
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if ((dropTargetDropEvent.getDropAction() & 3) == 0) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                String string = (String)transferable.getTransferData(dataFlavorArray[i]);
                if (this.appendChars(string)) {
                    this.dumpOutput();
                    this.setCaretPosition(this.getText().length());
                    this.append(string);
                }
                this.requestFocus();
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    protected void dragUnderFeedback(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        if (dropTargetDragEvent != null && bl) {
            Point point = dropTargetDragEvent.getLocation();
            this.getCaret().setVisible(true);
            this.setCaretPosition(this.viewToModel(point));
        } else {
            this.getCaret().setVisible(false);
        }
    }

    protected boolean checkTransferType(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    protected int dragTargetCaretStart() {
        return this.getText().length();
    }

    protected int dragTargetCaretEnd() {
        return this.getText().length();
    }

    protected boolean acceptOrRejectDrag(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        int n2 = dropTargetDragEvent.getSourceActions();
        Point point = dropTargetDragEvent.getLocation();
        int n3 = this.viewToModel(point);
        if (n3 < this.dragTargetCaretStart() || n3 > this.dragTargetCaretEnd()) {
            dropTargetDragEvent.rejectDrag();
            return false;
        }
        if (!this.checkTransferType(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return false;
        }
        if ((n2 & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
            return false;
        }
        if ((n & 3) == 0) {
            dropTargetDragEvent.rejectDrag();
            return false;
        }
        dropTargetDragEvent.acceptDrag(n);
        return true;
    }

    @Override
    public void caretUpdate(final CaretEvent caretEvent) {
        if (EventQueue.isDispatchThread()) {
            this.removeCaretListener(this);
            this.caretUpdateAction(caretEvent.getDot(), caretEvent.getMark());
            this.addCaretListener(this);
            return;
        }
        this.removeCaretListener(this);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RouterTextArea.this.caretUpdateAction(caretEvent.getDot(), caretEvent.getMark());
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addCaretListener(this);
    }

    protected void caretUpdateAction(int n, int n2) {
        if (n == n2) {
            int n3 = this.getText().length();
            if (n < n3) {
                this.getCaret().setDot(n3);
            }
            if (this.hasFocus) {
                this.getCaret().setVisible(true);
            }
        } else {
            this.getCaret().setVisible(false);
        }
    }
}

