/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// BatchCheckResponse struct for BatchCheckResponse
type BatchCheckResponse struct {
	// map keys are the correlation_id values from the BatchCheckItems in the request
	Result *map[string]BatchCheckSingleResult `json:"result,omitempty" yaml:"result,omitempty"`
}

// NewBatchCheckResponse instantiates a new BatchCheckResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBatchCheckResponse() *BatchCheckResponse {
	this := BatchCheckResponse{}
	return &this
}

// NewBatchCheckResponseWithDefaults instantiates a new BatchCheckResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBatchCheckResponseWithDefaults() *BatchCheckResponse {
	this := BatchCheckResponse{}
	return &this
}

// GetResult returns the Result field value if set, zero value otherwise.
func (o *BatchCheckResponse) GetResult() map[string]BatchCheckSingleResult {
	if o == nil || o.Result == nil {
		var ret map[string]BatchCheckSingleResult
		return ret
	}
	return *o.Result
}

// GetResultOk returns a tuple with the Result field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BatchCheckResponse) GetResultOk() (*map[string]BatchCheckSingleResult, bool) {
	if o == nil || o.Result == nil {
		return nil, false
	}
	return o.Result, true
}

// HasResult returns a boolean if a field has been set.
func (o *BatchCheckResponse) HasResult() bool {
	if o != nil && o.Result != nil {
		return true
	}

	return false
}

// SetResult gets a reference to the given map[string]BatchCheckSingleResult and assigns it to the Result field.
func (o *BatchCheckResponse) SetResult(v map[string]BatchCheckSingleResult) {
	o.Result = &v
}

func (o BatchCheckResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Result != nil {
		toSerialize["result"] = o.Result
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableBatchCheckResponse struct {
	value *BatchCheckResponse
	isSet bool
}

func (v NullableBatchCheckResponse) Get() *BatchCheckResponse {
	return v.value
}

func (v *NullableBatchCheckResponse) Set(val *BatchCheckResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableBatchCheckResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableBatchCheckResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBatchCheckResponse(val *BatchCheckResponse) *NullableBatchCheckResponse {
	return &NullableBatchCheckResponse{value: val, isSet: true}
}

func (v NullableBatchCheckResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBatchCheckResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
