#!/bin/sh
# Nagios cached check script for GLSAs (Gentoo Linux Security Advisories)
# Created by <robbat2@gentoo.org>
# Distributed under BSD-2
# 
# Invokes the check_glsa2.sh scripy by craig.

# Caches the result of check_glsa2.sh
# First line is the return code, rest of the file is the message
NAME=$(basename $0 .sh)
CACHEDIR=/var/lib/gentoo/
CACHEFILE=${CACHEDIR}/check_glsa2.cache
SCRIPT=/usr/lib/nagios/plugins/check_glsa2.sh
ret=0
FIND_AGE_CHECK='-mtime -2'

mkdir -p $CACHEDIR

# Keep the file secure
umask 037

do_clean_cache() {
	# If the file is more than 2 days old, clean it.
	find $CACHEFILE ! ${FIND_AGE_CHECK} -exec rm {} \;
	exit 0
}
do_generate_cache() {
	tmp="${CACHEFILE}.tmp"
	$SCRIPT >$tmp
	( echo $? ; cat $tmp ) >${CACHEFILE} 
	if [ ! -s $tmp ]; then
		echo \
		-e "3\nERROR - $NAME failed running $SCRIPT to generate cache" \
		| tee $CACHEFILE
		exit 1
	fi
	chgrp nagios $CACHEFILE
	chmod 640 $CACHEFILE
	rm -f $tmp
	exit 0
}
do_use_cache() {
	if [ ! -f $CACHEFILE ]; then
		echo "ERROR - $NAME cache file $CACHEFILE does not exist"
		exit 3
	fi
	if [ -z "$(find $CACHEFILE ${FIND_AGE_CHECK})" ]; then
		echo "ERROR - $NAME cache file $CACHEFILE is too old"
		exit 3
	fi
	ret=3
	exec 3<$CACHEFILE
	read ret <&3
	cat <&3
	exit $ret
}
do_help() {
	cat <<-EOF
Usage: $0 ARGS
Cached version of the check_glsa2.sh script.

Modes (one MUST be selected):
  --generate	- Generate cache
  --check		- Return content of cache
  --clean		- Remove cache forcibly
  --help		- This document
	EOF
}

case "$1" in
	--generate) do_generate_cache ;;
	--check) do_use_cache ;;
	--clean) do_clean_cache ;;
	--help) do_help ;;
	*) echo "ERROR - $NAME invalid arguments" ; exit 3 ;;
esac
