/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import org.rundeck.client.api.LoginFailed;
import org.rundeck.client.util.ServiceClient;

public class FormAuthInterceptor
implements Interceptor {
    private boolean authorized;
    private final String username;
    private final String password;
    private final String baseUrl;
    private final String j_security_url;
    private final String usernameField;
    private final String passwordField;
    private final String loginErrorURLPath;

    public FormAuthInterceptor(String username, String password, String baseUrl, String securityUrl, String usernameField, String passwordField, String loginErrorPath) {
        this.username = username;
        this.password = password;
        this.baseUrl = baseUrl;
        this.j_security_url = securityUrl;
        this.usernameField = usernameField;
        this.passwordField = passwordField;
        this.loginErrorURLPath = loginErrorPath;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (!this.authorized) {
            this.authenticate(chain);
        }
        return chain.proceed(chain.request());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(Interceptor.Chain chain) throws IOException {
        Response baseResponse = chain.proceed(this.baseUrlRequest());
        try {
            if (!baseResponse.isSuccessful()) {
                throw new IllegalStateException(String.format("Expected successful response from: %s", this.baseUrl));
            }
        }
        finally {
            baseResponse.body().close();
        }
        Response authResponse = chain.proceed(this.postAuthRequest());
        try {
            if (!authResponse.isSuccessful()) {
                throw new IllegalStateException("Password Authentication failed, expected a successful response.");
            }
            if (authResponse.request().url().toString().contains(this.loginErrorURLPath)) {
                throw new LoginFailed(String.format("Password Authentication failed for: %s", this.username));
            }
            if (null == authResponse.priorResponse() && ServiceClient.hasAnyMediaType(authResponse.body().contentType(), MediaType.parse("text/html"))) {
                String securitycheck = System.getProperty("rundeck.client.j_security_check", "j_security_check");
                if (authResponse.body().string().contains("action=\"" + securitycheck + "\"")) {
                    throw new LoginFailed(String.format("Password Authentication failed for: %s", this.username));
                }
            }
        }
        finally {
            authResponse.body().close();
        }
        this.authorized = true;
    }

    private Request postAuthRequest() {
        return new Request.Builder().url(this.j_security_url).post(new FormBody.Builder().add(this.usernameField, this.username).add(this.passwordField, this.password).build()).build();
    }

    private Request baseUrlRequest() {
        return new Request.Builder().url(this.baseUrl).build();
    }
}

