/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.projects;

import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.rundeck.client.api.ReadmeFile;
import org.rundeck.client.api.model.ProjectReadme;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.ProjectInput;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.tool.options.ProjectRequiredNameOptions;
import picocli.CommandLine;

@CommandLine.Command(description={"Manage Project readme.md/motd.md"}, name="readme")
public class Readme
extends BaseCommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    String validate(ProjectInput input) throws InputError {
        if (null != input.getProject()) {
            ProjectRequiredNameOptions.validateProjectName(input.getProject(), this.spec);
        }
        return this.getRdTool().projectOrEnv(input);
    }

    @CommandLine.Command(description={"get project readme/motd file"})
    public void get(@CommandLine.Mixin BaseOptions opts) throws IOException, InputError {
        String project = this.validate(opts);
        ProjectReadme readme = (ProjectReadme)this.apiCall(api -> api.getReadme(project, opts.getReadmeFile()));
        this.getRdOutput().output(readme.getContents());
    }

    @CommandLine.Command(description={"set project readme/motd file"})
    public void put(@CommandLine.Mixin SetOptions options, @CommandLine.Mixin BaseOptions opts) throws IOException, InputError {
        if (!options.isText() && !options.isFile()) {
            throw new InputError("-f/--file or -t/--text is required");
        }
        RequestBody requestBody = options.isFile() ? RequestBody.create(options.getFile(), MediaType.parse("text/plain")) : RequestBody.create(options.getText(), MediaType.parse("text/plain"));
        String project = this.validate(opts);
        ProjectReadme readme = (ProjectReadme)this.apiCall(api -> api.putReadme(project, opts.getReadmeFile(), requestBody));
        this.getRdOutput().output(readme.getContents());
    }

    @CommandLine.Command(description={"delete project readme/motd file"})
    public void delete(@CommandLine.Mixin BaseOptions opts) throws IOException, InputError {
        String project = this.validate(opts);
        Void readme = (Void)this.apiCall(api -> api.deleteReadme(project, opts.getReadmeFile()));
        this.getRdOutput().info(String.format("Deleted %s for project %s", new Object[]{opts.getReadmeFile(), project}));
    }

    public static class SetOptions {
        @CommandLine.Option(names={"-f", "--file"}, description={"Path to a file to read for readme/motd contents."})
        File file;
        @CommandLine.Option(names={"-t", "--text"}, description={"Text to use for readme/motd contents."})
        String text;

        boolean isFile() {
            return this.file != null;
        }

        boolean isText() {
            return this.text != null;
        }

        public File getFile() {
            return this.file;
        }

        public String getText() {
            return this.text;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    static class BaseOptions
    extends ProjectNameOptions {
        @CommandLine.Option(names={"-m", "--motd"}, description={"Choose the 'motd.md' file. If unset, choose 'readme.md'."})
        private boolean motd;

        BaseOptions() {
        }

        public ReadmeFile getReadmeFile() {
            return this.isMotd() ? ReadmeFile.MOTD : ReadmeFile.README;
        }

        public boolean isMotd() {
            return this.motd;
        }

        public void setMotd(boolean motd) {
            this.motd = motd;
        }
    }
}

