/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.IOException;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.ProjectInput;
import org.rundeck.client.tool.RdApp;
import org.rundeck.client.tool.extension.RdCommandExtension;
import org.rundeck.client.tool.extension.RdOutput;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.ConfigSource;
import org.rundeck.client.util.RdClientConfig;
import org.rundeck.client.util.ServiceClient;
import retrofit2.Call;

public class RdToolImpl
implements RdTool {
    private final RdApp rdApp;

    public RdToolImpl(RdApp rdApp) {
        this.rdApp = rdApp;
    }

    @Override
    public <T extends RdCommandExtension> T initExtension(T extension) {
        extension.setRdTool(this);
        if (extension instanceof RdOutput) {
            ((RdOutput)((Object)extension)).setRdOutput(this.rdApp.getOutput());
        }
        return extension;
    }

    @Override
    public ServiceClient<RundeckApi> getClient() throws InputError {
        return this.getRdApp().getClient();
    }

    @Override
    public RdClientConfig getAppConfig() {
        return this.getRdApp().getAppConfig();
    }

    @Override
    public <T> T apiCall(Function<RundeckApi, Call<T>> func) throws InputError, IOException {
        return this.apiCallDowngradable(func);
    }

    @Override
    public <T> ServiceClient.WithErrorResponse<T> apiWithErrorResponse(Function<RundeckApi, Call<T>> func) throws InputError, IOException {
        return this.apiWithErrorResponseDowngradable(func);
    }

    @Override
    public <T> T apiCallDowngradable(Function<RundeckApi, Call<T>> func) throws InputError, IOException {
        try {
            return this.rdApp.getClient().apiCallDowngradable(func);
        }
        catch (Client.UnsupportedVersionDowngrade downgrade) {
            this.rdApp.versionDowngradeWarning(downgrade.getRequestedVersion(), downgrade.getSupportedVersion());
            return this.rdApp.getClient(downgrade.getSupportedVersion()).apiCall(func);
        }
    }

    @Override
    public <T> ServiceClient.WithErrorResponse<T> apiWithErrorResponseDowngradable(Function<RundeckApi, Call<T>> func) throws InputError, IOException {
        try {
            return this.rdApp.getClient().apiWithErrorResponseDowngradable(func);
        }
        catch (Client.UnsupportedVersionDowngrade downgrade) {
            this.rdApp.versionDowngradeWarning(downgrade.getRequestedVersion(), downgrade.getSupportedVersion());
            return this.rdApp.getClient(downgrade.getSupportedVersion()).apiWithErrorResponse(func);
        }
    }

    @Override
    public String projectOrEnv(ProjectInput options) throws InputError {
        if (null != options.getProject()) {
            return options.getProject();
        }
        try {
            String rd_project = this.getAppConfig().require("RD_PROJECT", "or specify as `-p/--project value` : Project name.");
            Pattern pat = Pattern.compile("^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
            if (!pat.matcher(rd_project).matches()) {
                throw new InputError(String.format("Cannot match (%s) to pattern: /%s/ : RD_PROJECT", rd_project, "^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$"));
            }
            return rd_project;
        }
        catch (ConfigSource.ConfigSourceError configSourceError) {
            throw new InputError(configSourceError.getMessage());
        }
    }

    @Override
    public void requireApiVersion(String description, int min) throws InputError {
        RdTool.apiVersionCheck(description, min, this.getClient().getApiVersion());
    }

    @Override
    public RdApp getRdApp() {
        return this.rdApp;
    }
}

