use crate::Algorithm;
pub const CRC_8_AUTOSAR: Algorithm<u8> = Algorithm { poly: 0x2f, init: 0xff, refin: false, refout: false, xorout: 0xff, check: 0xdf, residue: 0x42 };
pub const CRC_8_BLUETOOTH: Algorithm<u8> = Algorithm { poly: 0xa7, init: 0x00, refin: true, refout: true, xorout: 0x00, check: 0x26, residue: 0x00 };
pub const CRC_8_CDMA2000: Algorithm<u8> = Algorithm { poly: 0x9b, init: 0xff, refin: false, refout: false, xorout: 0x00, check: 0xda, residue: 0x00 };
pub const CRC_8_DARC: Algorithm<u8> = Algorithm { poly: 0x39, init: 0x00, refin: true, refout: true, xorout: 0x00, check: 0x15, residue: 0x00 };
pub const CRC_8_DVB_S2: Algorithm<u8> = Algorithm { poly: 0xd5, init: 0x00, refin: false, refout: false, xorout: 0x00, check: 0xbc, residue: 0x00 };
pub const CRC_8_GSM_A: Algorithm<u8> = Algorithm { poly: 0x1d, init: 0x00, refin: false, refout: false, xorout: 0x00, check: 0x37, residue: 0x00 };
pub const CRC_8_GSM_B: Algorithm<u8> = Algorithm { poly: 0x49, init: 0x00, refin: false, refout: false, xorout: 0xff, check: 0x94, residue: 0x53 };
pub const CRC_8_I_432_1: Algorithm<u8> = Algorithm { poly: 0x07, init: 0x00, refin: false, refout: false, xorout: 0x55, check: 0xa1, residue: 0xac };
pub const CRC_8_I_CODE: Algorithm<u8> = Algorithm { poly: 0x1d, init: 0xfd, refin: false, refout: false, xorout: 0x00, check: 0x7e, residue: 0x00 };
pub const CRC_8_LTE: Algorithm<u8> = Algorithm { poly: 0x9b, init: 0x00, refin: false, refout: false, xorout: 0x00, check: 0xea, residue: 0x00 };
pub const CRC_8_MAXIM_DOW: Algorithm<u8> = Algorithm { poly: 0x31, init: 0x00, refin: true, refout: true, xorout: 0x00, check: 0xa1, residue: 0x00 };
pub const CRC_8_MIFARE_MAD: Algorithm<u8> = Algorithm { poly: 0x1d, init: 0xc7, refin: false, refout: false, xorout: 0x00, check: 0x99, residue: 0x00 };
pub const CRC_8_NRSC_5: Algorithm<u8> = Algorithm { poly: 0x31, init: 0xff, refin: false, refout: false, xorout: 0x00, check: 0xf7, residue: 0x00 };
pub const CRC_8_OPENSAFETY: Algorithm<u8> = Algorithm { poly: 0x2f, init: 0x00, refin: false, refout: false, xorout: 0x00, check: 0x3e, residue: 0x00 };
pub const CRC_8_ROHC: Algorithm<u8> = Algorithm { poly: 0x07, init: 0xff, refin: true, refout: true, xorout: 0x00, check: 0xd0, residue: 0x00 };
pub const CRC_8_SAE_J1850: Algorithm<u8> = Algorithm { poly: 0x1d, init: 0xff, refin: false, refout: false, xorout: 0xff, check: 0x4b, residue: 0xc4 };
pub const CRC_8_SMBUS: Algorithm<u8> = Algorithm { poly: 0x07, init: 0x00, refin: false, refout: false, xorout: 0x00, check: 0xf4, residue: 0x00 };
pub const CRC_8_TECH_3250: Algorithm<u8> = Algorithm { poly: 0x1d, init: 0xff, refin: true, refout: true, xorout: 0x00, check: 0x97, residue: 0x00 };
pub const CRC_8_WCDMA: Algorithm<u8> = Algorithm { poly: 0x9b, init: 0x00, refin: true, refout: true, xorout: 0x00, check: 0x25, residue: 0x00 };
pub const CRC_16_ARC: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0x0000, refin: true, refout: true, xorout: 0x0000, check: 0xbb3d, residue: 0x0000 };
pub const CRC_16_CDMA2000: Algorithm<u16> = Algorithm { poly: 0xc867, init: 0xffff, refin: false, refout: false, xorout: 0x0000, check: 0x4c06, residue: 0x0000 };
pub const CRC_16_CMS: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0xffff, refin: false, refout: false, xorout: 0x0000, check: 0xaee7, residue: 0x0000 };
pub const CRC_16_DDS_110: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0x800d, refin: false, refout: false, xorout: 0x0000, check: 0x9ecf, residue: 0x0000 };
pub const CRC_16_DECT_R: Algorithm<u16> = Algorithm { poly: 0x0589, init: 0x0000, refin: false, refout: false, xorout: 0x0001, check: 0x007e, residue: 0x0589 };
pub const CRC_16_DECT_X: Algorithm<u16> = Algorithm { poly: 0x0589, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0x007f, residue: 0x0000 };
pub const CRC_16_DNP: Algorithm<u16> = Algorithm { poly: 0x3d65, init: 0x0000, refin: true, refout: true, xorout: 0xffff, check: 0xea82, residue: 0x66c5 };
pub const CRC_16_EN_13757: Algorithm<u16> = Algorithm { poly: 0x3d65, init: 0x0000, refin: false, refout: false, xorout: 0xffff, check: 0xc2b7, residue: 0xa366 };
pub const CRC_16_GENIBUS: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0xffff, refin: false, refout: false, xorout: 0xffff, check: 0xd64e, residue: 0x1d0f };
pub const CRC_16_GSM: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0x0000, refin: false, refout: false, xorout: 0xffff, check: 0xce3c, residue: 0x1d0f };
pub const CRC_16_IBM_3740: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0xffff, refin: false, refout: false, xorout: 0x0000, check: 0x29b1, residue: 0x0000 };
pub const CRC_16_IBM_SDLC: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0xffff, refin: true, refout: true, xorout: 0xffff, check: 0x906e, residue: 0xf0b8 };
pub const CRC_16_ISO_IEC_14443_3_A: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0xc6c6, refin: true, refout: true, xorout: 0x0000, check: 0xbf05, residue: 0x0000 };
pub const CRC_16_KERMIT: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0x0000, refin: true, refout: true, xorout: 0x0000, check: 0x2189, residue: 0x0000 };
pub const CRC_16_LJ1200: Algorithm<u16> = Algorithm { poly: 0x6f63, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0xbdf4, residue: 0x0000 };
pub const CRC_16_MAXIM_DOW: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0x0000, refin: true, refout: true, xorout: 0xffff, check: 0x44c2, residue: 0xb001 };
pub const CRC_16_MCRF4XX: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0xffff, refin: true, refout: true, xorout: 0x0000, check: 0x6f91, residue: 0x0000 };
pub const CRC_16_MODBUS: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0xffff, refin: true, refout: true, xorout: 0x0000, check: 0x4b37, residue: 0x0000 };
pub const CRC_16_NRSC_5: Algorithm<u16> = Algorithm { poly: 0x080b, init: 0xffff, refin: true, refout: true, xorout: 0x0000, check: 0xa066, residue: 0x0000 };
pub const CRC_16_OPENSAFETY_A: Algorithm<u16> = Algorithm { poly: 0x5935, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0x5d38, residue: 0x0000 };
pub const CRC_16_OPENSAFETY_B: Algorithm<u16> = Algorithm { poly: 0x755b, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0x20fe, residue: 0x0000 };
pub const CRC_16_PROFIBUS: Algorithm<u16> = Algorithm { poly: 0x1dcf, init: 0xffff, refin: false, refout: false, xorout: 0xffff, check: 0xa819, residue: 0xe394 };
pub const CRC_16_RIELLO: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0xb2aa, refin: true, refout: true, xorout: 0x0000, check: 0x63d0, residue: 0x0000 };
pub const CRC_16_SPI_FUJITSU: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0x1d0f, refin: false, refout: false, xorout: 0x0000, check: 0xe5cc, residue: 0x0000 };
pub const CRC_16_T10_DIF: Algorithm<u16> = Algorithm { poly: 0x8bb7, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0xd0db, residue: 0x0000 };
pub const CRC_16_TELEDISK: Algorithm<u16> = Algorithm { poly: 0xa097, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0x0fb3, residue: 0x0000 };
pub const CRC_16_TMS37157: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0x89ec, refin: true, refout: true, xorout: 0x0000, check: 0x26b1, residue: 0x0000 };
pub const CRC_16_UMTS: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0xfee8, residue: 0x0000 };
pub const CRC_16_USB: Algorithm<u16> = Algorithm { poly: 0x8005, init: 0xffff, refin: true, refout: true, xorout: 0xffff, check: 0xb4c8, residue: 0xb001 };
pub const CRC_16_XMODEM: Algorithm<u16> = Algorithm { poly: 0x1021, init: 0x0000, refin: false, refout: false, xorout: 0x0000, check: 0x31c3, residue: 0x0000 };
pub const CRC_32_AIXM: Algorithm<u32> = Algorithm { poly: 0x814141ab, init: 0x00000000, refin: false, refout: false, xorout: 0x00000000, check: 0x3010bf7f, residue: 0x00000000 };
pub const CRC_32_AUTOSAR: Algorithm<u32> = Algorithm { poly: 0xf4acfb13, init: 0xffffffff, refin: true, refout: true, xorout: 0xffffffff, check: 0x1697d06a, residue: 0x904cddbf };
pub const CRC_32_BASE91_D: Algorithm<u32> = Algorithm { poly: 0xa833982b, init: 0xffffffff, refin: true, refout: true, xorout: 0xffffffff, check: 0x87315576, residue: 0x45270551 };
pub const CRC_32_BZIP2: Algorithm<u32> = Algorithm { poly: 0x04c11db7, init: 0xffffffff, refin: false, refout: false, xorout: 0xffffffff, check: 0xfc891918, residue: 0xc704dd7b };
pub const CRC_32_CD_ROM_EDC: Algorithm<u32> = Algorithm { poly: 0x8001801b, init: 0x00000000, refin: true, refout: true, xorout: 0x00000000, check: 0x6ec2edc4, residue: 0x00000000 };
pub const CRC_32_CKSUM: Algorithm<u32> = Algorithm { poly: 0x04c11db7, init: 0x00000000, refin: false, refout: false, xorout: 0xffffffff, check: 0x765e7680, residue: 0xc704dd7b };
pub const CRC_32_ISCSI: Algorithm<u32> = Algorithm { poly: 0x1edc6f41, init: 0xffffffff, refin: true, refout: true, xorout: 0xffffffff, check: 0xe3069283, residue: 0xb798b438 };
pub const CRC_32_ISO_HDLC: Algorithm<u32> = Algorithm { poly: 0x04c11db7, init: 0xffffffff, refin: true, refout: true, xorout: 0xffffffff, check: 0xcbf43926, residue: 0xdebb20e3 };
pub const CRC_32_JAMCRC: Algorithm<u32> = Algorithm { poly: 0x04c11db7, init: 0xffffffff, refin: true, refout: true, xorout: 0x00000000, check: 0x340bc6d9, residue: 0x00000000 };
pub const CRC_32_MPEG_2: Algorithm<u32> = Algorithm { poly: 0x04c11db7, init: 0xffffffff, refin: false, refout: false, xorout: 0x00000000, check: 0x0376e6e7, residue: 0x00000000 };
pub const CRC_32_XFER: Algorithm<u32> = Algorithm { poly: 0x000000af, init: 0x00000000, refin: false, refout: false, xorout: 0x00000000, check: 0xbd0be338, residue: 0x00000000 };
pub const CRC_64_ECMA_182: Algorithm<u64> = Algorithm { poly: 0x42f0e1eba9ea3693, init: 0x0000000000000000, refin: false, refout: false, xorout: 0x0000000000000000, check: 0x6c40df5f0b497347, residue: 0x0000000000000000 };
pub const CRC_64_GO_ISO: Algorithm<u64> = Algorithm { poly: 0x000000000000001b, init: 0xffffffffffffffff, refin: true, refout: true, xorout: 0xffffffffffffffff, check: 0xb90956c775a41001, residue: 0x5300000000000000 };
pub const CRC_64_WE: Algorithm<u64> = Algorithm { poly: 0x42f0e1eba9ea3693, init: 0xffffffffffffffff, refin: false, refout: false, xorout: 0xffffffffffffffff, check: 0x62ec59e3f1a4f00a, residue: 0xfcacbebd5931a992 };
pub const CRC_64_XZ: Algorithm<u64> = Algorithm { poly: 0x42f0e1eba9ea3693, init: 0xffffffffffffffff, refin: true, refout: true, xorout: 0xffffffffffffffff, check: 0x995dc9bbdf1939fa, residue: 0x49958c9abd7d353f };
