/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.filter;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.filter.AbstractBranchFilterModule;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.ProfilingFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLFilter;

public class TopicBranchFilterModule
extends AbstractBranchFilterModule {
    private static final String SKIP_FILTER = "skip-filter";
    private URI map;
    private final Set<URI> filtered = new HashSet<URI>();

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Job.FileInfo in = this.job.getFileInfo(fi -> fi.isInput).iterator().next();
        this.processMap(in.uri);
        this.addFlagImagesSetToProperties(this.job, this.relFlagImagesSet);
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize job configuration: " + e.getMessage(), e);
        }
        return null;
    }

    protected void processMap(URI map) {
        Document doc;
        SubjectScheme subjectSchemeMap;
        assert (!map.isAbsolute());
        this.map = map;
        this.currentFile = this.job.tempDirURI.resolve(map);
        this.logger.info("Processing " + String.valueOf(this.currentFile));
        try {
            this.logger.debug("Reading " + String.valueOf(this.currentFile));
            subjectSchemeMap = this.getSubjectScheme(this.job.getStore().getImmutableNode(this.currentFile).getOutermostElement());
        }
        catch (IOException e) {
            this.logger.error("Failed to parse " + String.valueOf(this.currentFile), e);
            return;
        }
        try {
            this.logger.debug("Reading " + String.valueOf(this.currentFile));
            doc = this.job.getStore().getDocument(this.currentFile);
        }
        catch (IOException e) {
            this.logger.error("Failed to parse " + String.valueOf(this.currentFile), e);
            return;
        }
        this.logger.debug("Filter topics and generate copies");
        this.generateCopies(doc.getDocumentElement(), Collections.emptyList(), subjectSchemeMap);
        this.logger.debug("Filter existing topics");
        this.filterTopics(doc.getDocumentElement(), Collections.emptyList(), subjectSchemeMap);
        this.logger.debug("Writing " + String.valueOf(this.currentFile));
        try {
            this.job.getStore().writeDocument(doc, this.currentFile);
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize " + String.valueOf(map) + ": " + e.getMessage(), e);
        }
    }

    private void generateCopies(Element topicref, List<FilterUtils> filters, SubjectScheme subjectSchemeMap) {
        List<FilterUtils> fs = this.combineFilterUtils(topicref, filters, subjectSchemeMap);
        String copyTo = topicref.getAttribute("filter-copy-to");
        if (!copyTo.isEmpty()) {
            String href = topicref.getAttribute("href");
            URI srcUri = this.map.resolve(href);
            URI srcAbsUri = this.job.tempDirURI.resolve(srcUri);
            Job.FileInfo srcFileInfo = this.job.getFileInfo(srcUri);
            if (srcFileInfo != null) {
                URI dstUri = this.map.resolve(copyTo);
                URI dstAbsUri = this.job.tempDirURI.resolve(dstUri);
                Job.FileInfo dstFileInfo = this.job.getFileInfo(dstAbsUri);
                if (dstFileInfo != null) {
                    Job.FileInfo updatedDstFileInfo = new Job.FileInfo.Builder(dstFileInfo).addContentFields(srcFileInfo).build();
                    this.job.add(updatedDstFileInfo);
                }
                this.logger.info("Filtering " + String.valueOf(srcAbsUri) + " to " + String.valueOf(dstAbsUri));
                ProfilingFilter writer = new ProfilingFilter();
                writer.setLogger(this.logger);
                writer.setJob(this.job);
                writer.setFilterUtils(fs);
                writer.setCurrentFile(dstAbsUri);
                List<XMLFilter> pipe = Collections.singletonList(writer);
                File dstDirUri = new File(dstAbsUri.resolve("."));
                if (!dstDirUri.exists()) {
                    try {
                        Files.createDirectories(dstDirUri.toPath(), new FileAttribute[0]);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to create directory " + String.valueOf(dstDirUri));
                    }
                }
                try {
                    this.job.getStore().transform(srcAbsUri, dstAbsUri, pipe);
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to filter " + String.valueOf(srcAbsUri) + " to " + String.valueOf(dstAbsUri) + ": " + e.getMessage(), e);
                }
            }
            topicref.setAttribute("href", copyTo);
            topicref.removeAttribute("filter-copy-to");
            topicref.setAttribute(SKIP_FILTER, Boolean.TRUE.toString());
        }
        for (Element child : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF)) {
            if (Constants.DITAVAREF_D_DITAVALREF.matches(child)) continue;
            this.generateCopies(child, fs, subjectSchemeMap);
        }
    }

    private void filterTopics(Element topicref, List<FilterUtils> filters, SubjectScheme subjectSchemeMap) {
        List<FilterUtils> fs = this.combineFilterUtils(topicref, filters, subjectSchemeMap);
        String href = topicref.getAttribute("href");
        Attr skipFilter = topicref.getAttributeNode(SKIP_FILTER);
        URI srcAbsUri = URLUtils.stripFragment(this.job.tempDirURI.resolve(this.map.resolve(href)));
        if (!(fs.isEmpty() || skipFilter != null || this.filtered.contains(srcAbsUri) || href.isEmpty() || DitaUtils.isExternalScope(topicref))) {
            ProfilingFilter writer = new ProfilingFilter();
            writer.setLogger(this.logger);
            writer.setJob(this.job);
            writer.setFilterUtils(fs);
            writer.setCurrentFile(srcAbsUri);
            List<XMLFilter> pipe = Collections.singletonList(writer);
            this.logger.info("Filtering " + String.valueOf(srcAbsUri));
            try {
                this.job.getStore().transform(srcAbsUri, pipe);
            }
            catch (DITAOTException e) {
                this.logger.error("Failed to filter " + String.valueOf(srcAbsUri) + ": " + e.getMessage(), e);
            }
            this.filtered.add(srcAbsUri);
        }
        if (skipFilter != null) {
            topicref.removeAttributeNode(skipFilter);
        }
        for (Element child : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF)) {
            if (Constants.DITAVAREF_D_DITAVALREF.matches(child)) continue;
            this.filterTopics(child, fs, subjectSchemeMap);
        }
    }
}

