/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	mock "github.com/stretchr/testify/mock"
	"k8s.io/apimachinery/pkg/util/version"
	"k8s.io/component-helpers/nodedeclaredfeatures"
)

// NewMockFeature creates a new instance of MockFeature. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockFeature(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockFeature {
	mock := &MockFeature{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockFeature is an autogenerated mock type for the Feature type
type MockFeature struct {
	mock.Mock
}

type MockFeature_Expecter struct {
	mock *mock.Mock
}

func (_m *MockFeature) EXPECT() *MockFeature_Expecter {
	return &MockFeature_Expecter{mock: &_m.Mock}
}

// Discover provides a mock function for the type MockFeature
func (_mock *MockFeature) Discover(cfg *nodedeclaredfeatures.NodeConfiguration) bool {
	ret := _mock.Called(cfg)

	if len(ret) == 0 {
		panic("no return value specified for Discover")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*nodedeclaredfeatures.NodeConfiguration) bool); ok {
		r0 = returnFunc(cfg)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockFeature_Discover_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Discover'
type MockFeature_Discover_Call struct {
	*mock.Call
}

// Discover is a helper method to define mock.On call
//   - cfg *nodedeclaredfeatures.NodeConfiguration
func (_e *MockFeature_Expecter) Discover(cfg interface{}) *MockFeature_Discover_Call {
	return &MockFeature_Discover_Call{Call: _e.mock.On("Discover", cfg)}
}

func (_c *MockFeature_Discover_Call) Run(run func(cfg *nodedeclaredfeatures.NodeConfiguration)) *MockFeature_Discover_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *nodedeclaredfeatures.NodeConfiguration
		if args[0] != nil {
			arg0 = args[0].(*nodedeclaredfeatures.NodeConfiguration)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockFeature_Discover_Call) Return(b bool) *MockFeature_Discover_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockFeature_Discover_Call) RunAndReturn(run func(cfg *nodedeclaredfeatures.NodeConfiguration) bool) *MockFeature_Discover_Call {
	_c.Call.Return(run)
	return _c
}

// InferForScheduling provides a mock function for the type MockFeature
func (_mock *MockFeature) InferForScheduling(podInfo *nodedeclaredfeatures.PodInfo) bool {
	ret := _mock.Called(podInfo)

	if len(ret) == 0 {
		panic("no return value specified for InferForScheduling")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*nodedeclaredfeatures.PodInfo) bool); ok {
		r0 = returnFunc(podInfo)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockFeature_InferForScheduling_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'InferForScheduling'
type MockFeature_InferForScheduling_Call struct {
	*mock.Call
}

// InferForScheduling is a helper method to define mock.On call
//   - podInfo *nodedeclaredfeatures.PodInfo
func (_e *MockFeature_Expecter) InferForScheduling(podInfo interface{}) *MockFeature_InferForScheduling_Call {
	return &MockFeature_InferForScheduling_Call{Call: _e.mock.On("InferForScheduling", podInfo)}
}

func (_c *MockFeature_InferForScheduling_Call) Run(run func(podInfo *nodedeclaredfeatures.PodInfo)) *MockFeature_InferForScheduling_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *nodedeclaredfeatures.PodInfo
		if args[0] != nil {
			arg0 = args[0].(*nodedeclaredfeatures.PodInfo)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockFeature_InferForScheduling_Call) Return(b bool) *MockFeature_InferForScheduling_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockFeature_InferForScheduling_Call) RunAndReturn(run func(podInfo *nodedeclaredfeatures.PodInfo) bool) *MockFeature_InferForScheduling_Call {
	_c.Call.Return(run)
	return _c
}

// InferForUpdate provides a mock function for the type MockFeature
func (_mock *MockFeature) InferForUpdate(oldPodInfo *nodedeclaredfeatures.PodInfo, newPodInfo *nodedeclaredfeatures.PodInfo) bool {
	ret := _mock.Called(oldPodInfo, newPodInfo)

	if len(ret) == 0 {
		panic("no return value specified for InferForUpdate")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(*nodedeclaredfeatures.PodInfo, *nodedeclaredfeatures.PodInfo) bool); ok {
		r0 = returnFunc(oldPodInfo, newPodInfo)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockFeature_InferForUpdate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'InferForUpdate'
type MockFeature_InferForUpdate_Call struct {
	*mock.Call
}

// InferForUpdate is a helper method to define mock.On call
//   - oldPodInfo *nodedeclaredfeatures.PodInfo
//   - newPodInfo *nodedeclaredfeatures.PodInfo
func (_e *MockFeature_Expecter) InferForUpdate(oldPodInfo interface{}, newPodInfo interface{}) *MockFeature_InferForUpdate_Call {
	return &MockFeature_InferForUpdate_Call{Call: _e.mock.On("InferForUpdate", oldPodInfo, newPodInfo)}
}

func (_c *MockFeature_InferForUpdate_Call) Run(run func(oldPodInfo *nodedeclaredfeatures.PodInfo, newPodInfo *nodedeclaredfeatures.PodInfo)) *MockFeature_InferForUpdate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *nodedeclaredfeatures.PodInfo
		if args[0] != nil {
			arg0 = args[0].(*nodedeclaredfeatures.PodInfo)
		}
		var arg1 *nodedeclaredfeatures.PodInfo
		if args[1] != nil {
			arg1 = args[1].(*nodedeclaredfeatures.PodInfo)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockFeature_InferForUpdate_Call) Return(b bool) *MockFeature_InferForUpdate_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockFeature_InferForUpdate_Call) RunAndReturn(run func(oldPodInfo *nodedeclaredfeatures.PodInfo, newPodInfo *nodedeclaredfeatures.PodInfo) bool) *MockFeature_InferForUpdate_Call {
	_c.Call.Return(run)
	return _c
}

// MaxVersion provides a mock function for the type MockFeature
func (_mock *MockFeature) MaxVersion() *version.Version {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for MaxVersion")
	}

	var r0 *version.Version
	if returnFunc, ok := ret.Get(0).(func() *version.Version); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*version.Version)
		}
	}
	return r0
}

// MockFeature_MaxVersion_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'MaxVersion'
type MockFeature_MaxVersion_Call struct {
	*mock.Call
}

// MaxVersion is a helper method to define mock.On call
func (_e *MockFeature_Expecter) MaxVersion() *MockFeature_MaxVersion_Call {
	return &MockFeature_MaxVersion_Call{Call: _e.mock.On("MaxVersion")}
}

func (_c *MockFeature_MaxVersion_Call) Run(run func()) *MockFeature_MaxVersion_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockFeature_MaxVersion_Call) Return(version1 *version.Version) *MockFeature_MaxVersion_Call {
	_c.Call.Return(version1)
	return _c
}

func (_c *MockFeature_MaxVersion_Call) RunAndReturn(run func() *version.Version) *MockFeature_MaxVersion_Call {
	_c.Call.Return(run)
	return _c
}

// Name provides a mock function for the type MockFeature
func (_mock *MockFeature) Name() string {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for Name")
	}

	var r0 string
	if returnFunc, ok := ret.Get(0).(func() string); ok {
		r0 = returnFunc()
	} else {
		r0 = ret.Get(0).(string)
	}
	return r0
}

// MockFeature_Name_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Name'
type MockFeature_Name_Call struct {
	*mock.Call
}

// Name is a helper method to define mock.On call
func (_e *MockFeature_Expecter) Name() *MockFeature_Name_Call {
	return &MockFeature_Name_Call{Call: _e.mock.On("Name")}
}

func (_c *MockFeature_Name_Call) Run(run func()) *MockFeature_Name_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockFeature_Name_Call) Return(s string) *MockFeature_Name_Call {
	_c.Call.Return(s)
	return _c
}

func (_c *MockFeature_Name_Call) RunAndReturn(run func() string) *MockFeature_Name_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockFeatureGate creates a new instance of MockFeatureGate. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockFeatureGate(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockFeatureGate {
	mock := &MockFeatureGate{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockFeatureGate is an autogenerated mock type for the FeatureGate type
type MockFeatureGate struct {
	mock.Mock
}

type MockFeatureGate_Expecter struct {
	mock *mock.Mock
}

func (_m *MockFeatureGate) EXPECT() *MockFeatureGate_Expecter {
	return &MockFeatureGate_Expecter{mock: &_m.Mock}
}

// Enabled provides a mock function for the type MockFeatureGate
func (_mock *MockFeatureGate) Enabled(key string) bool {
	ret := _mock.Called(key)

	if len(ret) == 0 {
		panic("no return value specified for Enabled")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(string) bool); ok {
		r0 = returnFunc(key)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockFeatureGate_Enabled_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Enabled'
type MockFeatureGate_Enabled_Call struct {
	*mock.Call
}

// Enabled is a helper method to define mock.On call
//   - key string
func (_e *MockFeatureGate_Expecter) Enabled(key interface{}) *MockFeatureGate_Enabled_Call {
	return &MockFeatureGate_Enabled_Call{Call: _e.mock.On("Enabled", key)}
}

func (_c *MockFeatureGate_Enabled_Call) Run(run func(key string)) *MockFeatureGate_Enabled_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockFeatureGate_Enabled_Call) Return(b bool) *MockFeatureGate_Enabled_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockFeatureGate_Enabled_Call) RunAndReturn(run func(key string) bool) *MockFeatureGate_Enabled_Call {
	_c.Call.Return(run)
	return _c
}
