/*
 * UseProxy.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1999-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: cstevens.
 * Portions created by cstevens are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.2
 * Created by cstevens on 99/09/29
 * Last modified by suhler on 04/11/30 15:19:40
 */

package sunlabs.brazil.proxy;

/**
 * This interface is used by the {@link ProxyHandler} class to
 * decide whether to issue an HTTP request directly to the
 * specified host, or to issue the request via an HTTP proxy.
 *
 * @author	Colin Stevens (colin.stevens@sun.com)
 * @version		2.2
 */
public interface UseProxy
{
    /**
     * Determines if the user can issue a direct or proxy request to the
     * specified host and port.
     * <p>
     * The actual HTTP proxy to use is specified external to this routine by
     * some other mechanism.
     *
     * @param	host
     *		The host name.
     *
     * @param	port
     *		The port number.
     *
     * @return	<code>true</code> if the user should send the HTTP request
     *		via an HTTP proxy, <code>false</code> if the user can
     *		send the HTTP request directly to the specified named host.
     */
    public boolean useProxy(String host, int port);
}
    
