/* audio.c
 * Copyright (C) 2004, 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

#define THEME_NAME    "NAME"
#define THEME_DESC    "DESC"
#define THEME_AUTHOR  "AUTHOR"
#define THEME_VERSION "VERSION"
#define THEME_DATE    "DATE"
#define THEME_URL     "URL"
#define THEME_ITEM    6

Ttheme *free_theme(Ttheme *Atheme)
{
  g_free(Atheme->path);
  g_free(Atheme->name);
  g_free(Atheme->desc);
  g_free(Atheme->author);
  g_free(Atheme->date);
  g_free(Atheme->url);
  g_free(Atheme);

  return NULL;
}


/* on decompose une locale fr_FR.utf8@euro */
GSList *split_locale()
{
  GSList *Lcurlocale = NULL;
  gchar *s = Glocale;
  gchar Lbuf[_BUF_SIZE];
#ifdef ENABLE_NLS
  if (s) {
    Lcurlocale = g_slist_append(Lcurlocale, g_strconcat("[", Glocale, "]=", NULL));

    g_strlcpy(Lbuf, Glocale, _BUF_SIZE-1);

    if ((s=strchr(Lbuf, '@'))) {
      *s=0;
      Lcurlocale = g_slist_append(Lcurlocale, g_strconcat("[", Lbuf, "]=", NULL));
    }

    if (*Lbuf && ((s=strchr(Lbuf, '.')))) {
      *s=0;
      Lcurlocale = g_slist_append(Lcurlocale, g_strconcat("[", Lbuf, "]=", NULL));

      if (*Lbuf && ((s=strchr(Lbuf, '_')))) {
        *s=0;
        Lcurlocale = g_slist_append(Lcurlocale, g_strconcat("[", Lbuf, "]=", NULL));
      }
    }
  }
#endif
  Lcurlocale = g_slist_append(Lcurlocale, g_strdup("="));

  return Lcurlocale;
}

GSList *free_locale(GSList *Alistlocale)
{
  GSList *Lcurlocale = Alistlocale;
  gpointer Ldata;

  while (Lcurlocale) {
    if ((Ldata = Lcurlocale->data)) g_free(Ldata);
    Lcurlocale = g_slist_next(Lcurlocale);
  }

  g_slist_free(Alistlocale);

  return NULL;
}

/* allocation theme */
Ttheme *read_theme_desc(const gchar *Afile, GError **Aerror)
{
  gchar *Lbuf;
  gchar **Larrbuf;
  gint i;
  gchar *s, *Ldata;
  Ttheme *Ltheme = g_malloc0(sizeof(Ttheme));
  GSList *Llistlocale = split_locale();
  GSList *Lcurlocale;
  gint Ltrouve = 0;
  
  if (!g_file_get_contents(Afile, &Lbuf, NULL, Aerror)) return NULL;
  Larrbuf = g_strsplit(Lbuf, "\n", 0);
  g_free(Lbuf);


  for (Lcurlocale = Llistlocale; Lcurlocale; Lcurlocale = g_slist_next(Lcurlocale)) {
    if (!(Ldata = (gchar *)Lcurlocale->data)) continue;

    for (i=0; Larrbuf[i]; i++) {
      s=ltrim(Larrbuf[i]);
      if (*s==';' || *s=='#' || !*s) continue;

      if (!Ltheme->name && !strncmp(s, THEME_NAME, strlen(THEME_NAME)) && 
          ((!*Ldata) || strstr(s, Ldata))) {
        Ltheme->name = g_strdup(strchr(s, '=')+1);
        Ltrouve ++;
      } else if (!Ltheme->desc && !strncmp(s, THEME_DESC, strlen(THEME_DESC)) &&
          ((!*Ldata) || strstr(s, Ldata))) {
        Ltheme->desc = g_strdup(strchr(s, '=')+1);
        Ltrouve ++;
      } else if (!Ltheme->author && !strncmp(s, THEME_AUTHOR, strlen(THEME_AUTHOR)) &&
          ((!*Ldata) || strstr(s, Ldata))) {
        Ltheme->author = g_strdup(strchr(s, '=')+1);
        Ltrouve ++;
      } else if (!Ltheme->version && !strncmp(s, THEME_VERSION, strlen(THEME_VERSION)) &&
          ((!*Ldata) || strstr(s, Ldata))) {
        Ltheme->version = atoi(ltrim(strchr(s, '=')+1));
        Ltrouve ++;
      } else if (!Ltheme->date && !strncmp(s, THEME_DATE, strlen(THEME_DATE)) &&
          ((!*Ldata) || strstr(s, Ldata))) {
        Ltheme->date = g_strdup(ltrim(strchr(s, '=')+1));
        Ltrouve ++;
      } else if (!Ltheme->url && !strncmp(s, THEME_URL, strlen(THEME_URL)) &&
          ((!*Ldata) || strstr(s, Ldata))) {
        Ltheme->url = g_strdup(ltrim(strchr(s, '=')+1));
        Ltrouve ++;
      }

      if (Ltrouve == THEME_ITEM) break;
    }
  }
  g_strfreev(Larrbuf);

  Llistlocale = free_locale(Llistlocale);

  /* un theme valide doit au moins avoir un nom .. */
  if (Ltheme->name && *Ltheme->name) {
    Ltheme->path = g_strdup(Afile);
    return Ltheme;
  } else {
    return free_theme(Ltheme);
  }
}

/* retourne un hash contenant un chemin d'acces vers toutes les images */
GHashTable *get_imagespath_plus_from_theme(Timages *Aimages, gchar *Atheme, gchar *Aplus, GError **Aerror)
{
  GHashTable *Lhashimagespath = _hash();
  GSList *Lthemesemp = get_data_path();
  GSList *Lcur;
  Timages *Luneimage;
  gchar Lpath[MAXPATHLEN];
  gboolean Ltrouve;
  gboolean Laumoinsun = FALSE;

  for (Luneimage = Aimages; Luneimage->code; Luneimage++) {
    _DEB("on cherche l'image [%s]", Luneimage->code);

    Ltrouve = FALSE;
    /* on recherche d'abord dans les repertoires themes specifiques */
    if (Atheme) {
      for (Lcur = Lthemesemp; Lcur && Lcur->data; Lcur = Lcur->next) {
        g_snprintf(Lpath, sizeof(Lpath)-1, "%s/themes/%s/%s%s.%s", (gchar *)Lcur->data,
            Atheme, Luneimage->code, Aplus ? Aplus : "",
            Luneimage->type == _IMG_PNG ? "png" : "mng");
_DEB("on cherche dans [%s]\n", Lpath);
        if (g_file_test(Lpath, G_FILE_TEST_IS_REGULAR)) {
          Ltrouve = TRUE;
          break;
        }
      }
    }

    /* puis dans les repertoires themes par defaut */
    if (Ltrouve == FALSE && ((!Atheme) || strcmp(Atheme, _THEME_DEFAULT))) {
      for (Lcur = Lthemesemp; Lcur && Lcur->data; Lcur = Lcur->next) {
        g_snprintf(Lpath, sizeof(Lpath)-1, "%s/themes/%s/%s%s.%s",
            (gchar *)Lcur->data, _THEME_DEFAULT, Aplus ? Aplus : "", Luneimage->code,
            Luneimage->type == _IMG_PNG ? "png" : "mng");

        if (g_file_test(Lpath, G_FILE_TEST_IS_REGULAR)) {
          Ltrouve = TRUE;
          break;
        }
      }
    }

    if (Ltrouve == TRUE) {
      _DEB("on trouve [%s] => [%s]", Luneimage->code, Lpath);
      g_hash_table_insert(Lhashimagespath, Luneimage->code, g_strdup(Lpath));
      Laumoinsun = TRUE;
    } else {
      g_warning(_("cannot find file '%s' in any theme directories :-("), Luneimage->code);
    }
  }

  g_slist_free(Lthemesemp);

  if (!Laumoinsun) {
    g_hash_table_destroy(Lhashimagespath);
  }

  return Laumoinsun ? Lhashimagespath : NULL;
}

/* remple une liststore avec tous les themes */
void managelistethemes(GtkComboBox *Acombo, gboolean Aadddef, gchar *Asel)
{
  GtkListStore *Lmodel = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  GtkTreeIter Liter;
  GSList *Lthemesemp = get_data_path();
  GSList *Lcur;
  gchar Lpath[MAXPATHLEN];
  gchar Ltestpath[MAXPATHLEN];
  const gchar *Lcurnom;
  GDir *Ldir;
  Ttheme *Luntheme = NULL;
  gint i = 0;
  gint Ltosel = -1, Ldefault = 0;

  gtk_list_store_clear(Lmodel);

  for (Lcur = Lthemesemp; Lcur && Lcur->data; Lcur = Lcur->next) {
    g_snprintf(Lpath, sizeof(Lpath)-1, "%s/themes", (gchar *)Lcur->data);
    if (g_file_test(Lpath, G_FILE_TEST_IS_DIR)==FALSE) continue;

    if (!(Ldir = g_dir_open(Lpath, 0, NULL))) continue;

    while ((Lcurnom = g_dir_read_name(Ldir))) {
      g_snprintf(Ltestpath, sizeof(Ltestpath)-1, "%s/%s/graveman", Lpath, Lcurnom);
      
      if (g_file_test(Ltestpath, G_FILE_TEST_IS_REGULAR)) {
        if ((Luntheme = read_theme_desc(Ltestpath, NULL))) {
          
          if (Ltosel == -1 && !strcmp(Lcurnom, _THEME_DEFAULT)) Ldefault = i;
    
          gtk_list_store_append(Lmodel, &Liter);

          gtk_list_store_set(Lmodel, &Liter, 0, i, 1, get_image("Themes"), 2,
            Luntheme->desc, 3, Lcurnom, -1);
          if (Asel && Ltosel == -1 && !strcmp(Asel, Lcurnom)) {
            Ltosel = i;
          }

          Luntheme = free_theme(Luntheme); 

          i++;
        }
      }
    }

    g_dir_close(Ldir);
  }

  g_slist_free(Lthemesemp);

  if (Ltosel == -1) Ltosel = Ldefault;
  if (i) gtk_combo_box_set_active(Acombo, Ltosel);
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
