/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.ConstantMap;
import jdk.jfr.consumer.EventParser;
import jdk.jfr.consumer.LongMap;
import jdk.jfr.consumer.ObjectFactory;
import jdk.jfr.consumer.Parser;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.RecordingInput;

final class ParserFactory {
    private final LongMap<Parser> parsers = new LongMap();
    private final TimeConverter timeConverter;
    private final LongMap<Type> types = new LongMap();
    private final LongMap<ConstantMap> constantPools = new LongMap();

    public ParserFactory(MetadataDescriptor metadataDescriptor, TimeConverter timeConverter) throws IOException {
        this.timeConverter = timeConverter;
        for (Type object : metadataDescriptor.getTypes()) {
            this.types.put(object.getId(), object);
        }
        for (Type type : this.types) {
            if (type.getFields().isEmpty()) continue;
            CompositeParser compositeParser = this.createCompositeParser(type);
            if (!type.isSimpleType()) continue;
            this.parsers.put(type.getId(), compositeParser.parsers[0]);
        }
        for (EventType eventType : metadataDescriptor.getEventTypes()) {
            this.parsers.put(eventType.getId(), this.createEventParser(eventType));
        }
    }

    public LongMap<Parser> getParsers() {
        return this.parsers;
    }

    public LongMap<ConstantMap> getConstantPools() {
        return this.constantPools;
    }

    public LongMap<Type> getTypeMap() {
        return this.types;
    }

    private EventParser createEventParser(EventType eventType) throws IOException {
        ArrayList<Parser> arrayList = new ArrayList<Parser>();
        for (ValueDescriptor valueDescriptor : eventType.getFields()) {
            arrayList.add(this.createParser(valueDescriptor));
        }
        return new EventParser(this.timeConverter, eventType, arrayList.toArray(new Parser[0]));
    }

    private Parser createParser(ValueDescriptor valueDescriptor) throws IOException {
        boolean bl = PrivateAccess.getInstance().isConstantPool(valueDescriptor);
        if (valueDescriptor.isArray()) {
            Type type = PrivateAccess.getInstance().getType(valueDescriptor);
            ValueDescriptor valueDescriptor2 = PrivateAccess.getInstance().newValueDescriptor(valueDescriptor.getName(), type, valueDescriptor.getAnnotationElements(), 0, bl, null);
            return new ArrayParser(this.createParser(valueDescriptor2));
        }
        long l = valueDescriptor.getTypeId();
        Type type = this.types.get(l);
        if (type == null) {
            throw new IOException("Type '" + valueDescriptor.getTypeName() + "' is not defined");
        }
        if (bl) {
            ConstantMap constantMap = this.constantPools.get(l);
            if (constantMap == null) {
                constantMap = new ConstantMap(ObjectFactory.create(type, this.timeConverter), type.getName());
                this.constantPools.put(l, constantMap);
            }
            return new ConstantMapValueParser(constantMap);
        }
        Parser parser = this.parsers.get(l);
        if (parser == null) {
            if (!valueDescriptor.getFields().isEmpty()) {
                return this.createCompositeParser(type);
            }
            return this.registerParserType(type, this.createPrimitiveParser(type));
        }
        return parser;
    }

    private Parser createPrimitiveParser(Type type) throws IOException {
        switch (type.getName()) {
            case "int": {
                return new IntegerParser();
            }
            case "long": {
                return new LongParser();
            }
            case "float": {
                return new FloatParser();
            }
            case "double": {
                return new DoubleParser();
            }
            case "char": {
                return new CharacterParser();
            }
            case "boolean": {
                return new BooleanParser();
            }
            case "short": {
                return new ShortParser();
            }
            case "byte": {
                return new ByteParser();
            }
            case "java.lang.String": {
                ConstantMap constantMap = new ConstantMap(ObjectFactory.create(type, this.timeConverter), type.getName());
                this.constantPools.put(type.getId(), constantMap);
                return new StringParser(constantMap);
            }
        }
        throw new IOException("Unknown primitive type " + type.getName());
    }

    private Parser registerParserType(Type type, Parser parser) {
        Parser parser2 = this.parsers.get(type.getId());
        if (parser2 != null) {
            return parser2;
        }
        this.parsers.put(type.getId(), parser);
        return parser;
    }

    private CompositeParser createCompositeParser(Type type) throws IOException {
        List<ValueDescriptor> list = type.getFields();
        Parser[] parserArray = new Parser[list.size()];
        CompositeParser compositeParser = new CompositeParser(parserArray);
        this.registerParserType(type, compositeParser);
        int n = 0;
        for (ValueDescriptor valueDescriptor : list) {
            parserArray[n++] = this.createParser(valueDescriptor);
        }
        return compositeParser;
    }

    private static final class ConstantMapValueParser
    extends Parser {
        private final ConstantMap pool;

        ConstantMapValueParser(ConstantMap constantMap) {
            this.pool = constantMap;
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return this.pool.get(recordingInput.readLong());
        }
    }

    private static final class CompositeParser
    extends Parser {
        private final Parser[] parsers;

        public CompositeParser(Parser[] parserArray) {
            this.parsers = parserArray;
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            Object[] objectArray = new Object[this.parsers.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.parsers[i].parse(recordingInput);
            }
            return objectArray;
        }
    }

    private static final class ArrayParser
    extends Parser {
        private final Parser elementParser;

        public ArrayParser(Parser parser) {
            this.elementParser = parser;
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            int n = recordingInput.readInt();
            recordingInput.require(n, "Array size %d exceeds available data");
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.elementParser.parse(recordingInput);
            }
            return objectArray;
        }
    }

    private static final class StringParser
    extends Parser {
        private final ConstantMap stringConstantMap;
        private String last;

        StringParser(ConstantMap constantMap) {
            this.stringConstantMap = constantMap;
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            String string = this.parseEncodedString(recordingInput);
            if (!Objects.equals(string, this.last)) {
                this.last = string;
            }
            return this.last;
        }

        private String parseEncodedString(RecordingInput recordingInput) throws IOException {
            byte by = recordingInput.readByte();
            if (by == 2) {
                long l = recordingInput.readLong();
                return (String)this.stringConstantMap.get(l);
            }
            return recordingInput.readEncodedString(by);
        }
    }

    private static final class DoubleParser
    extends Parser {
        private DoubleParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return recordingInput.readDouble();
        }
    }

    private static final class FloatParser
    extends Parser {
        private FloatParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return Float.valueOf(recordingInput.readFloat());
        }
    }

    private static final class CharacterParser
    extends Parser {
        private CharacterParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return Character.valueOf(recordingInput.readChar());
        }
    }

    private static final class ShortParser
    extends Parser {
        private ShortParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return recordingInput.readShort();
        }
    }

    private static final class IntegerParser
    extends Parser {
        private IntegerParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return recordingInput.readInt();
        }
    }

    private static final class LongParser
    extends Parser {
        private LongParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return recordingInput.readLong();
        }
    }

    private static final class ByteParser
    extends Parser {
        private ByteParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return recordingInput.readByte();
        }
    }

    private static final class BooleanParser
    extends Parser {
        private BooleanParser() {
        }

        @Override
        public Object parse(RecordingInput recordingInput) throws IOException {
            return recordingInput.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

