/* This adds definitions for thread_info api in mach/thread_act.h, generated by:

bindgen /usr/include/mach/thread_act.h \
     --whitelist-function thread_info \
     --whitelist-type thread_.*_info \
     --whitelist-var TH_.*
*/
#![allow(dead_code)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(clippy::useless_transmute)]
#![allow(clippy::default_trait_access)]
#![allow(clippy::cast_lossless)]
#![allow(clippy::trivially_copy_pass_by_ref)]

/* automatically generated by rust-bindgen */

pub const THREAD_STATE_MAX: u32 = 614;
pub const THREAD_STATE_NONE: u32 = 13;
pub const THREAD_MACHINE_STATE_MAX: u32 = 614;
pub const THREAD_STATE_FLAVOR_LIST: u32 = 0;
pub const THREAD_STATE_FLAVOR_LIST_NEW: u32 = 128;
pub const THREAD_STATE_FLAVOR_LIST_10_9: u32 = 129;
pub const THREAD_STATE_FLAVOR_LIST_10_13: u32 = 130;
pub const THREAD_INFO_MAX: u32 = 32;
pub const THREAD_BASIC_INFO: u32 = 3;
pub const THREAD_IDENTIFIER_INFO: u32 = 4;
pub const TH_USAGE_SCALE: u32 = 1000;
pub const TH_STATE_RUNNING: u32 = 1;
pub const TH_STATE_STOPPED: u32 = 2;
pub const TH_STATE_WAITING: u32 = 3;
pub const TH_STATE_UNINTERRUPTIBLE: u32 = 4;
pub const TH_STATE_HALTED: u32 = 5;
pub const TH_FLAGS_SWAPPED: u32 = 1;
pub const TH_FLAGS_IDLE: u32 = 2;
pub const TH_FLAGS_GLOBAL_FORCED_IDLE: u32 = 4;
pub const THREAD_EXTENDED_INFO: u32 = 5;
pub const THREAD_DEBUG_INFO_INTERNAL: u32 = 6;
pub const THREAD_SCHED_TIMESHARE_INFO: u32 = 10;
pub const THREAD_SCHED_RR_INFO: u32 = 11;
pub const THREAD_SCHED_FIFO_INFO: u32 = 12;
pub const THREAD_STANDARD_POLICY: u32 = 1;
pub const THREAD_STANDARD_POLICY_COUNT: u32 = 0;
pub const THREAD_EXTENDED_POLICY: u32 = 1;
pub const THREAD_TIME_CONSTRAINT_POLICY: u32 = 2;
pub const THREAD_PRECEDENCE_POLICY: u32 = 3;
pub const THREAD_AFFINITY_POLICY: u32 = 4;
pub const THREAD_AFFINITY_TAG_NULL: u32 = 0;
pub const THREAD_BACKGROUND_POLICY: u32 = 5;
pub const THREAD_BACKGROUND_POLICY_DARWIN_BG: u32 = 4096;
pub const THREAD_LATENCY_QOS_POLICY: u32 = 7;
pub const THREAD_THROUGHPUT_QOS_POLICY: u32 = 8;
pub const THREAD_KERNEL_PORT: u32 = 1;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type kern_return_t = ::std::os::raw::c_int;
pub type natural_t = __darwin_natural_t;
pub type integer_t = ::std::os::raw::c_int;
pub type mach_port_t = __darwin_mach_port_t;
pub type mach_msg_type_number_t = natural_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct time_value {
    pub seconds: integer_t,
    pub microseconds: integer_t,
}
#[test]
fn bindgen_test_layout_time_value() {
    assert_eq!(
        ::std::mem::size_of::<time_value>(),
        8usize,
        concat!("Size of: ", stringify!(time_value))
    );
    assert_eq!(
        ::std::mem::align_of::<time_value>(),
        4usize,
        concat!("Alignment of ", stringify!(time_value))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<time_value>())).seconds as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(time_value),
            "::",
            stringify!(seconds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<time_value>())).microseconds as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(time_value),
            "::",
            stringify!(microseconds)
        )
    );
}
pub type time_value_t = time_value;
pub type policy_t = ::std::os::raw::c_int;
pub type thread_flavor_t = natural_t;
pub type thread_info_t = *mut integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_basic_info {
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub cpu_usage: integer_t,
    pub policy: policy_t,
    pub run_state: integer_t,
    pub flags: integer_t,
    pub suspend_count: integer_t,
    pub sleep_time: integer_t,
}
#[test]
fn bindgen_test_layout_thread_basic_info() {
    assert_eq!(
        ::std::mem::size_of::<thread_basic_info>(),
        40usize,
        concat!("Size of: ", stringify!(thread_basic_info))
    );
    assert_eq!(
        ::std::mem::align_of::<thread_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_basic_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).user_time as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).system_time as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).cpu_usage as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(cpu_usage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).policy as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).run_state as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(run_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).flags as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).suspend_count as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(suspend_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_basic_info>())).sleep_time as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(sleep_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_identifier_info {
    pub thread_id: u64,
    pub thread_handle: u64,
    pub dispatch_qaddr: u64,
}
#[test]
fn bindgen_test_layout_thread_identifier_info() {
    assert_eq!(
        ::std::mem::size_of::<thread_identifier_info>(),
        24usize,
        concat!("Size of: ", stringify!(thread_identifier_info))
    );
    assert_eq!(
        ::std::mem::align_of::<thread_identifier_info>(),
        8usize,
        concat!("Alignment of ", stringify!(thread_identifier_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_identifier_info>())).thread_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_identifier_info),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_identifier_info>())).thread_handle as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_identifier_info),
            "::",
            stringify!(thread_handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_identifier_info>())).dispatch_qaddr as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_identifier_info),
            "::",
            stringify!(dispatch_qaddr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct thread_extended_info {
    pub pth_user_time: u64,
    pub pth_system_time: u64,
    pub pth_cpu_usage: i32,
    pub pth_policy: i32,
    pub pth_run_state: i32,
    pub pth_flags: i32,
    pub pth_sleep_time: i32,
    pub pth_curpri: i32,
    pub pth_priority: i32,
    pub pth_maxpriority: i32,
    pub pth_name: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_thread_extended_info() {
    assert_eq!(
        ::std::mem::size_of::<thread_extended_info>(),
        112usize,
        concat!("Size of: ", stringify!(thread_extended_info))
    );
    assert_eq!(
        ::std::mem::align_of::<thread_extended_info>(),
        8usize,
        concat!("Alignment of ", stringify!(thread_extended_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_user_time as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_system_time as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_cpu_usage as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_cpu_usage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_extended_info>())).pth_policy as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_policy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_run_state as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_run_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_extended_info>())).pth_flags as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_sleep_time as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_sleep_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_extended_info>())).pth_curpri as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_curpri)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_priority as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_priority)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<thread_extended_info>())).pth_maxpriority as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_maxpriority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<thread_extended_info>())).pth_name as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_name)
        )
    );
}
pub type thread_inspect_t = mach_port_t;
extern "C" {
    #[link_name = "\u{1}_thread_info"]
    pub fn thread_info(
        target_act: thread_inspect_t,
        flavor: thread_flavor_t,
        thread_info_out: thread_info_t,
        thread_info_outCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
/* automatically generated by rust-bindgen */

pub const x86_THREAD_STATE64: u32 = 4;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
pub type x86_thread_state64_t = __darwin_x86_thread_state64;
