/*
 * This file is part of csharp-gentoodotnetinfo - .NET information tool for Gentoo.
 * Copyright (c) 2023, Maciej Barć <xgqt@riseup.net>
 * Licensed under the GNU GPL v2 License
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * csharp-gentoodotnetinfo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * csharp-gentoodotnetinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with csharp-gentoodotnetinfo.  If not, see <https://www.gnu.org/licenses/>.
 */

using System;
using Gentoo.DotNet.GentooDotnetInfo.Info;
using Gentoo.DotNet.GentooDotnetInfo.Util;

namespace Gentoo.DotNet.GentooDotnetInfo.Action
{

    public class GentooDotnetInfoAction
    {

        private readonly OperatingSystemInfo _operatingSystemInfo;

        private readonly PlatformInfo _platformInfo;

        private readonly DotnetSDKInfo _dotnetSDKInfo;

        private readonly DotnetRuntimeInfo _dotnetRuntimeInfo;

        public GentooDotnetInfoAction()
        {
            _operatingSystemInfo = new OperatingSystemInfo();
            _platformInfo = new PlatformInfo();
            _dotnetSDKInfo = new DotnetSDKInfo();
            _dotnetRuntimeInfo = new DotnetRuntimeInfo();
        }

        public void Write()
        {
            String osProcessArchitecture = _operatingSystemInfo.OSProcessArchitecture;
            String osProcessorCount = _operatingSystemInfo.OSProcessorCount;
            String osVersion = _operatingSystemInfo.OSVersion;

            String platformType = _platformInfo.PlatformType;
            String platformName = _platformInfo.PlatformName;
            String platformVersion = _platformInfo.PlatformVersion;

            String frameworkVersion = _dotnetSDKInfo.FrameworkVersion;
            String frameworkDescription = _dotnetSDKInfo.FrameworkDescription;

            String runtimeIdentifier = _dotnetRuntimeInfo.RuntimeIdentifier;
            String runtimeProcessName = _dotnetRuntimeInfo.ProcessName;
            String runtimeProcessFileName = _dotnetRuntimeInfo.ProcessFileName;
            String runtimeDirectory = _dotnetRuntimeInfo.RuntimeDirectory;

            EWrite.Info("Operating System:");
            EWrite.Info($"  Process Architecture: {osProcessArchitecture}");
            EWrite.Info($"  Processor Count: {osProcessorCount}");

            if (osVersion is null)
            {
                EWrite.Warn($"  OS Version: unknown");
            }
            else
            {
                EWrite.Info($"  OS Version: {osVersion}");
            }

            EWrite.Info("Platform:");
            EWrite.Info($"  Type: {platformType}");
            EWrite.Info($"  Name: {platformName}");
            EWrite.Info($"  Version: {platformVersion}");

            EWrite.Info("Dotnet SDK:");
            EWrite.Info($"  Version: {frameworkVersion}");
            EWrite.Info($"  Framework Description: {frameworkDescription}");

            EWrite.Info("Dotnet Runtime:");
            EWrite.Info($"  Identifier: {runtimeIdentifier}");

            if (runtimeProcessName is null)
            {
                EWrite.Warn($"  Process Name: unknown");
            }
            else
            {
                EWrite.Info($"  Process Name: {runtimeProcessName}");
            }

            if (runtimeProcessFileName is null)
            {
                EWrite.Warn($"  Process File Name: unknown");
            }
            else
            {
                EWrite.Info($"  Process File Name: {runtimeProcessFileName}");
            }

            EWrite.Info($"  Runtime Directory: {runtimeDirectory}");
        }

    }

}
