/***************************************************************************
                       sprites.cpp  -  sprite objects
                             -------------------
    begin                : Tue Oct 14 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cob.hxx"

//	**************************************************************************************************************************
//
//                                                          Paint a sprite
//
//	**************************************************************************************************************************

void Sprite::Paint(void)
{
    Rect r(GetGraphic()*SPRITESIZE,             // Source rectangle
                            2*SPRITESIZE,0,0);
    r.Right = r.Left+SPRITESIZE-1;              // Calculate top and bottom then draw it
    r.Bottom = r.Top+SPRITESIZE-1;
    graphics.Copy(r,x*SPRITESIZE/256,y*SPRITESIZE/256);
}

//	**************************************************************************************************************************
//
//                                                      Move a sprite
//
//	**************************************************************************************************************************

int Sprite::Move(void)
{
    int dx,dy;
    if (x % 256 == 0 && y % 256 == 0)           // Reached a junction point ?
                        Junction(x >> 8,y >> 8);
    if (Direction != 0)                         // Are we moving ?
    {                                           // Can we move there ?
        if (CheckValidMove(Direction,dx,dy) != 0)
        {
            x = x + dx * 16;                    // If so do it
            y = y + dy * 16;
        }
    else                                        // otherwise do something else
        FailValidityCheck();
    }
    return 1;
}

//	**************************************************************************************************************************
//
//                                  Check to see if a move in a given direction is valid
//
//	**************************************************************************************************************************

int Sprite::CheckValidMove(int Dir,int &dx,int &dy)
{
    dx = dy = 0;                                // Work it out in terms of dx,dy
    switch(Dir)
    {
        case M_LEFT: dx = -1;break;
        case M_RIGHT:dx = 1;break;
        case M_UP:   dy = -1;break;
        case M_DOWN: dy = 1;break;
    }
    if (dx != 0 && y % 256 != 0) return 0;      // Can't turn in mid grid square
    if (dy != 0 && x % 256 != 0) return 0;

    if (x % 256 == 0 && y % 256 == 0)           // If at a junction
    {
        int xc = x >> 8;int yc = y >> 8;        // Convert to cell, reject if can't go that way
        if ((map.Read(xc,yc) & Dir) == 0) return 0;
        xc = xc + dx;yc = yc + dy;              // Next cell in current direction, check it's validity
        if (xc >= 0 && yc >= 0 && xc < map.XSize() && yc < map.YSize())
                if (map.Read(xc,yc) & M_HIDDEN) // If it's a hidden square reject it
                                              return 0;
    }
    return 1;
}

//	**************************************************************************************************************************
//
//                                                      Move the player
//
//	**************************************************************************************************************************

int Player::Move(void)
{
    int a,b,xc,yc,New;
    ReadStick(a,b,xc,yc);                       // Read controller
    New = 0;                                    // Convert to direction
    if (xc < 0 && yc == 0) New = M_LEFT;
    if (xc > 0 && yc == 0) New = M_RIGHT;
    if (xc == 0 && yc < 0) New = M_UP;
    if (xc == 0 && yc > 0) New = M_DOWN;
    if (New != 0 &&                             // Update direction if valid and moving
                CheckValidMove(New,xc,yc) != 0) Direction = New;
    if (a != 0)                                 // Fire Pressed
            map.Hide(x >> 8,y >> 8);            // Hide the square (possibly !)
    return Sprite::Move();                      // Base class movement code
}

//	**************************************************************************************************************************
//
//                                              Player at a junction
//
//	**************************************************************************************************************************

void Player::Junction(int x,int y)
{
    if ((map.Read(x,y) & M_COLOUR) == 0)        // If not coloured in, colour it in.
        map.Write(x,y,map.Read(x,y) | M_COLOUR);
}

//	**************************************************************************************************************************
//
//                                               Chaser at a junction
//
//	**************************************************************************************************************************

void Chaser::Junction(int x,int y)
{
    int n = map.Read(x,y) % 16;
    if (n != M_LEFT+M_RIGHT && n != M_UP+M_DOWN)// If it isn't straight up/down or left/right
    {
        Direction = (1 << (rand()%4));          // New direction.
    }
}

//	**************************************************************************************************************************
//
//                                              Return sprite graphic used
//
//	**************************************************************************************************************************

int Chaser::GetGraphic(void)
{
    return SystemClock()/400%2;
}

//	**************************************************************************************************************************
//
//                                  Chaser couldn't move - give a new direction
//
//	**************************************************************************************************************************

void Chaser::FailValidityCheck(void)
{
    Direction = (1 << (rand()%4));              // New direction.
}

//	**************************************************************************************************************************
//
//                                          Find a chaser start point
//
//	**************************************************************************************************************************

void Chaser::FindStart(void)
{    
    do
    {
        x = rand()%16+16;
        y = rand()%22;
    } while (map.Read(x,y) == 0);
    x = x << 8;y = y << 8;
}
        