# vcsgraph

This repository contains the sources of the vcsgraph project, a Rust
implementation of some revision graph manipulation functions.


## Contributing

This project targets Rust 1.48.0 for compatibility with most current Linux
distributions.

The code needs to be properly formatted by using:

    $ cargo fmt


## Testing

### CLI

For testing and evaluation purposes, some functions from this library are
accessible through command line utilities shipped when the "cli" feature flag is
present. Exposed functions can be listed by running:

    $ cargo run --features cli --bin testing -- --help
    $ cargo run --features cli --bin analytics -- --help

### Benchmarking

It's possible to empirically evaluate the performance impact of changesets by
adapting and running the following snippet, which compares the running time of
some subcommand of two revisions on some reference graph from the
[vcsgraph-reference repository]:


    ./utils/benchmark.sh ../vcsgraph-reference/graph/mercurial-2018-08-01-b2561d4a.graph

You will need the [hyperfine] benchmarking tool for this.

[vcsgraph-reference repository]: https://foss.heptapod.net/mercurial/vcsgraph-reference
[hyperfine]: https://github.com/sharkdp/hyperfine
