/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          rannum.h  -  description
                             -------------------
    begin                : Mon Oct 6 2003
    copyright            : (C) 2003 by 
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef RANNUM_H
#define RANNUM_H

#include "vec.h"
#include <time.h>

class RanNum {
public :

	//-------------------------------------------------------------
	//creat an arbitary order node for quartet puzzle method
	static void createOrderNd (int nSeq, Vec<int> &orderNdNoLs);

	/***********************************************************************************
	***********************************************************************************
	***********************************************************************************/
	/*get a random number from x1 to x2 arcording yo standard exponential distribution*/
	static int getUniDis (int minVal, int maxVal);



	/* variable */
	static long idum;

	static double randomunitintervall();
	/* Long period (> 2e18) random number generator. Returns a uniform random
	   deviate between 0.0 and 1.0 (exclusive of endpoint values).
	 
	   Source:
	   Press et al., "Numerical recipes in C", Cambridge University Press, 1992
	   (chapter 7 "Random numbers", ran2 random number generator) */


	/******************/

	static int initRandom(int seed);
	/******************/


	/* returns a random integer in the range [0; n - 1] */
	static int getRanInt(int n);

};
#endif // end of class

