/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// lind.h: interface for the LiNd class.
//
//////////////////////////////////////////////////////////////////////

#ifndef LIND_H
#define LIND_H

#include "innd.h"
#include "vec.h"
#include "cube.h"

//#define _ALTERNATIVE_PRODUCT
#ifdef _ALTERNATIVE_PRODUCT
#define product(a,b) ((a) == 0.0) ? 0.0 : ((a) == 1.0) ? (b) : ((a) * (b))
#endif


// scaling of each pattern
extern double *ptn_logl;
	
void createPtnLiInfo();
void deletePtnLiInfo();

/**
        this class contains all information to compute
        conditional likelihood at this node
*/
class LiNd {
public:
    /**
   	the constructor function
   */
	LiNd ();

	/** 
		liNdCube_ is the partial likelihood at
		this node coressponding to ptnNo, rateNo, baseNo
	*/
	PVec liNdCube_;

	/**
		scaling factor of the node, 
		sum over all patterns and over all rates!
	*/
	double liscale;

	/**
		1 if it is an external node, 0 otherwise
	*/
	int isEx_;

	/**
		Node ID
	*/
	int id_;

	/**
		parent node of this likelihood node
	*/
	int parNdNo_;

	/**
		parent branch of this likelihood node
	*/
	int parBrNo_;

	/**
		1 of the list of all descending external node
		of this node is already created
	*/
	int isExDesNdCreated_;

	/**
		the list of all descending external node
	*/
	Vec<int> exDesNdNoLs_;

	/**
		1 if the partial likelihood at this node
		is already computed
	*/
	int isCmped_;

	/**
		print information 
	*/
	void writeInf ();

	/**
      set the ID number, type, parent node and branch ID number for 
		this node
        @param id the ID number
        @param ndType type of node: extern node or internal node
        @param parNdNo the parent node's ID number of this node
        @param parBrNo the parent branch's ID number of this node
	*/
	void set (int id, EX_IN ndType, int parNdNo, int parBrNo);

	/**
		@return node ID
	*/
	int getId ();

	/**
		@return the vector of all descending external nodes
	*/
	Vec<int> &getExDesNd ();

	/**
		set isCmped_ to 0, meaning partial likelihood
		is not computed
	*/
	void turnOffIsCmped ();

	/**
		set the parent node and parent branch
		@param newParNdNo parent node ID
		@param newParBrNo parent branch ID
		
	*/
	void setParNdBr (int newParNdNo, int newParBrNo);

	/**
		get the parent node, and branch ID number for this node
		@param parNdNo (OUT) parent node ID number
		@param parBrNo (OUT) parent branch ID number
	*/	
	void getPar (int &parNdNo, int &parBrNo);

	/**
		compute the likelihood for all ptnNo, rateNo, baseNo at this node
	*/
	void cmpLi ();

	/**
		compute the likelihood on uniform rate model or specific rate
		for all ptnNo, rateNo, baseNo at this node
		TODO: for partition model
	*/
	void cmpLiUniformRate ();

	/**
		compute the likelihood on gamma rate model or yang codon model
		for all ptnNo, rateNo, baseNo at this node
		TODO: for partition model
	*/
	void cmpLiGammaRate ();

	/**
		@return TRUE if in site-specific rate phase
	*/
	inline bool isSiteSpec();

	/**
		reCompute the likelihood for all 
		ptnNo, rateNo, baseNo of this node
	*/
	void reCmpLi ();

	/**
		create the external descendant nodes number list of this node
		@param exDesNdNoLs (OUT) vector of all external descendant nodes
	*/
	void createExDesNd (Vec<int> &exDesNdNoLs);

	/**
		create the external descendant nodes number list of this node
	*/
	void createExDesNd ();

	/**
			set memory for this class
	*/
	void setLimit ();

	/**
			release the memory of this class
	*/
	void release ();

	/**
		the destructor function
	*/
	virtual ~LiNd ();

}
;// end of class

#endif //LIINND
