/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef USERTREE_H
#define USERTREE_H

#include "urtree.h"

//this class HAVE NOT worked with the tree less than 4 external nodes

class UserTree : public UrTree {
public :

	//the constructor function
	UserTree ();

	void setNewickTree (Vec<char> &newickTree);

	//read the user tree from the file
	void readFile (std::istream &usertree);

	//read the user tree from the file
	void readFile (const char *userTreeFile);

	//convert the newick tree form into the unrooted tree structure
	int createUrTree ();

	// check the correctness of the user tree
	void checkUrTree();

	//the destructor function
	virtual ~UserTree ();


	/******************************************************************
	******************************************************************
	******************************************************************
	******************************************************************
	******************************************************************/

private :
	NEWICK_TREE_STATUS newickTreeStatus_;

	//the input newick tree form
	Vec<char> inputNewickTree_;

	//register the newick tree form is a rooted or unrooted tree form
	int isUrTreeForm_;

	int isUrTreeForm (Vec<char> &newickTree);
	//=======================================================
	//check if it is a tree newick tree form
	int isNewickTree (Vec<char> &newickTree);

	/* (  (subTree0), (subTree1), (subTree2), ... )
	find the  right sub tree point form the given point 
	return -1, if not found*/
	int findRightSubTreePoint (Vec<char> &newickTree, int startPoint);

	/* (  (subTree0), (subTree1), (subTree2), ... )
	compute the number of sub trees of this newick tree form*/
	int cmpNumSubTree (Vec<char> &newickTree);


	//compute the number external nodes of this newick tree form
	int cmpNumExNd (Vec<char> &newickTree);

	/*get the subtree of this newick tree. the subtree is end at rightPoint
	return the leftPoint of this subtree in the newick tree */
	int getSubTree (Vec<char> &newickTree, int rightPoint, Vec<char> &subTree, double &len);

	//return 1, if this newickTree is a leaf tree
	int isLeaf (Vec<char> &newickTree);

	//decode the newick tree at an internal node
	int decodeInNd (Vec<char> &newickTree, int parNdNo, int parBrNo);

	//decode the newick tree at an external node
	int decodeExNd (Vec<char> &newickTree, int parNdNo, int parBrNo);

}
; //end of class

#endif

