/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef RATE_H
#define RATE_H

#include "vec.h"
#include "seqpair.h"
#include "brent.h"
#include "codonny98.h"

const int USE_GAMMA_SHAPE = 1;
const int USE_GAMMA_SCALE = 2;
const int USE_PTN = 3;
const int USE_PROB_INVAR_SITE = 4;
const double MIN_GAMMA_SCALE = 0.1;
const double MAX_GAMMA_SCALE = 100.0;
				  
class Rate : public Brent {
	//====================================================================================

public :

	//====================================================================================
/**	
	set the number of catagories
	@param nRate
*/
	//set the number of catagories
	void setNRate (const int nRate);

/**	
	get the number of catagories
	@return the number of catagories
*/

	//return the number of categories rate
	int getNRate ();

/**
	set the shape of gamma distribution
	@param gammaShape
*/
	//set the shape of gamma distribution
	void setGammaShape (const double gammaShape);

/**
	set the shape type of gamma distribution
	@param gammaShapeType shape type of gamma distribution
*/
/**
	get the shape type of gamma distribution
	@return shape type of gamma distribution
*/
	double getGammaShape ();


	void setGammaShapeType (const PAM_TYPE gammaShapeType);

/**
	get the shape type of gamma distribution
	@return shape type of gamma distribution
*/

	PAM_TYPE getGammaShapeType ();

/**
	return the fraction of number of invariable sites over the number of sites
	@return the fraction of number of invariable sites over the number of sites
*/
	//return the fraction of number of invariable sites over the number of sites
	double getInvarRatio ();


	PAM_TYPE getInvarSiteType ();
	

	// get the nCategories mean rates of nCatefories different categories
	Vec<double> &getRate ();

	//return the rateArr_[rateNo];
	double getRate (int rateNo);

	//get the prob of rateNo
	double getProb ();

	//get the prob of rateNo
	//double getProb (int rateNo);

/**
	optimize all parameters of Rate class
*/
	void optRatePam ();

/**
	everything is inited  here
*/
	void init ();

/**
	create the mean rate list using Gamma distribution, using existed parameters
*/
	//create the mean rate list using Gamma distribution, using existed parameters
	void create ();

	void setType (RATE_TYPE rateType);
	RATE_TYPE getType ();

	//====================================================================================
	//optimize specific site substitution rates using Sonja Meyer and Arndt von Haeseler, MBE-2003
	int optSpecificSite (Vec<SeqPair> &indSeqPairArr);

	//==================================================================
	//optimize specific site substitution rates using Sonja Meyer and Arndt von Haeseler, MBE-2003
	Vec<double> *getPtnRate ();

	//==================================================================
	//optimize specific site substitution rates using Sonja Meyer and Arndt von Haeseler, MBE-2003
	double getPtnRate (int ptnNo);

	int isOptedSpecificRate ();

	bool isNsSyHeterogenous();
	
	//optimize the gamma shape parameter using Brent method
	// void optGammaShape ();

	//release all memmory for this class
	void release ();

	//the destructor function
	virtual ~Rate ();
	/********************************************************************************
	********************************************************************************
	********************************************************************************
	 
	********************************************************************************
	********************************************************************************
	********************************************************************************/
	//bool use_invar_site; // true if you want to use propotion of invariable sites
	double prob_invar_site; // probability of a site to be invariable
	PAM_TYPE invar_site_type;
	double gamma_scale;		
	
	// for codon-based Nielsen Yang Model
	NSSITE_TYPE nsSy_ratio_type;
	int nsSy_classes; // number of classes for Ns/Sy Ratio
	double nsSy_ratio_val[MAX_NUM_CLASS];
	double nsSy_prob_val[MAX_NUM_CLASS];
	
private :
	//the number of categories
	int nRate_;

	RATE_TYPE rateType_;
	PAM_TYPE gammaShapeType_;

	Vec<double> rateArr_;
	Vec<double> ptnRateArr_;
	Vec<SeqPair> indSeqPairArr_;

	int actPtnNo_;

	int isOptedSpecificRate_;

	
	//====================================================================================
	//cmp likelihood when active pattern changes using Sonja Meyer and Arndt von Haeseler, MBE-2003
	double cmpNegLogLiPtn (double ptnRate);

	double cmpNegLogLiGammaShape (double shape);
	
	double cmpNegLogLiGammaScale (double scale);
	
	
	double cmpNegLogLiProbInvarSite (double prob_invar);
	
	int flag;


	/**
		compute the negative log likelihood
	*/
	virtual double cmpNegLogLi(double value);

	void setOptFlag(int aflag) {
		flag = aflag;
	}

	void scalePtnRate ();

	//====================================================================================
	//optimize specific site substitution rate for PTNNO using Sonja Meyer and Arndt von Haeseler, MBE-2003
	double optPtn (int ptnNo);

	//====================================================================================
	//optimize specific site substitution rates using Sonja Meyer and Arndt von Haeseler, MBE-2003
	void estimatePtnRate ();

	//the shape parameter of gamma distribution
	double xxx_gammaShape_;

	/* discrete Gamma according to Yang 1994 (JME 39:306-314) */
	void doYangDiscreteGamma (const double shape, const double scale, const int nRate, Vec<double> &rateArr);



	//Normally, beta is assigned equal to alpha
	double cmpPerPointGamma (const double prob, const double shape, const double scale);



	/*NUMERICAL SUBROUTINES
	THE FOLLOWING CODE COMES FROM tools.c in Yang's PAML package */

	/* returns ln(gamma(alpha)) for alpha>0, accurate to 10 decimal places.
	   Stirling's formula is used for the central polynomial part of the procedure.
	   Pike MC & Hill ID (1966) Algorithm 291: Logarithm of the gamma function.
	   Communications of the Association for Computing Machinery, 9:684
	 
	*/
	double cmpLnGamma (double alpha);

	/* returns the incomplete gamma ratio I(x,alpha) where x is the upper
	   limit of the integration and alpha is the shape parameter.
	   returns (-1) if in error
	   (1) series expansion     if (alpha>x || x<=1)
	   (2) continued fraction   otherwise
	   RATNEST FORTRAN by
	   Bhattacharjee GP (1970) The incomplete gamma integral.  Applied Statistics,
	   19: 285-287 (AS32)
	*/
	double cmpIncompleteGamma (double x, double alpha, double ln_gamma_alpha);

	/* functions concerning the CDF and percentage points of the gamma and
	   Chi2 distribution
	   returns z so that Prob{x<z}=prob where x ~ N(0,1) and (1e-12)<prob<1-(1e-12)
	   returns (-9999) if in error
	   Odeh RE & Evans JO (1974) The percentage points of the normal distribution.
	   Applied Statistics 22: 96-97 (AS70)
	 
	   Newer methods:
	     Wichura MJ (1988) Algorithm AS 241: the percentage points of the
	       normal distribution.  37: 477-484.
	     Beasley JD & Springer SG  (1977).  Algorithm AS 111: the percentage 
	       points of the normal distribution.  26: 118-121.
	*/
	double cmpPointNormal (double prob);


	/* returns z so that Prob{x<z}=prob where x is Chi2 distributed with df=v
	   returns -1 if in error.   0.000002<prob<0.999998
	   RATNEST FORTRAN by
	       Best DJ & Roberts DE (1975) The percentage points of the 
	       Chi2 distribution.  Applied Statistics 24: 385-388.  (AS91)
	   Converted into C by Ziheng Yang, Oct. 1993.
	*/
	double cmpPointChi2 (double prob, double v);

	/* THE END OF THE CODES COMMING FROM tools.c in Yang's PAML package */

}
;//end of class Rate

extern Rate myrate;

bool atBound(double min, double num, double max);

#endif
