/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "codonpedersen98.h"
#include <assert.h>
#include "opturtree.h"
#include "model.h"

const double MIN_CPG_RATIO = 0.1;
const double MAX_CPG_RATIO = 20.0;

CodonPedersen98::CodonPedersen98() : CodonYN98() {
	CpG_Ratio = 1.0;
}


/**
	get the rate parameters and frequency vector
*/
/*
void CodonPedersen98::rtfdata (DMat20 &a, DVec20 &forg, int num_state) {
	double sqr_CpG_Ratio = CpG_Ratio * CpG_Ratio;
	double frq_sum = 0.0;
	int count0_;
	for (count0_ = 0; count0_ < num_state; count0_ ++) {
		forg[count0_] = stateFrqArr_[count0_];
		// multiply by lamda^2 if codon contains NO C-G dinucleotide
		if (!codon_list[count0_].CpG_status) 
			forg[count0_] *= sqr_CpG_Ratio;
		frq_sum += forg[count0_];
		
		for (int count1_ = 0; count1_ < num_state; count1_ ++)
			a[count0_][count1_] = unitRateMat_[count0_][count1_];
	}
	
	for (count0_ = 0; count0_ < num_state; count0_ ++) {
		forg[count0_] /= frq_sum;
	}
	
}
*/

/**
		calculate the rate parameters (not rate matrix)
*/
void CodonPedersen98::calcRateParameters() {

	for (int i = 0; i < NUM_CODON; i++)
		for (int j = i+1; j < NUM_CODON; j++) {
			if (codon_trans[i][j].source == 0) { // more than 2 different codon positions
				continue;
			}

			if (codon_trans[i][j].is_transition)
				if (codon_trans[i][j].is_synonymous)
					// synonymous transition
					unitRateMat_[i][j] = tsTvRatio_;
				else // nonsynonymous transition
					unitRateMat_[i][j] = tsTvRatio_ * nsSyRatio;
			else
				if (codon_trans[i][j].is_synonymous)
					// synonymous transversion
					unitRateMat_[i][j] = 1.0;
				else
					// nonsynonymous transversion
					unitRateMat_[i][j] = nsSyRatio;

			/*
			if (codon_trans[i][j].CpG_status != CPG_UNCHANGED)
				unitRateMat_[i][j] *= CpG_Ratio;
			*/

			unitRateMat_[j][i] = unitRateMat_[i][j];


			switch ( codon_trans[i][j].CpG_status ) {
			case CPG_GAINED:
				unitRateMat_[i][j] /= CpG_Ratio;
				unitRateMat_[j][i] *= CpG_Ratio;
				break;
			case CPG_LOST:
				unitRateMat_[i][j] *= CpG_Ratio;
				unitRateMat_[j][i] /= CpG_Ratio;
				break;
			}

		}
}

double CodonPedersen98::cmpNegLogLi (double value) {
	if (isActPam_ == TS_TV_RATIO)
		tsTvRatio_ = value;
	else if (isActPam_ == NS_SY_RATIO)
		nsSyRatio = value;
	else
		CpG_Ratio = value;

	reInit ();

	opt_urtree.cmpLiNd ();
	double logLi_ = opt_urtree.getLogLi ();
	return -logLi_;
}


bool CodonPedersen98::optPam () {
	double fx_, error_;
	double oriTsTvRatio_ = tsTvRatio_;
	double oriNsSyRatio = nsSyRatio;
	double oriCpG_Ratio = CpG_Ratio;

	//  double logLi_ = opt_urtree.getLogLi ();
	if (isMasterProc())
		std::cout <<"Optimizing CpG Depression Codon-based Model parameters (Pedersen et al. 1998) ..." << endl;
	Brent::turnOnOptedPam ();
	double logLi_ = opt_urtree.cmpLogLi ();
	//  std::cout <<"Log likelihood: " << logLi_ << endl;


	if (mymodel.getTsTvRatioType() == ESTIMATE) {
		isActPam_ = TS_TV_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing transition/transversion ratio..." << endl;
		tsTvRatio_ = Brent::optOneDim (MIN_TS_TV_RATIO, tsTvRatio_, MAX_TS_TV_RATIO,
		                               EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();
	}//end of optimizing tsTvRatio

	if (true) {
		isActPam_ = NS_SY_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing nonsynonymous/synonymous ratio..." << endl;
		nsSyRatio = Brent::optOneDim (MIN_NS_SY_RATIO, nsSyRatio, MAX_NS_SY_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}//end of optimizing pyPuRatio

	if (true) {
		isActPam_ = CPG_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing CpG depression ratio..." << endl;
		CpG_Ratio = Brent::optOneDim (MIN_CPG_RATIO, CpG_Ratio, MAX_CPG_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}//end of optimizing CpG Ratio


	//      logLi_ = opt_urtree.cmpLogLi ();
	//     std::cout <<"Log likelihood: " << logLi_ << endl;
	//------------------------------/------------------------------/





	opt_urtree.cmpLiNd ();
	logLi_ = opt_urtree.getLogLi ();

	std::cout.precision (10);
	//  std::cout << "Log likelihood: " << logLi_ << endl;

	if (isMasterProc()) {

		std::cout.precision (5);
		std::cout << "Transition/transversion ratio  =  " << tsTvRatio_/2.0 << endl;
		std::cout << "Nonsynonymous/synonymous ratio =  " << nsSyRatio << endl;
		std::cout << "CpG depression ratio           =  " << CpG_Ratio << endl;
	}

	Brent::turnOffOptedPam ();
	return (fabs (tsTvRatio_ - oriTsTvRatio_) > EPS_MODEL_PAM_ERROR ||
	        fabs (nsSyRatio - oriNsSyRatio) > EPS_MODEL_PAM_ERROR ||
	        fabs (CpG_Ratio - oriCpG_Ratio) > EPS_MODEL_PAM_ERROR );
}


/**
	@return Nonsynonymous/Synonymous Ratio
*/
double CodonPedersen98::getCpG_Ratio() {
	return CpG_Ratio;
}



CodonPedersen98::~CodonPedersen98() {}


