/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef URTREEPARARRAY_H
#define URTREEPARARRAY_H

#include "vec.h"
#include "urtreepar.h"
#include "constant.h"

#ifdef PARALLEL

/**
	This class define an array of UrTreePar, which is useful for master process
	for receiving trees from slaves
	@author Bui Quang Minh
*/
class UrTreeParArray : public Vec<UrTreePar*>
{
public:
	/** 
		constructor, which duplicates the tree mpi_size times
	*/
    UrTreeParArray(UrTree &tree);

	/** 
		constructor, does nothing
	*/
    UrTreeParArray();

	/**
		start to receive from all slaves
	*/
	void receiveFromSlaves();
	
	/**
		wait until some slaves send tree back
		@return the rank of completed process
	*/
	int waitForSlaves();

	/**
		broadcast a tree to all slaves
		@param process the process which creates the tree
	*/
	void broadcastToSlaves(UrTree &tree, int process);
		
	/**
		cancel all the attached receive or send of all elements
	*/
	void cancelCommunications();

	/**
		return TRUE of all slaves done their job
	*/
	bool allSlavesDone();
		
	/**
		return the number of running slaves
	*/
	int runningSlaves();
	
	/** 
		destructor 
	*/
    ~UrTreeParArray();

protected:

	/**
		current index, used by waitForSlaves() to return a fair process index
	*/
	int responded_index;
	/**
		vector of process indices that communicate
	*/
	Vec<int> responded_procs;
	
};

#endif // PARALLEL

#endif
